/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.wrapper;

import com.ghostchu.peerbanhelper.downloader.DownloaderBasicInfo;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.wrapper.BanMetadata;
import com.ghostchu.peerbanhelper.wrapper.PeerWrapper;
import com.ghostchu.peerbanhelper.wrapper.TorrentWrapper;
import java.io.Serializable;
import java.time.OffsetDateTime;
import lombok.Generated;

public final class BakedBanMetadata
implements Serializable {
    private DownloaderBasicInfo downloader;
    private TorrentWrapper torrent;
    private PeerWrapper peer;
    private String reverseLookup = "N/A";
    private String context;
    private OffsetDateTime banAt;
    private OffsetDateTime unbanAt;
    private String rule;
    private String description;

    public BakedBanMetadata(String locale, BanMetadata banMetadata) {
        this.downloader = banMetadata.getDownloader();
        this.torrent = banMetadata.getTorrent();
        this.peer = banMetadata.getPeer();
        this.reverseLookup = banMetadata.getReverseLookup();
        this.context = banMetadata.getContext();
        this.banAt = banMetadata.getBanAt();
        this.unbanAt = banMetadata.getUnbanAt();
        this.rule = TextManager.tl(locale, banMetadata.getRule());
        this.description = TextManager.tl(locale, banMetadata.getDescription());
    }

    @Generated
    public DownloaderBasicInfo getDownloader() {
        return this.downloader;
    }

    @Generated
    public TorrentWrapper getTorrent() {
        return this.torrent;
    }

    @Generated
    public PeerWrapper getPeer() {
        return this.peer;
    }

    @Generated
    public String getReverseLookup() {
        return this.reverseLookup;
    }

    @Generated
    public String getContext() {
        return this.context;
    }

    @Generated
    public OffsetDateTime getBanAt() {
        return this.banAt;
    }

    @Generated
    public OffsetDateTime getUnbanAt() {
        return this.unbanAt;
    }

    @Generated
    public String getRule() {
        return this.rule;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDownloader(DownloaderBasicInfo downloader) {
        this.downloader = downloader;
    }

    @Generated
    public void setTorrent(TorrentWrapper torrent) {
        this.torrent = torrent;
    }

    @Generated
    public void setPeer(PeerWrapper peer) {
        this.peer = peer;
    }

    @Generated
    public void setReverseLookup(String reverseLookup) {
        this.reverseLookup = reverseLookup;
    }

    @Generated
    public void setContext(String context) {
        this.context = context;
    }

    @Generated
    public void setBanAt(OffsetDateTime banAt) {
        this.banAt = banAt;
    }

    @Generated
    public void setUnbanAt(OffsetDateTime unbanAt) {
        this.unbanAt = unbanAt;
    }

    @Generated
    public void setRule(String rule) {
        this.rule = rule;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BakedBanMetadata)) {
            return false;
        }
        BakedBanMetadata other = (BakedBanMetadata)o;
        DownloaderBasicInfo this$downloader = this.getDownloader();
        DownloaderBasicInfo other$downloader = other.getDownloader();
        if (this$downloader == null ? other$downloader != null : !((Object)this$downloader).equals(other$downloader)) {
            return false;
        }
        TorrentWrapper this$torrent = this.getTorrent();
        TorrentWrapper other$torrent = other.getTorrent();
        if (this$torrent == null ? other$torrent != null : !((Object)this$torrent).equals(other$torrent)) {
            return false;
        }
        PeerWrapper this$peer = this.getPeer();
        PeerWrapper other$peer = other.getPeer();
        if (this$peer == null ? other$peer != null : !((Object)this$peer).equals(other$peer)) {
            return false;
        }
        String this$reverseLookup = this.getReverseLookup();
        String other$reverseLookup = other.getReverseLookup();
        if (this$reverseLookup == null ? other$reverseLookup != null : !this$reverseLookup.equals(other$reverseLookup)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        OffsetDateTime this$banAt = this.getBanAt();
        OffsetDateTime other$banAt = other.getBanAt();
        if (this$banAt == null ? other$banAt != null : !((Object)this$banAt).equals(other$banAt)) {
            return false;
        }
        OffsetDateTime this$unbanAt = this.getUnbanAt();
        OffsetDateTime other$unbanAt = other.getUnbanAt();
        if (this$unbanAt == null ? other$unbanAt != null : !((Object)this$unbanAt).equals(other$unbanAt)) {
            return false;
        }
        String this$rule = this.getRule();
        String other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DownloaderBasicInfo $downloader = this.getDownloader();
        result = result * 59 + ($downloader == null ? 43 : ((Object)$downloader).hashCode());
        TorrentWrapper $torrent = this.getTorrent();
        result = result * 59 + ($torrent == null ? 43 : ((Object)$torrent).hashCode());
        PeerWrapper $peer = this.getPeer();
        result = result * 59 + ($peer == null ? 43 : ((Object)$peer).hashCode());
        String $reverseLookup = this.getReverseLookup();
        result = result * 59 + ($reverseLookup == null ? 43 : $reverseLookup.hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        OffsetDateTime $banAt = this.getBanAt();
        result = result * 59 + ($banAt == null ? 43 : ((Object)$banAt).hashCode());
        OffsetDateTime $unbanAt = this.getUnbanAt();
        result = result * 59 + ($unbanAt == null ? 43 : ((Object)$unbanAt).hashCode());
        String $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BakedBanMetadata(downloader=" + String.valueOf(this.getDownloader()) + ", torrent=" + String.valueOf(this.getTorrent()) + ", peer=" + String.valueOf(this.getPeer()) + ", reverseLookup=" + this.getReverseLookup() + ", context=" + this.getContext() + ", banAt=" + String.valueOf(this.getBanAt()) + ", unbanAt=" + String.valueOf(this.getUnbanAt()) + ", rule=" + this.getRule() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public BakedBanMetadata() {
    }
}

