/*
 * Decompiled with CFR 0.152.
 */
package raccoonfink.deluge.responses;

import com.google.gson.JsonObject;
import raccoonfink.deluge.DelugeException;

public class DelugeResponse {
    private final int m_id;
    private final int m_responseCode;
    private final JsonObject m_result;

    public DelugeResponse(Integer httpResponseCode, JsonObject response) throws DelugeException {
        assert (httpResponseCode != null);
        if (!response.has("id")) {
            throw new DelugeException("Invalid 'id' field in JSON: " + String.valueOf(response));
        }
        this.m_id = response.get("id").getAsInt();
        this.m_responseCode = httpResponseCode;
        this.m_result = response;
    }

    public int getId() {
        return this.m_id;
    }

    public int getResponseCode() {
        return this.m_responseCode;
    }

    public JsonObject getResponseData() {
        return this.m_result;
    }

    public JsonObject toResponseJSON() {
        JsonObject ret = new JsonObject();
        ret.addProperty("id", (Number)this.getId());
        ret.addProperty("responseCode", (Number)this.getResponseCode());
        ret.add("result", null);
        return ret;
    }
}

