/*
 * Decompiled with CFR 0.152.
 */
package raccoonfink.deluge.responses;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import raccoonfink.deluge.DelugeEvent;
import raccoonfink.deluge.DelugeException;
import raccoonfink.deluge.responses.DelugeResponse;

public final class EventsResponse
extends DelugeResponse {
    private final List<DelugeEvent> m_events = new ArrayList<DelugeEvent>();

    public EventsResponse(Integer httpResponseCode, JsonObject result) throws DelugeException {
        super(httpResponseCode, result);
        if (result.has("result") && !result.get("result").isJsonNull()) {
            JsonArray res = result.getAsJsonArray("result");
            for (JsonElement element : res) {
                this.m_events.add(new DelugeEvent(element.getAsJsonArray()));
            }
        }
    }

    public List<DelugeEvent> getEvents() {
        return Collections.unmodifiableList(this.m_events);
    }

    @Override
    public JsonObject toResponseJSON() {
        JsonObject ret = super.toResponseJSON();
        JsonArray resultArray = new JsonArray();
        for (DelugeEvent ev : this.m_events) {
            resultArray.add((JsonElement)ev.toJSON());
        }
        ret.add("result", (JsonElement)resultArray);
        return ret;
    }
}

