/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.jta;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.stone.beecp.BeeConnectionPoolMonitorVo;
import org.stone.beecp.BeeDataSource;
import org.stone.beecp.BeeMethodLog;
import org.stone.beecp.BeeMethodLogListener;
import org.stone.beecp.jta.BeeJtaSynchronization;

public class BeeJtaDataSource
extends TimerTask
implements DataSource,
AutoCloseable {
    private final Timer transactionTimer = new Timer(true);
    private final ConcurrentHashMap<Transaction, Connection> transactionMap = new ConcurrentHashMap(10);
    private BeeDataSource ds;
    private TransactionManager tm;

    public BeeJtaDataSource() {
        this(null, null);
    }

    public BeeJtaDataSource(BeeDataSource ds, TransactionManager tm) {
        this.ds = ds;
        this.tm = tm;
        this.transactionTimer.schedule((TimerTask)this, 0L, 6000L);
    }

    public void setDataSource(BeeDataSource ds) {
        this.ds = ds;
    }

    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.checkDataSource();
        return this.ds.getConnection();
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn;
        Transaction transaction;
        this.checkDataSource();
        if (this.tm == null) {
            throw new SQLException("transactionManager not set");
        }
        try {
            transaction = this.tm.getTransaction();
            int statusCode = transaction.getStatus();
            if (0 != statusCode) {
                throw new SQLException("Current transaction status code is not expect value:" + statusCode);
            }
            conn = this.transactionMap.get(transaction);
            if (conn != null) {
                return conn;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
        XAConnection xaConn = null;
        try {
            xaConn = this.ds.getXAConnection();
            conn = xaConn.getConnection();
            if (transaction.enlistResource(xaConn.getXAResource())) {
                this.transactionMap.put(transaction, conn);
                BeeJtaSynchronization synchronization = new BeeJtaSynchronization(transaction, this.transactionMap);
                transaction.registerSynchronization((Synchronization)synchronization);
                return conn;
            }
            throw new SQLException("Failed to enlist resource in transaction");
        }
        catch (Throwable e) {
            if (xaConn != null) {
                xaConn.close();
            }
            throw e instanceof SQLException ? (SQLException)e : new SQLException(e);
        }
    }

    @Override
    public void run() {
        Iterator<Map.Entry<Transaction, Connection>> iterator = this.transactionMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Transaction, Connection> entry = iterator.next();
            Transaction transaction = entry.getKey();
            try {
                int statusCode = transaction.getStatus();
                if (statusCode != 3 && statusCode != 9) continue;
                iterator.remove();
                entry.getValue().close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void checkDataSource() throws SQLException {
        if (this.ds == null || this.ds.isClosed()) {
            throw new SQLException("Inner data source not set or has been closed");
        }
    }

    public void restart() throws SQLException {
        this.restart(false);
    }

    public void restart(boolean force) throws SQLException {
        this.checkDataSource();
        this.ds.restart(force);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz != null && clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz != null && clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        throw new SQLException("Wrapped object was not an instance of " + clazz);
    }

    public BeeConnectionPoolMonitorVo getPoolMonitorVo() throws SQLException {
        this.checkDataSource();
        return this.ds.getPoolMonitorVo();
    }

    public void enableLogPrinter(boolean printRuntimeLog) throws SQLException {
        this.checkDataSource();
        this.ds.enableLogPrinter(printRuntimeLog);
    }

    public void enableLogCache(boolean enable) throws SQLException {
        this.checkDataSource();
        this.ds.enableLogCache(enable);
    }

    public void changeLogListener(BeeMethodLogListener listener) throws SQLException {
        this.checkDataSource();
        this.ds.changeLogListener(listener);
    }

    public List<BeeMethodLog> getLogs(int type) throws SQLException {
        this.checkDataSource();
        return this.ds.getLogs(type);
    }

    public void clearLogs(int type) throws SQLException {
        this.checkDataSource();
        this.ds.clearLogs(type);
    }

    public boolean cancelStatement(String logId) throws SQLException {
        this.checkDataSource();
        return this.ds.cancelStatement(logId);
    }

    public boolean isClosed() throws SQLException {
        this.checkDataSource();
        return this.ds.isClosed();
    }

    @Override
    public void close() throws SQLException {
        this.checkDataSource();
        this.ds.close();
        this.transactionTimer.cancel();
    }
}

