/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import org.stone.beecp.BeeMethodLog;

public class MethodExecutionLog
implements BeeMethodLog {
    static final int State_Running = 0;
    static final int State_Successful = 1;
    static final int State_Failed = 2;
    private final int type;
    private final String id;
    private final String poolName;
    private final String method;
    private final Object[] parameters;
    private final long startTime;
    private long endTime;
    private int status = 0;
    private transient Object resultObject;
    private Throwable failureCause;
    private String sql;
    private long sqlPreparedTime;
    private Object[] sqlPreparedParameters;
    private transient Statement statement;
    private boolean removed;
    private boolean slow;
    private boolean longRunning;
    private boolean handled;

    public MethodExecutionLog(String poolName, int type, String method, Object[] parameters, Statement statement) {
        this.poolName = poolName;
        this.type = type;
        this.method = method;
        this.parameters = parameters;
        this.statement = statement;
        this.id = UUID.randomUUID().toString();
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public Object[] getParameters() {
        return this.parameters;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public boolean isRunning() {
        return this.status == 0;
    }

    @Override
    public boolean isSuccessful() {
        return this.status == 1;
    }

    @Override
    public boolean isException() {
        return this.status == 2;
    }

    @Override
    public boolean isSlow() {
        return this.slow;
    }

    @Override
    public boolean hasHandledByListener() {
        return this.handled;
    }

    void setHandled(boolean isHandled) {
        this.handled = isHandled;
    }

    @Override
    public boolean isLongRunning() {
        return this.longRunning;
    }

    void setAsSlow(long curTime, long slowThreshold) {
        if (this.endTime != 0L) {
            this.slow = this.endTime - this.startTime - slowThreshold >= 0L;
        } else {
            this.longRunning = curTime - this.startTime - slowThreshold >= 0L;
            this.slow = this.longRunning;
        }
    }

    @Override
    public Object getResult() {
        return this.resultObject;
    }

    @Override
    public Throwable getFailureCause() {
        return this.failureCause;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    void setSql(String sql) {
        this.sql = sql;
    }

    @Override
    public long getSqlPreparedTime() {
        return this.sqlPreparedTime;
    }

    @Override
    public Object[] getSqlPreparedParameters() {
        return this.sqlPreparedParameters;
    }

    @Override
    public boolean cancelStatement() throws SQLException {
        if (this.statement != null) {
            this.statement.cancel();
            return true;
        }
        return false;
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    void setRemoved(boolean removed) {
        this.removed = removed;
    }

    void setStatement(Statement statement) {
        this.statement = statement;
    }

    void setResult(Object result, long sqlPreparedTime, Object[] sqlPreparedParameters) {
        this.sqlPreparedTime = sqlPreparedTime;
        this.sqlPreparedParameters = sqlPreparedParameters;
        this.statement = null;
        this.endTime = System.currentTimeMillis();
        if (result instanceof Throwable) {
            this.failureCause = (Throwable)result;
            this.status = 2;
        } else {
            this.resultObject = result;
            this.status = 1;
        }
    }

    public boolean equals(Object v) {
        return v instanceof MethodExecutionLog && this.id.equals(((MethodExecutionLog)v).id);
    }
}

