/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.stone.beecp.pool.PooledConnection;
import org.stone.beecp.pool.ProxyConnectionBase;
import org.stone.beecp.pool.ProxyResultSet;
import org.stone.beecp.pool.ProxyStatementBase;

public class ProxyStatement
extends ProxyStatementBase {
    public ProxyStatement(Statement statement, ProxyConnectionBase proxyConnectionBase, PooledConnection pooledConnection) {
        super(statement, proxyConnectionBase, pooledConnection);
    }

    public ProxyStatement(Statement statement, ProxyConnectionBase proxyConnectionBase, PooledConnection pooledConnection, long l, String string) {
        super(statement, proxyConnectionBase, pooledConnection, l, string);
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        try {
            this.p.commitDirtyInd = !this.p.curAutoCommit;
            ResultSet resultSet = this.raw.executeQuery(string);
            this.p.lastAccessTime = System.currentTimeMillis();
            return new ProxyResultSet(resultSet, this, this.p);
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        try {
            this.p.commitDirtyInd = !this.p.curAutoCommit;
            int n = this.raw.executeUpdate(string);
            this.p.lastAccessTime = System.currentTimeMillis();
            return n;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            int n = this.raw.getMaxFieldSize();
            return n;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        try {
            this.raw.setMaxFieldSize(n);
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            int n = this.raw.getMaxRows();
            return n;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        try {
            this.raw.setMaxRows(n);
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            this.raw.setEscapeProcessing(bl);
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            int n = this.raw.getQueryTimeout();
            return n;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        try {
            this.raw.setQueryTimeout(n);
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this.raw.cancel();
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            SQLWarning sQLWarning = this.raw.getWarnings();
            return sQLWarning;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.raw.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        try {
            this.raw.setCursorName(string);
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        try {
            this.p.commitDirtyInd = !this.p.curAutoCommit;
            boolean bl = this.raw.execute(string);
            this.p.lastAccessTime = System.currentTimeMillis();
            return bl;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            int n = this.raw.getUpdateCount();
            return n;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        try {
            this.raw.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            int n = this.raw.getFetchDirection();
            return n;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        try {
            this.raw.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            int n = this.raw.getFetchSize();
            return n;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            int n = this.raw.getResultSetConcurrency();
            return n;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            int n = this.raw.getResultSetType();
            return n;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void addBatch(String string) throws SQLException {
        try {
            this.raw.addBatch(string);
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.raw.clearBatch();
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            this.p.commitDirtyInd = !this.p.curAutoCommit;
            int[] nArray = this.raw.executeBatch();
            this.p.lastAccessTime = System.currentTimeMillis();
            return nArray;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            ResultSet resultSet = this.raw.getGeneratedKeys();
            return new ProxyResultSet(resultSet, this, this.p);
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        try {
            this.p.commitDirtyInd = !this.p.curAutoCommit;
            int n2 = this.raw.executeUpdate(string, n);
            this.p.lastAccessTime = System.currentTimeMillis();
            return n2;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            this.p.commitDirtyInd = !this.p.curAutoCommit;
            int n = this.raw.executeUpdate(string, nArray);
            this.p.lastAccessTime = System.currentTimeMillis();
            return n;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            this.p.commitDirtyInd = !this.p.curAutoCommit;
            int n = this.raw.executeUpdate(string, stringArray);
            this.p.lastAccessTime = System.currentTimeMillis();
            return n;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        try {
            this.p.commitDirtyInd = !this.p.curAutoCommit;
            boolean bl = this.raw.execute(string, n);
            this.p.lastAccessTime = System.currentTimeMillis();
            return bl;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        try {
            this.p.commitDirtyInd = !this.p.curAutoCommit;
            boolean bl = this.raw.execute(string, nArray);
            this.p.lastAccessTime = System.currentTimeMillis();
            return bl;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            this.p.commitDirtyInd = !this.p.curAutoCommit;
            boolean bl = this.raw.execute(string, stringArray);
            this.p.lastAccessTime = System.currentTimeMillis();
            return bl;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            int n = this.raw.getResultSetHoldability();
            return n;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            boolean bl = this.raw.isPoolable();
            return bl;
        }
        catch (SQLException sQLException) {
            this.p.checkSQLException(sQLException);
            throw sQLException;
        }
    }
}

