/*
 * Decompiled with CFR 0.152.
 */
package org.stone.tools;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogPrinter {
    public static final LogPrinter DefaultLogPrinter = new LogPrinter(LoggerFactory.getLogger(LogPrinter.class));
    protected final Logger logger;
    private boolean isEnabled = true;

    public LogPrinter(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("Logger cannot be null");
        }
        this.logger = logger;
    }

    public static LogPrinter getLogPrinter(Class<?> targetClass, boolean outputLogs) {
        if (targetClass == null) {
            return NotOutputLogPrinter.SingleInstance;
        }
        return outputLogs ? new UnSwitchableLogPrinter(LoggerFactory.getLogger(targetClass)) : NotOutputLogPrinter.SingleInstance;
    }

    public static LogPrinter getSwitchableLogPrinter(Class<?> targetClass) {
        return new LogPrinter(LoggerFactory.getLogger(targetClass));
    }

    public boolean isEnableLogOutput() {
        return this.isEnabled;
    }

    public void enableLogOutput(boolean outputLogs) {
        this.isEnabled = outputLogs;
    }

    public void debug(String s) {
        if (this.isEnabled) {
            this.logger.debug(s);
        }
    }

    public void debug(String s, Object ... var2) {
        if (this.isEnabled) {
            this.logger.debug(s, var2);
        }
    }

    public void debug(String s, Throwable e) {
        if (this.isEnabled) {
            this.logger.debug(s, e);
        }
    }

    public void debug(String s, Throwable e, Object ... var2) {
        if (this.isEnabled) {
            this.logger.debug(s, (Object)e, (Object)var2);
        }
    }

    public void info(String s) {
        if (this.isEnabled) {
            this.logger.info(s);
        }
    }

    public void info(String s, Object ... var2) {
        if (this.isEnabled) {
            this.logger.info(s, var2);
        }
    }

    public void info(String s, Throwable e) {
        if (this.isEnabled) {
            this.logger.info(s, e);
        }
    }

    public void info(String s, Throwable e, Object ... var2) {
        if (this.isEnabled) {
            this.logger.info(s, (Object)e, (Object)var2);
        }
    }

    public void warn(String s) {
        if (this.isEnabled) {
            this.logger.warn(s);
        }
    }

    public void warn(String s, Object ... var2) {
        if (this.isEnabled) {
            this.logger.warn(s, var2);
        }
    }

    public void warn(String s, Throwable e) {
        if (this.isEnabled) {
            this.logger.warn(s, e);
        }
    }

    public void warn(String s, Throwable e, Object ... var2) {
        if (this.isEnabled) {
            this.logger.warn(s, (Object)e, (Object)var2);
        }
    }

    public void error(String s) {
        if (this.isEnabled) {
            this.logger.error(s);
        }
    }

    public void error(String s, Object ... var2) {
        if (this.isEnabled) {
            this.logger.error(s, var2);
        }
    }

    public void error(String s, Throwable e) {
        if (this.isEnabled) {
            this.logger.error(s, e);
        }
    }

    public void error(String s, Throwable e, Object ... var2) {
        if (this.isEnabled) {
            this.logger.error(s, (Object)e, (Object)var2);
        }
    }

    static final class NotOutputLogPrinter
    extends LogPrinter {
        static final NotOutputLogPrinter SingleInstance = new NotOutputLogPrinter();

        NotOutputLogPrinter() {
            super(LoggerFactory.getLogger(LogPrinter.class));
        }

        @Override
        public boolean isEnableLogOutput() {
            return false;
        }

        @Override
        public void debug(String s) {
        }

        @Override
        public void debug(String s, Object ... var2) {
        }

        @Override
        public void debug(String s, Throwable e) {
        }

        @Override
        public void debug(String s, Throwable e, Object ... var2) {
        }

        @Override
        public void info(String s) {
        }

        @Override
        public void info(String s, Object ... var2) {
        }

        @Override
        public void info(String s, Throwable e) {
        }

        @Override
        public void info(String s, Throwable e, Object ... var2) {
        }

        @Override
        public void warn(String s) {
        }

        @Override
        public void warn(String s, Object ... var2) {
        }

        @Override
        public void warn(String s, Throwable e) {
        }

        @Override
        public void warn(String s, Throwable e, Object ... var2) {
        }

        @Override
        public void error(String s) {
        }

        @Override
        public void error(String s, Object ... var2) {
        }

        @Override
        public void error(String s, Throwable e) {
        }

        @Override
        public void error(String s, Throwable e, Object ... var2) {
        }
    }

    static final class UnSwitchableLogPrinter
    extends LogPrinter {
        public UnSwitchableLogPrinter(Logger logger) {
            super(logger);
        }

        @Override
        public boolean isEnableLogOutput() {
            return true;
        }

        @Override
        public void debug(String s) {
            this.logger.debug(s);
        }

        @Override
        public void debug(String s, Object ... var2) {
            this.logger.debug(s, var2);
        }

        @Override
        public void debug(String s, Throwable e) {
            this.logger.debug(s, e);
        }

        @Override
        public void debug(String s, Throwable e, Object ... var2) {
            this.logger.debug(s, (Object)e, (Object)var2);
        }

        @Override
        public void info(String s) {
            this.logger.info(s);
        }

        @Override
        public void info(String s, Object ... var2) {
            this.logger.info(s, var2);
        }

        @Override
        public void info(String s, Throwable e) {
            this.logger.info(s, e);
        }

        @Override
        public void info(String s, Throwable e, Object ... var2) {
            this.logger.info(s, (Object)e, (Object)var2);
        }

        @Override
        public void warn(String s) {
            this.logger.warn(s);
        }

        @Override
        public void warn(String s, Object ... var2) {
            this.logger.warn(s, var2);
        }

        @Override
        public void warn(String s, Throwable e) {
            this.logger.warn(s, e);
        }

        @Override
        public void warn(String s, Throwable e, Object ... var2) {
            this.logger.warn(s, (Object)e, (Object)var2);
        }

        @Override
        public void error(String s) {
            this.logger.error(s);
        }

        @Override
        public void error(String s, Object ... var2) {
            this.logger.error(s, var2);
        }

        @Override
        public void error(String s, Throwable e) {
            this.logger.error(s, e);
        }

        @Override
        public void error(String s, Throwable e, Object ... var2) {
            this.logger.error(s, (Object)e, (Object)var2);
        }
    }
}

