
'use strict';
{
  const globals = this;
  const django = globals.django || (globals.django = {});

  
  django.pluralidx = function(n) {
    const v = (n != 1);
    if (typeof v === 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  /* gettext library */

  django.catalog = django.catalog || {};
  
  const newcatalog = {
    "(If left blank, owner will be admin)": "(Ohne Angabe wird der aktuelle Benutzer Eigent\u00fcmer der Gruppe.)",
    "(at least {passwordMinLength} characters and includes {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols)": "(mindestens {passwordMinLength} Zeichen und und {passwordStrengthLevel} der folgenden Zeichentypen: Zahl, Gro\u00dfbuchstabe, Kleinbuchstabe, Sonderzeichen)",
    "(at least {placeholder} characters)": "(mindestens {placeholder} Zeichen)",
    "(current notification)": "(aktueller Hinweis)",
    "(current version)": "(aktuelle Version)",
    "(deleted)": "(gel\u00f6scht)",
    "1 Hidden property": "1 ausgeblendete Eigenschaft",
    "1 Year": "1 Jahr",
    "1 cell copied": "1 Zelle wurde in die Zwischenablage kopiert.",
    "1 cell cut": "1 Zelle wurde ausgeschnitten und in die Zwischenablage gelegt.",
    "1 filter": "1 Filter",
    "1 hidden property": "1 ausgeblendete Eigenschaft",
    "1 month ago": "vor 1 Monat",
    "1 preset hidden property": "1 voreingestellt ausgeblendete Eigenschaft",
    "1 record selected": "1 Eintrag ausgew\u00e4hlt",
    "1 row is copied.": "1 Zeile wurde in die Zwischenablage kopiert.",
    "1 sort": "1 Sortierung",
    "1 week ago": "vor einer Woche",
    "3 days ago": "vor 3 Tagen",
    "30 Days": "30 Tage",
    "7 Days": "7 Tage",
    "A file is being uploaded. Are you sure you want to leave this page?": "Gerade wird eine Datei hochgeladen. M\u00f6chten Sie die Seite wirklich verlassen?",
    "A file named {upload_file_link} is uploaded to {uploaded_link}.": "Die Datei {upload_file_link} wurde hochgeladen nach {uploaded_link}.",
    "A file named {upload_file_link} is uploaded.": "Die Datei {upload_file_link} wurde hochgeladen.",
    "A file with the same name already exists in this folder.": "Es gibt bereits eine Datei mit dem gleichen Namen in diesem Ordner.",
    "A folder named {upload_folder_link} is uploaded to {uploaded_link}.": "Der Ordner {upload_file_link} wurde hochgeladen nach {uploaded_link}.",
    "A folder named {upload_folder_link} is uploaded.": "Der Ordner {upload_folder_link} wurde hochgeladen.",
    "AI": "KI",
    "AI credit used this month": "In diesem Monat verbrauchte KI-Credits",
    "AI credit used:": "Verbrauchte KI-Credits:",
    "API Token": "API-Token",
    "API token is copied to the clipboard.": "Das API-Token wurde in die Zwischenablage kopiert.",
    "About": "\u00dcber",
    "About Us": "\u00dcber uns",
    "Abuse Content": "Missbr\u00e4uchliche Inhalte",
    "Abuse Reports": "Berichte zu missbr\u00e4uchlicher Nutzung",
    "Abuse Type": "Art der missbr\u00e4uchlichen Nutzung",
    "Abuse report added": "Ein Bericht \u00fcber missbr\u00e4uchliche Nutzung wurde hinzugef\u00fcgt.",
    "Accept": "Annehmen",
    "Accepted": "Angenommen",
    "Accepted at": "Angenommen am",
    "Accepter": "Gast",
    "Access Log": "Nutzungsdaten",
    "Access scope": "Access Scope",
    "Accurate to minute": "Minutengenau",
    "Action": "Aktion",
    "Actions": "Aktionen",
    "Activate after registration": "Selbstregistrierung aktivieren",
    "Activate user immediately after registration. If unchecked, a user need to be activated by administrator or via activation email": "Neue, selbstregistrierte Benutzerkonten werden automatisch auf aktiv gesetzt, so dass sich die Benutzer sofort anmelden k\u00f6nnen. (Wenn dies nicht aktiviert ist, dann m\u00fcssen Registrierungen manuell aktiviert werden.)",
    "Activated": "Aktiviert",
    "Activated Users": "Aktive Benutzerkonten",
    "Active": "Aktiv",
    "Active Users": "Aktive Benutzerkonten",
    "Active users": "Aktive Benutzerkonten",
    "Activities": "Aktivit\u00e4ten",
    "Actual size": "Tats\u00e4chliche Gr\u00f6\u00dfe",
    "Add": "Hinzuf\u00fcgen",
    "Add Admin": "Admin hinzuf\u00fcgen",
    "Add Folder": "Ordner hinzuf\u00fcgen",
    "Add Institution": "Einrichtung hinzuf\u00fcgen",
    "Add Library": "Bibliothek hinzuf\u00fcgen",
    "Add Member": "Mitglied hinzuf\u00fcgen",
    "Add Organization": "Organisation hinzuf\u00fcgen",
    "Add Terms and Conditions": "Nutzungsvereinbarungen hinzuf\u00fcgen",
    "Add User": "Benutzer hinzuf\u00fcgen",
    "Add User to Group": "Benutzer zur Gruppe hinzuf\u00fcgen",
    "Add Wiki": "Wiki hinzuf\u00fcgen",
    "Add admin": "Admin hinzuf\u00fcgen",
    "Add auto expiration": "Ablaufdatum hinzuf\u00fcgen",
    "Add column": "Spalte hinzuf\u00fcgen",
    "Add cover": "Deckblatt hinzuf\u00fcgen",
    "Add custom permission": "Benutzerdefinierte Freigabeberechtigung hinzuf\u00fcgen",
    "Add department at": "Bereich hinzuf\u00fcgen in",
    "Add filter": "Filter hinzuf\u00fcgen",
    "Add group": "Gruppierung hinzuf\u00fcgen",
    "Add group member": "Gruppenmitglied hinzuf\u00fcgen",
    "Add icon": "Icon hinzuf\u00fcgen",
    "Add institution": "Einrichtung hinzuf\u00fcgen",
    "Add member": "Mitglied hinzuf\u00fcgen",
    "Add members": "Mitglieder hinzuf\u00fcgen",
    "Add new notification": "Mitteilung hinzuf\u00fcgen",
    "Add option": "Option hinzuf\u00fcgen",
    "Add option: %s": "Option hinzuf\u00fcgen:%s",
    "Add page": "Seite hinzuf\u00fcgen",
    "Add page above": "Seite oberhalb einf\u00fcgen",
    "Add page below": "Seite unterhalb einf\u00fcgen",
    "Add page inside": "Seite innerhalb einf\u00fcgen",
    "Add password protection": "Passwort hinzuf\u00fcgen",
    "Add permission": "Berechtigung hinzuf\u00fcgen",
    "Add sort": "Sortierung hinzuf\u00fcgen",
    "Add sub-department": "Unterbereich anlegen",
    "Add tag": "Tag hinzuf\u00fcgen",
    "Add to groups": "Den Gruppen hinzuf\u00fcgen",
    "Add user": "Hinzuf\u00fcgen",
    "Add view": "Ansicht hinzuf\u00fcgen",
    "Added": "Hinzugef\u00fcgt",
    "Added a new comment in document {sdoc_link}:": "Hat im Dokument {sdoc_link} einen neuen Kommentar hinzugef\u00fcgt:",
    "Added a new reply in document {sdoc_link}:": "Hat im Dokument {sdoc_link} eine neue Antwort hinzugef\u00fcgt:",
    "Added user {user}": "Benutzer {user} hinzugef\u00fcgt",
    "Added user {user} to group {group}": "Benutzer {user} wurde zur Gruppe {group} hinzugef\u00fcgt",
    "Address": "Adresse",
    "Admin": "Administration",
    "Admin Login Logs": "Administrative Loginprotokolle",
    "Admin Logs": "Administrationsprotokolle",
    "Admin Operation Logs": "Administrative Betriebsprotokolle",
    "Admin access": "Zugang f\u00fcr Administration",
    "Admin updated": "Der Administrator wurde aktualisiert.",
    "Admins": "Administratoren",
    "Advanced": "Erweitert",
    "After": "Danach",
    "After enable extended properties for files, you can add different properties to files, like collaborators, file expiring time, file description. You can also create different views for files based extended properties.": "Erweiterte Dateieigenschaften erm\u00f6glichen die Erfassung von Metadaten f\u00fcr Dateien, z.B. die Dateibearbeiter, die Ablaufzeit einer Datei oder eine Dateibeschreibung. Sie k\u00f6nnen auch Ansichten auf Basis der erweiterten Dateieigenschaften erstellen.",
    "After exceeding the traffic limit, the file download speed will be restricted.": "Nach Aussch\u00f6pfen des Limits f\u00fcr Daten\u00fcbertragungen wird die Geschwindigkeit f\u00fcr Downloads gedrosselt.",
    "All": "Alle",
    "All Activities": "Alle Aktivit\u00e4ten",
    "All Groups": "Meine Gruppen",
    "All Notifications": "Alle Mitteilungen",
    "All Public Links": "Alle \u00f6ffentlichen Links",
    "All comments": "Alle Kommentare",
    "All files uploaded": "Alle Dateien wurden hochgeladen.",
    "All tags": "Alle Tags",
    "Allow new registrations": "Selbstregistrierung zulassen",
    "Allow new user registrations. Uncheck this to prevent anyone from creating a new account.": "\u00dcber die Anmeldung k\u00f6nnen sich Besucher der Seite selbst ein Benutzerkonto anlegen.",
    "Allow users to change library history settings": "Benutzer k\u00f6nnen \u00c4nderungen an den Versionseinstellungen von Bibliotheken vornehmen.",
    "Allow users to clean library trash": "Benutzer k\u00f6nnen den Papierkorb von Bibliotheken leeren.",
    "Allow users to create encrypted libraries": "Benutzer k\u00f6nnen verschl\u00fcsselte Bibliotheken erstellen.",
    "An integer that is greater than 0 or equal to -2.": "Zahl gr\u00f6\u00dfer oder gleich 0 erforderlich, andernfalls -2.",
    "An integer that is greater than or equal to 0.": "Zahl gr\u00f6\u00dfer oder gleich 0 erforderlich.",
    "An internal link is a link to a file or folder that can be accessed by users with read permission to the file or folder.": "Interne Links sind Verweise auf Dateien oder Ordner, die nur von Benutzern mit mindestens Leserechten f\u00fcr die Dateien bzw. Ordner genutzt werden k\u00f6nnen. Interne Links eignen sich insbesondere f\u00fcr die interne Kommunikation in Ticket-/CRM-Systemen sowie E-Mails und Chats.",
    "And": "Und",
    "Anonymous User": "unbekannter Benutzer",
    "Another property has this property type": "Eine andere Eigenschaft hat diesen Eigenschaftstyp.",
    "Another user is editing this file!": "Ein anderer Benutzer bearbeitet diese Datei.",
    "Anyone with the link": "Jeder mit diesem Link",
    "App Name": "Name der App",
    "Are you sure to change group {placeholder} to department ?": "M\u00f6chten Sie die Gruppe {placeholder} wirklich in einen Bereich konvertieren?",
    "Are you sure to delete": "M\u00f6chten Sie dies wirklich l\u00f6schen",
    "Are you sure to delete ": "M\u00f6chten Sie dies wirklich l\u00f6schen:",
    "Are you sure to delete this comment?": "M\u00f6chten Sie das Kommentar wirklich l\u00f6schen?",
    "Are you sure to delete this reply?": "M\u00f6chten Sie die Antwort wirklich l\u00f6schen?",
    "Are you sure to revoke access of user {placeholder} ?": "M\u00f6chten Sie {placeholder} den Zugang wirklich entziehen?",
    "Are you sure you want to clean invalid share links?": "M\u00f6chten Sie die ung\u00fcltigen Freigabe-Links wirklich l\u00f6schen?",
    "Are you sure you want to clean invalid upload links?": "M\u00f6chten Sie die ung\u00fcltigen Upload-Links wirklich l\u00f6schen?",
    "Are you sure you want to clear trash?": "M\u00f6chten Sie den Papierkorb wirklich leeren?",
    "Are you sure you want to delete": "M\u00f6chten Sie dies wirklich l\u00f6schen:",
    "Are you sure you want to delete WebDAV password?": "M\u00f6chten Sie das WebDAV Passwort wirklich l\u00f6schen?",
    "Are you sure you want to delete Wiki": "M\u00f6chten Sie das Wiki wirklich l\u00f6schen?",
    "Are you sure you want to delete the notification ?": "M\u00f6chten Sie die Mitteilung wirklich l\u00f6schen?",
    "Are you sure you want to delete the selected share link(s) ?": "M\u00f6chten Sie den/die ausgew\u00e4hlten Freigabe-Link(s) wirklich l\u00f6schen?",
    "Are you sure you want to delete the selected upload link(s) ?": "M\u00f6chten Sie die ausgew\u00e4hlten Upload-Links wirklich l\u00f6schen?",
    "Are you sure you want to delete the selected user(s) ?": "M\u00f6chten Sie die ausgew\u00e4hlten Benutzer wirklich l\u00f6schen?",
    "Are you sure you want to delete the share link?": "M\u00f6chten Sie den Freigabe-Link wirklich l\u00f6schen?",
    "Are you sure you want to delete this option?": "M\u00f6chten Sie diese Option wirklich l\u00f6schen?",
    "Are you sure you want to delete this page?": "M\u00f6chten Sie die Seite wirklich l\u00f6schen?",
    "Are you sure you want to delete {placeholder} ?": "M\u00f6chten Sie {placeholder} wirklich l\u00f6schen?",
    "Are you sure you want to delete {placeholder} completely?": "M\u00f6chten Sie {placeholder} wirklich unwiderruflich l\u00f6schen?",
    "Are you sure you want to disconnect?": "M\u00f6chten Sie die Verbindung wirklich trennen?",
    "Are you sure you want to leave share Wiki": "M\u00f6chten Sie die Wiki-Freigabe wirklich verlassen?",
    "Are you sure you want to remove {placeholder} ?": "M\u00f6chten Sie {placeholder} wirklich entfernen?",
    "Are you sure you want to reset the password of {placeholder} ?": "M\u00f6chten Sie das Passwort f\u00fcr {placeholder} wirklich zur\u00fccksetzen?",
    "Are you sure you want to restore this library?": "M\u00f6chten Sie diese Version wirklich wiederherstellen?",
    "Are you sure you want to restore {placeholder}?": "M\u00f6chten Sie {placeholder} wirklich wiederherstellen?",
    "Are you sure you want to revoke the admin permission of {placeholder} ?": "M\u00f6chten Sie dem Benutzer {placeholder} wirklich die Administratorrechte entziehen?",
    "Are you sure you want to set {placeholder} as Admin?": "M\u00f6chten Sie {placeholder} wirklich zum Administrator machen?",
    "Are you sure you want to set {user_placeholder} inactive?": "M\u00f6chten Sie den Status von {user_placeholder} wirklich auf inaktiv setzen?",
    "Are you sure you want to unlink this device?": "M\u00f6chten Sie die Verbindung zu diesem Ger\u00e4t wirklich trennen?",
    "Are you sure you want to unpublish Wiki": "M\u00f6chten Sie die Ver\u00f6ffentlichung der Bibliothek wirklich r\u00fcckg\u00e4ngig machen? ",
    "Are you sure you want to unshare {placeholder} ?": "M\u00f6chten Sie die Freigabe von {placeholder} wirklich beenden?",
    "Ascending by count": "Aufsteigend nach Anzahl",
    "Ascending by creation time": "Aufsteigend nach Erstellungsdatum",
    "Ascending by name": "Aufsteigend nach Name",
    "Ascending by role": "Aufsteigend nach Rolle",
    "Ascending by size": "Aufsteigend nach Gr\u00f6\u00dfe",
    "Ascending by space used": "Aufsteigend nach verbrauchtem Speicherplatz",
    "Ascending by time": "Aufsteigend nach Datum",
    "Ascending by visit count": "Aufsteigend nach Aufrufen",
    "At server": "Server",
    "Audio": "Audio",
    "Auth Token created": "Ein Auth-Token wurde erstellt.",
    "Auth Token deleted": "Der Auth-Token wurde gel\u00f6scht.",
    "Authenticated emails": "Authentifizierte E-Mails",
    "Authenticated users": "Authentifizierte Benutzer",
    "Auto deletion": "Autol\u00f6schung",
    "Automatically delete files that are not modified within certain days:": "Dateien automatisch l\u00f6schen, die nicht innerhalb ein bestimmten Zeit ge\u00e4ndert wurden:",
    "Avatar": "Avatar",
    "Avatar updated": "Der Avatar wurde aktualisiert.",
    "Avatar:": "Avatar",
    "Back": "Zur\u00fcck",
    "Basic": "Basic",
    "Before": "Davor",
    "Bell Icon": "Glockensymbol",
    "Besides Write permission, user can also share the library.": "Schreiben und auch das Freigeben der Bibliothek ist erlaubt.",
    "Billing": "Bezahlung",
    "Branding": "Branding",
    "Broken (please contact your administrator to fix this library)": "Fehler (bitte wenden Sie sich zur Wiederherstellung dieser Bibliothek an Ihre Administration)",
    "Broken ({repo_id_placeholder})": "Keine Verbindung ({repo_id_placeholder})",
    "By child tags count ascending": "Aufsteigend nach Zahl der Tags",
    "By child tags count descending": "Absteigend nach Zahl der Tags",
    "By day": "Nach Tag",
    "By file count ascending": "Aufsteigend nach Zahl der Dateien",
    "By file count descending": "Absteigend nach Zahl der Dateien",
    "By month": "Nach Monat",
    "By name ascending": "Aufsteigend nach Name",
    "By name descending": "Absteigend nach Name",
    "By quarter": "Nach Quartal",
    "By size ascending": "Aufsteigend nach Gr\u00f6\u00dfe",
    "By size descending": "Absteigend nach Gr\u00f6\u00dfe",
    "By tag name ascending": "Aufsteigend nach Name des Tags",
    "By tag name descending": "Absteigend nach Name des Tags",
    "By time ascending": "Aufsteigend nach Zeit",
    "By time descending": "Absteigend nach Zeit",
    "By week": "Nach Woche",
    "By year": "Nach Jahr",
    "Can not copy folder %(src)s to its subfolder %(des)s": "Der Order  %(src)s kann nicht in den Unterordner %(des)s kopiert werden.",
    "Can not move folder %(src)s to its subfolder %(des)s": "Der Ordner %(src)s kann nicht in den Unterordner %(des)s verschoben werden",
    "Can only copy files that are in the same folder": "Nur Dateien im selben Ordner k\u00f6nnen kopiert werden",
    "Can only download files that are in the same folder": "Nur Dateien im selben Ordner k\u00f6nnen heruntergeladen werden",
    "Can only move files that are in the same folder": "Nur Dateien im selben Ordner k\u00f6nnen verschoben werden",
    "Cancel": "Abbrechen",
    "Cancel All": "Alle abbrechen",
    "Cannot move parent page to child page": "Die \u00fcbergeordnete Seite kann nicht auf die untergeordnete Seite verschoben werden.",
    "Capture information": "Aufnahmeinformtionen",
    "Capture time": "Aufnahmezeit",
    "Card": "Karte",
    "Certificate": "Zertifikat",
    "Change": "\u00c4ndern",
    "Change Password": "Passwort \u00e4ndern",
    "Change Password of Library {placeholder}": "Passwort der Bibliothek \u00e4ndern {placeholder}",
    "Change cover": "Deckblatt \u00e4ndern",
    "Change group to department": "Gruppe in Bereich konvertieren",
    "Change to department": "In Bereich \u00e4ndern",
    "Change view type": "Vorschautyp \u00e4ndern",
    "Changes": "\u00c4nderungen",
    "Checkbox": "Checkbox",
    "Child tags count": "Anzahl der untergeordneten Tags",
    "Choose date": "Datum ausw\u00e4hlen",
    "Clean": "Leeren",
    "Clean invalid share links": "Ung\u00fcltige Freigabelinks l\u00f6schen",
    "Clean invalid upload links": "Ung\u00fcltige Upload-Links l\u00f6schen",
    "Clean succeeded.": "Der Papierkorb wurde geleert.",
    "Cleaned trash": "Papierkorb geleert",
    "Clear": "L\u00f6schen",
    "Clear Trash": "Papierkorb leeren",
    "Clear files in trash and history\uff1a": "Papierkorb leeren und Versionen l\u00f6schen:",
    "Clear search": "Suche leeren",
    "Clear selected": "Auswahl aufheben",
    "Clients": "Programm",
    "Close": "Schlie\u00dfen",
    "Close (Esc)": "Schlie\u00dfen (Esc)",
    "Close the panel": "Leiste verbergen",
    "Code": "Code",
    "Collaborator": "Mitarbeiter",
    "Collaborators": "Mitarbeiter",
    "Collapse all": "Alle reduzieren",
    "Collected time": "Gesammelt um",
    "Color": "Farbe",
    "Color space": "Farbraum",
    "Comma (1,000,000)": "Komma (1,000,000)",
    "Comma(1,03)": "Komma (1,03)",
    "Comment": "Kommentar",
    "Comment details": "Kommentardetails",
    "Comments": "Kommentare",
    "Community Edition": "Community Edition",
    "Compressed": "Komprimiert",
    "Configure Seafile": "Konfiguration von Seafile",
    "Configure your Identity Provider": "Konfiguration des Identity Providers",
    "Confirm": "Best\u00e4tigen",
    "Confirm Password": "Passwort best\u00e4tigen",
    "Confirm password": "Passwort best\u00e4tigen",
    "Confluence export file": "Confluence-Export-Datei",
    "Confluence file imported": "Die Confluence-Datei wurde importiert",
    "Confluence imported": "Confluence wurde importiert",
    "Connect": "Verbinden",
    "Contact Email": "E-Mail-Kontakt",
    "Contact Email:": "E-Mail-Kontakt:",
    "Contact Information": "Kontaktinformation",
    "Contact email": "Kontakt-E-Mail",
    "Contact information is required.": "Kontaktinformation erforderlich",
    "Content Scan Records": "Doku der Datei-Scans",
    "Convert & Export": "Konvertieren & Exportieren",
    "Convert Wiki": "Wiki konvertieren",
    "Convert to Markdown": "In MD-Format konvertieren",
    "Convert to docx": "In DOCX-Format konvertieren",
    "Convert to new Wiki": "In neues Wiki konvertieren",
    "Convert to sdoc": "In SDOC-Format konvertieren",
    "Convert with ONLYOFFICE": "Mit ONLYOFFICE umwandeln",
    "Converting": "Konvertierung",
    "Converting, please wait...": "Die Konvertierung ist im Gang. Bitte warten Sie.",
    "Converting...": "Die Konvertierung ist im Gang ...",
    "Copied": "Kopiert",
    "Copied link to clipboard": "Der Link wurde in die Zwischenablage kopiert.",
    "Copy": "Kopieren",
    "Copy failed": "Die Kopie ist fehlgeschlagen.",
    "Copy link": "Link kopieren",
    "Copy path": "Pfad kopieren",
    "Copy selected": "Auswahl kopieren",
    "Copy selected item(s) to:": "Auswahl kopieren nach:",
    "Copy the IdP's certificate and paste it here. The certificate format is as follows:": "Kopieren Sie das Zertifikat des IdPs und f\u00fcgen Sie es hier ein. Das Format des Zertifikats ist wie folgt:",
    "Copy the domain DNS TXT and add it to your domain's DNS records, then click the button to verify domain ownership. You must verify the ownership of domain before Single Sign-On.": "Kopieren Sie den TXT-Wert und f\u00fcgen Sie diesen den DNS-Einstellungen Ihrer Domain hinzu. Klicken Sie dann die Schaltfl\u00e4che, um die Verifikation der Inhaberschaft der Domain zu starten. Sie m\u00fcssen die Domain-Inhaberschaft vor Nutzung von Single Sign-On nachweisen.",
    "Copy {num} items": "{num} Objekte werden kopiert",
    "Copy {placeholder} to": "{placeholder} kopieren nach",
    "Copyright Infringement": "Copyright-Verletzung",
    "Count": "Zugriffe",
    "Cover": "Deckblatt",
    "Cover photo set": "Titelfoto gesetzt",
    "Create": "Erstellen",
    "Create At": "Erstellt am",
    "Create Group": "Gruppe erstellen",
    "Create Library": "Bibliothek erstellen",
    "Create Report": "Bericht erzeugen",
    "Create a DNS TXT record to confirm the ownership of your Email Domain.": "Erstellen Sie einen TXT-Wert und verifizieren Sie damit Ihre Inhaberschaft der Domain.",
    "Create a new tag": "Neues Tag erstellen",
    "Create time": "Erstellt",
    "Create top department": "Obersten Bereich erstellen",
    "Created": "Erstellt",
    "Created At": "Erstellungsdatum",
    "Created Files": "Erstellte Dateien",
    "Created draft": "Entwurf erstellt",
    "Created file": "Erstellte Datei",
    "Created folder": "Ordner erstellt",
    "Created group {group_name}": "Gruppe {group_name} erstellt",
    "Created library": "Bibliothek erstellt",
    "Created library {library_name} with {owner} as its owner": "Bibliothek {library_name} mit {owner} als Eigent\u00fcmer/in erstellt",
    "Created time": "Erstellt",
    "Created {n} files": "{n} Dateien erstellt",
    "Creator": "Eigent\u00fcmer",
    "Currency symbol is required": "W\u00e4hrungssymbol erforderlich",
    "Current Connected Devices": "aktuell verbundene Ger\u00e4te",
    "Current Library": "Aktuelle Bibliothek",
    "Current Path: ": "Aktueller Pfad: ",
    "Current Version": "Aktuelle Version",
    "Current page": "Aktuelle Seite",
    "Current password": "Aktuelles Passwort",
    "Current password cannot be blank": "Aktuelles Passwort darf nicht leer sein",
    "Current path: ": "Aktueller Pfad: ",
    "Custom CSS": "Angepasstes CSS",
    "Custom currency": "Eigene W\u00e4hrung",
    "Custom properties": "Benutzerdefinierte Eigenschaften",
    "Custom sharing permissions": "Benutzerdefinierte Freigabeberechtigung",
    "Custom symbol": "Eigenes Symbol",
    "Custom time": "Eigener Zeitraum",
    "Customer Portal": "Kundenportal",
    "Customize URL": "URL anpassen",
    "DNS TXT Value": "TXT-Wert",
    "Dark mode": "Dunkler Modus",
    "Date": "Datum",
    "Date Invalid.": "Datum ung\u00fcltig",
    "Day": "Tag",
    "Decimal separator": "Dezimaltrenner",
    "Decrypt document": "Dokument entschl\u00fcsseln",
    "Default": "Standard",
    "Delete": "L\u00f6schen",
    "Delete Account": "Benutzerkonto l\u00f6schen",
    "Delete Department": "Bereich l\u00f6schen",
    "Delete Expired Invitations": "Abgelaufene Einladungen l\u00f6schen",
    "Delete File": "Datei l\u00f6schen",
    "Delete Folder": "Ordner l\u00f6schen",
    "Delete Group": "Gruppe l\u00f6schen",
    "Delete Institution": "Einrichtung l\u00f6schen",
    "Delete Library": "Bibliothek l\u00f6schen",
    "Delete Member": "Mitglied l\u00f6schen",
    "Delete Notification": "Mitteilung l\u00f6schen",
    "Delete Organization": "Organisation l\u00f6schen",
    "Delete Password": "Passwort l\u00f6schen",
    "Delete T&C": "T&C l\u00f6schen",
    "Delete Team": "Team l\u00f6schen",
    "Delete User": "Benutzer l\u00f6schen",
    "Delete User from Group": "Benutzer aus der Gruppe l\u00f6schen",
    "Delete Users": "Benutzer l\u00f6schen",
    "Delete WebDAV Password": "WebDAV Passwort l\u00f6schen",
    "Delete Wiki": "Wiki l\u00f6schen",
    "Delete department": "Bereich l\u00f6schen",
    "Delete file": "Datei l\u00f6schen",
    "Delete files from this device the next time it comes online.": "L\u00f6sche beim n\u00e4chsten Verbindungsaufbau alle Dateien von diesem Ger\u00e4t.",
    "Delete folder": "Ordner l\u00f6schen",
    "Delete group": "Gruppe l\u00f6schen",
    "Delete location": "Standort l\u00f6schen",
    "Delete member": "Mitglied l\u00f6schen",
    "Delete page": "Seite l\u00f6schen",
    "Delete property": "Eigenschaft l\u00f6schen",
    "Delete selected": "Auswahl l\u00f6schen",
    "Delete share link": "Freigabe-Link l\u00f6schen",
    "Delete share links": "Freigabe-Links l\u00f6schen",
    "Delete tag": "Tag l\u00f6schen",
    "Delete tags": "Tags l\u00f6schen",
    "Delete upload links": "Upload-Links l\u00f6schen",
    "Deleted": "Gel\u00f6scht",
    "Deleted Libraries": "Gel\u00f6schte Bibliotheken",
    "Deleted Time": "L\u00f6schdatum",
    "Deleted by": "Gel\u00f6scht von",
    "Deleted directories": "Gel\u00f6schte Ordner",
    "Deleted draft": "Entwurf wurde gel\u00f6scht.",
    "Deleted file": "Gel\u00f6schte Datei",
    "Deleted files": "Gel\u00f6schte Dateien",
    "Deleted folder": "Gel\u00f6schter Ordner",
    "Deleted group {group_name}": "Gruppe {group_name} gel\u00f6scht",
    "Deleted library": "Gel\u00f6schte Bibliothek",
    "Deleted library {library_name}": "Bibliothek {library_name} gel\u00f6scht",
    "Deleted option": "Gel\u00f6schte Option",
    "Deleted time": "L\u00f6schdatum",
    "Deleted user %s": "Der Bentzer %s wurde gel\u00f6scht.",
    "Deleted user {user}": "Benutzer {user} gel\u00f6scht",
    "Deleted user {user} from group {group}": "Benutzer {user} wurde aus der Gruppe {group} gel\u00f6scht",
    "Department ID": "Bereichs ID",
    "Department moved successfully": "Der Bereich wurde verschoben",
    "Department not found": "Bereich nicht gefunden",
    "Department renamed": "Der Bereich wurde umbenannt",
    "Departments": "Bereiche",
    "Descending by count": "Absteigend nach Anzahl",
    "Descending by creation time": "Absteigend nach Erstellungsdatum",
    "Descending by files": "Absteigend nach Dateien",
    "Descending by name": "Absteigend nach Name",
    "Descending by role": "Absteigend bei Rolle",
    "Descending by size": "Absteigend nach Gr\u00f6\u00dfe",
    "Descending by space used": "Absteigend nach verbrauchtem Speicherplatz",
    "Descending by time": "Absteigend nach Datum",
    "Descending by visit count": "Absteigend nach Aufrufen",
    "Description": "Beschreibung",
    "Description generated": "Eine Beschreibung wurde erzeugt.",
    "Description is required": "Beschreibung erforderlich",
    "Desktop": "Desktop",
    "Detail": "Details",
    "Details": "Details",
    "Detect faces": "Gesichter finden",
    "Detecting faces by AI...": "Gesichtserkennung mit KI \u2026",
    "Device": "Ger\u00e4t",
    "Device Name": "Name des Ger\u00e4ts",
    "Device make": "Ger\u00e4temarke",
    "Device model": "Ger\u00e4temodell",
    "Devices": "Ger\u00e4te",
    "Diagram": "Diagramm",
    "Dimensions": "Dimensionen",
    "Direct download link": "Direkter Download-Link",
    "Direct download link is copied to the clipboard.": "Der Link zum direkten Download wurde in die Zwischenablage kopiert.",
    "Disable SSO user email / password login": "SSO-Benutzer-E-Mail / Passwort-Anmeldung deaktivieren",
    "Disable Two-Factor Authentication": "Zwei-Faktor-Authentifizierung deaktivieren",
    "Disable sync with any folder": "Sync mit jedem Ordner ausschlie\u00dfen",
    "Disable user clean trash": "Leeren des Papierkorbs durch Benutzer ausschlie\u00dfen",
    "Disconnect": "Trennen",
    "Discussion": "Diskussionen",
    "Display files": "Dateien anzeigen",
    "Do not automatically delete files": "Dateien nicht automatisch l\u00f6schen",
    "Do not keep sharing": "Freigabe l\u00f6schen",
    "Do you really want to turn off extended properties? Existing properties will all be deleted.": "M\u00f6chten Sie die erweiterten Eigenschaften wirklich deaktivieren? Alle Eigenschaften werden gel\u00f6scht.",
    "Do you really want to turn off face recognition? Existing results will all be deleted.": "M\u00f6chten Sie die Gesichtserkennung wirklich deaktivieren? Alle Ergebnisse der Gesichtserkennung werden gel\u00f6scht.",
    "Do you really want to turn off tags? Existing tags will all be deleted.": "M\u00f6chten Sie Tags wirklich deaktivieren? Alle Tags werden gel\u00f6scht.",
    "Do you want to keep the library sharing relationships?": "Wollen Sie die Freigabe-Verbindungen f\u00fcr die Bibliothek beibehalten?",
    "Document": "Dokument",
    "Document conversion failed.": "Konvertierung der Datei fehlgeschlagen.",
    "Document keywords": "Stichworte des Dokuments",
    "Dollar": "Dollar",
    "Domain verified": "Die Domain wurde verifiziert.",
    "Don't ignore": "Nicht ignorieren",
    "Don't keep history": "Versionen nicht speichern",
    "Don't replace": "Nicht ersetzen",
    "Don't send emails": "Keine E-Mails schicken",
    "Don't show empty values": "Leere Werte nicht anzeigen",
    "Done": "Erledigt",
    "Dot(1.03)": "Punkt (1.03)",
    "Down": "Absteigend",
    "Download": "Herunterladen",
    "Download Rate Limit": "Download-Durchsatzbegrenzung",
    "Download an example file": "Beispieldatei herunterladen",
    "Download and upload": "Download und Upload",
    "Drag and drop files or folders here.": "Ziehen Sie Dateien oder Ordner hierher",
    "Duplicate": "Duplikat",
    "Duplicate page": "Seite duplizieren",
    "Edit": "Bearbeiten",
    "Edit format settings": "Formateinstellungen bearbeiten",
    "Edit labels": "Label bearbeiten",
    "Edit metadata properties": "Metadata-Eigenschaften bearbeiten",
    "Edit multiple select": "Mehrfachauswahl bearbeiten",
    "Edit on cloud and download": "Bearbeiten online und Herunterladen",
    "Edit on cloud only": "Bearbeiten nur online",
    "Edit permission": "Berechtigung bearbeiten",
    "Edit single select": "Einfachauswahl bearbeiten",
    "Edit succeeded": "Die Bearbeitung wurde gespeichert.",
    "Edit succeeded.": "Die Bearbeitung wurde gespeichert.",
    "Edit tag": "Tag bearbeiten",
    "Edit tags": "Tags bearbeiten",
    "Email": "E-Mail-Adresse",
    "Email Domain": "E-Mail-Domain",
    "Email Notification": "E-Mail-Benachrichtigung",
    "Email is invalid.": "Die E-Mail-Adresse ist ung\u00fcltig.",
    "Email notification updated": "Die E-Mail-Benachrichtigung wurde aktualisiert.",
    "Emails": "E-Mails",
    "Emails, separated by ','": "E-Mail-Adressen, getrennt durch Komma",
    "Emojis": "Emojis",
    "Empty": "Leer",
    "Enable Two-Factor Authentication": "Zwei-Faktor-Authentifizierung aktivieren",
    "Enable branding CSS": "Custom CSS",
    "Enable departments feature": "Bereiche aktivieren",
    "Enable extended properties": "Erweiterte Eigenschaften aktivieren",
    "Enable face recognition to identify people in your photos.": "Gesichtserkennung aktivieren, um Personen in Ihren Fotos zu identifizeren",
    "Enable system admin to add Terms and Conditions, and all users will have to accept the terms.": "Benutzer m\u00fcssen vor der Nutzung des Systems die Nutzungsbedingungen akzeptieren.",
    "Enable tags to add tags to files and search files by tags.": "Mit Tags lassen sich Dateien einfach kategorisieren und danach suchen.",
    "Enable terms and conditions": "Nutzungsbedingungen aktivieren",
    "Enable two factor authentication": "Benutzer k\u00f6nnen \u00fcber ihre Einstellungen die Zwei-Faktor-Authentifizierung einrichten.",
    "Enable users to clean trash": "Leeren des Papierkorbs zulassen",
    "Enable users to share libraries to any groups in the system.": "Benutzer k\u00f6nnen Bibliotheken an jede Gruppen freigeben. (Wenn dies nicht aktiviert ist, dann sind Freigaben nur an die Gruppen m\u00f6glich, in denen die Benutzer Mitglied sind.)",
    "Enable\u00a0sharing\u00a0to\u00a0all\u00a0groups": "Freigabe an alle Gruppen zulassen",
    "Encrypt": "Verschl\u00fcsseln",
    "Encrypted library": "Verschl\u00fcsselte Bibliothek",
    "End date": "Enddatum",
    "Enforce precision": "Genauigkeit obligat",
    "Enter characters to start searching": "Geben Sie etwas ein, um die Suche zu starten",
    "Enter custom currency symbol": "Eigenes W\u00e4hrungssymbol eingeben",
    "Enter date": "Datum eingeben",
    "Error": "Fehler",
    "Errors": "Fehlermeldungen",
    "Euro": "Euro",
    "European": "Europ\u00e4isch",
    "Exact date": "Exaktes Datum",
    "Exit Institution Admin": "Einrichtungsverwaltung verlassen",
    "Exit Organization Admin": "Organisationsverwaltung verlassen",
    "Exit System Admin": "Systemverwaltung verlassen",
    "Expand all": "Alle erweitern",
    "Expiration": "Ablaufdatum",
    "Expiration date": "Ablaufdatum",
    "Expiration days": "Tage bis zum Ablaufen",
    "Expiration time": "Zeitpunkt des Ablaufens",
    "Expired": "Abgelaufen",
    "Expired at": "Abgelaufen am",
    "Export": "Exportieren",
    "Export Excel": "In Excel exportieren",
    "Export as Markdown": "Als Markdown-Datei exportieren",
    "Export as docx": "Als DOCX-Datei exportieren",
    "Export as sdoc": "Als sdoc-Datei exportieren",
    "Export as zip": "In ZIP-Archiv exportieren",
    "Export options": "Optionen exportieren",
    "Export tags": "Tags exportieren",
    "Exporting": "Export",
    "Exporting...": "Der Export ist im Gang...",
    "Exposure time": "Belichtungszeit",
    "Extended properties": "Erweiterte Eigenschaften",
    "Extension Prompts": "Extension Prompts",
    "Extensions of text files that can be online previewed, each suffix is separated by a comma.": "Textdateiformate, die im Texteditor des Web Interfaces angezeigt werden (mehrere Endungen durch Komma trennen).",
    "Extract file detail": "Dateidetails extrahieren",
    "Extract file details": "Dateidetails extrahieren",
    "Extract text": "Text extrahieren",
    "Extracting file details by AI...": "Die Dateidetails werden durch KI extrahiert ...",
    "Extracting text, please wait...": "Text wird extrahiert, bitte warten \u2026",
    "F number": "Lichtst\u00e4rke",
    "Face recognition": "Gesichtserkennung",
    "Face recognition is done for library {libraryName}.": "Die Gesichtserkennung erfolgt f\u00fcr die Bibliothek {libraryName}.",
    "Faces detected": "Gesichter gefunden",
    "Failed": "Fehlgeschlagen",
    "Failed imported options": "Der Import der Optionen ist fehlgeschlagen.",
    "Failed to add linked tags": "Das Hinzuf\u00fcgen von verlinkten Tags ist fehlgeschlagen.",
    "Failed to add people photos": "Das Hinzuf\u00fcgen von Personenfotos ist fehlgeschlagen.",
    "Failed to add tags": "Das Hinzuf\u00fcgen der Tags ist fehlgeschlagen.",
    "Failed to add {email_placeholder}: {error_msg_placeholder}": "Hinzuf\u00fcgen von {email_placeholder} fehlgeschlagen: {error_msg_placeholder}",
    "Failed to convert {name}.": "Die Konvertierung von {name} ist fehlgeschlagen.",
    "Failed to copy %(name)s": "Fehler beim Kopieren von %(name)s.",
    "Failed to copy %(name)s and %(amount)s other item(s).": "Fehler beim Kopieren von %(name)s und %(amount)s weiteren Objekten.",
    "Failed to copy %(name)s.": "Fehler beim Kopieren von %(name)s.",
    "Failed to copy file": "Fehler beim Kopieren der Datei",
    "Failed to copy files to another library.": "Die Dateien konnten nicht in die andere Bibliothek kopiert werden.",
    "Failed to copy {n} items": "Fehler beim Kopieren von {n} Elementen",
    "Failed to delete %(virus_file) from library %(library): %(error_msg)": "Die Datei %(virus_file) in Bibliothek %(library) konnte nicht gel\u00f6scht werden: %(error_msg)",
    "Failed to delete linked tags": "Das L\u00f6schen von verlinkten Tags ist fehlgeschlagen.",
    "Failed to delete property": "Das L\u00f6schen der Eigenschaft ist fehlgeschlagen.",
    "Failed to delete records": "Das L\u00f6schen der Eintr\u00e4ge ist fehlgeschlagen.",
    "Failed to delete tags": "Das L\u00f6schen der Tags ist fehlgeschlagen.",
    "Failed to delete {name}": "Fehler beim L\u00f6schen von {name}",
    "Failed to delete {name} and {n} other items.": "Die L\u00f6schung von {name} und {n} anderen Elements/anderer Elemente ist fehlgeschlagen.",
    "Failed to delete {name}.": "Fehler beim L\u00f6schen von {name}.",
    "Failed to detect faces": "Keine Gesichter gefunden ",
    "Failed to download. The total size of the files exceeded the limit.": "Der Download ist fehlgeschlagen. Die Gesamtgr\u00f6\u00dfe der Dateien \u00fcberschreitet das Limit.",
    "Failed to duplicate file": "Die Duplizierung der Datei ist fehlgeschlagen.",
    "Failed to duplicate folder": "Die Duplizierung des Ordners ist fehlgeschlagen.",
    "Failed to duplicate page": "Die Duplizierung der Seite ist fehlgeschlagen.",
    "Failed to export tags": "Export der Tags fehlgeschlagen",
    "Failed to export. Please check whether the size of table attachments exceeds the limit.": "Der Export ist fehlgeschlagen. Stellen Sie sicher, dass die Gr\u00f6\u00dfe der Anh\u00e4nge nicht das Limit \u00fcberschreiten.",
    "Failed to extract file details": "Die Extraktion der Dateidetails ist fehlgeschlagen.",
    "Failed to extract text": "Die Extraktion des Textes ist fehlgeschlagen.",
    "Failed to generate description": "Die Erzeugung einer Beschreibung ist fehlgeschlagen.",
    "Failed to generate file tags": "Die Erstellung von Datei-Tags ist fehlgeschlagen.",
    "Failed to ignore %(virus_file) from library %(library): %(error_msg)": "Die Datei %(virus_file) in Bibliothek %(library) konnte nicht ignoriert werden: %(error_msg)",
    "Failed to import Confluence": "Confluence konnte nicht importiert werden",
    "Failed to import Confluence file": "Die Confluence-Datei konnte nicht importiert werden",
    "Failed to import page": "Import der Seite fehlgeschlagen",
    "Failed to import tags": "Import der Tags fehlgeschlagen",
    "Failed to insert property": "Das Einf\u00fcgen der Eigenschaft ist fehlgeschlagen.",
    "Failed to merge tags": "Das Zusammenf\u00fchren von Tags ist fehlgeschlagen.",
    "Failed to modify filter": "Die Bearbeitung der Filter ist fehlgeschlagen.",
    "Failed to modify group": "Die Bearbeitung der Gruppierung ist fehlgeschlagen.",
    "Failed to modify hidden properties": "Die Bearbeitung der ausgeblendeten Eigenschaften ist fehlgeschlagen.",
    "Failed to modify people name": "Die Bearbeitung der Personennamen ist fehlgeschlagen.",
    "Failed to modify property data": "Die Bearbeitung der Eigenschaft ist fehlgeschlagen.",
    "Failed to modify property order": "Die Bearbeitung der Reihenfolge der Eigenschaften ist fehlgeschlagen.",
    "Failed to modify records": "Die Bearbeitung der Eintr\u00e4ge ist fehlgeschlagen.",
    "Failed to modify settings": "Die \u00c4nderung der Einstellungen ist fehlgeschlagen.",
    "Failed to modify sort": "Die Bearbeitung der Sortierung ist fehlgeschlagen.",
    "Failed to modify tags": "Die Bearbeitung der Tags ist fehlgeschlagen.",
    "Failed to move %(name)s and %(amount)s other item(s).": "Fehler beim Verschieben von %(name)s und %(amount)s weiteren Objekten.",
    "Failed to move %(name)s.": "Fehler beim Verschieben von %(name)s.",
    "Failed to move file": "Das Verschieben der Datei ist fehlgeschlagen.",
    "Failed to move files to another library.": "Die Dateien konnten nicht in die andere Bibliothek verschoben werden.",
    "Failed to move folder": "Das Verschieben des Ordners ist fehlgeschlagen.",
    "Failed to move {name}.": "Fehler beim Verschieben von {name}.",
    "Failed to move {n} items": "Fehler beim Verschieben von {n} Elementen",
    "Failed to remove people photos": "Die L\u00f6schung der Personenfotos ist fehlgeschlagen.",
    "Failed to rename property": "Das Umbenennen der Eigenschaft ist fehlgeschlagen.",
    "Failed to restore records": "Die Wiederherstellung der Eintr\u00e4ge ist fehlgeschlagen.",
    "Failed to restore tags": "Das Wiederherstellen von Tags ist fehlgeschlagen.",
    "Failed to restore {name}": "Die Wiederherstellung von {name} ist fehlgeschlagen.",
    "Failed to restore {name} and {n} other items": "Die Wiederherstellung von {name} und {n} anderen Elements/anderer Elemente ist fehlgeschlagen.",
    "Failed to save": "Die Speicherung ist fehlgeschlagen.",
    "Failed to send to {email_placeholder}: {errorMsg_placeholder}": "Senden an {email_placeholder} fehlgeschlagen: {errorMsg_placeholder}",
    "Failed to set people cover photo": "Das Setzen von Personenfotos als Deckblatt ist fehlgeschlagen.",
    "Failed to unshare {name}": "Fehler beim Beenden der Freigabe von {name}",
    "Failed to upload {file_name}.": "Der Upload der Datei {file_name} ist fehlgeschlagen.",
    "Failed. Please check the network.": "Fehlgeschlagen. Bitte \u00fcberpr\u00fcfen Sie die Netzwerkverbindung.",
    "Favicon": "Favicon",
    "Favorites": "Favoriten",
    "File": "Datei",
    "File Access": "Dateizugriff",
    "File Operations": "Dateioperationen",
    "File Scan": "Scan der Dateien",
    "File Update": "Dateiaktualisierung",
    "File Upload": "Datei-Upload",
    "File Uploading...": "Der Upload ist im Gang ...",
    "File already exists.": "Die Datei existiert bereits.",
    "File collaborators": "Mitarbeiter der Datei",
    "File count": "Anzahl der Dateien",
    "File details": "Details der Datei",
    "File details extracted": "Die Dateidetails wurden extrahiert.",
    "File download is disabled: the share link traffic of owner is used up.": "Das Herunterladen ist deaktiviert: Das Datenvolumen des Eigent\u00fcmers f\u00fcr Freigaben ist aufgebraucht.",
    "File expire time": "Ablaufdatum der Datei",
    "File extension white list": "Dateiendungen-Whitelist",
    "File extension white list for file upload via web UI and API. For example, \"md;txt;docx\". Empty means no limit.": "Dateiendungen-Whitelist f\u00fcr Dateien, die per Webinterface und API hochgeladen werden. (Beispiel: \"md;txt;docx\") Leer bedeutet keine Einschr\u00e4nkungen.",
    "File extensions can only be {placeholder}.": "Die Dateiendung muss eine der folgenden sein: {placeholder}",
    "File is locked by others.": "Die Datei ist durch jemand anderen gesperrt.",
    "File name": "Dateiname",
    "File name and content": "Dateiname und Inhalt",
    "File name only": "Nur Dateiname",
    "File owner": "Eigent\u00fcmer der Datei",
    "File rate": "Rating der Datei",
    "File reviewer": "Reviewer der Datei",
    "File size is too large.": "Die Datei ist zu gro\u00df.",
    "File size should be smaller than {max_size_placeholder}.": "Die Dateigr\u00f6\u00dfe muss kleiner sein als {max_size_placeholder}.",
    "File status": "Status der Datei",
    "File suffix": "Dateiendung",
    "File too large": "Die Datei ist zu gro\u00df.",
    "File type": "Dateityp",
    "File {file_link} has a new comment form user {author}.": "{file_link} wurde von {author} kommentiert.",
    "Files": "Dateien",
    "Files and folders": "Dateien und Ordner",
    "Files by creator": "Dateien nach Ersteller/in",
    "Files by time": "Dateien nach Datum",
    "Files by type": "Dateien nach Typ",
    "Fill in": "Ausf\u00fcllen",
    "Filter": "Filter",
    "Filters": "Filter",
    "Find": "Suchen",
    "Find a tag": "Tag suchen",
    "Find libraries": "Bibliotheken suchen",
    "Find modifiers": "Bearbeiter suchen",
    "Find users": "Benutzer suchen",
    "Focal length": "Brennweite",
    "Fold": "Einklappen",
    "Fold the sidebar": "Seitenleiste einklappen",
    "Folder": "Ordner",
    "Folder Permission": "Ordnerberechtigung",
    "Folder does not exist.": "Der Ordner ist nicht vorhanden.",
    "Folder permission is only effective after the library is shared to users or groups. It is used to fine tune sub-folder permissions.": "Die Ordnerberechtigungen werden erst wirksam, nachdem die Bibliothek an Benutzer oder Gruppen freigegeben wurde. Sie werden zur Feinjustierung des Zugriffs auf Unterordner verwendet.",
    "Folders": "Ordner",
    "Force Two-Factor Authentication": "Zwei-Faktor-Authentifizierung erzwingen",
    "Force password change": "Passwort\u00e4nderung erzwingen",
    "Force user to change password when account is newly added or reset by admin": "Benutzer m\u00fcssen bei der n\u00e4chsten Anmeldung ihr Passwort \u00e4ndern, wenn es systemseitig erzeugt oder zur\u00fcckgesetzt wurde.",
    "Force user to use SSO login if SSO account is bound": "Benutzer zwingen, SSO-Anmeldung zu verwenden, wenn SSO-Konto gebunden ist",
    "Force user to use a strong password when sign up or change password.": "Benutzer m\u00fcssen bei der Passwort\u00e4nderung oder der Selbstregistrierung Passw\u00f6rter verwenden, die den definierten Mindestanforderungen gen\u00fcgen. (Wenn dies nicht aktiviert ist, dann werden die Anforderungen unten nicht erzwungen.)",
    "Force users to use password when generating share/upload link.": "Benutzer m\u00fcssen bei der Erstellung eines Upload- oder Download-Links ein Passwort vergeben",
    "Format": "Format",
    "Freeze Document": "Dokument sperren",
    "Freeze page": "Seite einfrieren",
    "Freeze user account when failed login attempts exceed limit.": "Benutzerkonten werden gesperrt, wenn die erlaubte Anzahl an Anmeldeversuche \u00fcberschritten werden.",
    "Freeze user on login failed": "Benutzer sperren bei erfolgloser Anmeldung",
    "Frozen by {name}": "Eingefroren von {name}",
    "Full screen": "Vollbild",
    "Gallery": "Galerie",
    "General": "Allgemein",
    "General information": "Allgemeine Informationen",
    "Generate": "Erstellen",
    "Generate Link": "Link generieren",
    "Generate description": "Beschreibung erstellen",
    "Generate file tags": "Tags erstellen",
    "Generate links in batch": "Mehrere Links generieren",
    "Generate share link": "Freigabe-Link erstellen",
    "Generating description by AI...": "Eine Beschreibung wird durch KI erzeugt ...",
    "Germany Russia etc": "Deutschland, Russland, etc",
    "Global Address Book": "Zentrales Adressbuch",
    "Global hidden properties": "Zentral ausgeblendete Eigenschaften",
    "Global hidden properties will not be displayed in all views.": "Zentral ausgeblendete Eigenschaften werden generell nicht angezeigt.",
    "Go back": "Zur\u00fcck",
    "Go to Library": "Zur Bibliothek wechseln",
    "Greater than or equal to {minDays_placeholder} days": "Mindestens {minDays_placeholder} Tage",
    "Grid view": "Rasteransicht",
    "Group": "Gruppe",
    "Group Invite": "Gruppeneinladung",
    "Group Member": "Gruppenmitglied",
    "Group Permission": "Gruppenberechtigung",
    "Group Shares": "Gruppenfreigaben",
    "Group by": "Gruppierung \u00fcber",
    "Group deleted": "Gruppe ist gel\u00f6scht",
    "Group has been transferred": "Die Gruppe wurde \u00fcbertragen",
    "Group info": "Gruppeninformation",
    "Group invitation link": "Einladungslink f\u00fcr Gruppen",
    "Group members": "Gruppenmitglieder",
    "Grouped by 1 property": "Gruppierung \u00fcber 1 Eigenschaft",
    "Grouped by {name_placeholder} properties": "Gruppiert nach {name_placeholder} Eigenschaften",
    "Groups": "Gruppen",
    "Guest": "Gast",
    "Handled": "Erledigt",
    "Help": "Hilfe",
    "Help and resources": "Hilfe und Ressourcen",
    "Hidden properties": "Ausgeblendete Eigenschaften",
    "Hide": "Verbergen",
    "Hide advanced search": "Erweiterte Suche verbergen",
    "Hide all": "Alle ausblenden",
    "Hide properties": "Eigenschaften ausblenden",
    "History": "Versionen",
    "History Setting": "Versionseinstellungen",
    "History Versions": "Versionen",
    "ID": "ID",
    "IP": "IP-Adresse",
    "ISO": "International (ISO)",
    "Identifying portraits...": "Die Identifizierung der Portr\u00e4ts ist im Gang ...",
    "If notifications have not been read within one hour, they will be sent to your mailbox.": "Wenn Benachrichtigungen nicht innerhalb einer Stunde gelesen werden, dann erhalten Sie eine E-Mail-Benachrichtigung.",
    "If the library is shared to another department, the sharing will be kept.": "Wenn die Bibliothek an einen anderen Bereich freigegeben ist, dann bleibt die Freigabe bestehen.",
    "If the library is shared to another user, the sharing will be kept.": "Wenn die Bibliothek an einen anderen Benutzer freigegeben ist, dann bleibt die Freigabe bestehen.",
    "If there are multiple items in the cell, a random one will be chosen and be compared with the filter value.": "Wenn eine Zelle mehrere Elemente enth\u00e4lt, dann wird ein Element zuf\u00e4llig ausgew\u00e4hlt und mit dem Filterwert verglichen.",
    "If turn on, the desktop clients will not be able to sync a folder outside the default Seafile folder.": "Benutzer k\u00f6nnen \u00fcber den Sync Client Bibliotheken nur in den Standardordner synchronisieren. (Eine \u00c4nderung hat keine Auswirkung auf bestehende Synchronisationen.)",
    "If you don't have any device with you, you can access your account using backup codes.": "Falls Sie kein Ger\u00e4t bei sich haben, k\u00f6nnen Sie sich mit Ersatz-Codes einloggen.",
    "Ignore": "Ignorieren",
    "Ignored": "Ignoriert",
    "Image saved": "Das Bild wurde gespeichert.",
    "Import": "Import",
    "Import Confluence": "Confluence importieren",
    "Import Confluence Wiki": "Confluence-Wiki importieren",
    "Import Users": "Benutzer importieren",
    "Import members": "Mitglieder importieren",
    "Import members from a .xlsx file": "Mitglieder aus XLSX-Datei importieren",
    "Import options": "Optionen importieren",
    "Import page": "Seite importieren",
    "Import page from Markdown": "Seite aus Markdown importieren",
    "Import page from docx": "Seite aus docx importieren",
    "Import sdoc": "SDOC-Dokument importieren",
    "Import tags": "Tags importieren",
    "Import users": "Importieren",
    "Import users from a .xlsx file": "Benutzer aus XLSX-Datei importieren",
    "Importing page...": "Seite wird importiert \u2026",
    "Importing sdoc, please wait...": "Import von SDOC-Dokument im Gang ...",
    "Importing tags...": "Tags werden importiert \u2026",
    "Importing...": "Import l\u00e4uft \u2026",
    "In progress": "In Arbeit",
    "In review": "In der \u00dcberpr\u00fcfung",
    "Inactive": "Inaktiv",
    "Info": "Info",
    "Institution Admin": "Einrichtungsverwaltung",
    "Institutions": "Einrichtungen",
    "Internal Link": "Interner Link",
    "Internal Server Error": "Interner Serverfehler",
    "Internal link has been copied to clipboard": "Der interne Link wurde in die Zwischenablage kopiert.",
    "Invalid destination path": "Ung\u00fcltiger Zielpfad",
    "Invalid filename.": "Der Dateiname ist ung\u00fcltig.",
    "Invalid filter": "Ung\u00fcltiger Filter",
    "Invalid month, should be yyyymm.": "Bitte geben Sie den Monat im Format JJJJMM ein.",
    "Invalid regular expression": "Ung\u00fcltiger regul\u00e4rer Ausdruck (Regex)",
    "Invisible": "Unsichtbar",
    "Invitation link has been copied to clipboard": "Einladungslink ist in die Zwischenablage kopiert",
    "Invitations": "Einladungen",
    "Invite Guest": "Gast einladen",
    "Invite Time": "Zeitpunkt der Einladung",
    "Invite members": "Mitglieder einladen",
    "Invite users": "Benutzer einladen",
    "Invite users via WeChat": "Nutzer \u00fcber WeChat einladen",
    "Invited at": "Eingeladen am",
    "Inviter": "Gastgeber",
    "Is expired": "Ist abgelaufen",
    "It is already shared to user": "Es ist bereits an den Benutzer freigegeben.",
    "It is required.": "Erforderlich",
    "It may take some time, please wait.": "Es kann etwas dauern, bitte warten Sie.",
    "Kanban": "Kanban",
    "Keep full history": "Alle Versionen speichern",
    "Keep sharing": "Freigabe beibehalten",
    "Keep sign in": "Anmeldung speichern",
    "LDAP": "LDAP",
    "LDAP(imported)": "LDAP (Import)",
    "Label": "Label",
    "Label Current State": "Bezeichnung aktueller Status",
    "Labels": "Label",
    "Language": "Sprache",
    "Language Setting": "Sprache",
    "Language for tags generated by AI": "Sprache f\u00fcr Tags, die mit KI generiert werden",
    "Last 30 days": "Letzte 30 Tage",
    "Last 7 days": "Letzte 7 Tage",
    "Last Access": "Letzter Zugriff",
    "Last Login": "Letzte Anmeldung",
    "Last Update": "Letzte \u00c4nderung",
    "Last modification": "Letzte \u00c4nderung",
    "Last modified by": "Zuletzt bearbeitet von",
    "Last modified time": "Letzte Bearbeitungszeit",
    "Last modifier": "Letzter Bearbeiter",
    "Leave": "Verlassen",
    "Leave Group": "Gruppe verlassen",
    "Leave Share": "Freigegebene Bibliothek verlassen",
    "Leave Share Wiki": "Wiki-Freigabe verlassen",
    "Leave group": "Gruppe verlassen",
    "Leave this page? The system may not save your changes.": "Sind Sie sicher, dass Sie diese Seite verlassen wollen? Ihre \u00c4nderungen wurden noch nicht gespeichert.",
    "Less than or equal to {maxDays_placeholder} days": "H\u00f6chstens {maxDays_placeholder} Tage",
    "Libraries": "Bibliotheken",
    "Library": "Bibliothek",
    "Library Type": "Art der Bibliothek",
    "Library can not be shared to owner.": "Bibliotheken k\u00f6nnen nicht f\u00fcr ihre Eigent\u00fcmer freigegeben werden.",
    "Library does not exist": "Die Bibliothek ist nicht vorhanden",
    "Library history": "Versionierungs\u00e4nderungen zulassen",
    "Library not found": "Bibliothek nicht gefunden",
    "Library password minimum length": "Mindestl\u00e4nge von Passw\u00f6rtern f\u00fcr verschl\u00fcsselte Bibliotheken",
    "Light mode": "Heller Modus",
    "Limits": "Maximum",
    "Line wrapping": "Umbruch von Zeilen",
    "Link": "Link",
    "Link has been copied to clipboard": "Der Link wurde in den Zwischenspeicher kopiert",
    "Link image": "Bild verlinken",
    "Linked Devices": "Verbundene Ger\u00e4te",
    "Links": "Links",
    "List view": "Listenansicht",
    "List your account in global address book, so that others can find you by typing your name.": "Ihr Konto wird im zentralen Adressbuch aufgef\u00fchrt, damit andere Sie durch Eingabe Ihres Namens finden k\u00f6nnen.",
    "Load all": "Alle laden",
    "Loading": "Ladevorgang im Gang ...",
    "Loading metadata...": "Metadaten werden geladen \u2026",
    "Loading...": "Wird geladen \u2026",
    "Location": "Ort",
    "Lock": "Sperren",
    "Log out": "Abmelden",
    "Login": "Login",
    "Login ID": "Benutzername",
    "Login attempt limit": "Limit f\u00fcr Anmeldeversuche",
    "Login background image": "Hintergrundbild der Anmeldeseite",
    "Logo": "Logo",
    "Logo updated": "Das Logo wurde aktualisiert.",
    "Logs": "Protokolle",
    "Long text": "Formatierter Text",
    "Manage group members": "Gruppenmitglieder verwalten",
    "Manage members": "Mitglieder verwalten",
    "Map": "Karte",
    "Map is not ready": "Karte ist nicht fertig",
    "Mark all as read": "Alle als gelesen markieren",
    "Mark all read": "Alle als gelesen markieren",
    "Mark as resolved": "Als erledigt markieren",
    "Mark notification as read": "Benachrichtigung als gelesen markieren",
    "Marked \"{resolve_comment}\" as resolved in document {sdoc_link}": "Hat im Dokument {sdoc_link} den Kommentar \"{resolve_comment}\" als gel\u00f6st markiert:",
    "Marked as resolved in document {sdoc_link}": "Hat im Dokument {sdoc_link} als gel\u00f6st markiert:",
    "Matching tags": "Passende Tags",
    "Max": "Max",
    "Max number of members": "Maximale Anzahl der Mitglieder",
    "Member": "Mitglied",
    "Members": "Mitglieder",
    "Merge tags": "Tags zusammenf\u00fchren",
    "Merge tags to": "Tags zusammenf\u00fchren in",
    "Message": "Nachricht",
    "Message (optional):": "Nachricht (optional):",
    "Metrics": "Kennzahlen",
    "Migrate": "Migrieren",
    "Migrate User": "Benutzer migrieren",
    "Migrate old version tags": "Veraltete Tags migrieren",
    "Mobile": "Mobilger\u00e4t",
    "Modification Details": "Bearbeitungsdetails",
    "Modified": "Ge\u00e4ndert:",
    "Modified by": "Ver\u00e4ndert durch",
    "Modified by:": "Ver\u00e4ndert durch:",
    "Modified files": "Ge\u00e4nderte Dateien",
    "Modified time": "Datum der Bearbeitung",
    "Modifier": "Bearbeiter",
    "Modify": "\u00c4ndern",
    "Modify includes modify file, move/rename file and folder": "Dateien und Ordner k\u00f6nnen umbenannt und verschoben, Dateien auch bearbeitet werden.",
    "Modify name": "Name bearbeiten",
    "Month": "Monat",
    "Month:": "Monat:",
    "Monthly User Traffic": "Monatliches Datenvolumen pro Benutzer",
    "More": "Mehr",
    "More operations": "Weitere Aktionen",
    "Move": "Verschieben",
    "Move department": "Bereich verschieben",
    "Move file": "Datei verschieben",
    "Move folder": "Ordner verschieben",
    "Move selected item(s) to:": "Auswahl verschieben nach:",
    "Move to department": "In Bereich verschieben",
    "Move {num} items": "{num} Objekte werden verschoben",
    "Move {placeholder} to": "{placeholder} verschieben nach",
    "Moved file": "Datei verschoben",
    "Moved folder": "Ordner verschoben",
    "Multiple select": "Mehrfachauswahl",
    "My Activities": "Meine Aktivit\u00e4ten",
    "My Libraries": "Meine Bibliotheken",
    "My Wikis": "Meine Wikis",
    "Name": "Name",
    "Name already exists": "Der Name wird bereits verwendet.",
    "Name cannot be double dots": "Der Name darf keinen Doppelpunkt ( : ) enthalten.",
    "Name cannot be empty": "Der Name ist erforderlich.",
    "Name cannot contain backslash": "Der Name darf keinen Backslash ( \\ ) enthalten.",
    "Name cannot contain backtick": "Der Name darf kein Hochkomma ( ` ) enthalten. ",
    "Name cannot contain curly braces": "Der Name darf keine geschwungenen Klammern ( { } ) enthalten.",
    "Name cannot contain dots": "Der Name darf keinen Punkt ( . ) enthalten.",
    "Name cannot contain slash": "Der Name darf keinen Schr\u00e4gstrich ( / ) enthalten.",
    "Name is required": "Name erforderlich",
    "Name is required.": "Name erforderlich.",
    "Name or ID": "Name oder ID",
    "Name should be string": "Der Name muss ein String sein.",
    "Name should not include '/'.": "Name darf kein '/' enthalten",
    "Name updated": "Der Name wurde aktualisiert.",
    "Name(optional)": "Name (optional)",
    "Names don't match": "Namen stimmen nicht \u00fcberein",
    "Network error": "Netzwerkfehler",
    "New": "Erstellen",
    "New Department": "Neuer Bereich",
    "New Department Library": "Neue Bereichs-Bibliothek",
    "New Docxf File": "Neue Docxf-Datei",
    "New Excalidraw File": "Neue Excalidraw Datei",
    "New Excel File": "Neue Excel Datei",
    "New File": "Neue Datei",
    "New Folder": "Neuer Ordner",
    "New Group": "Neue Gruppe",
    "New Library": "Neue Bibliothek",
    "New Markdown File": "Neue Markdown Datei",
    "New Password": "Neues Passwort",
    "New Password Again": "Passwort erneut eingeben",
    "New PowerPoint File": "Neue PowerPoint Datei",
    "New SeaDoc File": "Neue SeaDoc Datei",
    "New Sub-department": "Neuer Unterbereich",
    "New Whiteboard File": "Neue Whiteboard-Datei",
    "New Word File": "Neue Word Datei",
    "New category": "Neue Kategorie",
    "New child tag": "Neuer untergeordneter Tag",
    "New directories": "Neue Ordner",
    "New file name": "Neuer Dateiname",
    "New files": "Neue Dateien",
    "New folder": "Neuer Ordner",
    "New folder name": "Neuer Ordnername",
    "New page": "Neue Seite",
    "New password": "Neues Passwort",
    "New password cannot be the same as old password": "Das neue Passwort darf nicht identisch mit dem alten sein.",
    "New password has been sent to your email {mail}. Please check your mailbox. If you don\u2019t receive the password, please check if your email address is properly configured.": "Ein neues Passwort wurde an {mail} geschickt. Falls Sie keine E-Mail erhalten, pr\u00fcfen Sie bitte, ob die E-Mailadresse richtig eingetragen ist.",
    "New password is too short": "Das neue Passwort ist zu kurz",
    "New passwords don't match": "Die neuen Passw\u00f6rter stimmen nicht \u00fcberein",
    "New tag": "Neues Tag",
    "New view": "Neue Ansicht",
    "Next": "N\u00e4chste Seite",
    "Next (Right arrow key)": "Weiter (Rechte Pfeiltaste)",
    "Next modification": "N\u00e4chste \u00c4nderung",
    "No Admin login logs": "Keine Protokolle zu Anmeldungen der Administration",
    "No Admin operation logs": "Keine Protokolle zu Aktivit\u00e4ten der Administration verf\u00fcgbar",
    "No Wikis": "Keine Wikis",
    "No categories": "Keine Kategorien",
    "No changes": "Keine \u00c4nderungen",
    "No collaborators": "Keine Mitarbeiter",
    "No collaborators available": "Keine Mitarbeiter verf\u00fcgbar",
    "No comment yet.": "Keine Kommentare vorhanden",
    "No connected devices": "Keine verbundenen Ger\u00e4te",
    "No creator data available": "Keine Daten zur Erstellung vorhanden",
    "No data available for statistics": "Keine statistischen Daten vorhanden",
    "No deleted libraries": "Keine gel\u00f6schten Bibliotheken",
    "No favorites": "Keine Favoriten",
    "No file": "Keine Datei",
    "No file access logs": "Keine Protokolle zu Dateiaufrufen verf\u00fcgbar",
    "No file selected": "Keine Datei ausgew\u00e4hlt",
    "No file update logs": "Keine Protokolle zu Aktualisierungen verf\u00fcgbar",
    "No files": "Keine Dateien",
    "No files or folders have been shared with you": "Sie haben keinen Zugriff auf Dateien oder Bibliotheken anderer Benutzer.",
    "No files or folders have been shared with you from other servers.": "Sie haben keinen Zugriff auf Dateien oder Bibliotheken von anderen Servern.",
    "No filters": "Keine Filter",
    "No folders shared": "Keine Ordner freigegeben",
    "No group invitation link yet. Group invitation link let registered users to join the group by clicking a link.": "Einladungslink f\u00fcr Gruppen noch nicht vorhanden. Eine solche Einladung erm\u00f6glicht registrierten Nutzenden den Beitritt zur Gruppe per Klick auf den Link.",
    "No group shares": "Keine Gruppenanteile",
    "No groupings applied to this view.": "F\u00fcr diese Ansicht ist keine Gruppierung ausgew\u00e4hlt.",
    "No groups": "Keine Gruppen",
    "No guest invitations": "Keine eingeladenen G\u00e4ste",
    "No invitations": "Keine Einladungen",
    "No items": "Keine Artikel",
    "No libraries": "Keine Bibliotheken",
    "No libraries have been shared directly with you. A shared library can be shared with full or restricted permission. If you need access to a library owned by another user, ask the user to share the library with you.": "F\u00fcr Sie sind noch keine Bibliotheken pers\u00f6nlich freigegeben worden. Eine Bibliothek kann mit allen Rechten oder mit Einschr\u00e4nkungen freigegeben werden. Wenn Sie Zugang zu einer Bibliothek ben\u00f6tigen, bitten Sie die betreffende Person, sie f\u00fcr Sie freizugeben.",
    "No libraries have been shared with this group yet. A library shared with a group can be accessed by all group members. You can share a library with a group in \"My Libraries\". You can also create a new library to be shared with this group by clicking the \"New Library\" item in the dropdown menu.": "Es sind noch keine Bibliotheken f\u00fcr diese Gruppe freigegeben worden. Auf eine f\u00fcr eine Gruppe freigegebene Bibliothek k\u00f6nnen alle Mitglieder der Gruppe zugreifen. Sie k\u00f6nnen Ihre Bibliotheken in \u201eMeine Bibliotheken\u201c f\u00fcr Gruppen freigeben. Sie k\u00f6nnen auch eine neue Bibliothek mit einer Freigabe f\u00fcr diese Gruppe anlegen, indem Sie im Dropdown-Men\u00fc auf \u201eNeue Bibliothek\u201c klicken.",
    "No libraries have been shared with you": "Sie haben keinen Zugriff auf Bibliotheken anderer Benutzer.",
    "No libraries have been shared with you from other servers.": "F\u00fcr Sie wurden noch keine Bibliotheken von anderen Servern freigegeben worden.",
    "No libraries shared": "Keine Bibliotheken freigegeben",
    "No libraries shared with this group": "F\u00fcr diese Gruppe sind keine Bibliotheken freigegeben",
    "No linked devices": "Keine verbundenen Ger\u00e4te",
    "No linked devices. You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "Keine verkn\u00fcpften Ger\u00e4te. Sie haben noch nicht mit einem mobilen oder station\u00e4ren Ger\u00e4t auf Ihre Dateien zugegriffen. Um komfortabler mit Ihren Daten zu arbeiten, installieren Sie auf Ihren Ger\u00e4ten die entsprechenden Clients oder Apps.",
    "No login logs": "Keine Protokolle zu Anmeldungen verf\u00fcgbar",
    "No matching tags": "Keine passenden Tags",
    "No members": "Keine Mitglieder",
    "No more activities": "Keine weiteren Aktivit\u00e4ten",
    "No notifications": "Keine Mitteilungen",
    "No option": "Keine Option",
    "No options": "Keine Optionen",
    "No options available": "Keine Optionen verf\u00fcgbar",
    "No permission logs": "Keine Protokolle zu Berechtigungen",
    "No properties available to be hidden": "Es gibt keine Eigenschaften, die ausgeblendet werden k\u00f6nnen",
    "No public libraries": "Es gibt keine \u00f6ffentlichen Bibliotheken.",
    "No public libraries have been created yet. A public library is accessible by all users. You can create a public library by clicking the \"Add Library\" item in the dropdown menu.": "Es sind noch keine \u00f6ffentlichen Bibliotheken angelegt worden. Eine \u00f6ffentliche Bibliothek ist f\u00fcr alle Benutzer zug\u00e4nglich. Sie k\u00f6nnen eine \u00f6ffentliche Bibliothek anlegen, indem Sie im Dropdown-Men\u00fc auf \u201eNeue Bibliothek\u201c klicken.",
    "No recommended new tags": "Keine Vorschl\u00e4ge f\u00fcr neue Tags",
    "No record": "Kein Eintrag",
    "No result": "Kein Ergebnis",
    "No results": "Keine Ergebnisse",
    "No results found": "Keine Ergebnisse gefunden",
    "No results matching": "Keine passenden Ergebnisse",
    "No separator (1000000)": "Kein Trenner (1000000)",
    "No share links": "Keine Freigabe-Links",
    "No shared Wikis": "Keine Wikis freigegeben",
    "No shared libraries": "Keine freigegebenen Bibliotheken",
    "No sorts": "Keine Sortierungen",
    "No sync errors": "Keine Fehler beim Synchronisieren",
    "No tag": "Kein Tag",
    "No tags": "Keine Tags",
    "No tags available": "Keine Tags verf\u00fcgbar",
    "No terms and conditions": "Keine Nutzungsvereinbarungen",
    "No text extracted": "Kein Text extrahiert",
    "No time-based data available": "Keine Daten zu Zeiten vorhanden",
    "No upload links": "Keine Upload-Links",
    "No user shares": "Keine Benutzerteile",
    "No users found": "Keine Benutzer gefunden",
    "No version history": "Keine Versionshistorie",
    "Node": "Knoten",
    "None": "Keine",
    "Not allow user to clean library trash": "Benutzer k\u00f6nnen den Papierkorb von Bibliotheken nicht leeren",
    "Not allow user to create encrypted libraries": "Benutzer k\u00f6nnen keine verschl\u00fcsselten Bibliotheken erstellen",
    "Note: Settings via web interface are saved in database table (seahub-db/constance_config). They have a higher priority over the settings in config files.": "Hinweis: Einstellungen per Weboberfl\u00e4che werden in einer Datenbanktabelle gespeichert (seahub-db/constance_config) und haben dann eine h\u00f6here Priorit\u00e4t als Einstellungen in den Config-Dateien.",
    "Notification": "Benachrichtigung",
    "Notification Detail": "Text",
    "Notifications": "Mitteilungen",
    "Notifications of collaboration": "E-Mail-Benachrichtigungen \u00fcber die Zusammenarbeit",
    "Notifications of file changes": "E-Mail-Benachrichtigung \u00fcber ge\u00e4nderte Dateien",
    "Number": "Zahl",
    "Number format settings": "Formatierung von Zahlen",
    "Number of days ago": "Tage vor Heute",
    "Number of days from now": "Tage von Heute",
    "Number of days that keep user sign in.": "Anzahl an Tagen, f\u00fcr die das Web Interface die Anmeldedaten der Benutzer auf Wunsch speichert.",
    "Number of groups": "Anzahl der Gruppen",
    "Number of links": "Anzahl der Links",
    "Number of members": "Anzahl der Mitglieder",
    "Number of records exceeds the limit of 1000": "Mehr als 1.000 Eintr\u00e4ge sind leider nicht m\u00f6glich.",
    "OCR": "OCR",
    "OCR result": "OCR-Ergebnisse",
    "Off": "Aus",
    "Office Suite": "Office Suite",
    "Old Password": "Altes Passwort",
    "Old Wikis": "Alte Wikis",
    "On": "An",
    "One month ago": "Vor einem Monat",
    "One month from now": "In einem Monat",
    "One week ago": "Vor einer Woche",
    "One week from now": "In einer Woche",
    "Online Preview": "Online-Vorschau",
    "Online Read-Only": "Online Nur Lesen",
    "Online Read-Only folder": "Online Nur Lesen-Ordner",
    "Online Read-Only library": "Online Nur Lesen-Bibliothek",
    "Online Read-Write": "Online Lesen und Schreiben",
    "Online Read-Write folder": "Online Lesen und Schreiben-Ordner",
    "Online Read-Write library": "Online Lesen und Schreiben-Bibliothek",
    "Online view is not applicable to this file format": "Die Vorschau ist f\u00fcr dieses Dateiformat nicht verf\u00fcgbar.",
    "Only Show": "Nur anzeigen",
    "Only files": "Nur Dateien",
    "Only folders": "Nur Ordner",
    "Only keep a period of history:": "Versionen nur f\u00fcr einen bestimmten Zeitraum speichern:",
    "Only pictures": "Nur Bilder",
    "Only videos": "Nur Videos",
    "Open file": "Datei \u00f6ffnen",
    "Open file in new tab": "Datei in einem neuen Tab \u00f6ffnen",
    "Open folder": "Ordner \u00f6ffnen",
    "Open folder in new tab": "Ordner in einem neuen Tab \u00f6ffnen",
    "Open in new tab": "In neuem Tab \u00f6ffnen",
    "Open parent folder": "\u00dcbergeordneten Ordner \u00f6ffnen",
    "Open the panel": "Leiste anzeigen",
    "Open via Client": "Lokal \u00f6ffnen",
    "Open via client": "Mit dem Client \u00f6ffnen",
    "Operation": "Aktion",
    "Operation succeeded.": "Aktion erfolgreich.",
    "Operations": "Aktion",
    "Operator": "Operator",
    "Optional": "Optional",
    "Options imported": "Die Optionen wurden importiert.",
    "Or": "Oder",
    "Organization": "Organisation",
    "Organization Admin": "Organisationsverwaltung",
    "Organizations": "Organisationen",
    "Original path": "Originalpfad",
    "Other": "Sonstige",
    "Other Libraries": "Andere Bibliotheken",
    "Others": "Sonstige",
    "Out of quota.": "Speicherplatz ist verbraucht.",
    "Outdated": "Veraltet",
    "Outline": "Gliederung",
    "Owned Libraries": "Eigene Bibliotheken",
    "Owner": "Eigent\u00fcmer",
    "Owner can use admin panel in an organization, must be a new account.": "Der Eigent\u00fcmer kann die Administrationsoberfl\u00e4che einer Organisation verwenden, dies muss ein neues Benutzerkonto sein.",
    "Packaging...": "Erzeuge ZIP-Archiv \u2026",
    "Page fit": "Seitengr\u00f6\u00dfe",
    "Page imported": "Seite ist importiert",
    "Page is frozen": "Seite ist eingefroren",
    "Page name": "Seitenname",
    "Page {name_placeholder} deleted.": "Die Seite {name_placeholder} wurde gel\u00f6scht.",
    "Pages": "Seiten",
    "Parent folder": "\u00dcbergeordneter Ordner",
    "Parent tags": "\u00dcbergeordnete Tags",
    "Password": "Passwort",
    "Password again": "Passwort erneut eingeben",
    "Password cannot be blank": "Das Passwort ist erforderlich.",
    "Password is too short": "Passwort ist zu kurz",
    "Password must be at least 8 characters long and contain different characters: uppercase letters, lowercase letters, numbers, and special symbols": "Das Passwort muss mindestens 8 Zeichen lang sein und folgende Zeichen enthalten: Gro\u00df- und Kleinbuchstaben, Zahlen und Sonderzeichen.",
    "Password removed": "Das Passwort wurde entfernt.",
    "Password reset": "Das Passwort wurde zur\u00fcckgesetzt.",
    "Password set": "Das Passwort wurde gesetzt.",
    "Password strength": "Passwortst\u00e4rke",
    "Password strength should be strong or very strong": "Die Passwortst\u00e4rke muss stark oder sehr stark sein.",
    "Password updated": "Das Passwort wurde aktualisiert.",
    "Passwords do not match.": "Passw\u00f6rter stimmen nicht \u00fcberein.",
    "Passwords don't match": "Passw\u00f6rter stimmen nicht \u00fcberein",
    "Path": "Pfad",
    "People": "Personen",
    "Per 4 hours": "Alle 4 Stunden",
    "Per day": "T\u00e4glich",
    "Per hour": "St\u00fcndlich",
    "Per week": "W\u00f6chentlich",
    "Percent": "Prozent",
    "Permission": "Berechtigung",
    "Permission denied": "Der Zugriff wurde verweigert.",
    "Permission denied. Please try {placeholder-left}login again.{placeholder-right}": "Kein Zugang. Bitte versuchen Sie {placeholder-left}die Anmeldung noch einmal.{placeholder-right}",
    "Permission name": "Berechtigungsname",
    "Person image": "Bild einer Person",
    "Picture": "Bild",
    "Pictures and videos": "Bilder und Videos",
    "Platform": "Plattform",
    "Please check the network.": "Bitte \u00fcberpr\u00fcfen Sie die Netzwerkverbindung.",
    "Please choose a .xlsx file.": "Bitte eine XLSX-Datei ausw\u00e4hlen",
    "Please choose an image file.": "W\u00e4hlen Sie ein Bild aus.",
    "Please enter 1 or more character": "Bitte geben Sie mehr als 1 Zeichen ein",
    "Please enter a new password": "Bitte geben Sie das neue Passwort ein",
    "Please enter a new quota": "Bitte geben Sie eine neue Speicherquota ein",
    "Please enter a non-negative integer": "Bitte geben Sie eine Zahl gr\u00f6\u00dfer oder gleich Null ein",
    "Please enter a password.": "Geben Sie ein Passwort ein.",
    "Please enter a positive integer": "Geben Sie eine positive Ganzzahl ein.",
    "Please enter an integer bigger than 1 as number of links.": "Geben Sie bei der Anzahl der Links eine ganze Zahl gr\u00f6\u00dfer 1 ein.",
    "Please enter an integer not bigger than {max_number} as number of links.": "Geben Sie eine Zahl nicht gr\u00f6\u00dfer als {max_number} f\u00fcr die Anzahl der Links an.",
    "Please enter days": "Bitte geben Sie Tage ein",
    "Please enter password": "Bitte geben Sie ein Passwort ein",
    "Please enter the address": "Bitte die Adresse eingeben",
    "Please enter the new password again": "Bitte geben Sie das neue Passwort noch einmal ein",
    "Please enter the old password": "Bitte geben Sie das alte Passwort ein",
    "Please enter the password again": "Bitte geben Sie das Passwort erneut ein",
    "Please input at least an email.": "Bitte geben Sie mindestens eine E-Mail-Adresse an.",
    "Please select": "Bitte ausw\u00e4hlen",
    "Please select a file": "Datei ausw\u00e4hlen",
    "Please select a library or folder first.": "Bitte w\u00e4hlen Sie zun\u00e4chst eine Bibliothek oder einen Ordner.",
    "Please select a library to share.": "Bitte w\u00e4hlen Sie eine Bibliothek zum Freigeben aus.",
    "Please select an expiration time": "W\u00e4hlen Sie ein Ablaufdatum",
    "Please turn on extended properties setting first": "Bitte aktivieren Sie zuerst  die erweiterten Eigenschaften",
    "Please upload no more than {maxFiles} files at a time.": "Bitte laden Sie nicht mehr als {maxFiles} Dateien auf einmal hoch.",
    "Precision": "Genauigkeit",
    "Preparing to upload...": "Hochladen wird vorbereitet \u2026",
    "Preset hide properties": "Voreingestellt ausgeblendete Eigenschaften",
    "Preview and download": "Vorschau und Herunterladen",
    "Preview online": "Online-Vorschau",
    "Preview only": "Nur Vorschau erlaubt",
    "Previous": "Vorherige",
    "Previous (Left arrow key)": "Zur\u00fcck (Linke Pfeiltaste)",
    "Print": "Drucken",
    "Print document": "Dokument drucken",
    "Professional Edition": "Professional Edition",
    "Profile": "Profil",
    "Profile Setting": "Profil",
    "Properties": "Einstellungen",
    "Properties to display on the card": "Anzuzeigende Eigenschaften",
    "Property name": "Name der Eigenschaft",
    "Publish": "Ver\u00f6ffentlichen",
    "Publish Wiki": "Wiki ver\u00f6ffentlichen",
    "Published": "Ver\u00f6ffentlicht",
    "QR Code": "QR-Code",
    "Quota": "Speicherquota",
    "Quota is invalid.": "Kein Speicherplatz verf\u00fcgbar.",
    "Rate": "Rating",
    "Read-Only": "Nur Lesen",
    "Read-Only folder": "Nur Lesen-Ordner",
    "Read-Only library": "Bibliothek mit Lesezugriff",
    "Read-Write": "Lesen und Schreiben",
    "Read-Write folder": "Lesen und Schreiben-Ordner",
    "Read-Write library": "Bibliothek mit Lese- und Schreibzugriff",
    "Really want to delete this group?": "M\u00f6chten Sie die Gruppe wirklich l\u00f6schen?",
    "Really want to delete your account?": "M\u00f6chten Sie Ihr Benutzerkonto wirklich l\u00f6schen?",
    "Really want to leave this group?": "M\u00f6chten Sie die Gruppe wirklich verlassen?",
    "Recently Used": "Zuletzt verwendet",
    "Recently used tags": "Zuletzt verwendete Tags",
    "Recognizing portraits. Please refresh the page later.": "Die Erkennung der Portr\u00e4ts l\u00e4uft. Kommen Sie sp\u00e4ter auf die Seite zur\u00fcck.",
    "Recommended new tags": "Vorgeschlagene neue Tags",
    "Refresh": "Aktualisieren",
    "Refresh the view": "Ansicht aktualisieren",
    "Remaining": "Verbleibend",
    "Remove": "Entfernen",
    "Remove Member": "Mitglied entfernen",
    "Remove from this group": "Aus der Gruppe entfernen",
    "Removed all items from trash": "Alle Objekte im Papierkorb wurden gel\u00f6scht",
    "Removed items older than {n} days from trash": "Objekte gel\u00f6scht, die sich l\u00e4nger als {n} Tage im Papierkorb befunden haben",
    "Rename": "Umbenennen",
    "Rename Department": "Bereich umbenennen",
    "Rename File": "Datei umbenennen",
    "Rename Folder": "Ordner umbenennen",
    "Rename Group": "Gruppe umbenennen",
    "Rename Library": "Bibliothek umbenennen",
    "Rename Wiki": "Wiki umbenennen",
    "Rename Wiki to": "Wiki umbenennen in",
    "Rename file": "Datei umbenennen",
    "Rename file to": "Datei umbenennen in",
    "Rename folder": "Ordner umbenennen",
    "Rename folder to": "Ordner umbenennen in",
    "Rename group to": "Gruppe umbenennen in",
    "Rename property": "Eigenschaft umbenennen",
    "Renamed file": "Umbenannte Datei",
    "Renamed folder": "Umbenannter Ordner",
    "Renamed library": "Bibliothek umbenannt",
    "Renamed or Moved files": "Umbenannte oder verschobene Dateien",
    "Renaming {name} failed": "Fehler beim Umbenennen von {name}",
    "Replace": "Ersetzen",
    "Replace file {filename}?": "Datei {filename} austauschen?",
    "Replacing it will overwrite its content.": "Ersetzen \u00fcberschreibt den Inhalt.",
    "Repo Transfer": "Repositorium \u00fcbertragen",
    "Report Abuse": "Missbr\u00e4uchliche Nutzung melden",
    "Reporter": "Berichterstatter/in",
    "Reports": "Berichte",
    "Required at least three letters.": "Mindestens drei Zeichen erforderlich",
    "Reset": "Zur\u00fccksetzen",
    "Reset Password": "Passwort zur\u00fccksetzen",
    "Reset WebDAV Password": "WebDAV Passwort zur\u00fccksetzen",
    "Reset library password": "Passwort der Bibliothek zur\u00fccksetzen",
    "ResetPwd": "Passwort zur\u00fccksetzen",
    "Resetting user's password, please wait for a moment.": "Das Passwort wird zur\u00fcckgesetzt, bitte einen Moment warten.",
    "Resolved comments": "Erledigte Kommentare",
    "Restore": "Wiederherstellen",
    "Restore Library": "Bibliothek wiederherstellen",
    "Restored 1 item": "1 Element wurde wiederhergestellt.",
    "Restored file": "Wiederhergestellte Datei",
    "Restored folder": "Wiederhergestellter Ordner",
    "Restored library": "Wiederhergestellte Bibliothek",
    "Restored {name}": "{name} wurde wiederhergestellt.",
    "Restored {name} and {n} other items": "{name} und {n} andere(s) Element(e) wiederhergestellt",
    "Resubmit": "Erneut einreichen",
    "Result": "Ergebnis",
    "Retry": "Erneut versuchen",
    "Retry All": "Alles erneut versuchen",
    "Revoke": "Entziehen",
    "Revoke Access": "Zugang entziehen",
    "Revoke Admin": "Adminrechte entziehen",
    "Role": "Rolle",
    "Rotate": "Drehen",
    "SAML config": "SAML-Konfiguration",
    "SAML config updated": "Die SAML-Konfiguration wurde aktualisiert.",
    "SSO": "SSO",
    "Satellite": "Satellit",
    "Save": "Speichern",
    "Save Selected Items": "Ausgew\u00e4hlte Elemente speichern",
    "Save as ...": "Speichern unter \u2026",
    "Save to description field": "Im Feld Beschreibung speichern",
    "Save to:": "Speichern unter:",
    "Saving...": "Speichere ...",
    "Scan the QR code to view the shared content directly": "QR-Code einscannen, um den geteilten Inhalt direkt zu sehen",
    "SeaTable integration": "SeaTable Integration",
    "Seafile": "Seafile",
    "Search": "Suchen",
    "Search Groups": "Gruppen suchen",
    "Search Libraries": "Bibliotheken suchen",
    "Search Organizations": "Organisationen suchen",
    "Search Users": "Benutzer suchen",
    "Search collaborator": "Mitarbeiter suchen",
    "Search collaborators": "Mitarbeiter suchen",
    "Search department": "Bereich suchen",
    "Search departments": "Bereiche suchen",
    "Search failed": "Keine Suchergebnisse gefunden",
    "Search failed. Please try again.": "Keine Suchergebnisse gefunden. Bitte versuchen Sie es noch einmal.",
    "Search files": "Dateien suchen",
    "Search files in this library": "Dateien in dieser Bibliothek durchsuchen",
    "Search group members": "Gruppenmitglieder suchen",
    "Search groups": "Gruppen suchen",
    "Search groups by name": "Gruppen nach Name suchen",
    "Search in trash": "Papierkorb durchsuchen",
    "Search in trash...": "Papierkorb wird durchsucht \u2026",
    "Search libraries by name or ID": "Bibliotheken nach Name oder ID suchen",
    "Search libraries by owner": "Bibliotheken nach Eigent\u00fcmer/in suchen",
    "Search option": "Option suchen",
    "Search organizations": "Organisationen suchen",
    "Search properties": "Eigenschaften suchen",
    "Search property": "Eigenschaften suchen",
    "Search results": "Suchergebnisse",
    "Search results visited recently": "Zuletzt verwendete Suchergebnisse",
    "Search service unavailable": "Suchdienst nicht verf\u00fcgbar",
    "Search tag": "Tag suchen",
    "Search user": "Benutzer suchen",
    "Search users": "Benutzer suchen",
    "Search users...": "Benutzer suchen \u2026",
    "Searching...": "Suche \u2026",
    "Select": "Ausw\u00e4hlen",
    "Select File": "Datei ausw\u00e4hlen",
    "Select a Confluence HTML export file (.html.zip)": "Einen Confluence-HTML-Export ausw\u00e4hlen (.html.zip)",
    "Select a Confluence HTML exported file (.html.zip)": "Einen Confluence-HTML-Export ausw\u00e4hlen (.html.zip)",
    "Select a Confluence exported file": "Einen Confluence-Export ausw\u00e4hlen",
    "Select a department": "Bereich ausw\u00e4hlen",
    "Select a server": "Server ausw\u00e4hlen",
    "Select a user": "Benutzer ausw\u00e4hlen",
    "Select a user as admin": "W\u00e4hlen Sie einen Benutzer als Administrator",
    "Select all": "Alle ausw\u00e4hlen",
    "Select all items": "Alle Elemente ausw\u00e4hlen",
    "Select an office suite": "Office Suite ausw\u00e4hlen",
    "Select an option": "Option w\u00e4hlen",
    "Select collaborators": "Mitarbeiter ausw\u00e4hlen",
    "Select group members": "Gruppenmitglieder ausw\u00e4hlen",
    "Select image": "Bild ausw\u00e4hlen",
    "Select items": "Elemente ausw\u00e4hlen",
    "Select libraries to share": "Bibliotheken zum Freigeben ausw\u00e4hlen",
    "Select members from department": "Mitglieder eines Bereichs ausw\u00e4hlen",
    "Select option(s)": "Option(en) ausw\u00e4hlen",
    "Select shared users": "Benutzer mit Freigabe ausw\u00e4hlen",
    "Select tag": "Tag ausw\u00e4hlen",
    "Select target department": "Bereich als Ziel ausw\u00e4hlen",
    "Select this item": "Element ausw\u00e4hlen",
    "Select up to 50 files": "W\u00e4hlen Sie bis zu 50 Dateien aus",
    "Select users": "Benutzer ausw\u00e4hlen",
    "Selected": "Ausgew\u00e4hlt",
    "Send": "Senden",
    "Send activation Email after user registration.": "Neue Benutzer erhalten nach der Registrierung eine E-Mail.",
    "Send activation email": "Registrierung bper E-Mail best\u00e4tigen",
    "Send to:": "Senden an:",
    "Sending new password...": "Verschicke neues Passwort \u2026",
    "Sending...": "Wird gesendet \u2026",
    "Separate multiple suffixes by \",\"(like sdoc, pdf)": "Unterschiedliche Dateiendungen mit Komma trennen (z.B. \" sdoc, pdf\")",
    "Server": "Server",
    "Server Version: ": "Server Version: ",
    "Set": "Festlegen",
    "Set Admin": "Administrator festlegen",
    "Set Contact Email": "E-Mail-Kontakt eintragen",
    "Set Download Rate Limit": "Download-Durchsatzbegrenzung einrichten",
    "Set Login ID": "Benutzername setzen",
    "Set Name": "Name setzen",
    "Set Password": "Passwort vergeben",
    "Set Quota": "Speicherquota setzen",
    "Set Upload Rate Limit": "Upload-Durchsatzbegrenzung einrichten",
    "Set WebDAV Password": "WebDAV Passwort vergeben",
    "Set access scope": "Access Scope festlegen",
    "Set as cover photo": "Foto als Deckblatt setzen",
    "Set child tags": "Untergeordnete Tags festlegen",
    "Set max number of members": "Maximale Anzahl der Mitglieder festlegen",
    "Set organization inactive": "Organisation deaktivieren",
    "Set password": "Passwort festlegen",
    "Set permission": "Berechtigung festlegen",
    "Set permission of {placeholder}": "Berechtigung von {placeholder} setzen",
    "Set quota": "Speicherplatz f\u00fcr Nutzer/in setzen",
    "Set to current": "Als aktuell markieren",
    "Set user contact email": "E-Mail-Adresse des Benutzers setzen",
    "Set user default quota": "Standard-Speicherquota setzen",
    "Set user inactive": "Benutzer auf inaktiv setzen",
    "Set user name": "Benutzername setzen",
    "Set user quota": "Speicherquota f\u00fcr Benutzer setzen",
    "Setting library history is disabled by Admin.": "Die Einstellungen f\u00fcr Versionen von Bibliotheken sind von der Administration nicht freigegeben.",
    "Setting updated": "Einstellungen aktualisiert",
    "Settings": "Einstellungen",
    "Share": "Freigeben",
    "Share Admin": "Freigabeverwaltung",
    "Share From": "Freigegeben von",
    "Share Link": "Freigabe-Link",
    "Share Link Traffic": "Datenvolumen Freigabe-Links",
    "Share Links": "Freigabe-Links",
    "Share To": "Von mir freigegeben f\u00fcr",
    "Share To:": "Freigeben f\u00fcr:",
    "Share existing libraries": "Vorhandene Bibliotheken freigeben",
    "Share link download": "Herunterladen per Freigabe-Link",
    "Share link is copied to the clipboard.": "Der Freigabe-Link wurde in die Zwischenablage kopiert.",
    "Share link upload": "Hochladen per Freigabe-Link",
    "Share links cannot be generated because \"Invisible\", \"Online Read-Write\" or \"Online Read-Only\" is set for you on some folder(s) in the library.": "Links k\u00f6nnen nicht erstellt werden, weil f\u00fcr einen oder mehrere Ordner in dieser Bibliothek Ihre Berechtigung auf \"Unsichtbar\", \"Online Lesen und Schreiben\" oder \"Online Nur Lesen\" gesetzt wurde.",
    "Share to group": "Freigabe f\u00fcr Gruppe",
    "Share to other server": "Freigabe f\u00fcr anderen Server",
    "Share to user": "Freigabe f\u00fcr Benutzer",
    "Share/upload link force password": "Passwortschutz f\u00fcr Upload-/Downloadlinks erzwingen",
    "Share/upload link password minimum length": "Mindestl\u00e4nge von Passw\u00f6rtern f\u00fcr Upload- und Download-Links",
    "Share/upload link password strength level": "Niveau der Passwortst\u00e4rke f\u00fcr Upload- und Download-Links",
    "Shared By": "Freigegeben von",
    "Shared Libraries": "Freigegebene Bibliotheken",
    "Shared Links": "Freigabe-Links",
    "Shared by:": "Freigegeben von:",
    "Shared by: ": "Freigegeben von:",
    "Shared from other servers": "Von anderen Servern",
    "Shared with all": "F\u00fcr alle freigegeben",
    "Shared with me": "F\u00fcr mich freigegeben",
    "Sharing Time": "Zeit der Freigabe",
    "Show": "Anzeigen",
    "Show Codes": "Codes anzeigen",
    "Show advanced search": "Erweiterte Suche anzeigen",
    "Show all": "Alle anzeigen",
    "Show changes": "\u00c4nderungen anzeigen",
    "Show daily history": "Tagesgeschichte anzeigen",
    "Show property names": "Eigenschaftsnamen anzeigen",
    "Side Nav Menu": "Seitliche Navigation",
    "Single Sign On (SSO)": "Single Sign On (SSO)",
    "Single select": "Einfachauswahl",
    "Site name": "Seitenname",
    "Site name used in email sending": "Name der Website, der in E-Mails verwendet wird",
    "Site title": "Seitentitel",
    "Site title shown in a browser tab": "Name der Website, der im Browserfenster angezeigt wird",
    "Size": "Gr\u00f6\u00dfe",
    "Sort": "Sortieren",
    "Sort ascending": "Aufsteigend sortieren",
    "Sort descending": "Absteigend sortieren",
    "Space (1 000 000)": "Abstand (1 000 000)",
    "Space Used": "Speicherbedarf",
    "Space Used / Quota": "Speicherbedarf / Speicherquota",
    "Space used": "Speicherbedarf",
    "Specific people with email address": "Bestimmte Benutzer mit E-Mail-Adresse",
    "Specific users in the team": "Bestimmte Benutzer im Team",
    "Star": "Favoriten hinzuf\u00fcgen",
    "Start date": "Startdatum",
    "Statistic": "Statistik",
    "Statistics": "Statistik",
    "Status": "Status",
    "Status: enabled": "Status: aktiviert",
    "Storage": "Ablage",
    "Storage Backend": "Physischer Speicherort",
    "Storage Used": "Speicherbedarf",
    "Strong password": "Starkes Passwort",
    "Style": "Stil",
    "Submit": "Absenden",
    "Success": "Die \u00c4nderung wurde gespeichert.",
    "Successfully added %s.": "%s wurde hinzugef\u00fcgt.",
    "Successfully added label(s) for library {placeholder}": "Label (s) f\u00fcr Bibliothek {placeholder} erfolgreich hinzugef\u00fcgt",
    "Successfully added the file.": "Die Datei wurde hinzugef\u00fcgt.",
    "Successfully added {email_placeholder}": "{email_placeholder} wurde hinzugef\u00fcgt.",
    "Successfully change the group": "Die Gruppe wurde ge\u00e4ndert.",
    "Successfully changed library password.": "Das Passwort der Bibliothek wurde ge\u00e4ndert.",
    "Successfully changed the office suite.": "Die Office Suite wurde ge\u00e4ndert.",
    "Successfully cleaned all errors.": "Alle Fehlermeldungen wurden gel\u00f6scht.",
    "Successfully cleaned invalid share links.": "Die ung\u00fcltigen Freigabelinks wurden gel\u00f6scht.",
    "Successfully cleaned invalid upload links.": "Die ung\u00fcltigen Upload-Links wurden gel\u00f6scht.",
    "Successfully cleared trash.": "Der Papierkorb ist geleert.",
    "Successfully converted the file.": "Die Datei wurde konvertiert.",
    "Successfully copied %(name)s and %(amount)s other items.": "%(name)s und %(amount)s weitere Objekte wurden kopiert.",
    "Successfully copied %(name)s and 1 other item.": "%(name)s und ein weiteres Objekt wurden kopiert.",
    "Successfully copied %(name)s.": "%(name)s wurde kopiert.",
    "Successfully copied files to another library.": "Die Dateien sind in die andere Bibliothek kopiert.",
    "Successfully copied {name} and {n} other items": "{name} und {n} andere Elemente wurden kopiert.",
    "Successfully deleted 1 item": "1 Objekt erfolgreich gel\u00f6scht",
    "Successfully deleted 1 item.": "Das Objekt wurde gel\u00f6scht.",
    "Successfully deleted 1 share link": "1 Freigabe-Link wurde gel\u00f6scht.",
    "Successfully deleted 1 upload link": "1 Upload-Link wurde gel\u00f6scht.",
    "Successfully deleted 1 user.": "Ein Konto wurde gel\u00f6scht.",
    "Successfully deleted {name}": "{name} wurde gel\u00f6scht.",
    "Successfully deleted {name} and {n} other items": "{name} und {n} andere Elemente wurden gel\u00f6scht.",
    "Successfully deleted {name} and {n} other items.": "{name} und {n} andere(s) Element(e) wurden gel\u00f6scht.",
    "Successfully deleted {name}.": "{name} wurde gel\u00f6scht.",
    "Successfully deleted {number_placeholder} share links": "{number_placeholder} Freigabe-Links wurden gel\u00f6scht.",
    "Successfully deleted {number_placeholder} upload links": "{number_placeholder} Upload-Links wurden gel\u00f6scht.",
    "Successfully deleted {user_number_placeholder} users.": "{user_number_placeholder} Benutzer wurden gel\u00f6scht.",
    "Successfully edited labels.": "Label erfolgreich bearbeitet.",
    "Successfully imported tags.": "Import der Tags erfolgreich.",
    "Successfully imported {user_placeholder}": "{user_placeholder} wurde hinzugef\u00fcgt.",
    "Successfully invited %(email) and %(num) other people.": "%(email) und %(num) weitere Personen sind nun eingeladen.",
    "Successfully invited %(email).": "%(email) ist nun eingeladen.",
    "Successfully modified permission.": "Die Berechtigung wurde ge\u00e4ndert.",
    "Successfully moved %(name)s and %(amount)s other items.": "%(name)s und %(amount)s weitere Objekte wurden verschoben.",
    "Successfully moved %(name)s and 1 other item.": "%(name)s und ein weiteres Objekt wurden verschoben.",
    "Successfully moved %(name)s.": "%(name)s wurde verschoben.",
    "Successfully moved files to another library.": "Die Dateien sind in die andere Bibliothek verschoben.",
    "Successfully moved {name} and {n} other items": "{name} und {n} andere Elemente wurden verschoben.",
    "Successfully moved {name}.": "{name} wurde verschoben.",
    "Successfully removed {placeholder}.": "{placeholder} wurde entfernt.",
    "Successfully renamed the library.": "Bibliothek wurde umbenannt..",
    "Successfully restored the library {library_name}.": "Die Bibliothek {library_name} wurde wiederhergestellt.",
    "Successfully restored the library.": "Bibliothek wurde wiederhergestellt.",
    "Successfully restored.": "Erfolgreich wiederhergestellt.",
    "Successfully revoke the admin permission of %s": "%s wurden die Adminrechte entzogen.",
    "Successfully revoked access of user {placeholder}.": "{placeholder} hat keinen Zugang mehr.",
    "Successfully revoked the admin permission of {placeholder}.": "Dem Benutzer {placeholder} wurden die Administratorrechte entzogen.",
    "Successfully saved": "Erfolgreich gespeichert",
    "Successfully sent to {placeholder}": "Erfolgreich an {placeholder} gesendet.",
    "Successfully set %s as admin.": "%s hat die Adminrechte verliehen bekommen.",
    "Successfully set it.": "Die Einstellung wurde gespeichert.",
    "Successfully set library history.": "Versionierung f\u00fcr die Bibliothek eingestellt.",
    "Successfully set quota.": "Speicherquota wurde gesetzt.",
    "Successfully starred {library_name_placeholder}.": "{library_name_placeholder} wurde den Favoriten hinzugef\u00fcgt.",
    "Successfully starred {name_placeholder}.": "{name_placeholder} wurde den Favoriten hinzugef\u00fcgt.",
    "Successfully transferred the group.": "Die Gruppe wurde \u00fcbertragen.",
    "Successfully transferred the library.": "Bibliothek ist \u00fcbertragen",
    "Successfully unlinked %(name)s.": "%(name)s wurde erfolgreich getrennt.",
    "Successfully unlinked the device.": "Die Verbindung mit dem Ger\u00e4t wurde getrennt.",
    "Successfully unshared library {placeholder}": "Freigabe von Bibliothek {placeholder} wurde beendet.",
    "Successfully unshared {name}": "Die Freigabe von {name} ist beendet.",
    "Successfully unstarred {library_name_placeholder}.": "{library_name_placeholder} wurde aus den Favoriten entfernt.",
    "Successfully unstarred {name_placeholder}.": "{placeholder} ist nicht mehr als Favorit markiert.",
    "Successfully unwatched the library.": "Bibliothek wird nicht mehr beobachtet.",
    "Successfully watched the library.": "Bibliothek wird nun beobachtet.",
    "Suggestion": "Vorschlag",
    "Switch sort mode": "Sortiermodus wechseln",
    "Switch to plain text editor": "Zum reinen Texteditor wechseln",
    "Switch to rich text editor": "Zum Editor mit Formatierungen wechseln",
    "Switch view mode": "Ansichtsmodus wechseln",
    "Symbol position": "Position des Symbols",
    "Sync": "Synchronisation",
    "Sync Download": "Herunterladen per Synchronisieren",
    "Sync Traffic": "Datenvolumen Synchronisation",
    "Sync Upload": "Hochladen per Synchronisieren",
    "System": "System",
    "System Admin": "Systemverwaltung",
    "System Info": "Systeminformationen",
    "System settings updated": "Die Systemeinstellungen wurden aktualisiert.",
    "Table": "Tabelle",
    "Tag": "Tag",
    "Tag not found": "Das Tag wurde nicht gefunden",
    "Tagged Files": "Dateien mit Tags",
    "Tags": "Tags",
    "Tags migrated successfully": "Tags sind erfolgreich migriert",
    "Team deleted": "Das Team wurde gel\u00f6scht",
    "Team name": "Teamname",
    "Template": "Template",
    "Terms": "Nutzungsbedingungen",
    "Terms and Conditions": "Nutzungsvereinbarungen",
    "Text": "Text",
    "Text file extensions": "Texteditor aktivieren",
    "Text is required.": "Text erforderlich.",
    "Text wraps": "Text umbrechen",
    "The content of the document has exceeded the limit of 100000 characters, and only the first 100000 characters are saved": "Die L\u00e4nge dieses Dokuments \u00fcberschreitet das Maximum von 100 000 Zeichen. Nur 100 000 Zeichen werden gespeichert.",
    "The content of the document has exceeded the limit of 100000 characters, and the content cannot be saved": "Das Dokument hat eine L\u00e4nge von mehr als 100 000 Zeichen und kann daher nicht gespeichert werden.",
    "The current quota for {group_name} is {quota}": "Die Speicherquota f\u00fcr {group_name} ist {quota}",
    "The custom part of the URL must be between 5 and 30 characters long and may only contain letters (a-z), numbers, and hyphens.": "Der benutzerdefinierte Teil der URL muss zwischen 5 und 30 Zeichen lang sein und kann nur Buchstaben (a-z) und Zahlen sowie Bindestriche enthalten.",
    "The file is too large. Allowed maximum size is 1MB.": "Die Datei ist zu gro\u00df. Die maximale Gr\u00f6\u00dfe betr\u00e4gt 1 MB.",
    "The image could not be previewed.": "F\u00fcr das Bild ist keine Vorschau verf\u00fcgbar.",
    "The import process may take several minutes depending on the size of your Confluence export.": "Je nach Gr\u00f6\u00dfe des Confluence-Exports kann der Import einige Minuten ben\u00f6tigen.",
    "The imported options already exists": "Die importierten Optionen gibt es bereits.",
    "The imported options are invalid": "Die importierten Optionen sind ung\u00fcltig.",
    "The least number of characters a share/upload link password should include.": "Mindestzahl an Zeichen f\u00fcr Freigabe- oder Upload-Links",
    "The least number of characters an encrypted library password should include.": "Mindestzahl von Zeichen f\u00fcr Passw\u00f6rter von verschl\u00fcsselten Bibliotheken.",
    "The level(1-4) of a share/upload link password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols": "Die Verwendung unterschiedlicher Zeichentypen wie Zahlen, Gro\u00dfbuchstaben, Kleinbuchstaben und Sonderzeichen macht die St\u00e4rke eines Passworts aus. Die Angabe f\u00fcr die St\u00e4rke (1-4) legt fest, wie viele dieser Zeichentypen verwendet werden m\u00fcssen. (Beispiel: 4 bedeutet, dass Passw\u00f6rter alle vier Zeichentypen enthalten m\u00fcssen.)",
    "The link is copied to the clipboard.": "Der Link wurde in die Zwischenablage kopiert.",
    "The list of added, deleted and modified files will be sent to your mailbox.": "Die Liste mit den neuen, gel\u00f6schten oder ver\u00e4nderten Dateien wird an Ihre E-Mail-Adresse verschickt.",
    "The maximum number of failed login attempts before showing CAPTCHA.": "Erlaubte Anzahl an erfolglosen Anmeldeversuchen, bevor zus\u00e4tzlich ein Captcha verlangt oder das Konto gesperrt wird.",
    "The name \"{name}\" is already taken. Please choose a different name.": "Der Name \u201e{name}\u201c ist bereits vergeben, bitte w\u00e4hlen Sie einen anderen.",
    "The next month": "Im n\u00e4chsten Monat",
    "The next numbers of days": "Innerhalb der n\u00e4chsten x Tage",
    "The next week": "In n\u00e4chster Woche",
    "The next year": "Im n\u00e4chsten Jahr",
    "The owner of this library has run out of space.": "Der Speicherplatz des Eigent\u00fcmers der Bibliothek ist aufgebraucht.",
    "The password is too short.": "Das Passwort ist zu kurz.",
    "The password is too weak. It should include at least {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols.": "Das Passwort ist zu schwach. Es sollte mindestens {passwordStrengthLevel} der folgenden Zeichentypen beinhalten: Zahl, Gro\u00dfbuchstabe, Kleinbuchstabe, Sonderzeichen.",
    "The password will be kept in the server for only 1 hour.": "Das Passwort wird f\u00fcr 1 Stunde auf dem Server gespeichert.",
    "The past month": "Letzten Monat",
    "The past numbers of days": "Innerhalb der letzten x Tage",
    "The past week": "Letzte Woche",
    "The past year": "Letztes Jahr",
    "The path has been copied to the clipboard": "Der Pfad wurde in den Zwischenspeicher kopiert",
    "The row is locked and cannot be modified": "Die Zeile ist gesperrt und kann nicht bearbeitet werden.",
    "The uploaded image has not been saved yet. Please close this page later.": "Das hochgeladene Bild ist noch nicht gespeichert. Bitte schlie\u00dfen Sie diese Seite erst sp\u00e4ter.",
    "There is another option with this name": "Es gibt eine andere Option mit diesem Namen",
    "There is another property with this name": "Es gibt bereits eine Eigenschaft mit diesem Namen.",
    "There is no information to display.": "Es gibt keine Informationen, die sich anzeigen lassen.",
    "This file has (apparently) not been accessed yet": "Die Datei ist (anscheinend) noch nicht benutzt worden",
    "This file has been updated.": "Die Datei wurde aktualisiert.",
    "This folder has been shared to {user_amount} user(s) and {group_amount} group(s).": "Dieser Ordner wurde f\u00fcr {user_amount} Benutzer und {group_amount} Gruppe(n) freigegeben.",
    "This folder has no content at this time.": "Der Ordner ist leer.",
    "This is a special group representing a department.": "Dies ist eine spezielle Gruppe, die f\u00fcr einen Bereich steht.",
    "This is required": "Dies ist erforderlich.",
    "This library contains tags of old version. Do you like to migrate the tags to new version?": "Die Bibliothek enth\u00e4lt noch veraltete Tags. M\u00f6chten Sie die Tags in die aktuelle Version migrieren?",
    "This library has been set to read-only by admin and cannot be updated.": "Diese Bibliothek wurde von der Administration schreibgesch\u00fctzt und kann nur gelesen werden.",
    "This library has been shared to {user_amount} user(s) and {group_amount} group(s).": "Die Bibliothek ist mit {user_amount} Benutzer(n) und {group_amount} Gruppe(n) geteilt.",
    "This library is password protected": "Die Bibliothek ist passwortgesch\u00fctzt.",
    "This list is collapsed": "Diese Liste ist eingeklappt",
    "This month": "Diesen Monat",
    "This operation will not be reverted. Please think twice!": "Dieser Vorgang kann nicht r\u00fcckg\u00e4ngig gemacht werden. Bitte seien Sie sicher, was Sie tun!",
    "This property can not be deleted": "Diese Eigenschaft kann nicht gel\u00f6scht werden.",
    "This property does not support sorting": "Diese Eigenschaft kann nicht sortiert werden.",
    "This property is not editable": "Diese Eigenschaft ist nicht bearbeitbar.",
    "This user has not created or joined any groups": "Dieser Benutzer ist nicht Mitglied einer Gruppe und hat keine erstellt.",
    "This week": "Diese Woche",
    "This year": "Dieses Jahr",
    "Thousands separator": "Tausendertrenner",
    "Thumbnail": "Vorschaubild",
    "Time": "\u00c4nderungsdatum",
    "Tip: -2 means no limit.": "Hinweis: -2 bedeutet ohne Limit.",
    "Tip: 0 means default limit": "Hinweis: 0 bedeutet Standardlimit",
    "Tip: 0 means default limit, the unit is MB": "Hinweis: 0 bedeutet Standardlimit; die Einheit ist MB.",
    "Tip: a snapshot will be generated after modification, which records the library state after the modification.": "Hinweis: Bei jeder \u00c4nderung wird ein Schnappschuss erzeugt, der den Zustand der Bibliothek nach der \u00c4nderung enth\u00e4lt.",
    "Tip: libraries deleted {placeholder} days ago will be cleaned automatically.": "Hinweis: Nach {placeholder} Tagen werden gel\u00f6schte Bibliotheken automatisch vollst\u00e4ndig entfernt.",
    "Tip: libraries deleted {trashReposExpireDays} days ago will be cleaned automatically.": "Hinweis: Bibliotheken werden {trashReposExpireDays} Tage nach L\u00f6schung automatisch ganz entfernt.",
    "Tip: you can search by keyword in name or ID.": "Hinweis: Sie k\u00f6nnen mit einem Schlagwort im Namen oder der ID suchen.",
    "Tip: you can search by keyword in name.": "Hinweis: Sie k\u00f6nnen mit einem Schlagwort in Name suchen.",
    "Tips: There are tags of old version. Please migrate tags to new version.": "Tipp: Es gibt noch veraltete Tags. Bitte migrieren Sie die Tags in die aktuelle Version.",
    "Tips: These are tags of old version. The feature is deprecated and can no longer be used.": "Tipp: Diese Tags sind veraltet. Die alte Version wird nicht mehr l\u00e4nger unterst\u00fctzt und kann nicht genutzt werden.",
    "Title property": "Titleigenschaften",
    "To confirm, type \"{placeholder}\" in the box below": "Geben Sie \"{placeholder}\" in der Box unten ein f\u00fcr eine Best\u00e4tigung",
    "Today": "Heute",
    "Toggle children": "Kinder wechseln",
    "Toggle repo selector": "Repo Auswahl umschalten",
    "Toggle selector menu": "Auswahlmen\u00fc umschalten",
    "Toggle user selector": "Benutzerauswahl umschalten",
    "Token": "Token",
    "Token:": "Token:",
    "Tomorrow": "Morgen",
    "Too many requests": "Zu viele Anfragen",
    "Total Devices": "Ger\u00e4te",
    "Total Storage": "Gesamtspeicher",
    "Total Traffic": "Datenvolumen gesamt",
    "Total Users": "Benutzerkonten",
    "Total users": "Benutzerkonten",
    "Total {comments_count} comment": "Insgesamt {comments_count} Kommentar",
    "Total {comments_count} comments": "Insgesamt {comments_count} Kommentare",
    "Traffic": "Datenvolumen",
    "Traffic exceeded": "Datenvolumen \u00fcberschritten",
    "Traffic this month": "Datenvolumen diesen Monat",
    "Transfer": "\u00dcbertragen",
    "Transfer From": "\u00dcbertragen von",
    "Transfer Group": "Gruppe \u00fcbertragen",
    "Transfer Group {placeholder} to": "Gruppe {placeholder} \u00fcbertragen",
    "Transfer Library": "Bibliothek \u00fcbertragen",
    "Transfer Library {library_name}": "\u00dcbertragen von Bibliothek {library_name}",
    "Transfer To": "\u00dcbertragen nach",
    "Transfer group to": "Gruppe \u00fcbertragen auf",
    "Transfer to department": "\u00dcbertragen auf Bereich",
    "Transfer to user": "\u00dcbertragen auf Benutzer",
    "Transferred group {group_name} from {user_from} to {user_to}": "Gruppe {group_name} von {user_from} \u00fcbertragen auf {user_to} ",
    "Transferred library {library_name} from {user_from} to {user_to}": "Bibliothek {library_name} von {user_from} \u00fcbertragen auf {user_to} ",
    "Trash": "Papierkorb",
    "Turn off": "Deaktivieren",
    "Turn off extended properties": "Erweiterte Eigenschaften deaktivieren",
    "Turn off face recognition": "Gesichtserkennung deaktivieren",
    "Turn off tags": "Tags deaktivieren",
    "Turn on extensible properties and views to experience a new way of managing files": "Aktivieren Sie erweiterte Eigenschaften und Ansichten, um eine neue Art der Dateiverwaltung zu erleben",
    "Two-Factor Authentication": "Zwei-Faktor-Authentifizierung",
    "Two-factor authentication is not enabled for your account. Enable two-factor authentication for enhanced account security.": "Die Zwei-Faktor-Authentifizierung wurde f\u00fcr Ihren Account nicht aktiviert. F\u00fcr einen zus\u00e4tzlichen Schutz Ihres Accounts aktivieren Sie die Zwei-Faktor-Authentifizierung.",
    "Type": "Typ",
    "Type characters to start search": "Geben Sie etwas ein, um die Suche zu starten",
    "URL is copied to the clipboard": "Die URL wurde in die Zwischenanlage kopiert.",
    "URL is required": "Die URL ist erforderlich.",
    "US": "Amerikanisch",
    "Uncategorized": "nicht kategorisiert",
    "Undo": "R\u00fcckg\u00e4ngig machen",
    "Unfold": "Ausklappen",
    "Unfold the sidebar": "Seitenleiste ausklappen",
    "Unfreeze Document": "Dokument entsperren",
    "Unhandled": "Unbehandelt",
    "Unknown": "Unbekannt",
    "Unknown people": "Unbekannte Personen",
    "Unlink": "Trennen",
    "Unlink device": "Verbindung zum Ger\u00e4t trennen",
    "Unlock": "Entsperren",
    "Unpublish": "Ver\u00f6ffentlichung r\u00fcckg\u00e4ngig machen",
    "Unpublish Wiki": "Ver\u00f6ffentlichung r\u00fcckg\u00e4ngig machen",
    "Unresolved comments": "Nicht erledigte Kommentare",
    "Unselect": "Abw\u00e4hlen",
    "Unselect all": "Alle abw\u00e4hlen",
    "Unselect all items": "Alle Elemente abw\u00e4hlen",
    "Unselect items": "Elemente ausw\u00e4hlen",
    "Unselect this item": "Element abw\u00e4hlen",
    "Unshare": "Freigabe beenden",
    "Unshare Library": "Freigabe beenden",
    "Unstar": "Aus Favoriten entfernen",
    "Untitled": "Unbenannt",
    "Unwatch File Changes": "Datei\u00e4nderungen nicht \u00fcberwachen",
    "Up": "Aufsteigend",
    "Update": "Aktualisieren",
    "Update Terms and Conditions": "Nutzungsvereinbarungen aktualisieren",
    "Update password": "Passwort aktualisieren",
    "Update succeeded.": "Die Aktualisierung wurde gespeichert.",
    "Update time": "Zeit aktualisieren",
    "Updated draft": "Entwurf ist aktualisiert",
    "Updated file": "Aktualisierte Datei",
    "Upgrade to Pro Edition": "Upgrade auf die Pro Edition",
    "Upload": "Hochladen",
    "Upload Files": "Dateien hochladen",
    "Upload Folder": "Ordner hochladen",
    "Upload Link": "Upload-Link",
    "Upload Links": "Upload-Links",
    "Upload failed": "Hochladen fehlgeschlagen",
    "Upload file": "Datei hochladen",
    "Upload files to": "Dateien hochladen nach",
    "Upload license": "Lizenz hochladen",
    "Upload link is copied to the clipboard.": "Der Upload-Link wurde in die Zwischenablage kopiert.",
    "Uploaded": "Hochgeladen",
    "Uploading...": "Lade hoch\u2026",
    "Use custom CSS": "Angepasstes CSS verwenden",
    "Use information from your Identity Provider to configure Seafile": "F\u00fcgen Sie Informationen Ihres Identity Providers ein, um Seafile zu konfigurieren.",
    "Use the import/export function to transfer options quickly. (The export is in JSON format.) By pasting cells, copied from a text column, an Excel or a TXT file, you can also add options quickly.": "Verwenden Sie \"Optionen importieren\" bzw. \"Optionen exportieren\", um Optionen schnell zu \u00fcbertragen. (Der Export erfolgt im JSON-Format.) Durch das Einf\u00fcgen eines oder mehrerer kopierter Werte aus einer Textspalte, einer Excel Tabelle oder einer TXT-Datei k\u00f6nnen Sie Optionen ebenfalls schnell erstellen.",
    "Use these values to configure your Identity Provider": "Nutzen Sie die folgenden Informationen zur Konfiguration Ihres Identity Providers.",
    "Used:": "Verwendet:",
    "User": "Benutzer",
    "User Email": "E-Mail des Benutzers",
    "User ID": "Benutzer ID",
    "User Permission": "Benutzerberechtigung",
    "User Shares": "Benutzerfreigaben",
    "User Storage": "Nutzerspeicher",
    "User can not see this folder.": "Benutzer k\u00f6nnen diesen Ordner nicht sehen.",
    "User can only view files online via browser. Files can't be downloaded.": "Nur das Anzeigen im Web-Browser ist erlaubt. Dateien k\u00f6nnen nicht heruntergeladen werden.",
    "User can read, download and sync files.": "Lesen, Herunterladen und Synchronisieren von Dateien erlaubt.",
    "User can read, write, upload, download and sync files.": "Lesen, Schreiben, Hochladen, Herunterladen und Synchronisieren von Dateien erlaubt.",
    "User can view and edit file online via browser. Files can't be downloaded.": "Nur das Anzeigen und Bearbeiten im Web-Browser ist erlaubt. Dateien k\u00f6nnen nicht heruntergeladen werden.",
    "User default quota": "Standard-Speicherquota",
    "User default quota updated": "Die Standard-Speicherquota wurde aktualisiert.",
    "User deleted": "Der Benutzer wurde gel\u00f6scht.",
    "User info updated": "Die Benutzerinformationen wurde aktualisiert.",
    "User is already in this group": "Der Benutzer ist bereits in der Gruppe.",
    "User migrate from {user_from} to {user_to}": "Benutzer von {user_from} zu {user_to} migrieren",
    "User not found": "Benutzer nicht gefunden",
    "User number limit": "Benutzerlimit",
    "User {user_link} has added you to {group_link}": "{user_link} hat Sie zur Gruppe {group_link} hinzugef\u00fcgt.",
    "Username:": "Benutzername:",
    "Users": "Benutzer",
    "Value": "Wert",
    "Verified": "Verifiziert",
    "Verify": "Verifizieren",
    "Verify Domain": "Domainverifizierung",
    "Version": "Version",
    "Version Number": "Versionsnummer",
    "Version Number is required.": "Versionsnummer erforderlich.",
    "Version Number must be a number.": "Versionsnummer muss eine Nummer sein.",
    "Video": "Video",
    "View": "Anzeigen",
    "View Link": "Link anzeigen",
    "View Related Snapshot": "Verbundenen Schnappschuss ansehen",
    "View Snapshot": "Schnappschuss ansehen",
    "View all notifications": "Alle Benachrichtigungen anzeigen",
    "View notification": "Benachrichtigung lesen",
    "View original image": "Originalbild anzeigen",
    "View profile and more": "Profil und weiteres anzeigen",
    "View published page": "Ver\u00f6ffentlichte Seite anzeigen",
    "Views": "Ansichten",
    "Virus": "Virus",
    "Virus File": "Virusdatei",
    "Virus Scan": "Viren-Scan",
    "Visit count": "Anzahl der Besucher",
    "Visit old version page": "Alte Darstellung der Versionierung anzeigen",
    "Visit the wiki": "Wiki aufrufen",
    "Visited": "Besucht",
    "Visits": "Aufrufe",
    "Waiting...": "In Arbeit ....",
    "Watch File Changes": "Datei\u00e4nderungen \u00fcberwachen",
    "Web API Auth Token": "Web API Auth-Token",
    "Web Download": "Web-Downloads",
    "Web Traffic": "Datenvolumen Weboberfl\u00e4che",
    "Web Upload": "Hochladen per Web",
    "WebDAV Access": "WebDAV-Zugriff",
    "WebDAV password:": "WebDAV Passwort:",
    "WebDAV username:": "WebDAV Benutzername:",
    "Welcome to {site_name_placeholder}": "Willkommen bei {site_name_placeholder}",
    "Whether the notifications of collaboration such as sharing library or joining group should be sent to your mailbox.": "Wollen Sie Benachrichtigungen \u00fcber die Zusammenarbeit (z.B. Bibliotheksfreigabe, Gruppenaufnahme) per E-Mail erhalten?",
    "Wiki custom URL deleted": "Die benutzerdefinierte URL des Wikis wurde gel\u00f6scht.",
    "Wiki owner": "Eigent\u00fcmer des Wikis",
    "Wiki published": "Das Wiki wurde ver\u00f6ffentlicht.",
    "Wikis": "Wikis",
    "Workspace": "Arbeitsplatz",
    "Wrong password": "Falsches Passwort",
    "Year": "Jahr",
    "Yesterday": "Gestern",
    "You can also add a user as a guest, who will not be allowed to create libraries and groups.": "Sie k\u00f6nnen Benutzer auch als G\u00e4ste hinzuf\u00fcgen. Diese k\u00f6nnen dann keine Bibliotheken oder Gruppen erstellen.",
    "You can click the \"Add Wiki\" button below to add a new Wiki.": "Verwenden Sie die Schaltfl\u00e4che \u201eWiki hinzuf\u00fcgen\u201c, wenn Sie ein neues Wiki anlagen wollen.",
    "You can create files quickly": "Sie k\u00f6nnen Dateien schnell anlegen",
    "You can create libraries by clicking the \"New Library\" item in the dropdown menu.": "Sie k\u00f6nnen eine neue Bibliothek anlegen, indem Sie im Dropdown-Men\u00fc auf \u201eNeue Bibliothek\u201c klicken.",
    "You can enter multiple emails. An invitation link will be sent to each of them.": "Sie k\u00f6nnen mehrere E-Mail-Adressen eingeben. An jede wird ein Einladungs-Link versendet.",
    "You can use this field at login.": "Dieses Feld k\u00f6nnen Sie zum Anmelden verwenden",
    "You do not have permission": "Sie haben keine ausreichende Berechtigung.",
    "You don't have any favorite items yet": "Sie haben keine Favoriten.",
    "You don't have any share links": "Sie haben keine Freigabe-Links erstellt.",
    "You don't have any upload links": "Sie haben keine Upload-Links erstellt.",
    "You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "Sie haben noch nicht mit einem mobilen oder station\u00e4ren Ger\u00e4t auf Ihre Dateien zugegriffen. Um komfortabler mit Ihren Daten zu arbeiten, installieren Sie auf Ihren Ger\u00e4ten die entsprechenden Clients oder Apps.",
    "You have not added any libraries, folders or files to your favorites yet. A favorite gives you quick access to your most frequently used objects. You can add a library, folder or file to your favorites by clicking the star to the left of its name.": "Sie haben noch keine Bibliotheken, Ordner oder Dateien zu Ihren Favoriten hinzugef\u00fcgt. \u00dcber Favoriten haben Sie schnellen Zugriff auf Ihre wichtigsten Objekte. Um eine Bibliothek, einen Ordner oder eine Datei zu Ihren Favoriten hinzuzuf\u00fcgen, klicken Sie auf den Stern links neben dem Namen.",
    "You have not created any libraries yet. A library is a container to organize your files and folders. A library can also be shared with others and synced to your connected devices. You can create a library by clicking the \"New Library\" item in the dropdown menu.": "Sie haben noch keine Bibliotheken angelegt. Eine Bibliothek ist ein Container, in dem Sie Ihre Dateien und Ordner organisieren k\u00f6nnen. Ein Bibliothek kann f\u00fcr andere Personen freigegeben sowie mit externen Ger\u00e4ten synchronisiert werden. Sie k\u00f6nnen eine Bibliothek anlegen, indem Sie im Dropdown-Men\u00fc auf \u201eNeue Bibliothek\u201c klicken.",
    "You have not created any share links yet. A share link can be used to share files and folders with anyone. You can create a share link for a file or folder by clicking the share icon to the right of its name.": "Sie habe noch keine Freigabe-Links angelegt. \u00dcber einen Freigabe-Link k\u00f6nnen Dateien und Ordner f\u00fcr beliebige Personen bereitgestellt werden. Um einen Freigabe-Link f\u00fcr eine Datei oder einen Ordner zu erstellen, klicken Sie auf das Freigabe-Icon rechts neben dem Namen.",
    "You have not created any upload links yet. An upload link allows anyone to upload files to a folder or library. You can create an upload link for a folder or library by clicking the share icon to the right of its name.": "Sie habe noch keine Upload-Links angelegt. \u00dcber einen Upload-Link k\u00f6nnen beliebige Personen Dateien in Ordner oder Bibliotheken hochladen. Um einen Upload-Link f\u00fcr einen Ordner oder eine Bibliothek zu erstellen, klicken Sie auf das Freigabe-Icon rechts neben dem Namen.",
    "You have not deleted any libraries in the last {placeholder} days. A deleted library will be cleaned automatically after this period.": "Sie haben in den letzten {placeholder} Tagen keine Bibliotheken gel\u00f6scht. Nach diesem Zeitraum werden gel\u00f6schte Bibliotheken automatisch vollst\u00e4ndig entfernt.",
    "You have not invited any guests yet. A guest can access shared libraries through the web interface allowing more efficient ways to collaborate than through links. You can invite a guest by clicking the \"Invite Guest\" item in the dropdown menu.": "Sie haben noch keine G\u00e4ste eingeladen. Ein Gast kann auf freigegebene Bibliotheken \u00fcber das Webinterface zugreifen. Dies erm\u00f6glicht effizientere Formen der Zusammenarbeit als dies mit Links m\u00f6glich ist. Sie k\u00f6nnen einen Gast einladen, indem Sie im Dropdown-Men\u00fc auf \u201eGast einladen\u201c klicken.",
    "You have not shared any folders": "Sie haben keine Ordner freigegeben.",
    "You have not shared any folders with other users yet. You can share a folder with other users by clicking the share icon to the right of a folder's name.": "Sie haben noch keine Ordner f\u00fcr andere Personen freigegeben. Um einen Ordner freizugeben, klicken Sie auf das Freigabe-Icon rechts neben dem Namen.",
    "You have not shared any libraries with other users yet. You can share a library with other users by clicking the share icon to the right of a library's name in \"My Libraries\".": "Sie haben noch keine Bibliotheken f\u00fcr andere Personen freigegeben. Um eine Bibliothek freizugeben, klicken Sie auf das Freigabe-Icon rechts vom Namen der Bibliothek in \u201eMeine Bibliotheken\u201c.",
    "You have only one backup code remaining.": "Sie haben nur noch einen freien Ersatz-Code zur Verf\u00fcgung.",
    "You have {num} backup codes remaining.": "Sie haben noch {num} freie Ersatz-Codes.",
    "Your name": "Ihr Name",
    "Your notifications will be sent to this email.": "Benachrichtigungen werden an diese E-Mail-Adresse geschickt.",
    "Yuan": "Yuan",
    "ZIP": "ZIP",
    "Zoom in": "Hineinzoomen",
    "Zoom out": "Herauszoomen",
    "all": "Alles",
    "all members": "Alle Mitglieder",
    "contains": "enth\u00e4lt",
    "copy": "kopieren",
    "days": "Tage",
    "deleted": "gel\u00f6scht",
    "deleted option": "gel\u00f6schte Option",
    "details": "Details",
    "does not contain": "enth\u00e4lt nicht",
    "email is required": "E-Mail-Adresse erforderlich",
    "freezed": "eingefroren",
    "has all of...": "enth\u00e4lt alle",
    "has any of...": "enth\u00e4lt einen von",
    "has none of...": "enth\u00e4lt nicht",
    "icon": "Symbol",
    "in all libraries": "in allen Bibliotheken",
    "in this folder": "in diesem Ordner",
    "in this library": "in dieser Bibliothek",
    "include the current user": "ist der aktuelle Benutzer",
    "is": "ist gleich",
    "is after...": "ist nach",
    "is any of...": "ist eine von",
    "is before...": "ist vor",
    "is current user's ID": "ist die aktuelle Benutzer-ID",
    "is empty": "ist leer",
    "is exactly...": "ist genau",
    "is none of...": "ist nicht",
    "is not": "ist ungleich",
    "is not empty": "ist nicht leer",
    "is on or after...": "ist am oder nach",
    "is on or before...": "ist am or vor",
    "is within...": "ist innerhalb",
    "items": "Elemente",
    "licensed to {placeholder_license_to}, expires on {placeholder_license_expiration}": "Lizenziert f\u00fcr {placeholder_license_to}, l\u00e4uft aus am {placeholder_license_expiration}",
    "licensed to {placeholder_license_to}, upgrade service expired in {placeholder_license_expiration}": " {placeholder_license_to}, der Upgrade-Service ist ausgelaufen am {placeholder_license_expiration}",
    "locked": "gesperrt",
    "locked by {name}": "von {name} gesperrt",
    "members": "Mitglieder",
    "mm": "mm",
    "name": "Name",
    "not set": "nicht gesetzt",
    "only show {placeholder}": "nur {placeholder} anzeigen",
    "progress": "Fortschritt",
    "s": "s",
    "selected": "ausgew\u00e4hlt",
    "show more": "mehr \u2026",
    "size": "Gr\u00f6\u00dfe",
    "sorts": "Sortierungen",
    "starred": "Favorit",
    "state": "Status",
    "successfully added user %s.": "%s wurde hinzugef\u00fcgt.",
    "successfully sent email to %s.": "Eine E-Mail wurde an %s versendet.",
    "tags": "Tags",
    "unstarred": "Kein Favorit",
    "xxx cells copied": "xxx Zellen wurden in die Zwischenablage kopiert.",
    "xxx cells cut": "xxx Zellen wurden ausgeschnitten und in die Zwischenablage gelegt.",
    "xxx cells selected": "xxx Zellen ausgew\u00e4hlt",
    "xxx record": "xxx Eintrag",
    "xxx records": "xxx Eintr\u00e4ge",
    "xxx records selected": "xxx Eintr\u00e4ge ausgew\u00e4hlt",
    "xxx rows are copied.": "xxx Zeilen wurden in die Zwischenablage kopiert.",
    "you can also press \u2192": "Sie k\u00f6nnen auch \u2192 (Pfeil rechts) verwenden ",
    "{failed_files_num} file(s) failed to upload": "Der Upload von {failed_files_num} ist fehlgeschlagen.",
    "{file} and {n} other files": "{file} und {n} weitere Dateien",
    "{library_name} Office Suite": "{library_name} Office Suite",
    "{minDays_placeholder} - {maxDays_placeholder} days": "{minDays_placeholder} - {maxDays_placeholder} Tage",
    "{name_placeholder} cells copied": "{name_placeholder} Zellen wurden in die Zwischenablage kopiert.",
    "{name_placeholder} cells cut": "{name_placeholder} Zellen wurden ausgeschnitten und in die Zwischenablage kopiert.",
    "{name_placeholder} cells selected": "{name_placeholder} Zellen wurden ausgew\u00e4hlt.",
    "{name_placeholder} hidden properties": "{name_placeholder} ausgeblendete Eigenschaften",
    "{name_placeholder} preset hidden properties": "{name_placeholder} voreingestellt ausgeblendete Eigenschaften",
    "{name_placeholder} record": "{name_placeholder} Eintrag",
    "{name_placeholder} records": "{name_placeholder} Eintr\u00e4ge",
    "{name_placeholder} records selected": "{name_placeholder} Eintr\u00e4ge wurden ausgew\u00e4hlt.",
    "{name_placeholder} rows are copied.": "{name_placeholder} Zeilen wurden in die Zwischenablage kopiert.",
    "{name} rows use this option.": "{name} Zeilen nutzen diese Option.",
    "{number_placeholder} / Page": "{number_placeholder} / Seite",
    "{placeholder} API Token": "{placeholder} API-Token",
    "{placeholder} Access Log": "{placeholder} Zugriffs-Log",
    "{placeholder} Folder Permission": "{placeholder} Ordnerberechtigung",
    "{placeholder} History Setting": "{placeholder} Versionierung einstellen",
    "{placeholder} Modification History": "{placeholder} Versionen",
    "{placeholder} Share Admin": "{placeholder} Freigabeverwaltung",
    "{placeholder} Snapshot": "{placeholder} Schnappschuss",
    "{placeholder} Trash": "{placeholder} Papierkorb",
    "{placeholder} Wiki Trash": "{placeholder} Wiki Papierkorb",
    "{share_from} has cancelled the sharing of folder {repo_name}.": "{share_from} hat die Freigabe des Ordners {repo_name} beendet.",
    "{share_from} has cancelled the sharing of library {repo_name}.": "{share_from} hat die Freigabe der Bibliothek {repo_name} beendet.",
    "{share_from} has changed the permission of folder {repo_link} to {permission}.": "{share_from} hat die Rechte des Ordners {repo_link} ge\u00e4ndert in {permission}.",
    "{share_from} has changed the permission of library {repo_link} to {permission}.": "{share_from} hat die Rechte der Bibliothek {repo_link} ge\u00e4ndert in {permission}.",
    "{share_from} has shared a folder named {repo_link} to group {group_link}.": "{share_from} hat den Ordner {repo_link} f\u00fcr die Gruppe {group_link} freigegeben.",
    "{share_from} has shared a folder named {repo_link} to you.": "{share_from} hat den Ordner {repo_link} f\u00fcr Sie freigegeben.",
    "{share_from} has shared a library named {repo_link} to group {group_link}.": "{share_from} hat die Bibliothek {repo_link} f\u00fcr die Gruppe {group_link} freigegeben.",
    "{share_from} has shared a library named {repo_link} to you.": "{share_from} hat die Bibliothek {repo_link} f\u00fcr Sie freigegeben.",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. However, since you are a guest user now, you can not create libraries.": "{site_name_placeholder} verwaltet Dateien in Bibliotheken. Jede Bibliothek kann synchronisiert und separat freigegeben werden. Da Sie aktuell als Gast angemeldet sind, k\u00f6nnen Sie leider keine neuen Bibliotheken erstellen.",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. We have created a personal library for you. You can create more libraries later.": "{site_name_placeholder} verwaltet Dateien in Bibliotheken. Jede Bibliothek kann synchronisiert und separat freigegeben werden. Wir haben hier bereits eine pers\u00f6nliche Bibliothek f\u00fcr Sie erstellt, weitere Bibliotheken k\u00f6nnen Sie nach Bedarf hinzuf\u00fcgen.",
    "{uploaded_files_num}/{all_files_num} Files": "{uploaded_files_num}/{all_files_num} Dateien",
    "{userCount} user(s) and {repoCount} libraries of this organization will also be deleted.": "{userCount} Benutzer und {repoCount} Bibliotheken dieser Organisation werden hiermit ebenfalls gel\u00f6scht.",
    "{user} created file {fileName} and {fileCount} other file(s) in library {libraryName}.": "Der Benutzer {user} hat die Datei {fileName} und {fileCount} weitere Datei(en) in der Bibliothek {libraryName} erstellt.",
    "{user} created file {fileName} in library {libraryName}.": "Der Benutzer {user} hat die Datei {fileName} in der Bibliothek {libraryName} erstellt.",
    "{user} created folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "Der Benutzer {user} hat den Ordner {folderName} und {folderCount} weitere Ordner in der Bibliothek {libraryName} erstellt.",
    "{user} created folder {folderName} in library {libraryName}.": "Der Benutzer {user} hat den Ordner {folderName} in der Bibliothek {libraryName} erstellt.",
    "{user} deleted file {fileName} and {fileCount} other file(s) in library {libraryName}.": "Der Benutzer {user} hat die Datei {fileName} und {fileCount} weitere Datei(en) in der Bibliothek {libraryName} gel\u00f6scht.",
    "{user} deleted file {fileName} in library {libraryName}.": "Der Benutzer {user} hat die Datei {fileName} in der Bibliothek {libraryName} gel\u00f6scht.",
    "{user} deleted folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "Der Benutzer {user} hat den Ordner {folderName} und {folderCount} weitere Ordner in der Bibliothek {libraryName} gel\u00f6scht.",
    "{user} deleted folder {folderName} in library {libraryName}.": "Der Benutzer {user} hat den Ordner {folderName} in der Bibliothek {libraryName} gel\u00f6scht.",
    "{user} has transferred a library named {repo_link} to you.": "{user} hat die Bibliothek {repo_link} auf Sie \u00fcbertragen.",
    "{user} moved file {fileName} and {fileCount} other file(s) in library {libraryName}.": "Der Benuter {user} hat die Datei {fileName} und {fileCount} weitere Datei(en) in der Bibliothek {libraryName} verschoben.",
    "{user} moved file {fileName} in library {libraryName}.": "Der Benutzer {user} hat die Datei {fileName} in der Bibliothek {libraryName} verschoben.",
    "{user} moved folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "Der Benutzer {user} hat den Ordner {folderName} und {folderCount} weitere Ordner in der Bibliothek {libraryName} verschoben.",
    "{user} moved folder {folderName} in library {libraryName}.": "Der Benutzer {user} hat den Ordner {folderName} in Bibliothek {libraryName} verschoben.",
    "{user} renamed file {oldFileName} {fileName} in library {libraryName}.": "Der Benutzer {user} hat die Datei {oldFileName} in der Bibliothek {libraryName} in {fileName} umbenannt.",
    "{user} renamed folder {oldFolderName} {folderName} in library {libraryName}.": "Der Benutzer {user} hat den Ordner {oldFolderName} in der Bibliothek {libraryName} in {folderName} umbenannt.",
    "{user} restored file {fileName} in library {libraryName}.": "Der Benutzer {user} hat die Datei {fileName} in der Bibliothek {libraryName} wiederhergestellt.",
    "{user} restored folder {folderName} in library {libraryName}.": "Der Benutzer {user} hat den Ordner {folderName} in der Bibliothek {libraryName} wiederhergestellt.",
    "{user} updated file {fileName} in library {libraryName}.": "Der Benutzer {user} hat die Datei {fileName} in der Bibliothek {libraryName} aktualisiert.",
    "{xxx} items have been selected": " {xxx} Artikel wurden ausgew\u00e4hlt"
  };
  for (const key in newcatalog) {
    django.catalog[key] = newcatalog[key];
  }
  

  if (!django.jsi18n_initialized) {
    django.gettext = function(msgid) {
      const value = django.catalog[msgid];
      if (typeof value === 'undefined') {
        return msgid;
      } else {
        return (typeof value === 'string') ? value : value[0];
      }
    };

    django.ngettext = function(singular, plural, count) {
      const value = django.catalog[singular];
      if (typeof value === 'undefined') {
        return (count == 1) ? singular : plural;
      } else {
        return value.constructor === Array ? value[django.pluralidx(count)] : value;
      }
    };

    django.gettext_noop = function(msgid) { return msgid; };

    django.pgettext = function(context, msgid) {
      let value = django.gettext(context + '\x04' + msgid);
      if (value.includes('\x04')) {
        value = msgid;
      }
      return value;
    };

    django.npgettext = function(context, singular, plural, count) {
      let value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
      if (value.includes('\x04')) {
        value = django.ngettext(singular, plural, count);
      }
      return value;
    };

    django.interpolate = function(fmt, obj, named) {
      if (named) {
        return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
      } else {
        return fmt.replace(/%s/g, function(match){return String(obj.shift())});
      }
    };


    /* formatting library */

    django.formats = {
    "DATETIME_FORMAT": "j. F Y H:i",
    "DATETIME_INPUT_FORMATS": [
      "%d.%m.%Y %H:%M:%S",
      "%d.%m.%Y %H:%M:%S.%f",
      "%d.%m.%Y %H:%M",
      "%Y-%m-%d %H:%M:%S",
      "%Y-%m-%d %H:%M:%S.%f",
      "%Y-%m-%d %H:%M",
      "%Y-%m-%d"
    ],
    "DATE_FORMAT": "j. F Y",
    "DATE_INPUT_FORMATS": [
      "%d.%m.%Y",
      "%d.%m.%y",
      "%Y-%m-%d"
    ],
    "DECIMAL_SEPARATOR": ",",
    "FIRST_DAY_OF_WEEK": 1,
    "MONTH_DAY_FORMAT": "j. F",
    "NUMBER_GROUPING": 3,
    "SHORT_DATETIME_FORMAT": "d.m.Y H:i",
    "SHORT_DATE_FORMAT": "d.m.Y",
    "THOUSAND_SEPARATOR": ".",
    "TIME_FORMAT": "H:i",
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S",
      "%H:%M:%S.%f",
      "%H:%M"
    ],
    "YEAR_MONTH_FORMAT": "F Y"
  };

    django.get_format = function(format_type) {
      const value = django.formats[format_type];
      if (typeof value === 'undefined') {
        return format_type;
      } else {
        return value;
      }
    };

    /* add to global namespace */
    globals.pluralidx = django.pluralidx;
    globals.gettext = django.gettext;
    globals.ngettext = django.ngettext;
    globals.gettext_noop = django.gettext_noop;
    globals.pgettext = django.pgettext;
    globals.npgettext = django.npgettext;
    globals.interpolate = django.interpolate;
    globals.get_format = django.get_format;

    django.jsi18n_initialized = true;
  }
};

