
'use strict';
{
  const globals = this;
  const django = globals.django || (globals.django = {});

  
  django.pluralidx = function(n) {
    const v = 0;
    if (typeof v === 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  /* gettext library */

  django.catalog = django.catalog || {};
  
  const newcatalog = {
    "(If left blank, owner will be admin)": "\uff08\u7a7a\u767d\u306e\u307e\u307e\u306b\u3059\u308b\u3068\u3001\u6240\u6709\u8005\u304c\u7ba1\u7406\u8005\u306b\u306a\u308a\u307e\u3059\uff09",
    "(at least {passwordMinLength} characters and includes {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols)": "(\u6700\u4f4e{passwordMinLength}\u6587\u5b57\u304b\u3064\u3001\u6570\u5b57, \u30a2\u30eb\u30d5\u30a1\u30d9\u30c3\u30c8\u5927\u6587\u5b57\u30fb\u5c0f\u6587\u5b57, \u305d\u306e\u4ed6\u306e\u8a18\u53f7\u306e\u3046\u3061\u3001\u6700\u4f4e{passwordStrengthLevel}\u7a2e\u985e\u3092\u542b\u3081\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059)",
    "(at least {placeholder} characters)": "\uff08{placeholder}\u6587\u5b57\u4ee5\u4e0a\uff09",
    "(current notification)": "(\u73fe\u5728\u306e\u901a\u77e5)",
    "(current version)": "\uff08\u73fe\u5728\u306e\u7248\uff09",
    "(deleted)": "\uff08\u524a\u9664\u6e08\u307f\uff09",
    "1 Hidden property": "\u975e\u8868\u793a\u30d7\u30ed\u30d1\u30c6\u30a3",
    "1 Year": "1\u5e74\u9593",
    "1 cell copied": "1 \u30bb\u30eb\u3092\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f",
    "1 cell cut": "1 \u30bb\u30eb\u3092\u5207\u308a\u53d6\u308a\u307e\u3057\u305f",
    "1 filter": "1\u30d5\u30a3\u30eb\u30bf\u30fc",
    "1 hidden property": "\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u975e\u8868\u793a",
    "1 month ago": "1\u30f6\u6708\u524d",
    "1 preset hidden property": "\u30d7\u30ea\u30bb\u30c3\u30c8\u975e\u8868\u793a\u30d7\u30ed\u30d1\u30c6\u30a3",
    "1 record selected": "1 \u30ec\u30b3\u30fc\u30c9\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f",
    "1 row is copied.": "1 \u884c\u3092\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f",
    "1 sort": "1\u4e26\u3079\u66ff\u3048",
    "1 week ago": "1\u9031\u9593\u524d",
    "3 days ago": "3\u65e5\u524d",
    "30 Days": "30\u65e5\u9593",
    "7 Days": "7\u65e5\u9593",
    "A file is being uploaded. Are you sure you want to leave this page?": "\u30d5\u30a1\u30a4\u30eb\u3092\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u4e2d\u3067\u3059\u3002\u3053\u306e\u30da\u30fc\u30b8\u3092\u96e2\u308c\u307e\u3059\u304b\uff1f",
    "A file named {upload_file_link} is uploaded to {uploaded_link}.": "\u30d5\u30a1\u30a4\u30eb {upload_file_link} \u304c {uploaded_link} \u306b\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u3055\u308c\u307e\u3057\u305f\u3002",
    "A file named {upload_file_link} is uploaded.": "\u30d5\u30a1\u30a4\u30eb {upload_file_link} \u304c\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u3055\u308c\u307e\u3057\u305f\u3002",
    "A file with the same name already exists in this folder.": "\u3053\u306e\u30d5\u30a9\u30eb\u30c0\u30fc\u306b\u540c\u3058\u540d\u524d\u306e\u30d5\u30a1\u30a4\u30eb\u304c\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002",
    "A folder named {upload_folder_link} is uploaded to {uploaded_link}.": "\u30d5\u30a9\u30eb\u30c0 {upload_folder_link} \u304c {uploaded_link} \u306b\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u3055\u308c\u307e\u3057\u305f\u3002",
    "A folder named {upload_folder_link} is uploaded.": "\u30d5\u30a9\u30eb\u30c0 {upload_folder_link} \u304c\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u3055\u308c\u307e\u3057\u305f\u3002",
    "AI": "AI",
    "AI credit used this month": "\u6708\u9593AI\u30af\u30ec\u30b8\u30c3\u30c8\u4f7f\u7528\u91cf",
    "AI credit used:": "AI\u30af\u30ec\u30b8\u30c3\u30c8: ",
    "API Token": "API\u30c8\u30fc\u30af\u30f3",
    "API token is copied to the clipboard.": "API\u30c8\u30fc\u30af\u30f3\u304c\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3059\u3002",
    "About": "\u5173\u4e8e",
    "About Us": "About Us",
    "Abuse Content": "\u4e0d\u6b63\u306a\u5185\u5bb9",
    "Abuse Reports": "\u6ee5\u7528\u5831\u544a",
    "Abuse Type": "\u4e0d\u6b63\u306e\u7a2e\u985e",
    "Abuse report added": "\u4e0d\u6b63\u306e\u5831\u544a\u304c\u8ffd\u52a0\u3055\u308c\u307e\u3057\u305f",
    "Accept": "\u53d7\u3051\u5165\u308c\u308b",
    "Accepted": "\u53d7\u3051\u5165\u308c\u6e08\u307f",
    "Accepted at": "\u627f\u8a8d\u65e5",
    "Accepter": "\u53d7\u4fe1\u8005",
    "Access Log": "\u30a2\u30af\u30bb\u30b9\u30ed\u30b0",
    "Access scope": "\u30a2\u30af\u30bb\u30b9\u7bc4\u56f2",
    "Accurate to minute": "\u5206\u5358\u4f4d\u307e\u3067\u6b63\u78ba",
    "Action": "\u64cd\u4f5c",
    "Actions": "\u64cd\u4f5c",
    "Activate after registration": "\u767b\u9332\u5f8c\u306b\u30a2\u30af\u30c6\u30a3\u30d6\u5316",
    "Activate user immediately after registration. If unchecked, a user need to be activated by administrator or via activation email": "\u767b\u9332\u5f8c\u3001\u76f4\u3061\u306b\u30e6\u30fc\u30b6\u3092\u30a2\u30af\u30c6\u30a3\u30d6\u5316\u3057\u307e\u3059\u3002\u30c1\u30a7\u30c3\u30af\u3092\u5916\u3059\u3068\u3001\u30e6\u30fc\u30b6\u306f\u7ba1\u7406\u8005\u306b\u3088\u3063\u3066\u3001\u307e\u305f\u306f\u30a2\u30af\u30c6\u30a3\u30d9\u30fc\u30b7\u30e7\u30f3\u30e1\u30fc\u30eb\u3092\u4ecb\u3057\u3066\u30a2\u30af\u30c6\u30a3\u30d6\u5316\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002",
    "Activated": "\u6709\u52b9\u5316",
    "Activated Users": "\u6709\u52b9\u30e6\u30fc\u30b6\u6570",
    "Active": "\u30a2\u30af\u30c6\u30a3\u30d6",
    "Active Users": "\u30a2\u30af\u30c6\u30a3\u30d6\u30e6\u30fc\u30b6",
    "Active users": "\u30a2\u30af\u30c6\u30a3\u30d6\u30e6\u30fc\u30b6",
    "Activities": "\u6d3b\u52d5",
    "Actual size": "\u5b9f\u969b\u306e\u30b5\u30a4\u30ba",
    "Add": "\u8ffd\u52a0",
    "Add Admin": "\u7ba1\u7406\u8005\u3092\u8ffd\u52a0",
    "Add Folder": "\u30d5\u30a9\u30eb\u30c0\u3092\u8ffd\u52a0",
    "Add Institution": "\u7d44\u7e54\u3092\u8ffd\u52a0",
    "Add Library": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u8ffd\u52a0",
    "Add Member": "\u4f1a\u54e1\u3092\u8ffd\u52a0",
    "Add Organization": "\u7d44\u7e54\u3092\u8ffd\u52a0",
    "Add Terms and Conditions": "\u5229\u7528\u898f\u7d04\u3092\u8ffd\u52a0",
    "Add User": "\u30e6\u30fc\u30b6\u3092\u8ffd\u52a0",
    "Add User to Group": "\u30e6\u30fc\u30b6\u3092\u30b0\u30eb\u30fc\u30d7\u306b\u8ffd\u52a0",
    "Add Wiki": "Wiki \u3092\u8ffd\u52a0",
    "Add admin": "\u7ba1\u7406\u8005\u306e\u8ffd\u52a0",
    "Add auto expiration": "\u6709\u52b9\u671f\u9650\u3092\u8a2d\u5b9a",
    "Add column": "\u5217\u3092\u8ffd\u52a0",
    "Add cover": "\u30b5\u30e0\u30cd\u30a4\u30eb\u3092\u8ffd\u52a0",
    "Add custom permission": "\u30ab\u30b9\u30bf\u30e0\u6a29\u9650\u3092\u8ffd\u52a0",
    "Add department at": "\u90e8\u9580\u3092\u8ffd\u52a0",
    "Add filter": "\u30d5\u30a3\u30eb\u30bf\u30fc\u3092\u8ffd\u52a0",
    "Add group": "\u30b0\u30eb\u30fc\u30d7\u3092\u8ffd\u52a0",
    "Add group member": "\u30b0\u30eb\u30fc\u30d7\u30e1\u30f3\u30d0\u3092\u8ffd\u52a0",
    "Add icon": "\u30a2\u30a4\u30b3\u30f3\u3092\u8ffd\u52a0",
    "Add institution": "\u6a5f\u95a2\u3092\u8ffd\u52a0\u3059\u308b",
    "Add member": "\u30e1\u30f3\u30d0\u3092\u8ffd\u52a0",
    "Add members": "\u30e1\u30f3\u30d0\u3092\u8ffd\u52a0",
    "Add new notification": "\u65b0\u898f\u901a\u77e5\u3092\u8ffd\u52a0",
    "Add option": "\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u8ffd\u52a0",
    "Add option: %s": "\u9078\u629e\u80a2\u3092\u8ffd\u52a0 %s",
    "Add page": "\u30da\u30fc\u30b8\u3092\u8ffd\u52a0",
    "Add page above": "\u4e0a\u306b\u30da\u30fc\u30b8\u3092\u8ffd\u52a0",
    "Add page below": "\u4e0b\u306b\u30da\u30fc\u30b8\u3092\u8ffd\u52a0",
    "Add page inside": "\u5185\u5074\u306b\u30da\u30fc\u30b8\u3092\u8ffd\u52a0",
    "Add password protection": "\u30d1\u30b9\u30ef\u30fc\u30c9\u4fdd\u8b77\u3092\u8ffd\u52a0",
    "Add permission": "\u6a29\u9650\u3092\u8ffd\u52a0",
    "Add sort": "\u4e26\u3079\u66ff\u3048\u3092\u8ffd\u52a0",
    "Add sub-department": "\u30b5\u30d6\u30c7\u30d1\u30fc\u30c8\u30e1\u30f3\u30c8\u3092\u8ffd\u52a0",
    "Add tag": "\u30bf\u30b0\u3092\u8ffd\u52a0",
    "Add to groups": "\u30b0\u30eb\u30fc\u30d7\u306b\u8ffd\u52a0",
    "Add user": "\u30e6\u30fc\u30b6\u306e\u8ffd\u52a0",
    "Add view": "\u30d3\u30e5\u30fc\u3092\u8ffd\u52a0",
    "Added": "\u8ffd\u52a0",
    "Added a new comment in document {sdoc_link}:": "\u30e6\u30fc\u30b6\u304c\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8 {sdoc_link} \u306b\u65b0\u3057\u3044\u30b3\u30e1\u30f3\u30c8\u3092\u8ffd\u52a0",
    "Added a new reply in document {sdoc_link}:": "\u30e6\u30fc\u30b6\u304c\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8 {sdoc_link} \u306b\u65b0\u3057\u3044\u8fd4\u4fe1\u3092\u8ffd\u52a0",
    "Added user {user}": "\u30e6\u30fc\u30b6{user}\u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f",
    "Added user {user} to group {group}": "\u30e6\u30fc\u30b6{user}\u3092\u30b0\u30eb\u30fc\u30d7{group}\u306b\u8ffd\u52a0\u3057\u307e\u3057\u305f",
    "Address": "\u4f4f\u6240",
    "Admin": "\u7ba1\u7406",
    "Admin Login Logs": "\u7ba1\u7406\u30ed\u30b0\u30a4\u30f3\u30ed\u30b0",
    "Admin Logs": "\u7ba1\u7406\u8005\u30ed\u30b0",
    "Admin Operation Logs": "\u7ba1\u7406\u64cd\u4f5c\u30ed\u30b0",
    "Admin access": "\u7ba1\u7406\u8005\u30a2\u30af\u30bb\u30b9",
    "Admin updated": "\u7ba1\u7406\u8005\u6a29\u9650\u3092\u8a2d\u5b9a\u3057\u307e\u3057\u305f\u3002",
    "Admins": "\u7ba1\u7406\u8005\u4e00\u89a7",
    "Advanced": "\u9ad8\u5ea6\u306a\u8a2d\u5b9a",
    "After": "\u5f8c",
    "After enable extended properties for files, you can add different properties to files, like collaborators, file expiring time, file description. You can also create different views for files based extended properties.": "\u62e1\u5f35\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u6709\u52b9\u306b\u3059\u308b\u3068\u3001\u30d5\u30a1\u30a4\u30eb\u306b\u7570\u306a\u308b\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8ffd\u52a0\u3067\u304d\u307e\u3059\u3002",
    "After exceeding the traffic limit, the file download speed will be restricted.": "\u4ea4\u901a\u91cf\u5236\u9650\u3092\u8d85\u3048\u308b\u3068\u3001\u30d5\u30a1\u30a4\u30eb\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u901f\u5ea6\u304c\u5236\u9650\u3055\u308c\u307e\u3059\u3002",
    "All": "\u5168\u3066",
    "All Activities": "\u3059\u3079\u3066\u306e\u30a2\u30af\u30c6\u30a3\u30d3\u30c6\u30a3",
    "All Groups": "\u5168\u3066\u306e\u30b0\u30eb\u30fc\u30d7",
    "All Notifications": "\u5168\u3066\u306e\u901a\u77e5",
    "All Public Links": "\u5168\u3066\u306e\u516c\u958b\u30ea\u30f3\u30af",
    "All comments": "\u3059\u3079\u3066\u306e\u30b3\u30e1\u30f3\u30c8",
    "All files uploaded": "\u5168\u3066\u306e\u30d5\u30a1\u30a4\u30eb\u304c\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u6e08\u307f",
    "All tags": "\u3059\u3079\u3066\u306e\u30bf\u30b0",
    "Allow new registrations": "\u65b0\u898f\u767b\u9332\u3092\u8a31\u53ef",
    "Allow new user registrations. Uncheck this to prevent anyone from creating a new account.": "\u65b0\u898f\u30e6\u30fc\u30b6\u767b\u9332\u3092\u8a31\u53ef\u3057\u307e\u3059\u3002\u3053\u306e\u30c1\u30a7\u30c3\u30af\u3092\u5916\u3059\u3068\u3001\u8ab0\u3082\u65b0\u3057\u3044\u30a2\u30ab\u30a6\u30f3\u30c8\u3092\u4f5c\u6210\u3067\u304d\u306a\u304f\u306a\u308a\u307e\u3059\u3002",
    "Allow users to change library history settings": "\u30e6\u30fc\u30b6\u304c\u30e9\u30a4\u30d6\u30e9\u30ea\u5c65\u6b74\u8a2d\u5b9a\u3092\u5909\u66f4\u3067\u304d\u308b\u3088\u3046\u306b\u3059\u308b",
    "Allow users to clean library trash": "\u30e6\u30fc\u30b6\u304c\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u30b4\u30df\u7bb1\u3092\u7a7a\u306b\u3067\u304d\u308b\u3088\u3046\u306b\u3059\u308b",
    "Allow users to create encrypted libraries": "\u30e6\u30fc\u30b6\u304c\u6697\u53f7\u5316\u3055\u308c\u305f\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u4f5c\u6210\u3067\u304d\u308b\u3088\u3046\u306b\u3059\u308b",
    "An integer that is greater than 0 or equal to -2.": "0\u3088\u308a\u5927\u304d\u3044\u6574\u6570\u307e\u305f\u306f-2\u3068\u7b49\u3057\u3044\u6574\u6570",
    "An integer that is greater than or equal to 0.": "0\u4ee5\u4e0a\u306e\u6574\u6570\u3002",
    "An internal link is a link to a file or folder that can be accessed by users with read permission to the file or folder.": "\u5185\u90e8\u30ea\u30f3\u30af\u306f\u3001\u30d5\u30a1\u30a4\u30eb\u307e\u305f\u306f\u30d5\u30a9\u30eb\u30c0\u30fc\u3078\u306e\u8aad\u307f\u53d6\u308a\u30a2\u30af\u30bb\u30b9\u8a31\u53ef\u3092\u6301\u3064\u30e6\u30fc\u30b6\u304c\u30a2\u30af\u30bb\u30b9\u3067\u304d\u308b\u30d5\u30a1\u30a4\u30eb\u307e\u305f\u306f\u30d5\u30a9\u30eb\u30c0\u30fc\u3078\u306e\u30ea\u30f3\u30af\u3067\u3059\u3002",
    "And": "AND",
    "Anonymous User": "\u533f\u540d\u30e6\u30fc\u30b6",
    "Another property has this property type": "\u4ed6\u306e\u30d7\u30ed\u30d1\u30c6\u30a3\u304c\u3053\u306e\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u7a2e\u985e\u3092\u6301\u3063\u3066\u3044\u307e\u3059",
    "Another user is editing this file!": "\u4ed6\u306e\u30e6\u30fc\u30b6\u304c\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u7de8\u96c6\u3057\u3066\u3044\u307e\u3059\uff01",
    "Anyone with the link": "\u30ea\u30f3\u30af\u3092\u6301\u3064\u4eba",
    "App Name": "\u30a2\u30d7\u30ea\u540d",
    "Are you sure to change group {placeholder} to department ?": "\u30b0\u30eb\u30fc\u30d7 {placeholder} \u3092\u90e8\u9580\u306b\u5909\u66f4\u3057\u307e\u3059\u304b\uff1f",
    "Are you sure to delete": "\u524a\u9664\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b",
    "Are you sure to delete ": "\u672c\u5f53\u306b\u524a\u9664\u3057\u307e\u3059\u304b\uff1f",
    "Are you sure to delete this comment?": "\u3053\u306e\u30b3\u30e1\u30f3\u30c8\u3092\u524a\u9664\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f",
    "Are you sure to delete this reply?": "\u3053\u306e\u8fd4\u4fe1\u3092\u524a\u9664\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f",
    "Are you sure to revoke access of user {placeholder} ?": "\u30e6\u30fc\u30b6 {placeholder} \u306e\u30a2\u30af\u30bb\u30b9\u6a29\u3092\u53d6\u308a\u6d88\u3059\u304b\u3069\u3046\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
    "Are you sure you want to clean invalid share links?": "\u7121\u52b9\u306a\u5171\u6709\u30ea\u30f3\u30af\u3092\u30af\u30ea\u30fc\u30f3\u3057\u307e\u3059\u304b\uff1f",
    "Are you sure you want to clean invalid upload links?": "\u7121\u52b9\u306a\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u3092\u30af\u30ea\u30fc\u30f3\u3057\u307e\u3059\u304b\uff1f",
    "Are you sure you want to clear trash?": "\u30b4\u30df\u7bb1\u3092\u7a7a\u306b\u3057\u3066\u3088\u3044\u3067\u3057\u3087\u3046\u304b\uff1f",
    "Are you sure you want to delete": "\u672c\u5f53\u306b\u524a\u9664\u3057\u307e\u3059\u304b\uff1f",
    "Are you sure you want to delete WebDAV password?": "WebDAV\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f",
    "Are you sure you want to delete Wiki": "\u672c\u5f53\u306b Wiki \u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f",
    "Are you sure you want to delete the notification ?": "\u901a\u77e5\u3092\u524a\u9664\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f",
    "Are you sure you want to delete the selected share link(s) ?": "\u9078\u629e\u3057\u305f\u5171\u6709\u30ea\u30f3\u30af\u3092\u524a\u9664\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f",
    "Are you sure you want to delete the selected upload link(s) ?": "\u9078\u629e\u3057\u305f\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u3092\u524a\u9664\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f",
    "Are you sure you want to delete the selected user(s) ?": "\u9078\u629e\u3057\u305f\u30e6\u30fc\u30b6\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f",
    "Are you sure you want to delete the share link?": "\u5171\u6709\u30ea\u30f3\u30af\u3092\u524a\u9664\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f",
    "Are you sure you want to delete this option?": "\u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u524a\u9664\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f",
    "Are you sure you want to delete this page?": "\u3053\u306e\u9805\u76ee\u3092\u672c\u5f53\u306b\u524a\u9664\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b?",
    "Are you sure you want to delete {placeholder} ?": "\u672c\u5f53\u306b {placeholder} \u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f",
    "Are you sure you want to delete {placeholder} completely?": "\u672c\u5f53\u306b {placeholder} \u3092\u5b8c\u5168\u306b\u524a\u9664\u3057\u3066\u3088\u3044\u3067\u3057\u3087\u3046\u304b\uff1f",
    "Are you sure you want to disconnect?": "\u5207\u65ad\u3057\u307e\u3059\u304b\uff1f",
    "Are you sure you want to leave share Wiki": "\u672c\u5f53\u306b\u3053\u306e\u5171\u6709\u304b\u3089\u96e2\u8131\u3057\u307e\u3059\u304b\uff1f",
    "Are you sure you want to remove {placeholder} ?": "{placeholder}\u3092\u524a\u9664\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f",
    "Are you sure you want to reset the password of {placeholder} ?": "\u30e6\u30fc\u30b6\u30fc{placeholder}\u306e\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u30ea\u30bb\u30c3\u30c8\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f",
    "Are you sure you want to restore this library?": "\u3053\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u672c\u5f53\u306b\u5fa9\u5143\u3057\u307e\u3059\u304b\uff1f",
    "Are you sure you want to restore {placeholder}?": "\u672c\u5f53\u306b {placeholder} \u3092\u5fa9\u5143\u3057\u3066\u3088\u3044\u3067\u3057\u3087\u3046\u304b\uff1f",
    "Are you sure you want to revoke the admin permission of {placeholder} ?": "\u30e6\u30fc\u30b6\u30fc{placeholder}\u306e\u7ba1\u7406\u8005\u6a29\u9650\u3092\u53d6\u308a\u6d88\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f",
    "Are you sure you want to set {placeholder} as Admin?": "\u30e6\u30fc\u30b6\u30fc{placeholder}\u3092\u7ba1\u7406\u8005\u306b\u8a2d\u5b9a\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f",
    "Are you sure you want to set {user_placeholder} inactive?": "\u30e6\u30fc\u30b6 {user_placeholder} \u3092\u975e\u30a2\u30af\u30c6\u30a3\u30d6\u306b\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f",
    "Are you sure you want to unlink this device?": "\u3053\u306e\u30c7\u30d0\u30a4\u30b9\u306e\u30ea\u30f3\u30af\u3092\u89e3\u9664\u3057\u307e\u3059\u304b\uff1f",
    "Are you sure you want to unpublish Wiki": "\u672c\u5f53\u306b Wiki \u306e\u516c\u958b\u3092\u505c\u6b62\u3057\u307e\u3059\u304b\uff1f",
    "Are you sure you want to unshare {placeholder} ?": "\u30e9\u30a4\u30d6\u30e9\u30ea\u5171\u6709\u3092\u5916\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b {placeholder}\uff1f",
    "Ascending by count": "\u6570\u5024\u3067\u6607\u9806",
    "Ascending by creation time": "\u4f5c\u6210\u65e5\u6642\u3067\u6607\u9806",
    "Ascending by name": "\u540d\u524d\u3067\u6607\u9806",
    "Ascending by role": "\u30ed\u30fc\u30eb\u3067\u6607\u9806\u306b\u4e26\u3079\u308b",
    "Ascending by size": "\u30b5\u30a4\u30ba\u3067\u6607\u9806",
    "Ascending by space used": "\u4f7f\u7528\u5bb9\u91cf\u3067\u6607\u9806",
    "Ascending by time": "\u6642\u523b\u3067\u6607\u9806",
    "Ascending by visit count": "\u30a2\u30af\u30bb\u30b9\u6570\u3067\u6607\u9806",
    "At server": "\u30b5\u30fc\u30d0\u30fc",
    "Audio": "\u30aa\u30fc\u30c7\u30a3\u30aa",
    "Auth Token created": "Web API \u8a8d\u8a3c\u30c8\u30fc\u30af\u30f3\u304c\u4f5c\u6210\u3055\u308c\u307e\u3057\u305f",
    "Auth Token deleted": "Web API \u8a8d\u8a3c\u30c8\u30fc\u30af\u30f3\u304c\u524a\u9664\u3055\u308c\u307e\u3057\u305f",
    "Authenticated emails": "\u8a8d\u8a3c\u6e08\u307f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9",
    "Authenticated users": "\u8a8d\u8a3c\u6e08\u307f\u306e\u30e6\u30fc\u30b6",
    "Auto deletion": "\u81ea\u52d5\u524a\u9664",
    "Automatically delete files that are not modified within certain days:": "\u4e00\u5b9a\u671f\u9593\u66f4\u65b0\u3055\u308c\u306a\u3044\u30d5\u30a1\u30a4\u30eb\u3092\u81ea\u52d5\u524a\u9664\u3059\u308b:",
    "Avatar": "\u30d7\u30ed\u30d5\u30a3\u30fc\u30eb\u753b\u50cf",
    "Avatar updated": "\u30d7\u30ed\u30d5\u30a3\u30fc\u30eb\u753b\u50cf\u304c\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f",
    "Avatar:": "\u30d7\u30ed\u30d5\u30a3\u30fc\u30eb\u753b\u50cf:",
    "Back": "\u623b\u308b",
    "Basic": "\u57fa\u672c",
    "Before": "\u524d",
    "Bell Icon": "\u30d9\u30eb\u30a2\u30a4\u30b3\u30f3",
    "Besides Write permission, user can also share the library.": "\u66f8\u304d\u8fbc\u307f\u6a29\u9650\u306b\u52a0\u3048\u3066\u3001\u30e6\u30fc\u30b6\u306f\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u5171\u6709\u3059\u308b\u3053\u3068\u3082\u3067\u304d\u307e\u3059\u3002",
    "Billing": "\u8acb\u6c42",
    "Branding": "\u30d6\u30e9\u30f3\u30c7\u30a3\u30f3\u30b0",
    "Broken (please contact your administrator to fix this library)": "\u58ca\u308c\u3066\u3044\u307e\u3059\uff08\u7ba1\u7406\u8005\u306b\u9023\u7d61\u3057\u3066\u3001\u3053\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u4fee\u6b63\u3057\u3066\u304f\u3060\u3055\u3044\uff09",
    "Broken ({repo_id_placeholder})": "\u58ca\u308c\u305f ({repo_id_placeholder})",
    "By child tags count ascending": "\u5b50\u30bf\u30b0\u6570\u3067\u6607\u9806",
    "By child tags count descending": "\u5b50\u30bf\u30b0\u6570\u3067\u964d\u9806",
    "By day": "\u65e5\u5358\u4f4d",
    "By file count ascending": "\u30d5\u30a1\u30a4\u30eb\u6570\u3067\u6607\u9806",
    "By file count descending": "\u30d5\u30a1\u30a4\u30eb\u6570\u3067\u964d\u9806",
    "By month": "\u6708\u5358\u4f4d",
    "By name ascending": "\u540d\u524d\u306e\u6607\u9806",
    "By name descending": "\u540d\u524d\u306e\u964d\u9806",
    "By quarter": "\u56db\u534a\u671f\u5358\u4f4d",
    "By size ascending": "\u30b5\u30a4\u30ba\u306e\u6607\u9806",
    "By size descending": "\u30b5\u30a4\u30ba\u306e\u964d\u9806",
    "By tag name ascending": "\u30bf\u30b0\u540d\u3067\u6607\u9806",
    "By tag name descending": "\u30bf\u30b0\u540d\u3067\u964d\u9806",
    "By time ascending": "\u6642\u9593\u306e\u6607\u9806",
    "By time descending": "\u6642\u9593\u306e\u964d\u9806",
    "By week": "\u9031\u5358\u4f4d",
    "By year": "\u5e74\u5358\u4f4d",
    "Can not copy folder %(src)s to its subfolder %(des)s": "\u30d5\u30a9\u30eb\u30c0 %(src)s \u3092 %(des)s \u306e\u30b5\u30d6\u30d5\u30a9\u30eb\u30c0\u306b\u30b3\u30d4\u30fc\u3067\u304d\u307e\u305b\u3093",
    "Can not move folder %(src)s to its subfolder %(des)s": "\u30d5\u30a9\u30eb\u30c0 %(src)s \u3092 %(des)s \u306e\u30b5\u30d6\u30d5\u30a9\u30eb\u30c0\u306b\u79fb\u52d5\u3067\u304d\u307e\u305b\u3093",
    "Can only copy files that are in the same folder": "\u540c\u3058\u30d5\u30a9\u30eb\u30c0\u30fc\u5185\u306e\u30d5\u30a1\u30a4\u30eb\u306e\u307f\u3092\u30b3\u30d4\u30fc\u3067\u304d\u307e\u3059",
    "Can only download files that are in the same folder": "\u540c\u3058\u30d5\u30a9\u30eb\u30c0\u30fc\u5185\u306e\u30d5\u30a1\u30a4\u30eb\u306e\u307f\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3067\u304d\u307e\u3059",
    "Can only move files that are in the same folder": "\u540c\u3058\u30d5\u30a9\u30eb\u30c0\u30fc\u5185\u306e\u30d5\u30a1\u30a4\u30eb\u306e\u307f\u3092\u79fb\u52d5\u3067\u304d\u307e\u3059",
    "Cancel": "\u30ad\u30e3\u30f3\u30bb\u30eb",
    "Cancel All": "\u5168\u3066\u3092\u30ad\u30e3\u30f3\u30bb\u30eb",
    "Cannot move parent page to child page": "\u89aa\u30da\u30fc\u30b8\u3092\u5b50\u30da\u30fc\u30b8\u306b\u79fb\u52d5\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002",
    "Capture information": "\u64ae\u5f71\u60c5\u5831",
    "Capture time": "\u64ae\u5f71\u6642\u523b",
    "Card": "\u30ab\u30fc\u30c9",
    "Certificate": "\u8a3c\u660e\u66f8",
    "Change": "\u66f4\u65b0",
    "Change Password": "\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u5909\u66f4",
    "Change Password of Library {placeholder}": "\u30e9\u30a4\u30d6\u30e9\u30ea {placeholder} \u306e\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u5909\u66f4\u3059\u308b",
    "Change cover": "\u30b5\u30e0\u30cd\u30a4\u30eb\u3092\u5909\u66f4",
    "Change group to department": "\u30b0\u30eb\u30fc\u30d7\u3092\u90e8\u9580\u306b\u5909\u66f4",
    "Change to department": "\u30c1\u30fc\u30e0\u540d\u3092\u5909\u66f4",
    "Change view type": "\u30d3\u30e5\u30fc\u30bf\u30a4\u30d7\u3092\u5909\u66f4",
    "Changes": "\u5909\u66f4",
    "Checkbox": "\u30c1\u30a7\u30c3\u30af\u30dc\u30c3\u30af\u30b9",
    "Child tags count": "\u5b50\u30bf\u30b0\u6570",
    "Choose date": "\u65e5\u4ed8\u3092\u9078\u629e",
    "Clean": "\u7a7a\u306b\u3059\u308b",
    "Clean invalid share links": "\u7121\u52b9\u306a\u5171\u6709\u30ea\u30f3\u30af\u3092\u30af\u30ea\u30fc\u30f3\u3057\u307e\u3057\u305f\u3002",
    "Clean invalid upload links": "\u7121\u52b9\u306a\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u3092\u30af\u30ea\u30fc\u30f3\u3057\u307e\u3057\u305f\u3002",
    "Clean succeeded.": "\u304a\u305d\u3046\u3058\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f",
    "Cleaned trash": "\u30b4\u30df\u7bb1\u3092\u7a7a\u306b\u3057\u307e\u3057\u305f",
    "Clear": "\u30af\u30ea\u30a2",
    "Clear Trash": "\u30b4\u30df\u7bb1\u3092\u7a7a\u306b\u3059\u308b",
    "Clear files in trash and history\uff1a": "\u30b4\u30df\u7bb1\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u5c65\u6b74\u3092\u6d88\u53bb\u3059\u308b: ",
    "Clear search": "\u691c\u7d22\u3092\u30af\u30ea\u30a2",
    "Clear selected": "\u9078\u629e\u3092\u89e3\u9664",
    "Clients": "\u30af\u30e9\u30a4\u30a2\u30f3\u30c8",
    "Close": "\u9589\u3058\u308b",
    "Close (Esc)": "\u9589\u3058\u308b (Esc)",
    "Close the panel": "\u30d1\u30cd\u30eb\u3092\u9589\u3058\u308b",
    "Code": "\u30b3\u30fc\u30c9",
    "Collaborator": "\u5171\u540c\u4f5c\u6210\u8005",
    "Collaborators": "\u5171\u540c\u4f5c\u6210\u8005",
    "Collapse all": "\u3059\u3079\u3066\u6298\u308a\u305f\u305f\u3080",
    "Collected time": "\u53ce\u96c6\u65e5\u6642",
    "Color": "\u8272",
    "Color space": "\u30ab\u30e9\u30fc\u30b9\u30da\u30fc\u30b9",
    "Comma (1,000,000)": "\u30ab\u30f3\u30de\u533a\u5207\u308a (1,000,000)",
    "Comma(1,03)": "\u30ab\u30f3\u30de\u533a\u5207\u308a (1,03)",
    "Comment": "\u30b3\u30e1\u30f3\u30c8",
    "Comment details": "\u30b3\u30e1\u30f3\u30c8\u306e\u8a73\u7d30",
    "Comments": "\u30b3\u30e1\u30f3\u30c8",
    "Community Edition": "\u30b3\u30df\u30e5\u30cb\u30c6\u30a3\u30a8\u30c7\u30a3\u30b7\u30e7\u30f3",
    "Compressed": "\u5727\u7e2e\u6e08\u307f",
    "Configure Seafile": "Seafile\u3092\u8a2d\u5b9a\u3059\u308b",
    "Configure your Identity Provider": "Identity Provider\u3092\u8a2d\u5b9a\u3059\u308b",
    "Confirm": "\u78ba\u8a8d",
    "Confirm Password": "\u30d1\u30b9\u30ef\u30fc\u30c9\u78ba\u8a8d",
    "Confirm password": "\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u78ba\u8a8d",
    "Confluence export file": "Confluence\u5f62\u5f0f\u30d5\u30a1\u30a4\u30eb",
    "Confluence file imported": "Confluence\u30d5\u30a1\u30a4\u30eb\u3092\u53d6\u308a\u8fbc\u307f\u307e\u3057\u305f",
    "Confluence imported": "Confluence \u304c\u30a4\u30f3\u30dd\u30fc\u30c8\u3055\u308c\u307e\u3057\u305f\u3002",
    "Connect": "\u63a5\u7d9a",
    "Contact Email": "\u9023\u7d61\u5148\u30e1\u30fc\u30eb",
    "Contact Email:": "\u9023\u7d61\u5148\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9:",
    "Contact Information": "\u9023\u7d61\u5148",
    "Contact email": "\u9023\u7d61\u5148\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9",
    "Contact information is required.": "\u9023\u7d61\u5148\u304c\u5fc5\u8981\u3067\u3059",
    "Content Scan Records": "\u30b3\u30f3\u30c6\u30f3\u30c4\u30b9\u30ad\u30e3\u30f3\u8a18\u9332",
    "Convert & Export": "\u5909\u63db\u3057\u3066\u30a8\u30af\u30b9\u30dd\u30fc\u30c8",
    "Convert Wiki": "Wiki \u3092\u5909\u63db",
    "Convert to Markdown": "Markdown\u306b\u5909\u63db",
    "Convert to docx": "docx\u306b\u5909\u63db",
    "Convert to new Wiki": "\u65b0\u3057\u3044 Wiki \u306b\u5909\u63db",
    "Convert to sdoc": "sdoc\u306b\u5909\u63db",
    "Convert with ONLYOFFICE": "ONLYOFFICE\u3067\u5909\u63db",
    "Converting": "\u5909\u63db\u4e2d",
    "Converting, please wait...": "\u5909\u63db\u4e2d\u3067\u3059\u3002\u3057\u3070\u3089\u304f\u304a\u5f85\u3061\u304f\u3060\u3055\u3044\u3002",
    "Converting...": "\u5909\u63db\u4e2d...",
    "Copied": "\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3057\u305f",
    "Copied link to clipboard": "\u30ea\u30f3\u30af\u304c\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3057\u305f\u3002",
    "Copy": "\u30b3\u30d4\u30fc",
    "Copy failed": "\u30b3\u30d4\u30fc\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Copy link": "\u30ea\u30f3\u30af\u3092\u30b3\u30d4\u30fc",
    "Copy path": "\u30d1\u30b9\u3092\u30b3\u30d4\u30fc",
    "Copy selected": "\u9078\u629e\u3057\u305f\u9805\u76ee\u3092\u30b3\u30d4\u30fc",
    "Copy selected item(s) to:": "\u9078\u629e\u3055\u308c\u305f\u9805\u76ee\u306e\u30b3\u30d4\u30fc\u5148: ",
    "Copy the IdP's certificate and paste it here. The certificate format is as follows:": "IdP\u306e\u8a3c\u660e\u66f8\u3092\u30b3\u30d4\u30fc\u3057\u3066\u3053\u3053\u306b\u8cbc\u308a\u4ed8\u3051\u3066\u304f\u3060\u3055\u3044\u3002\u8a3c\u660e\u66f8\u306e\u5f62\u5f0f\u306f\u6b21\u306e\u3068\u304a\u308a\u3067\u3059\uff1a",
    "Copy the domain DNS TXT and add it to your domain's DNS records, then click the button to verify domain ownership. You must verify the ownership of domain before Single Sign-On.": "\u30c9\u30e1\u30a4\u30f3\u306e\u6240\u6709\u6a29\u3092\u78ba\u8a8d\u3059\u308b\u305f\u3081\u306b\u3001DNS TXT\u30ec\u30b3\u30fc\u30c9\u3092\u4f5c\u6210\u3057\u3066\u304f\u3060\u3055\u3044\u3002Single Sign-On\u3092\u4f7f\u7528\u3059\u308b\u306b\u306f\u3001\u30c9\u30e1\u30a4\u30f3\u306e\u6240\u6709\u6a29\u3092\u78ba\u8a8d\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002",
    "Copy {num} items": "{num}\u500b\u306e\u9805\u76ee\u3092\u30b3\u30d4\u30fc",
    "Copy {placeholder} to": "{placeholder} \u3092\u30b3\u30d4\u30fc",
    "Copyright Infringement": "\u8457\u4f5c\u6a29\u4fb5\u5bb3",
    "Count": "\u56de\u6570",
    "Cover": "\u30b5\u30e0\u30cd\u30a4\u30eb",
    "Cover photo set": "\u8868\u7d19\u5199\u771f\u304c\u8a2d\u5b9a\u3055\u308c\u307e\u3057\u305f",
    "Create": "\u4f5c\u6210",
    "Create At": "\u4f5c\u6210\u65e5",
    "Create Group": "\u30b0\u30eb\u30fc\u30d7\u3092\u4f5c\u6210",
    "Create Library": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u4f5c\u6210",
    "Create Report": "\u30ec\u30dd\u30fc\u30c8\u306e\u4f5c\u6210",
    "Create a DNS TXT record to confirm the ownership of your Email Domain.": "Email\u30c9\u30e1\u30a4\u30f3\u306e\u6240\u6709\u6a29\u3092\u78ba\u8a8d\u3059\u308b\u305f\u3081\u306b\u3001DNS TXT\u30ec\u30b3\u30fc\u30c9\u3092\u4f5c\u6210\u3057\u3066\u304f\u3060\u3055\u3044",
    "Create a new tag": "\u65b0\u3057\u3044\u30bf\u30b0\u3092\u4f5c\u6210",
    "Create time": "\u4f5c\u6210\u65e5\u6642",
    "Create top department": "\u6700\u4e0a\u4f4d\u90e8\u9580\u3092\u4f5c\u6210",
    "Created": "\u4f5c\u6210\u65e5\u6642",
    "Created At": "\u4f5c\u6210\u65e5",
    "Created Files": "\u4f5c\u6210\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb",
    "Created draft": "\u30c9\u30e9\u30d5\u30c8\u3092\u4f5c\u6210\u3057\u307e\u3057\u305f",
    "Created file": "\u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210\u3057\u307e\u3057\u305f",
    "Created folder": "\u30d5\u30a9\u30eb\u30c0\u3092\u4f5c\u6210\u3057\u307e\u3057\u305f",
    "Created group {group_name}": "\u30b0\u30eb\u30fc\u30d7{group_name}\u3092\u4f5c\u6210\u3057\u307e\u3057\u305f",
    "Created library": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u4f5c\u6210\u3057\u307e\u3057\u305f",
    "Created library {library_name} with {owner} as its owner": "{owner}\u3092\u6240\u6709\u8005\u3068\u3057\u3066\u3001\u30e9\u30a4\u30d6\u30e9\u30ea{library_name}\u3092\u4f5c\u6210\u3057\u307e\u3057\u305f",
    "Created time": "\u4f5c\u6210\u65e5\u6642",
    "Created {n} files": "{n} \u500b\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210\u3057\u307e\u3057\u305f",
    "Creator": "\u4f5c\u6210\u8005",
    "Currency symbol is required": "\u901a\u8ca8\u8a18\u53f7\u304c\u5fc5\u8981\u3067\u3059",
    "Current Connected Devices": "\u73fe\u5728\u63a5\u7d9a\u3055\u308c\u3066\u3044\u308b\u30c7\u30d0\u30a4\u30b9\u6570",
    "Current Library": "\u73fe\u5728\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u30fc",
    "Current Path: ": "\u73fe\u5728\u306e\u30d5\u30a1\u30a4\u30eb\u30d1\u30b9\uff1a",
    "Current Version": "\u73fe\u5728\u306e\u30d0\u30fc\u30b8\u30e7\u30f3",
    "Current page": "\u73fe\u5728\u306e\u30da\u30fc\u30b8",
    "Current password": "\u73fe\u5728\u306e\u30d1\u30b9\u30ef\u30fc\u30c9",
    "Current password cannot be blank": "\u73fe\u5728\u306e\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u7a7a\u6b04\u306b\u3067\u304d\u307e\u305b\u3093",
    "Current path: ": "\u73fe\u5728\u306e\u30d1\u30b9\uff1a",
    "Custom CSS": "\u30ab\u30b9\u30bf\u30e0CSS",
    "Custom currency": "\u30ab\u30b9\u30bf\u30e0\u901a\u8ca8",
    "Custom properties": "\u30ab\u30b9\u30bf\u30e0\u30d7\u30ed\u30d1\u30c6\u30a3",
    "Custom sharing permissions": "\u5171\u6709\u30d1\u30fc\u30df\u30c3\u30b7\u30e7\u30f3\u3092\u30ab\u30b9\u30bf\u30de\u30a4\u30ba",
    "Custom symbol": "\u30ab\u30b9\u30bf\u30e0\u901a\u8ca8\u8a18\u53f7",
    "Custom time": "\u30ab\u30b9\u30bf\u30e0\u6642\u9593",
    "Customer Portal": "\u9867\u5ba2\u30dd\u30fc\u30bf\u30eb",
    "Customize URL": "URL\u3092\u30ab\u30b9\u30bf\u30de\u30a4\u30ba",
    "DNS TXT Value": "DNS TXT\u5024",
    "Dark mode": "\u30c0\u30fc\u30af\u30e2\u30fc\u30c9",
    "Date": "\u65e5\u4ed8",
    "Date Invalid.": "\u65e5\u4ed8\u304c\u7121\u52b9",
    "Day": "\u65e5",
    "Decimal separator": "\u5c0f\u6570\u70b9\u533a\u5207\u308a",
    "Decrypt document": "\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u3092\u5fa9\u53f7\u5316",
    "Default": "\u65e2\u5b9a",
    "Delete": "\u524a\u9664",
    "Delete Account": "\u30a2\u30ab\u30a6\u30f3\u30c8\u3092\u524a\u9664",
    "Delete Department": "\u90e8\u9580\u3092\u524a\u9664",
    "Delete Expired Invitations": "\u6709\u52b9\u671f\u9650\u5207\u308c\u306e\u62db\u5f85\u3092\u524a\u9664\u3057\u307e\u3057\u305f\u3002",
    "Delete File": "\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664",
    "Delete Folder": "\u30d5\u30a9\u30eb\u30c0\u3092\u524a\u9664",
    "Delete Group": "\u30b0\u30eb\u30fc\u30d7\u3092\u524a\u9664",
    "Delete Institution": "\u7d44\u7e54\u3092\u524a\u9664\u3057\u307e\u3057\u305f\u3002",
    "Delete Library": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u524a\u9664",
    "Delete Member": "\u30e1\u30f3\u30d0\u3092\u524a\u9664",
    "Delete Notification": "\u901a\u77e5\u306e\u524a\u9664",
    "Delete Organization": "\u7d44\u7e54\u3092\u524a\u9664\u3057\u307e\u3057\u305f\u3002",
    "Delete Password": "\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u524a\u9664",
    "Delete T&C": "\u5229\u7528\u898f\u7d04\u3092\u524a\u9664",
    "Delete Team": "\u30c1\u30fc\u30e0\u3092\u524a\u9664",
    "Delete User": "\u30e6\u30fc\u30b6\u524a\u9664",
    "Delete User from Group": "\u30e6\u30fc\u30b6\u3092\u30b0\u30eb\u30fc\u30d7\u304b\u3089\u524a\u9664",
    "Delete Users": "\u30e6\u30fc\u30b6\u3092\u524a\u9664",
    "Delete WebDAV Password": "WebDAV\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u524a\u9664",
    "Delete Wiki": "Wiki \u3092\u524a\u9664",
    "Delete department": "\u90e8\u9580\u3092\u524a\u9664",
    "Delete file": "\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664",
    "Delete files from this device the next time it comes online.": "\u6b21\u56de\u306e\u30aa\u30f3\u30e9\u30a4\u30f3\u306e\u969b\u306b\u524a\u9664\u3055\u308c\u307e\u3059",
    "Delete folder": "\u30d5\u30a9\u30eb\u30c0\u3092\u524a\u9664",
    "Delete group": "\u30b0\u30eb\u30fc\u30d7\u3092\u524a\u9664",
    "Delete location": "\u4f4d\u7f6e\u60c5\u5831\u3092\u524a\u9664",
    "Delete member": "\u30e1\u30f3\u30d0\u3092\u524a\u9664",
    "Delete page": "\u30da\u30fc\u30b8\u3092\u524a\u9664",
    "Delete property": "\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u524a\u9664",
    "Delete selected": "\u9078\u629e\u3057\u305f\u9805\u76ee\u3092\u524a\u9664",
    "Delete share link": "\u5171\u6709\u30ea\u30f3\u30af\u3092\u524a\u9664",
    "Delete share links": "\u5171\u6709\u30ea\u30f3\u30af\u3092\u524a\u9664",
    "Delete tag": "\u30bf\u30b0\u306e\u524a\u9664",
    "Delete tags": "\u30bf\u30b0\u306e\u524a\u9664",
    "Delete upload links": "\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u3092\u524a\u9664",
    "Deleted": "\u524a\u9664",
    "Deleted Libraries": "\u524a\u9664\u6e08\u307f\u30e9\u30a4\u30d6\u30e9\u30ea",
    "Deleted Time": "\u524a\u9664\u65e5\u6642",
    "Deleted by": "\u524a\u9664\u8005",
    "Deleted directories": "\u524a\u9664\u3055\u308c\u305f\u30d5\u30a9\u30eb\u30c0",
    "Deleted draft": "\u30c9\u30e9\u30d5\u30c8\u3092\u524a\u9664\u3057\u307e\u3057\u305f",
    "Deleted file": "\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3057\u307e\u3057\u305f",
    "Deleted files": "\u524a\u9664\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb",
    "Deleted folder": "\u30d5\u30a9\u30eb\u30c0\u3092\u524a\u9664\u3057\u307e\u3057\u305f",
    "Deleted group {group_name}": "\u30b0\u30eb\u30fc\u30d7{group_name}\u3092\u524a\u9664\u3057\u307e\u3057\u305f",
    "Deleted library": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u524a\u9664\u3057\u307e\u3057\u305f",
    "Deleted library {library_name}": "\u30e9\u30a4\u30d6\u30e9\u30ea{library_name}\u3092\u524a\u9664\u3057\u307e\u3057\u305f",
    "Deleted option": "\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u524a\u9664\u3057\u307e\u3057\u305f",
    "Deleted time": "\u524a\u9664\u65e5\u6642",
    "Deleted user %s": "\u30e6\u30fc\u30b6%s\u3092\u524a\u9664\u3057\u307e\u3057\u305f",
    "Deleted user {user}": "\u30e6\u30fc\u30b6{user}\u3092\u524a\u9664\u3057\u307e\u3057\u305f",
    "Deleted user {user} from group {group}": "\u30e6\u30fc\u30b6{user}\u3092\u30b0\u30eb\u30fc\u30d7{group}\u304b\u3089\u524a\u9664\u3057\u307e\u3057\u305f",
    "Department ID": "\u30c7\u30d1\u30fc\u30c8\u30e1\u30f3\u30c8ID",
    "Department moved successfully": "\u90e8\u9580\u304c\u6b63\u5e38\u306b\u79fb\u52d5\u3057\u307e\u3057\u305f",
    "Department not found": "\u90e8\u9580\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093",
    "Department renamed": "\u90e8\u9580\u540d\u304c\u5909\u66f4\u3055\u308c\u307e\u3057\u305f",
    "Departments": "\u90e8\u9580",
    "Descending by count": "\u6570\u5024\u3067\u964d\u9806",
    "Descending by creation time": "\u4f5c\u6210\u65e5\u6642\u3067\u964d\u9806",
    "Descending by files": "\u30d5\u30a1\u30a4\u30eb\u3067\u964d\u9806\u306b\u4e26\u3079\u308b",
    "Descending by name": "\u540d\u524d\u3067\u964d\u9806",
    "Descending by role": "\u30ed\u30fc\u30eb\u3067\u964d\u9806\u306b\u4e26\u3079\u308b",
    "Descending by size": "\u30b5\u30a4\u30ba\u3067\u964d\u9806",
    "Descending by space used": "\u4f7f\u7528\u5bb9\u91cf\u3067\u964d\u9806",
    "Descending by time": "\u6642\u523b\u3067\u964d\u9806",
    "Descending by visit count": "\u30a2\u30af\u30bb\u30b9\u6570\u3067\u964d\u9806",
    "Description": "\u8aac\u660e",
    "Description generated": "\u8aac\u660e\u304c\u751f\u6210\u3055\u308c\u307e\u3057\u305f",
    "Description is required": "\u8aac\u660e\u306f\u5fc5\u9808\u9805\u76ee\u3067\u3059",
    "Desktop": "\u30c7\u30b9\u30af\u30c8\u30c3\u30d7",
    "Detail": "\u8a73\u7d30",
    "Details": "\u8a73\u7d30",
    "Detect faces": "\u9854\u3092\u691c\u51fa",
    "Detecting faces by AI...": "AI\u306b\u3088\u308b\u9854\u691c\u51fa\u4e2d...",
    "Device": "\u7aef\u672b",
    "Device Name": "\u30c7\u30d0\u30a4\u30b9\u540d",
    "Device make": "\u30c7\u30d0\u30a4\u30b9\u30e1\u30fc\u30ab\u30fc",
    "Device model": "\u30c7\u30d0\u30a4\u30b9\u30e2\u30c7\u30eb",
    "Devices": "\u30c7\u30d0\u30a4\u30b9",
    "Diagram": "\u56f3\u8868",
    "Dimensions": "\u5bf8\u6cd5",
    "Direct download link": "\u76f4\u63a5\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u30ea\u30f3\u30af",
    "Direct download link is copied to the clipboard.": "\u76f4\u63a5\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u304c\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3059",
    "Disable SSO user email / password login": "SSO\u30e6\u30fc\u30b6\u30fc\u306e\u30e1\u30fc\u30eb/\u30d1\u30b9\u30ef\u30fc\u30c9\u30ed\u30b0\u30a4\u30f3\u3092\u7121\u52b9\u306b\u3059\u308b",
    "Disable Two-Factor Authentication": "2\u6bb5\u968e\u8a8d\u8a3c\u3092\u7121\u52b9\u306b\u3059\u308b",
    "Disable sync with any folder": "\u4efb\u610f\u306e\u30d5\u30a9\u30eb\u30c0\u3068\u306e\u540c\u671f\u3092\u7121\u52b9\u306b\u3059\u308b",
    "Disable user clean trash": "\u30e6\u30fc\u30b6\u306e\u30b4\u30df\u7bb1\u306e\u30af\u30ea\u30fc\u30f3\u3092\u7121\u52b9\u306b\u3059\u308b",
    "Disconnect": "\u5207\u65ad",
    "Discussion": "\u63b2\u793a\u677f",
    "Display files": "\u30d5\u30a1\u30a4\u30eb\u3092\u8868\u793a",
    "Do not automatically delete files": "\u30d5\u30a1\u30a4\u30eb\u3092\u81ea\u52d5\u3067\u524a\u9664\u3057\u306a\u3044",
    "Do not keep sharing": "\u5171\u6709\u95a2\u4fc2\u3092\u4fdd\u6301\u3057\u306a\u3044",
    "Do you really want to turn off extended properties? Existing properties will all be deleted.": "\u62e1\u5f35\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u7121\u52b9\u306b\u3059\u308b\u3068\u3001\u30d5\u30a1\u30a4\u30eb\u306b\u8ffd\u52a0\u3055\u308c\u305f\u30d7\u30ed\u30d1\u30c6\u30a3\u304c\u3059\u3079\u3066\u524a\u9664\u3055\u308c\u307e\u3059\u3002",
    "Do you really want to turn off face recognition? Existing results will all be deleted.": "\u30d5\u30a7\u30fc\u30b9\u8a8d\u8b58\u3092\u7121\u52b9\u306b\u3059\u308b\u3068\u3001\u5199\u771f\u5185\u306e\u4eba\u7269\u3092\u8a8d\u8b58\u3067\u304d\u307e\u305b\u3093\u3002",
    "Do you really want to turn off tags? Existing tags will all be deleted.": "\u30bf\u30b0\u3092\u7121\u52b9\u306b\u3059\u308b\u3068\u3001\u30d5\u30a1\u30a4\u30eb\u306b\u8ffd\u52a0\u3055\u308c\u305f\u30bf\u30b0\u304c\u3059\u3079\u3066\u524a\u9664\u3055\u308c\u307e\u3059\u3002",
    "Do you want to keep the library sharing relationships?": "\u30e9\u30a4\u30d6\u30e9\u30ea\u5171\u6709\u95a2\u4fc2\u3092\u4fdd\u6301\u3057\u307e\u3059\u304b\uff1f",
    "Document": "\u6587\u66f8",
    "Document conversion failed.": "\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u306e\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Document keywords": "\u6587\u66f8\u306e\u30ad\u30fc\u30ef\u30fc\u30c9",
    "Dollar": "\u30c9\u30eb",
    "Domain verified": "\u30c9\u30e1\u30a4\u30f3\u304c\u8a8d\u8a3c\u3055\u308c\u307e\u3057\u305f",
    "Don't ignore": "\u7121\u8996\u3057\u306a\u3044",
    "Don't keep history": "\u5c65\u6b74\u3092\u4fdd\u5b58\u3057\u306a\u3044",
    "Don't replace": "\u7f6e\u304d\u63db\u3048\u306a\u3044",
    "Don't send emails": "\u30e1\u30fc\u30eb\u901a\u77e5\u3092\u9001\u4fe1\u3057\u306a\u3044",
    "Don't show empty values": "\u7a7a\u306e\u5024\u3092\u8868\u793a\u3057\u306a\u3044",
    "Done": "\u5b8c\u4e86",
    "Dot(1.03)": "\u30c9\u30c3\u30c8\u533a\u5207\u308a (1.03)",
    "Down": "\u4e0b",
    "Download": "\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9",
    "Download Rate Limit": "\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u901f\u5ea6\u5236\u9650",
    "Download an example file": "\u30b5\u30f3\u30d7\u30eb\u30d5\u30a1\u30a4\u30eb\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9",
    "Download and upload": "\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3068\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9",
    "Drag and drop files or folders here.": "\u30d5\u30a1\u30a4\u30eb\u307e\u305f\u306f\u30d5\u30a9\u30eb\u30c0\u3092\u3053\u3053\u306b\u30c9\u30e9\u30c3\u30b0\u30a2\u30f3\u30c9\u30c9\u30ed\u30c3\u30d7\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
    "Duplicate": "\u8907\u88fd",
    "Duplicate page": "\u30da\u30fc\u30b8\u3092\u8907\u88fd",
    "Edit": "\u7de8\u96c6",
    "Edit format settings": "\u66f8\u5f0f\u8a2d\u5b9a\u3092\u7de8\u96c6",
    "Edit labels": "\u30e9\u30d9\u30eb\u3092\u7de8\u96c6",
    "Edit metadata properties": "\u30e1\u30bf\u30c7\u30fc\u30bf\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u7de8\u96c6",
    "Edit multiple select": "\u8907\u6570\u9078\u629e\u3092\u7de8\u96c6",
    "Edit on cloud and download": "\u30af\u30e9\u30a6\u30c9\u4e0a\u3067\u7de8\u96c6\u3057\u3066\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9",
    "Edit on cloud only": "\u30af\u30e9\u30a6\u30c9\u4e0a\u3067\u306e\u307f\u7de8\u96c6",
    "Edit permission": "\u6a29\u9650\u3092\u7de8\u96c6",
    "Edit single select": "\u5358\u4e00\u9078\u629e\u3092\u7de8\u96c6",
    "Edit succeeded": "\u7de8\u96c6\u5b8c\u4e86",
    "Edit succeeded.": "\u7de8\u96c6\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002",
    "Edit tag": "\u30bf\u30b0\u306e\u7de8\u96c6",
    "Edit tags": "\u30bf\u30b0\u3092\u7de8\u96c6",
    "Email": "\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9",
    "Email Domain": "Email\u30c9\u30e1\u30a4\u30f3",
    "Email Notification": "\u30e1\u30fc\u30eb\u901a\u77e5",
    "Email is invalid.": "\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304c\u7121\u52b9\u3067\u3059",
    "Email notification updated": "\u30e1\u30fc\u30eb\u901a\u77e5\u304c\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f",
    "Emails": "\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9",
    "Emails, separated by ','": "\u30ab\u30f3\u30de\u533a\u5207\u308a\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9",
    "Emojis": "\u7d75\u6587\u5b57",
    "Empty": "\u7a7a",
    "Enable Two-Factor Authentication": "2\u6bb5\u968e\u8a8d\u8a3c\u3092\u6709\u52b9\u306b\u3059\u308b",
    "Enable branding CSS": "\u30d6\u30e9\u30f3\u30c7\u30a3\u30f3\u30b0\u7528CSS\u3092\u6709\u52b9\u306b\u3059\u308b",
    "Enable departments feature": "\u30c7\u30d1\u30fc\u30c8\u30e1\u30f3\u30c8\u6a5f\u80fd\u3092\u6709\u52b9\u306b\u3059\u308b",
    "Enable extended properties": "\u62e1\u5f35\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u6709\u52b9\u306b\u3059\u308b",
    "Enable face recognition to identify people in your photos.": "\u30d5\u30a7\u30fc\u30b9\u8a8d\u8b58\u3092\u6709\u52b9\u306b\u3059\u308b\u3068\u3001\u5199\u771f\u5185\u306e\u4eba\u7269\u3092\u8a8d\u8b58\u3067\u304d\u307e\u3059\u3002",
    "Enable system admin to add Terms and Conditions, and all users will have to accept the terms.": "\u30b7\u30b9\u30c6\u30e0\u7ba1\u7406\u8005\u304c\u5229\u7528\u898f\u7d04\u3092\u8ffd\u52a0\u3067\u304d\u308b\u3088\u3046\u306b\u3057\u3001\u3059\u3079\u3066\u306e\u30e6\u30fc\u30b6\u304c\u305d\u306e\u898f\u7d04\u3092\u627f\u8a8d\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002",
    "Enable tags to add tags to files and search files by tags.": "\u30bf\u30b0\u3092\u6709\u52b9\u306b\u3059\u308b\u3068\u3001\u30d5\u30a1\u30a4\u30eb\u306b\u30bf\u30b0\u3092\u8ffd\u52a0\u3057\u3001\u30bf\u30b0\u3067\u30d5\u30a1\u30a4\u30eb\u3092\u691c\u7d22\u3067\u304d\u307e\u3059\u3002",
    "Enable terms and conditions": "\u5229\u7528\u898f\u7d04\u3092\u6709\u52b9\u306b\u3059\u308b",
    "Enable two factor authentication": "2\u8981\u7d20\u8a8d\u8a3c\u3092\u6709\u52b9\u306b\u3059\u308b",
    "Enable users to clean trash": "\u30e6\u30fc\u30b6\u304c\u30b4\u30df\u7bb1\u3092\u7a7a\u306b\u3067\u304d\u308b\u3088\u3046\u306b\u3059\u308b",
    "Enable users to share libraries to any groups in the system.": "\u30e6\u30fc\u30b6\u304c\u30b7\u30b9\u30c6\u30e0\u5185\u306e\u4efb\u610f\u306e\u30b0\u30eb\u30fc\u30d7\u306b\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u5171\u6709\u3067\u304d\u308b\u3088\u3046\u306b\u3059\u308b\u3002",
    "Enable\u00a0sharing\u00a0to\u00a0all\u00a0groups": "\u3059\u3079\u3066\u306e\u30b0\u30eb\u30fc\u30d7\u3078\u306e\u5171\u6709\u3092\u6709\u52b9\u5316",
    "Encrypt": "\u6697\u53f7\u5316",
    "Encrypted library": "\u6697\u53f7\u5316\u30e9\u30a4\u30d6\u30e9\u30ea",
    "End date": "\u7d42\u4e86\u65e5",
    "Enforce precision": "\u7cbe\u5ea6\u3092\u5f37\u5236",
    "Enter characters to start searching": "\u691c\u7d22\u3092\u958b\u59cb\u3059\u308b\u306b\u306f\u6587\u5b57\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044",
    "Enter custom currency symbol": "\u30ab\u30b9\u30bf\u30e0\u901a\u8ca8\u8a18\u53f7\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044",
    "Enter date": "\u65e5\u4ed8\u3092\u5165\u529b",
    "Error": "\u30a8\u30e9\u30fc",
    "Errors": "\u30a8\u30e9\u30fc",
    "Euro": "\u30e6\u30fc\u30ed",
    "European": "\u6b27\u5dde\u5f62\u5f0f",
    "Exact date": "\u6b63\u78ba\u306a\u65e5\u4ed8",
    "Exit Institution Admin": "\u6a5f\u95a2\u7ba1\u7406\u304b\u3089\u79fb\u52d5\u3059\u308b",
    "Exit Organization Admin": "\u7d44\u7e54\u7ba1\u7406\u304b\u3089\u79fb\u52d5\u3059\u308b",
    "Exit System Admin": "\u30b7\u30b9\u30c6\u30e0\u7ba1\u7406\u304b\u3089\u79fb\u52d5\u3059\u308b",
    "Expand all": "\u3059\u3079\u3066\u5c55\u958b",
    "Expiration": "\u6709\u52b9\u671f\u9650",
    "Expiration date": "\u6709\u52b9\u671f\u9650",
    "Expiration days": "\u6709\u52b9\u671f\u9650",
    "Expiration time": "\u6709\u52b9\u6642\u9593",
    "Expired": "\u671f\u9650\u5207\u308c",
    "Expired at": "\u6709\u52b9\u671f\u9650",
    "Export": "\u30a8\u30af\u30b9\u30dd\u30fc\u30c8",
    "Export Excel": "Excel\u30d5\u30a1\u30a4\u30eb\u3092\u30a8\u30af\u30b9\u30dd\u30fc\u30c8",
    "Export as Markdown": "Markdown \u5f62\u5f0f\u3067\u30a8\u30af\u30b9\u30dd\u30fc\u30c8",
    "Export as docx": "docx\u5f62\u5f0f\u3067\u30a8\u30af\u30b9\u30dd\u30fc\u30c8",
    "Export as sdoc": "sdoc \u5f62\u5f0f\u3067\u30a8\u30af\u30b9\u30dd\u30fc\u30c8",
    "Export as zip": "zip\u5f62\u5f0f\u3067\u30a8\u30af\u30b9\u30dd\u30fc\u30c8",
    "Export options": "\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u30a8\u30af\u30b9\u30dd\u30fc\u30c8",
    "Export tags": "\u30bf\u30b0\u306e\u30a8\u30af\u30b9\u30dd\u30fc\u30c8",
    "Exporting": "\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u4e2d",
    "Exporting...": "\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u4e2d...",
    "Exposure time": "\u9732\u51fa\u6642\u9593",
    "Extended properties": "\u62e1\u5f35\u30d7\u30ed\u30d1\u30c6\u30a3",
    "Extension Prompts": "\u62e1\u5f35\u30d7\u30ed\u30f3\u30d7\u30c8",
    "Extensions of text files that can be online previewed, each suffix is separated by a comma.": "\u30aa\u30f3\u30e9\u30a4\u30f3\u3067\u30d7\u30ec\u30d3\u30e5\u30fc\u53ef\u80fd\u306a\u30c6\u30ad\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u62e1\u5f35\u5b50\u3002\u5404\u62e1\u5f35\u5b50\u306f\u30ab\u30f3\u30de\u3067\u533a\u5207\u308a\u307e\u3059\u3002",
    "Extract file detail": "\u30d5\u30a1\u30a4\u30eb\u306e\u8a73\u7d30\u3092\u62bd\u51fa\u3059\u308b",
    "Extract file details": "\u30d5\u30a1\u30a4\u30eb\u8a73\u7d30\u3092\u62bd\u51fa",
    "Extract text": "\u30c6\u30ad\u30b9\u30c8\u3092\u62bd\u51fa\u3059\u308b",
    "Extracting file details by AI...": "AI\u306b\u3088\u308b\u30d5\u30a1\u30a4\u30eb\u8a73\u7d30\u306e\u62bd\u51fa\u4e2d...",
    "Extracting text, please wait...": "\u30c6\u30ad\u30b9\u30c8\u3092\u62bd\u51fa\u4e2d\u3067\u3059\u3002\u3057\u3070\u3089\u304f\u304a\u5f85\u3061\u304f\u3060\u3055\u3044...",
    "F number": "F\u6570",
    "Face recognition": "\u9854\u8a8d\u8b58",
    "Face recognition is done for library {libraryName}.": "\u30e9\u30a4\u30d6\u30e9\u30ea {libraryName} \u306e\u9854\u8a8d\u8b58\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002",
    "Faces detected": "\u9854\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f",
    "Failed": "\u5931\u6557",
    "Failed imported options": "\u30aa\u30d7\u30b7\u30e7\u30f3\u306e\u30a4\u30f3\u30dd\u30fc\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to add linked tags": "\u30ea\u30f3\u30af\u30bf\u30b0\u306e\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Failed to add people photos": "\u4eba\u7269\u306e\u5199\u771f\u306e\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to add tags": "\u30bf\u30b0\u306e\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Failed to add {email_placeholder}: {error_msg_placeholder}": "{email_placeholder}\u306e\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff1a{errorMsg_placeholder}",
    "Failed to convert {name}.": "{name}\u306e\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to copy %(name)s": "\u300c%(name)s\u300d\u306e\u30b3\u30d4\u30fc\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to copy %(name)s and %(amount)s other item(s).": "%(name)s \u306e\u307b\u304b%(amount)s\u9805\u76ee\u3092\u30b3\u30d4\u30fc\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002",
    "Failed to copy %(name)s.": "%(name)s \u306e\u30b3\u30d4\u30fc\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Failed to copy file": "\u30d5\u30a1\u30a4\u30eb\u306e\u30b3\u30d4\u30fc\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to copy files to another library.": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u30b3\u30d4\u30fc\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002",
    "Failed to copy {n} items": "\u30a2\u30a4\u30c6\u30e0\u306e\u30b3\u30d4\u30fc\u306b\u5931\u6557\u3057\u307e\u3057\u305f{n}",
    "Failed to delete %(virus_file) from library %(library): %(error_msg)": "\u30e9\u30a4\u30d6\u30e9\u30ea %(library) \u304b\u3089\u30a6\u30a4\u30eb\u30b9\u30d5\u30a1\u30a4\u30eb %(virus_file) \u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f: %(error_msg)",
    "Failed to delete linked tags": "\u30ea\u30f3\u30af\u30bf\u30b0\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Failed to delete property": "\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to delete records": "\u30ec\u30b3\u30fc\u30c9\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to delete tags": "\u30bf\u30b0\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Failed to delete {name}": "{name}\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to delete {name} and {n} other items.": "{name}\u3068{n}\u500b\u306e\u4ed6\u306e\u30a2\u30a4\u30c6\u30e0\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Failed to delete {name}.": "\u64cd\u4f5c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u5171\u6709\u30ea\u30f3\u30af\u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002",
    "Failed to detect faces": "\u9854\u691c\u51fa\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to download. The total size of the files exceeded the limit.": "\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30d5\u30a1\u30a4\u30eb\u306e\u5408\u8a08\u30b5\u30a4\u30ba\u304c\u5236\u9650\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002",
    "Failed to duplicate file": "\u30d5\u30a1\u30a4\u30eb\u306e\u8907\u88fd\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to duplicate folder": "\u30d5\u30a9\u30eb\u30c0\u306e\u8907\u88fd\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to duplicate page": "\u30da\u30fc\u30b8\u306e\u8907\u88fd\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Failed to export tags": "\u30bf\u30b0\u306e\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Failed to export. Please check whether the size of table attachments exceeds the limit.": "\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30c6\u30fc\u30d6\u30eb\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u306e\u30b5\u30a4\u30ba\u304c\u5236\u9650\u3092\u8d85\u3048\u3066\u3044\u306a\u3044\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
    "Failed to extract file details": "\u30d5\u30a1\u30a4\u30eb\u8a73\u7d30\u306e\u62bd\u51fa\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to extract text": "\u30c6\u30ad\u30b9\u30c8\u306e\u62bd\u51fa\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to generate description": "\u8aac\u660e\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to generate file tags": "\u30d5\u30a1\u30a4\u30eb\u30bf\u30b0\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to ignore %(virus_file) from library %(library): %(error_msg)": "\u30e9\u30a4\u30d6\u30e9\u30ea %(library) \u5185\u306e\u30a6\u30a4\u30eb\u30b9\u30d5\u30a1\u30a4\u30eb %(virus_file) \u3092\u7121\u8996\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f: %(error_msg)",
    "Failed to import Confluence": "Confluence \u306e\u30a4\u30f3\u30dd\u30fc\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Failed to import Confluence file": "Confluence\u30d5\u30a1\u30a4\u30eb\u306e\u53d6\u308a\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to import page": "\u30da\u30fc\u30b8\u306e\u30a4\u30f3\u30dd\u30fc\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Failed to import tags": "\u30bf\u30b0\u306e\u30a4\u30f3\u30dd\u30fc\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Failed to insert property": "\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u633f\u5165\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to merge tags": "\u30bf\u30b0\u306e\u30de\u30fc\u30b8\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Failed to modify filter": "\u30d5\u30a3\u30eb\u30bf\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to modify group": "\u30b0\u30eb\u30fc\u30d7\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to modify hidden properties": "\u975e\u8868\u793a\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to modify people name": "\u4eba\u7269\u540d\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to modify property data": "\u30d7\u30ed\u30d1\u30c6\u30a3\u30c7\u30fc\u30bf\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to modify property order": "\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u4e26\u3073\u9806\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to modify records": "\u30ec\u30b3\u30fc\u30c9\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to modify settings": "\u8a2d\u5b9a\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to modify sort": "\u4e26\u3079\u66ff\u3048\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to modify tags": "\u30bf\u30b0\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to move %(name)s and %(amount)s other item(s).": "%(name)s \u306e\u307b\u304b%(amount)s\u9805\u76ee\u3092\u79fb\u52d5\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002",
    "Failed to move %(name)s.": "%(name)s \u306e\u79fb\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Failed to move file": "\u30d5\u30a1\u30a4\u30eb\u306e\u79fb\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to move files to another library.": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u79fb\u52d5\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002",
    "Failed to move folder": "\u30d5\u30a9\u30eb\u30c0\u306e\u79fb\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to move {name}.": "{name} \u306e\u79fb\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Failed to move {n} items": "\u30a2\u30a4\u30c6\u30e0\u306e\u79fb\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f{n}",
    "Failed to remove people photos": "\u4eba\u7269\u306e\u5199\u771f\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to rename property": "\u30d7\u30ed\u30d1\u30c6\u30a3\u540d\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to restore records": "\u30ec\u30b3\u30fc\u30c9\u306e\u5fa9\u5143\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to restore tags": "\u30bf\u30b0\u306e\u5fa9\u5143\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Failed to restore {name}": "{name}\u306e\u5fa9\u5143\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to restore {name} and {n} other items": "{name}\u3068{n}\u500b\u306e\u4ed6\u306e\u30a2\u30a4\u30c6\u30e0\u306e\u5fa9\u5143\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to save": "\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Failed to send to {email_placeholder}: {errorMsg_placeholder}": "\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9 {email_placeholder} \u3078\u306e\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f: {errorMsg_placeholder}",
    "Failed to set people cover photo": "\u4eba\u7269\u306e\u8868\u7d19\u5199\u771f\u306e\u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Failed to unshare {name}": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u6210\u529f\u3057\u3066\u30a2\u30f3\u30b7\u30a7\u30a2\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f {name}\u3002",
    "Failed to upload {file_name}.": "{file_name} \u306e\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002",
    "Failed. Please check the network.": "\u64cd\u4f5c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u3092\u3054\u78ba\u8a8d\u304f\u3060\u3055\u3044\u3002",
    "Favicon": "\u30d5\u30a1\u30d3\u30b3\u30f3",
    "Favorites": "\u304a\u6c17\u306b\u5165\u308a",
    "File": "\u30d5\u30a1\u30a4\u30eb",
    "File Access": "\u30d5\u30a1\u30a4\u30eb\u30a2\u30af\u30bb\u30b9",
    "File Operations": "\u30d5\u30a1\u30a4\u30eb\u64cd\u4f5c",
    "File Scan": "\u30d5\u30a1\u30a4\u30eb\u306e\u30b9\u30ad\u30e3\u30f3",
    "File Update": "\u30d5\u30a1\u30a4\u30eb\u66f4\u65b0",
    "File Upload": "\u30d5\u30a1\u30a4\u30eb\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9",
    "File Uploading...": "\u30d5\u30a1\u30a4\u30eb\u306e\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u4e2d",
    "File already exists.": "\u30d5\u30a1\u30a4\u30eb\u304c\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059",
    "File collaborators": "\u30d5\u30a1\u30a4\u30eb\u306e\u5171\u540c\u4f5c\u696d\u8005",
    "File count": "\u30d5\u30a1\u30a4\u30eb\u6570",
    "File details": "\u30d5\u30a1\u30a4\u30eb\u306e\u8a73\u7d30",
    "File details extracted": "\u30d5\u30a1\u30a4\u30eb\u8a73\u7d30\u304c\u62bd\u51fa\u3055\u308c\u307e\u3057\u305f",
    "File download is disabled: the share link traffic of owner is used up.": "\u30d5\u30a1\u30a4\u30eb\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u304c\u7121\u52b9\u306b\u306a\u308a\u307e\u3057\u305f\u3002\u5171\u6709\u5143\u306e\u5171\u6709\u30ea\u30f3\u30af\u306e\u6d41\u91cf\u304c\u4f7f\u7528\u6e08\u307f\u3067\u3059\u3002",
    "File expire time": "\u30d5\u30a1\u30a4\u30eb\u306e\u6709\u52b9\u671f\u9650",
    "File extension white list": "\u30d5\u30a1\u30a4\u30eb\u62e1\u5f35\u5b50\u30db\u30ef\u30a4\u30c8\u30ea\u30b9\u30c8",
    "File extension white list for file upload via web UI and API. For example, \"md;txt;docx\". Empty means no limit.": "Web UI\u304a\u3088\u3073API\u7d4c\u7531\u3067\u30d5\u30a1\u30a4\u30eb\u3092\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u3059\u308b\u305f\u3081\u306e\u30d5\u30a1\u30a4\u30eb\u62e1\u5f35\u5b50\u30db\u30ef\u30a4\u30c8\u30ea\u30b9\u30c8\u3002\u305f\u3068\u3048\u3070\u3001\"md;txt;docx\"\u3002\u7a7a\u306e\u5834\u5408\u306f\u5236\u9650\u304c\u306a\u3044\u3053\u3068\u3092\u610f\u5473\u3057\u307e\u3059\u3002",
    "File extensions can only be {placeholder}.": "\u30d5\u30a1\u30a4\u30eb\u306e\u62e1\u5f35\u5b50\u306f {placeholder} \u306e\u307f\u304c\u8a31\u53ef\u3055\u308c\u3066\u3044\u307e\u3059\u3002",
    "File is locked by others.": "\u4ed6\u306e\u30e6\u30fc\u30b6\u306b\u3088\u3063\u3066\u30ed\u30c3\u30af\u3055\u308c\u3066\u3044\u307e\u3059",
    "File name": "\u30d5\u30a1\u30a4\u30eb\u540d",
    "File name and content": "\u30d5\u30a1\u30a4\u30eb\u540d\u3068\u5185\u5bb9",
    "File name only": "\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u307f",
    "File owner": "\u30d5\u30a1\u30a4\u30eb\u306e\u6240\u6709\u8005",
    "File rate": "\u30d5\u30a1\u30a4\u30eb\u306e\u8a55\u4fa1",
    "File reviewer": "\u30d5\u30a1\u30a4\u30eb\u306e\u30ec\u30d3\u30e5\u30a2\u30fc",
    "File size is too large.": "\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba\u304c\u5927\u304d\u3059\u304e\u307e\u3059\u3002",
    "File size should be smaller than {max_size_placeholder}.": "\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba\u306f {max_size_placeholder} \u4ee5\u4e0b\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002",
    "File status": "\u30d5\u30a1\u30a4\u30eb\u306e\u72b6\u614b",
    "File suffix": "\u30d5\u30a1\u30a4\u30eb\u306e suffix",
    "File too large": "\u30d5\u30a1\u30a4\u30eb\u304c\u5927\u304d\u3059\u304e\u307e\u3059",
    "File type": "\u30d5\u30a1\u30a4\u30eb\u306e\u7a2e\u985e",
    "File {file_link} has a new comment form user {author}.": "\u30e6\u30fc\u30b6 {author} \u304c\u30d5\u30a1\u30a4\u30eb {file_link} \u306b\u65b0\u3057\u3044\u30b3\u30e1\u30f3\u30c8\u3092\u8ffd\u52a0",
    "Files": "\u30d5\u30a1\u30a4\u30eb",
    "Files and folders": "\u30d5\u30a1\u30a4\u30eb\u3068\u30d5\u30a9\u30eb\u30c0",
    "Files by creator": "\u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210\u8005\u5225",
    "Files by time": "\u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210\u65e5\u5225",
    "Files by type": "\u30d5\u30a1\u30a4\u30eb\u306e\u7a2e\u985e\u5225",
    "Fill in": "\u4f4f\u6240\u3092\u5165\u529b",
    "Filter": "\u30d5\u30a3\u30eb\u30bf\u30fc",
    "Filters": "\u30d5\u30a3\u30eb\u30bf\u30fc",
    "Find": "\u691c\u7d22",
    "Find a tag": "\u30bf\u30b0\u3092\u691c\u7d22",
    "Find libraries": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u691c\u7d22",
    "Find modifiers": "\u5909\u66f4\u8005\u3092\u691c\u7d22",
    "Find users": "\u30e6\u30fc\u30b6\u3092\u691c\u7d22",
    "Focal length": "\u7126\u70b9\u8ddd\u96e2",
    "Fold": "\u6298\u308a\u305f\u305f\u3080",
    "Fold the sidebar": "\u30b5\u30a4\u30c9\u30d0\u30fc\u3092\u6298\u308a\u305f\u305f\u3080",
    "Folder": "\u30d5\u30a9\u30eb\u30c0",
    "Folder Permission": "\u30d5\u30a9\u30eb\u30c0\u30fc\u6a29\u9650",
    "Folder does not exist.": "\u30d5\u30a9\u30eb\u30c0\u30fc\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002",
    "Folder permission is only effective after the library is shared to users or groups. It is used to fine tune sub-folder permissions.": "\u30d5\u30a9\u30eb\u30c0\u30fc\u6a29\u9650\u306f\u3001\u30e9\u30a4\u30d6\u30e9\u30ea\u304c\u30e6\u30fc\u30b6\u307e\u305f\u306f\u30b0\u30eb\u30fc\u30d7\u306b\u5171\u6709\u3055\u308c\u305f\u5f8c\u306b\u306e\u307f\u6709\u52b9\u306b\u306a\u308a\u307e\u3059\u3002\u30b5\u30d6\u30d5\u30a9\u30eb\u30c0\u30fc\u6a29\u9650\u3092\u5fae\u8abf\u6574\u3059\u308b\u305f\u3081\u306b\u4f7f\u7528\u3055\u308c\u307e\u3059\u3002",
    "Folders": "\u30d5\u30a9\u30eb\u30c0",
    "Force Two-Factor Authentication": "2 \u6bb5\u968e\u8a8d\u8a3c\u3092\u5f37\u5236\u3059\u308b",
    "Force password change": "\u30d1\u30b9\u30ef\u30fc\u30c9\u5909\u66f4\u3092\u5f37\u5236\u3059\u308b",
    "Force user to change password when account is newly added or reset by admin": "\u30a2\u30ab\u30a6\u30f3\u30c8\u304c\u65b0\u898f\u8ffd\u52a0\u3055\u308c\u305f\u5834\u5408\u3001\u307e\u305f\u306f\u7ba1\u7406\u8005\u306b\u3088\u3063\u3066\u30ea\u30bb\u30c3\u30c8\u3055\u308c\u305f\u5834\u5408\u3001\u30e6\u30fc\u30b6\u306b\u30d1\u30b9\u30ef\u30fc\u30c9\u306e\u5909\u66f4\u3092\u5f37\u5236\u3059\u308b",
    "Force user to use SSO login if SSO account is bound": "SSO\u30a2\u30ab\u30a6\u30f3\u30c8\u304c\u30d0\u30a4\u30f3\u30c9\u3055\u308c\u3066\u3044\u308b\u5834\u5408\u306f\u3001\u30e6\u30fc\u30b6\u30fc\u304cSSO\u30ed\u30b0\u30a4\u30f3\u3092\u5f37\u5236\u3059\u308b",
    "Force user to use a strong password when sign up or change password.": "\u30e6\u30fc\u30b6\u304c\u65b0\u898f\u767b\u9332\u307e\u305f\u306f\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u5909\u66f4\u3059\u308b\u969b\u306b\u3001\u5f37\u529b\u306a\u30d1\u30b9\u30ef\u30fc\u30c9\u306e\u4f7f\u7528\u3092\u5f37\u5236\u3059\u308b\u3002",
    "Force users to use password when generating share/upload link.": "\u5171\u6709/\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u3092\u751f\u6210\u3059\u308b\u969b\u306b\u3001\u30e6\u30fc\u30b6\u306b\u30d1\u30b9\u30ef\u30fc\u30c9\u306e\u4f7f\u7528\u3092\u5fc5\u9808\u306b\u3059\u308b",
    "Format": "\u5f62\u5f0f",
    "Freeze Document": "\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u3092\u51cd\u7d50",
    "Freeze page": "\u30da\u30fc\u30b8\u3092\u51cd\u7d50",
    "Freeze user account when failed login attempts exceed limit.": "\u30ed\u30b0\u30a4\u30f3\u5931\u6557\u56de\u6570\u304c\u5236\u9650\u3092\u8d85\u3048\u305f\u5834\u5408\u3001\u30e6\u30fc\u30b6\u30a2\u30ab\u30a6\u30f3\u30c8\u3092\u51cd\u7d50\u3059\u308b\u3002",
    "Freeze user on login failed": "\u30ed\u30b0\u30a4\u30f3\u5931\u6557\u6642\u306b\u30e6\u30fc\u30b6\u3092\u51cd\u7d50",
    "Frozen by {name}": "{name} \u306b\u3088\u3063\u3066\u51cd\u7d50\u3055\u308c\u307e\u3057\u305f",
    "Full screen": "\u5168\u753b\u9762\u8868\u793a",
    "Gallery": "\u30ae\u30e3\u30e9\u30ea\u30fc",
    "General": "\u4e00\u822c",
    "General information": "\u4e00\u822c\u60c5\u5831",
    "Generate": "\u4f5c\u6210",
    "Generate Link": "\u5171\u6709\u30ea\u30f3\u30af\u3092\u751f\u6210",
    "Generate description": "\u8a18\u8ff0\u3092\u751f\u6210\u3059\u308b",
    "Generate file tags": "\u30d5\u30a1\u30a4\u30eb\u306e\u30bf\u30b0\u3092\u751f\u6210\u3059\u308b",
    "Generate links in batch": "\u4e00\u62ec\u3067\u5171\u6709\u30ea\u30f3\u30af\u3092\u751f\u6210",
    "Generate share link": "\u5171\u6709\u30ea\u30f3\u30af\u3092\u4f5c\u6210",
    "Generating description by AI...": "AI\u306b\u3088\u308b\u8aac\u660e\u306e\u751f\u6210\u4e2d...",
    "Germany Russia etc": "\u30c9\u30a4\u30c4 \u30ed\u30b7\u30a2 \u7b49",
    "Global Address Book": "\u30b0\u30ed\u30fc\u30d0\u30eb\u30a2\u30c9\u30ec\u30b9\u30d6\u30c3\u30af",
    "Global hidden properties": "\u30b0\u30ed\u30fc\u30d0\u30eb\u975e\u8868\u793a\u30d7\u30ed\u30d1\u30c6\u30a3",
    "Global hidden properties will not be displayed in all views.": "\u30b0\u30ed\u30fc\u30d0\u30eb\u975e\u8868\u793a\u30d7\u30ed\u30d1\u30c6\u30a3\u306f\u3001\u3059\u3079\u3066\u306e\u30d3\u30e5\u30fc\u3067\u975e\u8868\u793a\u306b\u306a\u308a\u307e\u3059\u3002",
    "Go back": "\u524d\u306b\u623b\u308b",
    "Go to Library": "\u30e9\u30a4\u30d6\u30e9\u30ea\u306b\u79fb\u52d5",
    "Greater than or equal to {minDays_placeholder} days": "{minDays_placeholder} \u65e5\u4ee5\u4e0a",
    "Grid view": "\u30b0\u30ea\u30c3\u30c9\u30d3\u30e5\u30fc",
    "Group": "\u30b0\u30eb\u30fc\u30d7",
    "Group Invite": "\u30b0\u30eb\u30fc\u30d7\u62db\u5f85",
    "Group Member": "\u30b0\u30eb\u30fc\u30d7\u30e1\u30f3\u30d0",
    "Group Permission": "\u30b0\u30eb\u30fc\u30d7\u6a29\u9650",
    "Group Shares": "\u30b0\u30eb\u30fc\u30d7\u5171\u6709",
    "Group by": "\u30d7\u30ed\u30d1\u30c6\u30a3\u306b\u3088\u308b\u30b0\u30eb\u30fc\u30d7\u5316",
    "Group deleted": "\u30b0\u30eb\u30fc\u30d7\u306f\u524a\u9664\u3055\u308c\u307e\u3057\u305f",
    "Group has been transferred": "\u30b0\u30eb\u30fc\u30d7\u304c\u8ee2\u9001\u3055\u308c\u307e\u3057\u305f",
    "Group info": "\u30b0\u30eb\u30fc\u30d7\u60c5\u5831",
    "Group invitation link": "\u30b0\u30eb\u30fc\u30d7\u62db\u5f85\u30ea\u30f3\u30af",
    "Group members": "\u30b0\u30eb\u30fc\u30d7\u30e1\u30f3\u30d0",
    "Grouped by 1 property": "\u30d7\u30ed\u30d1\u30c6\u30a3\u306b\u3088\u308b\u30b0\u30eb\u30fc\u30d7\u5316",
    "Grouped by {name_placeholder} properties": "\u30d7\u30ed\u30d1\u30c6\u30a3\u306b\u3088\u308b\u30b0\u30eb\u30fc\u30d7\u5316",
    "Groups": "\u30b0\u30eb\u30fc\u30d7",
    "Guest": "\u30b2\u30b9\u30c8",
    "Handled": "\u51e6\u7406\u6e08\u307f",
    "Help": "\u30d8\u30eb\u30d7",
    "Help and resources": "\u30d8\u30eb\u30d7\u3068\u30ea\u30bd\u30fc\u30b9",
    "Hidden properties": "\u975e\u8868\u793a\u30d7\u30ed\u30d1\u30c6\u30a3",
    "Hide": "\u96a0\u3059",
    "Hide advanced search": "\u9ad8\u5ea6\u306a\u691c\u7d22\u3092\u975e\u8868\u793a",
    "Hide all": "\u3059\u3079\u3066\u975e\u8868\u793a",
    "Hide properties": "\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u975e\u8868\u793a",
    "History": "\u5c65\u6b74",
    "History Setting": "\u5c65\u6b74\u8a2d\u5b9a",
    "History Versions": "\u5c65\u6b74\u30d0\u30fc\u30b8\u30e7\u30f3",
    "ID": "ID",
    "IP": "IP",
    "ISO": "ISO\u5f62\u5f0f",
    "Identifying portraits...": "\u8096\u50cf\u3092\u8b58\u5225\u4e2d...",
    "If notifications have not been read within one hour, they will be sent to your mailbox.": "1\u6642\u9593\u4ee5\u5185\u306b\u901a\u77e5\u304c\u672a\u8aad\u306e\u5834\u5408\u306f\u3001\u30e1\u30fc\u30eb\u30dc\u30c3\u30af\u30b9\u306b\u9001\u4fe1\u3055\u308c\u307e\u3059\u3002",
    "If the library is shared to another department, the sharing will be kept.": "\u30e9\u30a4\u30d6\u30e9\u30ea\u304c\u4ed6\u306e\u90e8\u9580\u306b\u5171\u6709\u3055\u308c\u3066\u3044\u308b\u5834\u5408\u306f\u3001\u5171\u6709\u95a2\u4fc2\u304c\u4fdd\u6301\u3055\u308c\u307e\u3059\u3002",
    "If the library is shared to another user, the sharing will be kept.": "\u30e9\u30a4\u30d6\u30e9\u30ea\u304c\u4ed6\u306e\u30e6\u30fc\u30b6\u306b\u5171\u6709\u3055\u308c\u3066\u3044\u308b\u5834\u5408\u306f\u3001\u5171\u6709\u95a2\u4fc2\u304c\u4fdd\u6301\u3055\u308c\u307e\u3059\u3002",
    "If there are multiple items in the cell, a random one will be chosen and be compared with the filter value.": "\u30bb\u30eb\u306b\u8907\u6570\u306e\u9805\u76ee\u304c\u3042\u308b\u5834\u5408\u306f\u3001\u30e9\u30f3\u30c0\u30e0\u306b1\u3064\u304c\u9078\u629e\u3055\u308c\u3001\u30d5\u30a3\u30eb\u30bf\u30fc\u5024\u3068\u6bd4\u8f03\u3055\u308c\u307e\u3059\u3002",
    "If turn on, the desktop clients will not be able to sync a folder outside the default Seafile folder.": "\u6709\u52b9\u306b\u3059\u308b\u3068\u3001\u30c7\u30b9\u30af\u30c8\u30c3\u30d7\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306fSeafile\u306e\u30c7\u30d5\u30a9\u30eb\u30c8\u30d5\u30a9\u30eb\u30c0\u5916\u306e\u30d5\u30a9\u30eb\u30c0\u3092\u540c\u671f\u3067\u304d\u306a\u304f\u306a\u308a\u307e\u3059\u3002",
    "If you don't have any device with you, you can access your account using backup codes.": "\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u30b3\u30fc\u30c9\u3092\u4f7f\u7528\u3057\u3066\u30a2\u30ab\u30a6\u30f3\u30c8\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u3059\u3002",
    "Ignore": "\u7121\u8996\u3059\u308b",
    "Ignored": "\u7121\u8996\u6e08\u307f",
    "Image saved": "\u753b\u50cf\u304c\u4fdd\u5b58\u3055\u308c\u307e\u3057\u305f",
    "Import": "\u53d6\u308a\u8fbc\u3080",
    "Import Confluence": "Confluence \u3092\u30a4\u30f3\u30dd\u30fc\u30c8",
    "Import Confluence Wiki": "\u7d71\u5408 Wiki\u3092\u30a4\u30f3\u30dd\u30fc\u30c8",
    "Import Users": "\u30e6\u30fc\u30b6\u3092\u30a4\u30f3\u30dd\u30fc\u30c8",
    "Import members": "\u30e1\u30f3\u30d0\u3092\u30a4\u30f3\u30dd\u30fc\u30c8",
    "Import members from a .xlsx file": "\u30e1\u30f3\u30d0\u3092Excel\u30d5\u30a1\u30a4\u30eb (.xlsx) \u304b\u3089\u53d6\u308a\u8fbc\u3080",
    "Import options": "\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u30a4\u30f3\u30dd\u30fc\u30c8",
    "Import page": "\u30da\u30fc\u30b8\u3092\u53d6\u308a\u8fbc\u3080",
    "Import page from Markdown": "Markdown \u5f62\u5f0f\u3067\u30da\u30fc\u30b8\u3092\u30a4\u30f3\u30dd\u30fc\u30c8",
    "Import page from docx": "docx \u5f62\u5f0f\u3067\u30da\u30fc\u30b8\u3092\u30a4\u30f3\u30dd\u30fc\u30c8",
    "Import sdoc": "sdoc\u3092\u30a4\u30f3\u30dd\u30fc\u30c8",
    "Import tags": "\u30bf\u30b0\u3092\u53d6\u308a\u8fbc\u3080",
    "Import users": "\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u30e6\u30fc\u30b6\u767b\u9332",
    "Import users from a .xlsx file": "\u30e6\u30fc\u30b6\u3092\u30a4\u30f3\u30dd\u30fc\u30c8",
    "Importing page...": "\u30da\u30fc\u30b8\u3092\u53d6\u308a\u8fbc\u307f\u4e2d...",
    "Importing sdoc, please wait...": "sdoc\u3092\u30a4\u30f3\u30dd\u30fc\u30c8\u4e2d\u3001\u3057\u3070\u3089\u304f\u304a\u5f85\u3061\u304f\u3060\u3055\u3044",
    "Importing tags...": "\u30bf\u30b0\u3092\u53d6\u308a\u8fbc\u307f\u4e2d...",
    "Importing...": "\u53d6\u308a\u8fbc\u307f\u4e2d...",
    "In progress": "\u9032\u884c\u4e2d",
    "In review": "\u30ec\u30d3\u30e5\u30fc\u4e2d",
    "Inactive": "\u7121\u52b9",
    "Info": "\u60c5\u5831",
    "Institution Admin": "\u6a5f\u95a2\u7ba1\u7406",
    "Institutions": "\u7d44\u7e54\u4e00\u89a7",
    "Internal Link": "\u5185\u90e8\u30ea\u30f3\u30af",
    "Internal Server Error": "\u30b5\u30fc\u30d0\u5185\u90e8\u30a8\u30e9\u30fc",
    "Internal link has been copied to clipboard": "\u5185\u90e8\u30ea\u30f3\u30af\u304c\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3057\u305f",
    "Invalid destination path": "\u7121\u52b9\u306a\u5b9b\u5148\u30d1\u30b9",
    "Invalid filename.": "\u7121\u52b9\u306a\u30d5\u30a1\u30a4\u30eb\u540d\u3067\u3059",
    "Invalid filter": "\u7121\u52b9\u306a\u30d5\u30a3\u30eb\u30bf\u30fc",
    "Invalid month, should be yyyymm.": "\u7121\u52b9\u306a\u6708\u3001yyyyMM \u306e\u5f62\u5f0f\u3067\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
    "Invalid regular expression": "\u7121\u52b9\u306a\u6b63\u898f\u8868\u73fe",
    "Invisible": "\u975e\u8868\u793a",
    "Invitation link has been copied to clipboard": "\u62db\u5f85\u30ea\u30f3\u30af\u304c\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3057\u305f",
    "Invitations": "\u62db\u5f85\u4e00\u89a7",
    "Invite Guest": "\u30b2\u30b9\u30c8\u3092\u62db\u5f85",
    "Invite Time": "\u62db\u5f85\u65e5",
    "Invite members": "\u30e1\u30f3\u30d0\u3092\u62db\u5f85",
    "Invite users": "\u30e6\u30fc\u30b6\u3092\u62db\u5f85",
    "Invite users via WeChat": "WeChat\u3067\u30e6\u30fc\u30b6\u30fc\u3092\u62db\u5f85",
    "Invited at": "\u62db\u5f85\u65e5",
    "Inviter": "\u62db\u5f85\u8005",
    "Is expired": "\u671f\u9650\u5207\u308c\u304b",
    "It is already shared to user": "\u65e2\u306b\u5171\u6709\u3055\u308c\u3066\u3044\u307e\u3059",
    "It is required.": "\u5fc5\u9808\u9805\u76ee\u3067\u3059",
    "It may take some time, please wait.": "\u305d\u308c\u306f\u3044\u304f\u3064\u304b\u306e\u6642\u9593\u304c\u304b\u304b\u308b\u5834\u5408\u304c\u3042\u308a\u307e\u3059\u3002\u3057\u3070\u3089\u304f\u304a\u5f85\u3061\u304f\u3060\u3055\u3044\u3002",
    "Kanban": "\u770b\u677f",
    "Keep full history": "\u5168\u3066\u306e\u5c65\u6b74\u3092\u4fdd\u5b58\u3059\u308b",
    "Keep sharing": "\u5171\u6709\u95a2\u4fc2\u3092\u4fdd\u6301\u3059\u308b",
    "Keep sign in": "\u30ed\u30b0\u30a4\u30f3\u72b6\u614b\u3092\u7dad\u6301",
    "LDAP": "LDAP",
    "LDAP(imported)": "LDAP\uff08\u8f38\u5165\uff09",
    "Label": "\u30e9\u30d9\u30eb",
    "Label Current State": "\u73fe\u5728\u306e\u72b6\u614b\u306b\u30e9\u30d9\u30eb\u3092\u4ed8\u3051\u308b",
    "Labels": "\u30e9\u30d9\u30eb",
    "Language": "\u8a00\u8a9e",
    "Language Setting": "\u8a00\u8a9e\u8a2d\u5b9a",
    "Language for tags generated by AI": "AI\u306b\u3088\u3063\u3066\u751f\u6210\u3055\u308c\u305f\u30bf\u30b0\u306e\u8a00\u8a9e",
    "Last 30 days": "\u76f4\u8fd130\u65e5\u9593",
    "Last 7 days": "\u76f4\u8fd17\u65e5\u9593",
    "Last Access": "\u524d\u56de\u306e\u30a2\u30af\u30bb\u30b9",
    "Last Login": "\u524d\u56de\u306e\u30ed\u30b0\u30a4\u30f3",
    "Last Update": "\u524d\u56de\u306e\u66f4\u65b0",
    "Last modification": "\u6700\u7d42\u5909\u66f4",
    "Last modified by": "\u6700\u7d42\u66f4\u65b0\u8005\uff1a",
    "Last modified time": "\u6700\u7d42\u66f4\u65b0\u65e5\u6642",
    "Last modifier": "\u6700\u7d42\u66f4\u65b0\u8005",
    "Leave": "\u9000\u51fa",
    "Leave Group": "\u30b0\u30eb\u30fc\u30d7\u3092\u9000\u4f1a\u3059\u308b",
    "Leave Share": "\u5171\u6709\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002",
    "Leave Share Wiki": "\u5171\u6709 Wiki \u3092\u96e2\u8131",
    "Leave group": "\u30b0\u30eb\u30fc\u30d7\u3092\u8131\u9000",
    "Leave this page? The system may not save your changes.": "\u3053\u306e\u30da\u30fc\u30b8\u3092\u96e2\u308c\u307e\u3059\u304b\uff1f\u30b7\u30b9\u30c6\u30e0\u306f\u5909\u66f4\u3092\u4fdd\u5b58\u3057\u306a\u3044\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002",
    "Less than or equal to {maxDays_placeholder} days": "{maxDays_placeholder} \u65e5\u4ee5\u4e0b",
    "Libraries": "\u30e9\u30a4\u30d6\u30e9\u30ea\u30fc",
    "Library": "\u30e9\u30a4\u30d6\u30e9\u30ea\u30fc",
    "Library Type": "\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u7a2e\u985e",
    "Library can not be shared to owner.": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u6240\u6709\u8005\u3068\u5171\u6709\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002",
    "Library does not exist": "\u30e9\u30a4\u30d6\u30e9\u30ea\u30fc\u304c\u5b58\u5728\u3057\u307e\u305b\u3093",
    "Library history": "\u30e9\u30a4\u30d6\u30e9\u30ea\u5c65\u6b74",
    "Library not found": "\u30e9\u30a4\u30d6\u30e9\u30ea\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093",
    "Library password minimum length": "\u30e9\u30a4\u30d6\u30e9\u30ea\u30d1\u30b9\u30ef\u30fc\u30c9\u306e\u6700\u5c0f\u6587\u5b57\u6570",
    "Light mode": "\u30e9\u30a4\u30c8\u30e2\u30fc\u30c9",
    "Limits": "\u5236\u9650",
    "Line wrapping": "\u6298\u308a\u8fd4\u3057",
    "Link": "\u30ea\u30f3\u30af",
    "Link has been copied to clipboard": "\u30ea\u30f3\u30af\u304c\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3057\u305f",
    "Link image": "\u753b\u50cf\u3092\u30ea\u30f3\u30af",
    "Linked Devices": "\u30ea\u30f3\u30af\u3055\u308c\u305f\u30c7\u30d0\u30a4\u30b9",
    "Links": "\u30ea\u30f3\u30af",
    "List view": "\u30ea\u30b9\u30c8\u30d3\u30e5\u30fc",
    "List your account in global address book, so that others can find you by typing your name.": "\u540d\u524d\u3092\u5165\u529b\u3059\u308b\u3068\u3001\u4ed6\u306e\u30e6\u30fc\u30b6\u304c\u3042\u306a\u305f\u3092\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u308b\u3088\u3046\u306b\u3001\u30a2\u30ab\u30a6\u30f3\u30c8\u3092\u30b0\u30ed\u30fc\u30d0\u30eb\u30a2\u30c9\u30ec\u30b9\u30d6\u30c3\u30af\u306b\u8ffd\u52a0\u3057\u307e\u3059\u3002",
    "Load all": "\u3059\u3079\u3066\u306e\u30ec\u30b3\u30fc\u30c9\u3092\u8aad\u307f\u8fbc\u3080",
    "Loading": "\u8aad\u307f\u8fbc\u307f\u4e2d...",
    "Loading metadata...": "\u30e1\u30bf\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u8fbc\u307f\u4e2d...",
    "Loading...": "\u8aad\u307f\u8fbc\u307f\u4e2d...",
    "Location": "\u30ed\u30b1\u30fc\u30b7\u30e7\u30f3",
    "Lock": "\u30ed\u30c3\u30af",
    "Log out": "\u30ed\u30b0\u30a2\u30a6\u30c8",
    "Login": "\u30ed\u30b0\u30a4\u30f3",
    "Login ID": "\u30ed\u30b0\u30a4\u30f3ID",
    "Login attempt limit": "\u30ed\u30b0\u30a4\u30f3\u8a66\u884c\u56de\u6570\u5236\u9650",
    "Login background image": "\u30ed\u30b0\u30a4\u30f3\u80cc\u666f\u753b\u50cf",
    "Logo": "\u30ed\u30b4",
    "Logo updated": "\u30ed\u30b4\u304c\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f",
    "Logs": "\u30ed\u30b0",
    "Long text": "\u9577\u3044\u30c6\u30ad\u30b9\u30c8",
    "Manage group members": "\u30b0\u30eb\u30fc\u30d7\u30e1\u30f3\u30d0\u3092\u7ba1\u7406",
    "Manage members": "\u30e1\u30f3\u30d0\u3092\u7ba1\u7406",
    "Map": "\u30de\u30c3\u30d7",
    "Map is not ready": "\u30de\u30c3\u30d7\u304c\u6e96\u5099\u3067\u304d\u3066\u3044\u307e\u305b\u3093",
    "Mark all as read": "\u3059\u3079\u3066\u3092\u65e2\u8aad\u306b\u3059\u308b",
    "Mark all read": "\u5168\u3066\u3092\u65e2\u8aad\u306b\u3059\u308b",
    "Mark as resolved": "\u89e3\u6c7a\u6e08\u307f\u3068\u3057\u3066\u30de\u30fc\u30af",
    "Mark notification as read": "\u901a\u77e5\u3092\u65e2\u8aad\u306b\u3059\u308b",
    "Marked \"{resolve_comment}\" as resolved in document {sdoc_link}": "\u30e6\u30fc\u30b6\u304c\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8 {sdoc_link} \u306e\u30b3\u30e1\u30f3\u30c8 \"{resolve_comment}\" \u3092\u78ba\u8a8d",
    "Marked as resolved in document {sdoc_link}": "\u30e6\u30fc\u30b6\u304c\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8 {sdoc_link} \u3092\u78ba\u8a8d",
    "Matching tags": "\u30de\u30c3\u30c1\u30f3\u30b0\u30bf\u30b0",
    "Max": "\u6700\u5927",
    "Max number of members": "\u6700\u5927\u30e1\u30f3\u30d0\u6570",
    "Member": "\u4f1a\u54e1",
    "Members": "\u30e1\u30f3\u30d0",
    "Merge tags": "\u30bf\u30b0\u306e\u30de\u30fc\u30b8",
    "Merge tags to": "\u30bf\u30b0\u3092\u30de\u30fc\u30b8",
    "Message": "\u30e1\u30c3\u30bb\u30fc\u30b8",
    "Message (optional):": "\u30e1\u30c3\u30bb\u30fc\u30b8\uff08\u4efb\u610f\uff09\uff1a",
    "Metrics": "\u30e1\u30c8\u30ea\u30af\u30b9",
    "Migrate": "\u30de\u30a4\u30b0\u30ec\u30fc\u30c8",
    "Migrate User": "\u30e6\u30fc\u30b6\u3092\u79fb\u884c",
    "Migrate old version tags": "\u53e4\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u30bf\u30b0\u3092\u65b0\u3057\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u79fb\u884c\u3059\u308b",
    "Mobile": "\u30e2\u30d0\u30a4\u30eb",
    "Modification Details": "\u66f4\u65b0\u306e\u8a73\u7d30",
    "Modified": "\u5909\u66f4\u6e08\u307f",
    "Modified by": "\u5909\u66f4\u8005",
    "Modified by:": "\u5909\u66f4\u8005:",
    "Modified files": "\u66f4\u65b0\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb",
    "Modified time": "\u4fee\u6b63\u65e5\u6642",
    "Modifier": "\u5909\u66f4\u8005",
    "Modify": "\u5909\u66f4",
    "Modify includes modify file, move/rename file and folder": "\u300c\u5909\u66f4\u300d\u306b\u306f\u3001\u30d5\u30a1\u30a4\u30eb\u306e\u5909\u66f4, \u79fb\u52d5\u3068\u30d5\u30a1\u30a4\u30eb, \u30d5\u30a9\u30eb\u30c0\u306e\u540d\u524d\u5909\u66f4\u304c\u542b\u307e\u308c\u307e\u3059\u3002",
    "Modify name": "\u540d\u524d\u3092\u5909\u66f4",
    "Month": "\u6708",
    "Month:": "\u6708\uff1a",
    "Monthly User Traffic": "\u6708\u6b21\u30e6\u30fc\u30b6\u901a\u4fe1\u91cf",
    "More": "\u7d9a\u304d",
    "More operations": "\u305d\u306e\u4ed6\u306e\u64cd\u4f5c",
    "Move": "\u79fb\u52d5",
    "Move department": "\u30c7\u30d1\u30fc\u30c8\u30e1\u30f3\u30c8\u3092\u79fb\u52d5",
    "Move file": "\u30d5\u30a1\u30a4\u30eb\u3092\u79fb\u52d5",
    "Move folder": "\u30d5\u30a9\u30eb\u30c0\u3092\u79fb\u52d5",
    "Move selected item(s) to:": "\u9078\u629e\u3057\u305f\u30a2\u30a4\u30c6\u30e0\u3092\u79fb\u52d5\u5148:",
    "Move to department": "\u90e8\u9580\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044",
    "Move {num} items": "{num}\u500b\u306e\u9805\u76ee\u3092\u79fb\u52d5",
    "Move {placeholder} to": "{placeholder}\u3092\u306b\u79fb\u52d5",
    "Moved file": "\u30d5\u30a1\u30a4\u30eb\u3092\u79fb\u52d5\u3057\u307e\u3057\u305f",
    "Moved folder": "\u30d5\u30a9\u30eb\u30c0\u3092\u79fb\u52d5\u3057\u307e\u3057\u305f",
    "Multiple select": "\u8907\u6570\u9078\u629e",
    "My Activities": "\u79c1\u306e\u30a2\u30af\u30c6\u30a3\u30d3\u30c6\u30a3",
    "My Libraries": "\u30de\u30a4\u30e9\u30a4\u30d6\u30e9\u30ea",
    "My Wikis": "\u30de\u30a4 Wiki",
    "Name": "\u6c0f\u540d",
    "Name already exists": "\u540d\u524d\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059",
    "Name cannot be double dots": "\u540d\u524d\u3092\u300c..\u300d\u306b\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002",
    "Name cannot be empty": "\u540d\u524d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
    "Name cannot contain backslash": "\u540d\u524d\u306b\u30d0\u30c3\u30af\u30b9\u30e9\u30c3\u30b7\u30e5\u3092\u542b\u3081\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093",
    "Name cannot contain backtick": "\u540d\u524d\u306b\u30d0\u30c3\u30af\u30c6\u30a3\u30c3\u30af\u3092\u542b\u3081\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093",
    "Name cannot contain curly braces": "\u540d\u524d\u306b\u6ce2\u62ec\u5f27\u3092\u542b\u3081\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093",
    "Name cannot contain dots": "\u540d\u524d\u306b\u30c9\u30c3\u30c8\u3092\u542b\u3081\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093",
    "Name cannot contain slash": "\u540d\u524d\u306b\u30b9\u30e9\u30c3\u30b7\u30e5\u3092\u542b\u3081\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093",
    "Name is required": "\u6c0f\u540d\u306f\u5fc5\u9808\u9805\u76ee\u3067\u3059",
    "Name is required.": "\u6c0f\u540d\u306f\u5fc5\u9808\u9805\u76ee\u3067\u3059\u3002",
    "Name or ID": "\u540d\u524d\u307e\u305f\u306f ID",
    "Name should be string": "\u540d\u524d\u306f\u6587\u5b57\u5217\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059",
    "Name should not include '/'.": "\u540d\u524d\u306b\u306f\u300c/\u300d\u3092\u542b\u3081\u3089\u308c\u307e\u305b\u3093",
    "Name updated": "\u540d\u524d\u304c\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f",
    "Name(optional)": "\u6c0f\u540d\uff08\u4efb\u610f\uff09",
    "Names don't match": "\u540d\u524d\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093",
    "Network error": "\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u30a8\u30e9\u30fc",
    "New": "\u65b0\u3057\u3044",
    "New Department": "\u65b0\u90e8\u9580",
    "New Department Library": "\u90e8\u9580\u30e9\u30a4\u30d6\u30e9\u30ea\u4f5c\u6210",
    "New Docxf File": "\u65b0\u3057\u3044Docxf\u30d5\u30a1\u30a4\u30eb",
    "New Excalidraw File": "\u65b0\u3057\u3044Excalidraw\u30d5\u30a1\u30a4\u30eb",
    "New Excel File": "\u65b0\u3057\u3044Excel\u30d5\u30a1\u30a4\u30eb",
    "New File": "\u65b0\u3057\u3044\u30d5\u30a1\u30a4\u30eb",
    "New Folder": "\u65b0\u3057\u3044\u30d5\u30a9\u30eb\u30c0",
    "New Group": "\u65b0\u3057\u3044\u30b0\u30eb\u30fc\u30d7",
    "New Library": "\u65b0\u3057\u3044\u30e9\u30a4\u30d6\u30e9\u30ea",
    "New Markdown File": "\u65b0\u3057\u3044Markdown\u30d5\u30a1\u30a4\u30eb",
    "New Password": "\u65b0\u3057\u3044\u30d1\u30b9\u30ef\u30fc\u30c9",
    "New Password Again": "\u30d1\u30b9\u30ef\u30fc\u30c9\u518d\u5165\u529b",
    "New PowerPoint File": "\u65b0\u3057\u3044PowerPoint\u30d5\u30a1\u30a4\u30eb",
    "New SeaDoc File": "\u65b0\u3057\u3044SeaDoc\u30d5\u30a1\u30a4\u30eb",
    "New Sub-department": "\u65b0\u3057\u3044\u30b5\u30d6\u90e8\u9580",
    "New Whiteboard File": "\u65b0\u3057\u3044Whiteboard\u30d5\u30a1\u30a4\u30eb",
    "New Word File": "\u65b0\u3057\u3044Word\u30d5\u30a1\u30a4\u30eb",
    "New category": "\u65b0\u3057\u3044\u30ab\u30c6\u30b4\u30ea",
    "New child tag": "\u5b50\u30bf\u30b0\u3092\u8ffd\u52a0",
    "New directories": "\u65b0\u3057\u3044\u30d5\u30a9\u30eb\u30c0",
    "New file name": "\u65b0\u3057\u3044\u30d5\u30a1\u30a4\u30eb\u540d",
    "New files": "\u65b0\u3057\u3044\u30d5\u30a1\u30a4\u30eb",
    "New folder": "\u65b0\u3057\u3044\u30d5\u30a9\u30eb\u30c0",
    "New folder name": "\u65b0\u3057\u3044\u30d5\u30a9\u30eb\u30c0\u540d",
    "New page": "\u65b0\u3057\u3044\u30da\u30fc\u30b8",
    "New password": "\u65b0\u898f\u30d1\u30b9\u30ef\u30fc\u30c9",
    "New password cannot be the same as old password": "\u65b0\u3057\u3044\u30d1\u30b9\u30ef\u30fc\u30c9\u306f\u53e4\u3044\u30d1\u30b9\u30ef\u30fc\u30c9\u3068\u540c\u3058\u3067\u306f\u306a\u3044\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059",
    "New password has been sent to your email {mail}. Please check your mailbox. If you don\u2019t receive the password, please check if your email address is properly configured.": "\u65b0\u3057\u3044\u30d1\u30b9\u30ef\u30fc\u30c9\u306f\u3042\u306a\u305f\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9 {mail} \u306b\u9001\u4fe1\u3055\u308c\u307e\u3057\u305f\u3002\u30e1\u30fc\u30eb\u30dc\u30c3\u30af\u30b9\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002 \u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u5c4a\u304b\u306a\u3044\u5834\u5408\u306f\u3001\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304c\u6b63\u3057\u304f\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
    "New password is too short": "\u65b0\u3057\u3044\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u77ed\u3059\u304e\u307e\u3059",
    "New passwords don't match": "\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093",
    "New tag": "\u65b0\u3057\u3044\u30bf\u30b0",
    "New view": "\u65b0\u3057\u3044\u30d3\u30e5\u30fc",
    "Next": "\u6b21\u3078",
    "Next (Right arrow key)": "\u6b21\u3078 (\u53f3\u77e2\u5370\u30ad\u30fc)",
    "Next modification": "\u6b21\u306e\u5909\u66f4",
    "No Admin login logs": "\u7ba1\u7406\u8005\u30ed\u30b0\u30a4\u30f3\u30ed\u30b0\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "No Admin operation logs": "\u7ba1\u7406\u8005\u64cd\u4f5c\u30ed\u30b0\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "No Wikis": "Wiki \u304c\u3042\u308a\u307e\u305b\u3093",
    "No categories": "\u30ab\u30c6\u30b4\u30ea\u304c\u3042\u308a\u307e\u305b\u3093",
    "No changes": "\u5909\u66f4\u306a\u3057",
    "No collaborators": "\u5354\u529b\u8005\u304c\u3042\u308a\u307e\u305b\u3093",
    "No collaborators available": "\u5354\u529b\u8005\u304c\u5229\u7528\u53ef\u80fd\u3067\u306f\u3042\u308a\u307e\u305b\u3093",
    "No comment yet.": "\u30b3\u30e1\u30f3\u30c8\u306f\u307e\u3060\u3042\u308a\u307e\u305b\u3093",
    "No connected devices": "\u63a5\u7d9a\u3055\u308c\u3066\u3044\u308b\u30c7\u30d0\u30a4\u30b9\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "No creator data available": "\u4f5c\u6210\u8005\u30c7\u30fc\u30bf\u304c\u5229\u7528\u3067\u304d\u307e\u305b\u3093",
    "No data available for statistics": "\u7d71\u8a08\u30c7\u30fc\u30bf\u304c\u5229\u7528\u3067\u304d\u307e\u305b\u3093",
    "No deleted libraries": "\u524a\u9664\u6e08\u307f\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u3042\u308a\u307e\u305b\u3093",
    "No favorites": "\u304a\u6c17\u306b\u5165\u308a\u306e\u30a2\u30a4\u30c6\u30e0\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "No file": "\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093",
    "No file access logs": "\u30d5\u30a1\u30a4\u30eb\u30a2\u30af\u30bb\u30b9\u30ed\u30b0\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "No file selected": "\u30d5\u30a1\u30a4\u30eb\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093",
    "No file update logs": "\u30d5\u30a1\u30a4\u30eb\u66f4\u65b0\u30ed\u30b0\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "No files": "\u30d5\u30a1\u30a4\u30eb\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "No files or folders have been shared with you": "\u5171\u6709\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u3084\u30d5\u30a9\u30eb\u30c0\u30fc\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002",
    "No files or folders have been shared with you from other servers.": "\u5171\u6709\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u3084\u30d5\u30a9\u30eb\u30c0\u30fc\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002",
    "No filters": "\u30d5\u30a3\u30eb\u30bf\u30fc\u304c\u3042\u308a\u307e\u305b\u3093",
    "No folders shared": "\u5171\u6709\u3057\u3066\u3044\u308b\u30d5\u30a9\u30eb\u30c0\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "No group invitation link yet. Group invitation link let registered users to join the group by clicking a link.": "\u30b0\u30eb\u30fc\u30d7\u62db\u5f85\u30ea\u30f3\u30af\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u767b\u9332\u6e08\u307f\u306e\u30e6\u30fc\u30b6\u304c\u3001\u30b0\u30eb\u30fc\u30d7\u62db\u5f85\u30ea\u30f3\u30af\u3092\u4f7f\u3046\u3053\u3068\u3067\u30b0\u30eb\u30fc\u30d7\u306b\u53c2\u52a0\u3067\u304d\u307e\u3059\u3002",
    "No group shares": "\u30b0\u30eb\u30fc\u30d7\u5171\u6709\u306a\u3057",
    "No groupings applied to this view.": "\u3053\u306e\u30d3\u30e5\u30fc\u306b\u306f\u30b0\u30eb\u30fc\u30d7\u5316\u304c\u9069\u7528\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002",
    "No groups": "\u30b0\u30eb\u30fc\u30d7\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "No guest invitations": "\u30b2\u30b9\u30c8\u62db\u5f85\u304c\u3042\u308a\u307e\u305b\u3093",
    "No invitations": "\u62db\u5f85\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "No items": "\u30a2\u30a4\u30c6\u30e0\u304c\u3042\u308a\u307e\u305b\u3093",
    "No libraries": "\u30e9\u30a4\u30d6\u30e9\u30ea\u304c\u3042\u308a\u307e\u305b\u3093",
    "No libraries have been shared directly with you. A shared library can be shared with full or restricted permission. If you need access to a library owned by another user, ask the user to share the library with you.": "\u56f3\u66f8\u9928\u306f\u3042\u306a\u305f\u3068\u76f4\u63a5\u5171\u6709\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u5171\u6709\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u5b8c\u5168\u307e\u305f\u306f\u5236\u9650\u3055\u308c\u305f\u8a31\u53ef\u3067\u5171\u6709\u3067\u304d\u307e\u3059\u3002\u4ed6\u306e\u30e6\u30fc\u30b6\u304c\u6240\u6709\u3059\u308b\u30e9\u30a4\u30d6\u30e9\u30ea\u306b\u30a2\u30af\u30bb\u30b9\u3059\u308b\u5fc5\u8981\u304c\u3042\u308b\u5834\u5408\u306f\u3001\u30e6\u30fc\u30b6\u306b\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u5171\u6709\u3059\u308b\u3088\u3046\u8981\u6c42\u3057\u307e\u3059\u3002",
    "No libraries have been shared with this group yet. A library shared with a group can be accessed by all group members. You can share a library with a group in \"My Libraries\". You can also create a new library to be shared with this group by clicking the \"New Library\" item in the dropdown menu.": "\u307e\u3060\u3053\u306e\u30b0\u30eb\u30fc\u30d7\u3068\u5171\u6709\u3055\u308c\u3066\u3044\u308b\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u3042\u308a\u307e\u305b\u3093\u3002\u30b0\u30eb\u30fc\u30d7\u3068\u5171\u6709\u3055\u308c\u3066\u3044\u308b\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u3001\u3059\u3079\u3066\u306e\u30b0\u30eb\u30fc\u30d7\u30e1\u30f3\u30d0\u30fc\u304c\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u3059\u3002\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u300cMy Libraries\u300d\u3067\u30b0\u30eb\u30fc\u30d7\u3068\u5171\u6709\u3067\u304d\u307e\u3059\u3002\u307e\u305f,\u30c9\u30ed\u30c3\u30d7\u30c0\u30a6\u30f3\u30e1\u30cb\u30e5\u30fc\u306e\"\u65b0\u3057\u3044\u30e9\u30a4\u30d6\u30e9\u30ea\"\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066,\u3053\u306e\u30b0\u30eb\u30fc\u30d7\u3068\u5171\u6709\u3059\u308b\u65b0\u3057\u3044\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u4f5c\u6210\u3059\u308b\u3053\u3068\u3082\u3067\u304d\u307e\u3059.",
    "No libraries have been shared with you": "\u5171\u6709\u3055\u308c\u305f\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u3042\u308a\u307e\u305b\u3093",
    "No libraries have been shared with you from other servers.": "\u4ed6\u306e\u30b5\u30fc\u30d0\u30fc\u304b\u3089\u5171\u6709\u3055\u308c\u305f\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u3042\u308a\u307e\u305b\u3093\u3002",
    "No libraries shared": "\u5171\u6709\u3055\u308c\u305f\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u3042\u308a\u307e\u305b\u3093",
    "No libraries shared with this group": "\u3053\u306e\u30b0\u30eb\u30fc\u30d7\u3068\u5171\u6709\u3055\u308c\u3066\u3044\u308b\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u3042\u308a\u307e\u305b\u3093",
    "No linked devices": "\u5171\u6709\u30c7\u30d0\u30a4\u30b9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002",
    "No linked devices. You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "\u30ea\u30f3\u30af\u3055\u308c\u305f\u30c7\u30d0\u30a4\u30b9\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u307e\u3060\u3069\u306e\u30af\u30e9\u30a4\u30a2\u30f3\u30c8 (\u30c7\u30b9\u30af\u30c8\u30c3\u30d7\u307e\u305f\u306f\u30e2\u30d0\u30a4\u30eb) \u3067\u3082\u30d5\u30a1\u30a4\u30eb\u306b\u30a2\u30af\u30bb\u30b9\u3057\u3066\u3044\u307e\u305b\u3093\u3002\u30c7\u30d0\u30a4\u30b9\u4e0a\u306e\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u3092\u69cb\u6210\u3057\u3066\u3001\u3088\u308a\u5feb\u9069\u306b\u30c7\u30fc\u30bf\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u308b\u3088\u3046\u306b\u3057\u307e\u3059\u3002",
    "No login logs": "\u30ed\u30b0\u30a4\u30f3\u30ed\u30b0\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "No matching tags": "\u30de\u30c3\u30c1\u30f3\u30b0\u30bf\u30b0\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093",
    "No members": "\u30e1\u30f3\u30d0\u306a\u3057",
    "No more activities": "\u3053\u308c\u4ee5\u4e0a\u306e\u30a2\u30af\u30c6\u30a3\u30d3\u30c6\u30a3\u306f\u3042\u308a\u307e\u305b\u3093",
    "No notifications": "\u901a\u77e5\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "No option": "\u30aa\u30d7\u30b7\u30e7\u30f3\u304c\u3042\u308a\u307e\u305b\u3093",
    "No options": "\u30aa\u30d7\u30b7\u30e7\u30f3\u304c\u3042\u308a\u307e\u305b\u3093",
    "No options available": "\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u3042\u308a\u307e\u305b\u3093",
    "No permission logs": "\u6a29\u9650\u30ed\u30b0\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "No properties available to be hidden": "\u975e\u8868\u793a\u306b\u3067\u304d\u308b\u30d7\u30ed\u30d1\u30c6\u30a3\u304c\u3042\u308a\u307e\u305b\u3093",
    "No public libraries": "\u516c\u958b\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u3042\u308a\u307e\u305b\u3093\u3002",
    "No public libraries have been created yet. A public library is accessible by all users. You can create a public library by clicking the \"Add Library\" item in the dropdown menu.": "\u307e\u3060\u516c\u5171\u56f3\u66f8\u9928\u306f\u4f5c\u3089\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u516c\u5171\u56f3\u66f8\u9928\u306f\u3059\u3079\u3066\u306e\u30e6\u30fc\u30b6\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u3059\u3002\u30c9\u30ed\u30c3\u30d7\u30c0\u30a6\u30f3\u30e1\u30cb\u30e5\u30fc\u306e\"\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u8ffd\u52a0\"\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u30d1\u30d6\u30ea\u30c3\u30af\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u4f5c\u6210\u3067\u304d\u307e\u3059.",
    "No recommended new tags": "\u63a8\u5968\u65b0\u30bf\u30b0\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093",
    "No record": "\u30ec\u30b3\u30fc\u30c9\u304c\u3042\u308a\u307e\u305b\u3093",
    "No result": "\u7d50\u679c\u306a\u3057",
    "No results": "\u7d50\u679c\u304c\u3042\u308a\u307e\u305b\u3093",
    "No results found": "\u7d50\u679c\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093",
    "No results matching": "\u4e00\u81f4\u3059\u308b\u7d50\u679c\u304c\u3042\u308a\u307e\u305b\u3093",
    "No separator (1000000)": "\u533a\u5207\u308a\u306a\u3057 (1000000)",
    "No share links": "\u5171\u6709\u30ea\u30f3\u30af\u306a\u3057",
    "No shared Wikis": "\u5171\u6709\u306e Wiki \u306f\u3042\u308a\u307e\u305b\u3093",
    "No shared libraries": "\u5171\u6709\u3055\u308c\u305f\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u3042\u308a\u307e\u305b\u3093\u3002",
    "No sorts": "\u4e26\u3079\u66ff\u3048\u304c\u3042\u308a\u307e\u305b\u3093",
    "No sync errors": "\u540c\u671f\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "No tag": "\u30bf\u30b0\u304c\u3042\u308a\u307e\u305b\u3093",
    "No tags": "\u30bf\u30b0\u306a\u3057",
    "No tags available": "\u30bf\u30b0\u304c\u5229\u7528\u53ef\u80fd\u3067\u306f\u3042\u308a\u307e\u305b\u3093",
    "No terms and conditions": "\u5229\u7528\u898f\u7d04\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "No text extracted": "\u30c6\u30ad\u30b9\u30c8\u304c\u62bd\u51fa\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f",
    "No time-based data available": "\u6642\u7cfb\u5217\u30c7\u30fc\u30bf\u304c\u5229\u7528\u3067\u304d\u307e\u305b\u3093",
    "No upload links": "\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u306a\u3057",
    "No user shares": "\u30e6\u30fc\u30b6\u30fc\u5171\u6709\u306a\u3057",
    "No users found": "\u30e6\u30fc\u30b6\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093",
    "No version history": "\u30d0\u30fc\u30b8\u30e7\u30f3\u5c65\u6b74\u306f\u3042\u308a\u307e\u305b\u3093",
    "Node": "\u30ce\u30fc\u30c9",
    "None": "\u306a\u3057",
    "Not allow user to clean library trash": "\u30e6\u30fc\u30b6\u304c\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u30b4\u30df\u7bb1\u3092\u30af\u30ea\u30fc\u30f3\u3059\u308b\u3053\u3068\u3092\u8a31\u53ef\u3057\u306a\u3044",
    "Not allow user to create encrypted libraries": "\u30e6\u30fc\u30b6\u304c\u6697\u53f7\u5316\u3055\u308c\u305f\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u4f5c\u6210\u3059\u308b\u3053\u3068\u3092\u8a31\u53ef\u3057\u306a\u3044",
    "Note: Settings via web interface are saved in database table (seahub-db/constance_config). They have a higher priority over the settings in config files.": "\u6ce8\u610f: \u30a6\u30a7\u30d6\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30a4\u30b9\u3092\u4ecb\u3057\u305f\u8a2d\u5b9a\u306f\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u30c6\u30fc\u30d6\u30eb (seahub-db/constance_config) \u306b\u4fdd\u5b58\u3055\u308c\u307e\u3059\u3002\u3053\u308c\u3089\u306f\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8a2d\u5b9a\u3088\u308a\u3082\u512a\u5148\u5ea6\u304c\u9ad8\u304f\u306a\u308a\u307e\u3059\u3002",
    "Notification": "\u901a\u77e5",
    "Notification Detail": "\u901a\u77e5\u306e\u8a73\u7d30",
    "Notifications": "\u901a\u77e5",
    "Notifications of collaboration": "\u30b3\u30e9\u30dc\u30ec\u30fc\u30b7\u30e7\u30f3\u306e\u901a\u77e5",
    "Notifications of file changes": "\u30d5\u30a1\u30a4\u30eb\u306e\u5909\u66f4\u901a\u77e5",
    "Number": "\u6570\u5024",
    "Number format settings": "\u6570\u5024\u306e\u5f62\u5f0f\u8a2d\u5b9a",
    "Number of days ago": "\u6570\u65e5\u9593\u524d",
    "Number of days from now": "\u6570\u65e5\u9593\u5f8c",
    "Number of days that keep user sign in.": "\u30e6\u30fc\u30b6\u306e\u30ed\u30b0\u30a4\u30f3\u72b6\u614b\u3092\u7dad\u6301\u3059\u308b\u65e5\u6570\u3002",
    "Number of groups": "\u30b0\u30eb\u30fc\u30d7\u6570",
    "Number of links": "\u5171\u6709\u30ea\u30f3\u30af\u306e\u6570",
    "Number of members": "\u30e1\u30f3\u30d0\u6570",
    "Number of records exceeds the limit of 1000": "\u30ec\u30b3\u30fc\u30c9\u6570\u304c1000\u4ef6\u306e\u5236\u9650\u3092\u8d85\u3048\u3066\u3044\u307e\u3059",
    "OCR": "OCR",
    "OCR result": "OCR\u7d50\u679c",
    "Off": "\u30aa\u30d5",
    "Office Suite": "\u30aa\u30d5\u30a3\u30b9\u30b9\u30a4\u30fc\u30c8",
    "Old Password": "\u53e4\u3044\u30d1\u30b9\u30ef\u30fc\u30c9",
    "Old Wikis": "\u904e\u53bb\u306e Wiki",
    "On": "\u30aa\u30f3",
    "One month ago": "1\u30f6\u6708\u524d",
    "One month from now": "1\u30f6\u6708\u5f8c",
    "One week ago": "1\u9031\u9593\u524d",
    "One week from now": "1\u9031\u9593\u5f8c",
    "Online Preview": "\u30aa\u30f3\u30e9\u30a4\u30f3\u30d7\u30ec\u30d3\u30e5\u30fc",
    "Online Read-Only": "\u30aa\u30f3\u30e9\u30a4\u30f3\u8aad\u307f\u53d6\u308a\u5c02\u7528",
    "Online Read-Only folder": "\u30aa\u30f3\u30e9\u30a4\u30f3\u8aad\u307f\u53d6\u308a\u5c02\u7528\u30d5\u30a9\u30eb\u30c0",
    "Online Read-Only library": "\u30aa\u30f3\u30e9\u30a4\u30f3\u8aad\u307f\u53d6\u308a\u5c02\u7528\u30e9\u30a4\u30d6\u30e9\u30ea",
    "Online Read-Write": "\u30aa\u30f3\u30e9\u30a4\u30f3\u8aad\u307f\u66f8\u304d",
    "Online Read-Write folder": "\u30aa\u30f3\u30e9\u30a4\u30f3\u8aad\u307f\u66f8\u304d\u30d5\u30a9\u30eb\u30c0",
    "Online Read-Write library": "\u30aa\u30f3\u30e9\u30a4\u30f3\u8aad\u307f\u66f8\u304d\u30e9\u30a4\u30d6\u30e9\u30ea",
    "Online view is not applicable to this file format": "\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f\u306b\u306f\u30aa\u30f3\u30e9\u30a4\u30f3\u8868\u793a\u304c\u9069\u7528\u3055\u308c\u307e\u305b\u3093",
    "Only Show": "\u8868\u793a\u3059\u308b",
    "Only files": "\u30d5\u30a1\u30a4\u30eb\u306e\u307f",
    "Only folders": "\u30d5\u30a9\u30eb\u30c0\u306e\u307f",
    "Only keep a period of history:": "\u5c65\u6b74\u4fdd\u5b58\u671f\u9593: ",
    "Only pictures": "\u753b\u50cf\u306e\u307f",
    "Only videos": "\u52d5\u753b\u306e\u307f",
    "Open file": "\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f",
    "Open file in new tab": "\u65b0\u3057\u3044\u30bf\u30d6\u3067\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f",
    "Open folder": "\u30d5\u30a9\u30eb\u30c0\u3092\u958b\u304f",
    "Open folder in new tab": "\u65b0\u3057\u3044\u30bf\u30d6\u3067\u30d5\u30a9\u30eb\u30c0\u3092\u958b\u304f",
    "Open in new tab": "\u65b0\u3057\u3044\u30bf\u30d6\u3067\u958b\u304f",
    "Open parent folder": "\u89aa\u30d5\u30a9\u30eb\u30c0\u3092\u958b\u304f",
    "Open the panel": "\u30d1\u30cd\u30eb\u3092\u958b\u304f",
    "Open via Client": "\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u3067\u958b\u304f",
    "Open via client": "\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u3067\u958b\u304f",
    "Operation": "\u64cd\u4f5c",
    "Operation succeeded.": "\u64cd\u4f5c\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002",
    "Operations": "\u64cd\u4f5c",
    "Operator": "\u64cd\u4f5c\u5143",
    "Optional": "\u4efb\u610f",
    "Options imported": "\u30aa\u30d7\u30b7\u30e7\u30f3\u304c\u30a4\u30f3\u30dd\u30fc\u30c8\u3055\u308c\u307e\u3057\u305f",
    "Or": "OR",
    "Organization": "\u7d44\u7e54",
    "Organization Admin": "\u7d44\u7e54\u7ba1\u7406",
    "Organizations": "\u7d44\u7e54",
    "Original path": "\u5143\u306e\u30d1\u30b9",
    "Other": "\u305d\u306e\u4ed6",
    "Other Libraries": "\u73fe\u5728\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u30fc",
    "Others": "\u305d\u306e\u4ed6",
    "Out of quota.": "\u30af\u30a9\u30fc\u30bf\u3092\u8d85\u3048\u3066\u3044\u307e\u3059",
    "Outdated": "\u6642\u4ee3\u9045\u308c",
    "Outline": "\u30a2\u30a6\u30c8\u30e9\u30a4\u30f3",
    "Owned Libraries": "\u6240\u6709\u30e9\u30a4\u30d6\u30e9\u30ea",
    "Owner": "\u6240\u6709\u8005",
    "Owner can use admin panel in an organization, must be a new account.": "\u6240\u6709\u8005\u306f\u7d44\u7e54\u5185\u3067\u7ba1\u7406\u8005\u30d1\u30cd\u30eb\u3092\u4f7f\u7528\u3067\u304d\u3001\u65b0\u3057\u3044\u30a2\u30ab\u30a6\u30f3\u30c8\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002",
    "Packaging...": "\u30d1\u30c3\u30b1\u30fc\u30b8\u5316\u4e2d...",
    "Page fit": "\u30da\u30fc\u30b8\u30d5\u30a3\u30c3\u30c8",
    "Page imported": "\u30da\u30fc\u30b8\u304c\u30a4\u30f3\u30dd\u30fc\u30c8\u3055\u308c\u307e\u3057\u305f\u3002",
    "Page is frozen": "\u30da\u30fc\u30b8\u304c\u51cd\u7d50\u3055\u308c\u3066\u3044\u307e\u3059\u3002",
    "Page name": "\u30da\u30fc\u30b8\u540d",
    "Page {name_placeholder} deleted.": "\u30da\u30fc\u30b8 {name_placeholder} \u304c\u524a\u9664\u3055\u308c\u307e\u3057\u305f\u3002",
    "Pages": "\u30da\u30fc\u30b8",
    "Parent folder": "\u89aa\u30d5\u30a9\u30eb\u30c0",
    "Parent tags": "\u89aa\u30bf\u30b0",
    "Password": "\u30d1\u30b9\u30ef\u30fc\u30c9",
    "Password again": "\u30d1\u30b9\u30ef\u30fc\u30c9 (\u518d\u5165\u529b)",
    "Password cannot be blank": "\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u7a7a\u6b04\u306b\u3067\u304d\u307e\u305b\u3093",
    "Password is too short": "\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u77ed\u3059\u304e\u307e\u3059",
    "Password must be at least 8 characters long and contain different characters: uppercase letters, lowercase letters, numbers, and special symbols": "\u30d1\u30b9\u30ef\u30fc\u30c9\u306e\u9577\u3055\u306f\u5c11\u306a\u304f\u3068\u30828\u6587\u5b57\u3067\u3001\u5927\u6587\u5b57\u3001\u5c0f\u6587\u5b57\u3001\u6570\u5b57\u3001\u7279\u5225\u306a\u30b7\u30f3\u30dc\u30eb\u306a\u3069\u306e\u6587\u5b57\u304c\u542b\u307e\u308c\u3066\u3044\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002",
    "Password removed": "\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u524a\u9664\u3055\u308c\u307e\u3057\u305f",
    "Password reset": "\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u30ea\u30bb\u30c3\u30c8\u3055\u308c\u307e\u3057\u305f",
    "Password set": "\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u8a2d\u5b9a\u3055\u308c\u307e\u3057\u305f",
    "Password strength": "\u30d1\u30b9\u30ef\u30fc\u30c9\u306e\u5f37\u3055",
    "Password strength should be strong or very strong": "\u30d1\u30b9\u30ef\u30fc\u30c9\u306e\u5f37\u3055\u306f\u5f37\u304f\u3042\u308b\u3044\u306f\u975e\u5e38\u306b\u5f37\u304f\u306a\u308b\u3079\u304d\u3067\u3059",
    "Password updated": "\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f",
    "Passwords do not match.": "\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u4e00\u81f4\u3057\u3066\u3044\u307e\u305b\u3093",
    "Passwords don't match": "\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093",
    "Path": "\u30d1\u30b9",
    "People": "\u4eba\u7269",
    "Per 4 hours": "4\u6642\u9593\u3054\u3068",
    "Per day": "1\u65e5\u3054\u3068",
    "Per hour": "1\u6642\u9593\u3054\u3068",
    "Per week": "1\u9031\u9593\u3054\u3068",
    "Percent": "\u30d1\u30fc\u30bb\u30f3\u30c8",
    "Permission": "\u6a29\u9650",
    "Permission denied": "\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "Permission denied. Please try {placeholder-left}login again.{placeholder-right}": "\u30ed\u30b0\u30a4\u30f3\u304c\u5fc5\u8981\u3067\u3059\u3002\u518d\u5ea6\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
    "Permission name": "\u6a29\u9650\u306e\u540d\u79f0",
    "Person image": "\u4eba\u7269\u753b\u50cf",
    "Picture": "\u753b\u50cf",
    "Pictures and videos": "\u753b\u50cf\u3068\u52d5\u753b",
    "Platform": "\u30d7\u30e9\u30c3\u30c8\u30d5\u30a9\u30fc\u30e0",
    "Please check the network.": "\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u3092\u3054\u78ba\u8a8d\u304f\u3060\u3055\u3044\u3002",
    "Please choose a .xlsx file.": "Excel\u30d5\u30a1\u30a4\u30eb (.xlsx) \u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please choose an image file.": "\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
    "Please enter 1 or more character": "1\u6587\u5b57\u4ee5\u4e0a\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please enter a new password": "\u65b0\u3057\u3044\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please enter a new quota": "\u65b0\u3057\u3044\u30af\u30a9\u30fc\u30bf\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please enter a non-negative integer": "\u6b63\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please enter a password.": "\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please enter a positive integer": "\u6b63\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please enter an integer bigger than 1 as number of links.": "\u5171\u6709\u30ea\u30f3\u30af\u3092\u751f\u6210\u3067\u304d\u307e\u305b\u3093\u3002\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
    "Please enter an integer not bigger than {max_number} as number of links.": "\u5171\u6709\u30ea\u30f3\u30af\u3092\u751f\u6210\u3067\u304d\u307e\u305b\u3093\u3002\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u6700\u5927 {max_number} \u307e\u3067\u5165\u529b\u3067\u304d\u307e\u3059\u3002",
    "Please enter days": "\u65e5\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please enter password": "\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please enter the address": "\u4f4f\u6240\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please enter the new password again": "\u65b0\u3057\u3044\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please enter the old password": "\u53e4\u3044\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please enter the password again": "\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please input at least an email.": "1\u3064\u306e\u4ee5\u4e0a\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please select": "\u65e5\u4ed8\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please select a file": "\u30d5\u30a1\u30a4\u30eb\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please select a library or folder first.": "\u6700\u521d\u306b\u30e9\u30a4\u30d6\u30e9\u30ea\u30fc\u307e\u305f\u306f\u30d5\u30a9\u30eb\u30c0\u30fc\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
    "Please select a library to share.": "\u5171\u6709\u3059\u308b\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please select an expiration time": "\u6709\u52b9\u671f\u9650\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please turn on extended properties setting first": "\u5148\u306b\u62e1\u5f35\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u6709\u52b9\u306b\u3057\u3066\u304f\u3060\u3055\u3044",
    "Please upload no more than {maxFiles} files at a time.": "\u4e00\u5ea6\u306b\u6700\u5927 {maxFiles} \u30d5\u30a1\u30a4\u30eb\u307e\u3067\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u3067\u304d\u307e\u3059",
    "Precision": "\u7cbe\u5ea6",
    "Preparing to upload...": "\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u3092\u6e96\u5099\u4e2d...",
    "Preset hide properties": "\u30d7\u30ea\u30bb\u30c3\u30c8\u975e\u8868\u793a\u30d7\u30ed\u30d1\u30c6\u30a3",
    "Preview and download": "\u30d7\u30ec\u30d3\u30e5\u30fc\u3068\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9",
    "Preview online": "\u30aa\u30f3\u30e9\u30a4\u30f3\u3067\u78ba\u8a8d",
    "Preview only": "\u30d7\u30ec\u30d3\u30e5\u30fc\u306e\u307f",
    "Previous": "\u524d\u3078",
    "Previous (Left arrow key)": "\u524d\u3078 (\u5de6\u77e2\u5370\u30ad\u30fc)",
    "Print": "\u5370\u5237",
    "Print document": "\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u3092\u5370\u5237",
    "Professional Edition": "\u30d7\u30ed\u30d5\u30a7\u30c3\u30b7\u30e7\u30ca\u30eb\u30a8\u30c7\u30a3\u30b7\u30e7\u30f3",
    "Profile": "\u30d7\u30ed\u30d5\u30a3\u30fc\u30eb",
    "Profile Setting": "\u30d7\u30ed\u30d5\u30a3\u30fc\u30eb\u8a2d\u5b9a",
    "Properties": "\u30d7\u30ed\u30d1\u30c6\u30a3",
    "Properties to display on the card": "\u30ab\u30fc\u30c9\u4e0a\u306b\u8868\u793a\u3059\u308b\u30d7\u30ed\u30d1\u30c6\u30a3",
    "Property name": "\u30d7\u30ed\u30d1\u30c6\u30a3\u540d",
    "Publish": "\u516c\u958b",
    "Publish Wiki": "Wiki\u3092\u516c\u958b",
    "Published": "\u516c\u958b",
    "QR Code": "QR\u30b3\u30fc\u30c9",
    "Quota": "\u30af\u30a9\u30fc\u30bf",
    "Quota is invalid.": "\u30af\u30a9\u30fc\u30bf\u304c\u7121\u52b9\u3067\u3059\u3002",
    "Rate": "\u8a55\u4fa1",
    "Read-Only": "\u8aad\u307f\u53d6\u308a\u306e\u307f",
    "Read-Only folder": "\u8aad\u307f\u53d6\u308a\u5c02\u7528\u30d5\u30a9\u30eb\u30c0",
    "Read-Only library": "\u8aad\u307f\u53d6\u308a\u5c02\u7528\u30e9\u30a4\u30d6\u30e9\u30ea",
    "Read-Write": "\u8aad\u307f\u66f8\u304d",
    "Read-Write folder": "\u8aad\u307f\u66f8\u304d\u53ef\u80fd\u306a\u30d5\u30a9\u30eb\u30c0",
    "Read-Write library": "\u8aad\u307f\u66f8\u304d\u53ef\u80fd\u30e9\u30a4\u30d6\u30e9\u30ea",
    "Really want to delete this group?": "\u672c\u5f53\u306b\u524a\u9664\u3057\u307e\u3059\u304b\uff1f",
    "Really want to delete your account?": "\u672c\u5f53\u306b\u30a2\u30ab\u30a6\u30f3\u30c8\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f",
    "Really want to leave this group?": "\u672c\u5f53\u306b\u3053\u306e\u30b0\u30eb\u30fc\u30d7\u304b\u3089\u9000\u4f1a\u3057\u307e\u3059\u304b\uff1f",
    "Recently Used": "\u6700\u8fd1\u4f7f\u7528\u3057\u305f",
    "Recently used tags": "\u6700\u8fd1\u4f7f\u7528\u3055\u308c\u305f\u30bf\u30b0",
    "Recognizing portraits. Please refresh the page later.": "\u8096\u50cf\u3092\u8a8d\u8b58\u4e2d\u3067\u3059\u3002\u5f8c\u3067\u30da\u30fc\u30b8\u3092\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
    "Recommended new tags": "\u63a8\u5968\u65b0\u30bf\u30b0",
    "Refresh": "\u66f4\u65b0",
    "Refresh the view": "\u8868\u793a\u3092\u66f4\u65b0",
    "Remaining": "\u6b8b\u308a",
    "Remove": "\u524a\u9664",
    "Remove Member": "\u30e1\u30f3\u30d0\u3092\u524a\u9664",
    "Remove from this group": "\u3053\u306e\u30b0\u30eb\u30fc\u30d7\u304b\u3089\u524a\u9664",
    "Removed all items from trash": "\u30b4\u30df\u7bb1\u5185\u306e\u3059\u3079\u3066\u306e\u30a2\u30a4\u30c6\u30e0\u3092\u524a\u9664\u3057\u307e\u3057\u305f",
    "Removed items older than {n} days from trash": "{n}\u65e5\u4ee5\u4e0a\u53e4\u3044\u30a2\u30a4\u30c6\u30e0\u3092\u30b4\u30df\u7bb1\u304b\u3089\u524a\u9664\u3057\u307e\u3057\u305f",
    "Rename": "\u540d\u524d\u306e\u5909\u66f4",
    "Rename Department": "\u90e8\u9580\u3092\u540d\u524d\u3092\u5909\u66f4",
    "Rename File": "\u30d5\u30a1\u30a4\u30eb\u3092\u6539\u540d",
    "Rename Folder": "\u30d5\u30a9\u30eb\u30c0\u306e\u540d\u524d\u3092\u5909\u66f4",
    "Rename Group": "\u30b0\u30eb\u30fc\u30d7\u306e\u540d\u524d\u3092\u5909\u66f4",
    "Rename Library": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u6539\u540d",
    "Rename Wiki": "Wiki\u3092\u6539\u540d",
    "Rename Wiki to": "Wiki \u3092\u6539\u540d",
    "Rename file": "\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u5909\u66f4",
    "Rename file to": "\u30d5\u30a1\u30a4\u30eb\u3092\u6539\u540d",
    "Rename folder": "\u30d5\u30a9\u30eb\u30c0\u540d\u3092\u5909\u66f4",
    "Rename folder to": "\u30d5\u30a9\u30eb\u30c0\u3092\u6539\u540d",
    "Rename group to": "\u30b0\u30eb\u30fc\u30d7\u306e\u540d\u524d\u3092",
    "Rename property": "\u30d7\u30ed\u30d1\u30c6\u30a3\u540d\u3092\u5909\u66f4",
    "Renamed file": "\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u5909\u66f4\u3057\u307e\u3057\u305f",
    "Renamed folder": "\u30d5\u30a9\u30eb\u30c0\u540d\u3092\u5909\u66f4\u3057\u307e\u3057\u305f",
    "Renamed library": "\u30e9\u30a4\u30d6\u30e9\u30ea\u540d\u3092\u5909\u66f4\u3057\u307e\u3057\u305f",
    "Renamed or Moved files": "\u30d5\u30a1\u30a4\u30eb\u306e\u79fb\u52d5\u307e\u305f\u306f\u540d\u524d\u304c\u5909\u66f4\u3055\u308c\u307e\u3057\u305f",
    "Renaming {name} failed": "{name} \u306e\u540d\u524d\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Replace": "\u4ee3\u308b",
    "Replace file {filename}?": "\u30d5\u30a1\u30a4\u30eb {filename} \u3092\u7f6e\u304d\u63db\u3048\u307e\u3059\u304b\uff1f",
    "Replacing it will overwrite its content.": "\u7f6e\u304d\u63db\u3048\u308b\u3068\u3001\u305d\u306e\u5185\u5bb9\u304c\u4e0a\u66f8\u304d\u3055\u308c\u307e\u3059\u3002",
    "Repo Transfer": "\u30ea\u30dd\u30b8\u30c8\u30ea\u8ee2\u9001",
    "Report Abuse": "\u4e0d\u6b63\u5229\u7528\u3092\u5831\u544a",
    "Reporter": "\u5831\u544a\u8005",
    "Reports": "\u30ec\u30dd\u30fc\u30c8",
    "Required at least three letters.": "3\u6587\u5b57\u4ee5\u4e0a\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
    "Reset": "\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u30ea\u30bb\u30c3\u30c8",
    "Reset Password": "\u30d1\u30b9\u30ef\u30fc\u30c9\u306e\u518d\u8a2d\u5b9a",
    "Reset WebDAV Password": "WebDAV\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u30ea\u30bb\u30c3\u30c8",
    "Reset library password": "\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u30ea\u30bb\u30c3\u30c8",
    "ResetPwd": "ResetPwd",
    "Resetting user's password, please wait for a moment.": "\u30e6\u30fc\u30b6\u306e\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u30ea\u30bb\u30c3\u30c8\u4e2d\u3067\u3059\u3002\u3057\u3070\u3089\u304f\u304a\u5f85\u3061\u304f\u3060\u3055\u3044\u3002",
    "Resolved comments": "\u89e3\u6c7a\u6e08\u307f\u306e\u30b3\u30e1\u30f3\u30c8",
    "Restore": "\u5fa9\u5143",
    "Restore Library": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u5fa9\u5143",
    "Restored 1 item": "1\u4ef6\u306e\u9805\u76ee\u304c\u5fa9\u5143\u3055\u308c\u307e\u3057\u305f",
    "Restored file": "\u30d5\u30a1\u30a4\u30eb\u3092\u5fa9\u5143\u3057\u307e\u3057\u305f",
    "Restored folder": "\u30d5\u30a9\u30eb\u30c0\u3092\u5fa9\u5143\u3057\u307e\u3057\u305f",
    "Restored library": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u5fa9\u5143\u3057\u307e\u3057\u305f",
    "Restored {name}": "{name}\u3092\u5fa9\u5143\u3057\u307e\u3057\u305f",
    "Restored {name} and {n} other items": "{name}\u3068{n}\u500b\u306e\u4ed6\u306e\u30a2\u30a4\u30c6\u30e0\u3092\u5fa9\u5143\u3057\u307e\u3057\u305f",
    "Resubmit": "\u518d\u63d0\u51fa",
    "Result": "\u7d50\u679c",
    "Retry": "\u518d\u8a66\u884c",
    "Retry All": "\u5168\u3066\u3092\u518d\u8a66\u884c",
    "Revoke": "\u7ba1\u7406\u8005\u6a29\u9650\u3092\u53d6\u308a\u6d88\u3059",
    "Revoke Access": "\u30a2\u30af\u30bb\u30b9\u6a29\u3092\u53d6\u308a\u6d88\u3059",
    "Revoke Admin": "\u7ba1\u7406\u6a29\u9650\u306e\u53d6\u308a\u5916\u3057",
    "Role": "\u5f79\u5272",
    "Rotate": "\u56de\u8ee2",
    "SAML config": "SAML\u8a2d\u5b9a",
    "SAML config updated": "SAML\u8a2d\u5b9a\u304c\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f",
    "SSO": "SSO",
    "Satellite": "\u822a\u7a7a\u5199\u771f",
    "Save": "\u4fdd\u5b58",
    "Save Selected Items": "\u9078\u629e\u3057\u305f\u30a2\u30a4\u30c6\u30e0\u3092\u4fdd\u5b58",
    "Save as ...": "\u540d\u524d\u3092\u4ed8\u3051\u3066\u4fdd\u5b58",
    "Save to description field": "\u8aac\u660e\u6b04\u306b\u4fdd\u5b58",
    "Save to:": "\u4fdd\u5b58\u5148\uff1a",
    "Saving...": "\u4fdd\u5b58\u4e2d...",
    "Scan the QR code to view the shared content directly": "QR\u30b3\u30fc\u30c9\u306e\u8aad\u307f\u53d6\u308a\u3067\u5185\u5bb9\u3092\u78ba\u8a8d\u3067\u304d\u307e\u3059",
    "SeaTable integration": "SeaTable\u7d71\u5408",
    "Seafile": "Seafile",
    "Search": "\u691c\u7d22",
    "Search Groups": "\u30b0\u30eb\u30fc\u30d7\u3092\u691c\u7d22",
    "Search Libraries": "\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u691c\u7d22",
    "Search Organizations": "\u7d44\u7e54\u306e\u691c\u7d22",
    "Search Users": "\u30e6\u30fc\u30b6\u3092\u691c\u7d22",
    "Search collaborator": "\u5354\u4f5c\u8005\u3092\u691c\u7d22",
    "Search collaborators": "\u5354\u529b\u8005\u3092\u691c\u7d22",
    "Search department": "\u90e8\u7f72\u3092\u691c\u7d22",
    "Search departments": "\u90e8\u9580\u3092\u691c\u7d22",
    "Search failed": "\u691c\u7d22\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "Search failed. Please try again.": "\u691c\u7d22\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u3082\u3046\u4e00\u5ea6\u304a\u8a66\u3057\u304f\u3060\u3055\u3044\u3002",
    "Search files": "\u30d5\u30a1\u30a4\u30eb\u3092\u691c\u7d22",
    "Search files in this library": "\u3053\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u691c\u7d22",
    "Search group members": "\u30b0\u30eb\u30fc\u30d7\u30e1\u30f3\u30d0\u3092\u691c\u7d22",
    "Search groups": "\u30b0\u30eb\u30fc\u30d7\u3092\u691c\u7d22",
    "Search groups by name": "\u30b0\u30eb\u30fc\u30d7\u540d\u3067\u691c\u7d22",
    "Search in trash": "\u30b4\u30df\u7bb1\u5185\u3092\u691c\u7d22",
    "Search in trash...": "\u30b4\u30df\u7bb1\u3092\u691c\u7d22\u4e2d...",
    "Search libraries by name or ID": "\u30e9\u30a4\u30d6\u30e9\u30ea\u30fc\u3092\u540d\u524d\u307e\u305f\u306fID\u3067\u691c\u7d22",
    "Search libraries by owner": "\u30aa\u30fc\u30ca\u30fc\u3067\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u691c\u7d22",
    "Search option": "\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u691c\u7d22",
    "Search organizations": "\u7d44\u7e54\u306e\u691c\u7d22",
    "Search properties": "\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u691c\u7d22",
    "Search property": "\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u691c\u7d22",
    "Search results": "\u691c\u7d22\u7d50\u679c",
    "Search results visited recently": "\u6700\u8fd1\u306e\u691c\u7d22\u7d50\u679c",
    "Search service unavailable": "\u691c\u7d22\u30b5\u30fc\u30d3\u30b9\u304c\u5229\u7528\u3067\u304d\u307e\u305b\u3093",
    "Search tag": "\u30bf\u30b0\u3092\u691c\u7d22",
    "Search user": "\u30e6\u30fc\u30b6\u3092\u691c\u7d22",
    "Search users": "\u30e6\u30fc\u30b6\u3092\u691c\u7d22",
    "Search users...": "\u30e6\u30fc\u30b6\u306e\u691c\u7d22\u4e2d...",
    "Searching...": "\u691c\u7d22\u4e2d...",
    "Select": "\u9078\u629e",
    "Select File": "\u30d5\u30a1\u30a4\u30eb\u3092\u9078\u629e",
    "Select a Confluence HTML export file (.html.zip)": "Confluence HTML\u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u9078\u629e (.html.zip)",
    "Select a Confluence HTML exported file (.html.zip)": "Confluence HTML\u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u9078\u629e (.html.zip)",
    "Select a Confluence exported file": "Confluence\u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u9078\u629e",
    "Select a department": "\u90e8\u9580\u3092\u9078\u629e",
    "Select a server": "\u30b5\u30fc\u30d0\u30fc\u3092\u9078\u629e",
    "Select a user": "\u30e6\u30fc\u30b6\u3092\u9078\u629e\u3057\u307e\u3059",
    "Select a user as admin": "\u7ba1\u7406\u8005\u3092\u8ffd\u52a0\u3059\u308b\u30e6\u30fc\u30b6\u3092\u9078\u629e",
    "Select all": "\u3059\u3079\u3066\u9078\u629e",
    "Select all items": "\u3059\u3079\u3066\u306e\u30a2\u30a4\u30c6\u30e0\u3092\u9078\u629e",
    "Select an office suite": "\u30aa\u30d5\u30a3\u30b9\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u3092\u9078\u629e",
    "Select an option": "\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u9078\u629e",
    "Select collaborators": "\u5171\u540c\u4f5c\u6210\u8005\u3092\u9078\u629e",
    "Select group members": "\u30b0\u30eb\u30fc\u30d7\u30e1\u30f3\u30d0\u3092\u9078\u629e",
    "Select image": "\u753b\u50cf\u3092\u9078\u629e",
    "Select items": "\u30a2\u30a4\u30c6\u30e0\u3092\u9078\u629e",
    "Select libraries to share": "\u5171\u6709\u3059\u308b\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u9078\u629e\u3059\u308b",
    "Select members from department": "\u90e8\u9580\u304b\u3089\u30e1\u30f3\u30d0\u3092\u9078\u629e",
    "Select option(s)": "\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u9078\u629e",
    "Select shared users": "\u30e6\u30fc\u30b6\u3092\u9078\u629e",
    "Select tag": "\u30bf\u30b0\u3092\u9078\u629e",
    "Select target department": "\u8ee2\u9001\u5148\u306e\u90e8\u9580\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044",
    "Select this item": "\u3053\u306e\u30a2\u30a4\u30c6\u30e0\u3092\u9078\u629e",
    "Select up to 50 files": "\u6700\u592750\u500b\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044",
    "Select users": "\u30e6\u30fc\u30b6\u3092\u9078\u629e",
    "Selected": "\u9078\u629e\u6e08\u307f",
    "Send": "\u9001\u4fe1",
    "Send activation Email after user registration.": "\u30e6\u30fc\u30b6\u767b\u9332\u5f8c\u306b\u30a2\u30af\u30c6\u30a3\u30d9\u30fc\u30b7\u30e7\u30f3\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3057\u307e\u3059\u3002",
    "Send activation email": "\u30a2\u30af\u30c6\u30a3\u30d9\u30fc\u30b7\u30e7\u30f3\u30e1\u30fc\u30eb\u3092\u9001\u4fe1",
    "Send to:": "\u9001\u4fe1\u5148\uff1a",
    "Sending new password...": "\u65b0\u3057\u3044\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u9001\u4fe1\u3057\u3066\u3044\u307e\u3059...",
    "Sending...": "\u9001\u4fe1\u4e2d...",
    "Separate multiple suffixes by \",\"(like sdoc, pdf)": "\u8907\u6570\u306e suffix \u3092 \",\" \u3067\u533a\u5207\u3063\u3066\u5165\u529b (\u4f8b: sdoc, pdf)",
    "Server": "\u30b5\u30fc\u30d0",
    "Server Version: ": "\u30d0\u30fc\u30b8\u30e7\u30f3: ",
    "Set": "\u8a2d\u5b9a",
    "Set Admin": "\u7ba1\u7406\u6a29\u9650\u3092\u8a2d\u5b9a",
    "Set Contact Email": "\u9023\u7d61\u5148\u30e1\u30fc\u30eb\u3092\u8a2d\u5b9a",
    "Set Download Rate Limit": "\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u7387\u306e\u5236\u9650\u3092\u8a2d\u5b9a",
    "Set Login ID": "\u30ed\u30b0\u30a4\u30f3ID\u3092\u8a2d\u5b9a",
    "Set Name": "\u8a2d\u5b9a\u540d\u524d",
    "Set Password": "\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u8a2d\u5b9a",
    "Set Quota": "\u6700\u5927\u5229\u7528\u53ef\u80fd\u5bb9\u91cf\u8a2d\u5b9a",
    "Set Upload Rate Limit": "\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u7387\u306e\u5236\u9650\u3092\u8a2d\u5b9a",
    "Set WebDAV Password": "WebDAV\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u8a2d\u5b9a",
    "Set access scope": "\u30a2\u30af\u30bb\u30b9\u7bc4\u56f2\u3092\u8a2d\u5b9a",
    "Set as cover photo": "\u8868\u7d19\u5199\u771f\u3068\u3057\u3066\u8a2d\u5b9a",
    "Set child tags": "\u5b50\u30bf\u30b0\u3092\u8a2d\u5b9a",
    "Set max number of members": "\u30e1\u30f3\u30d0\u306e\u6700\u5927\u6570\u3092\u8a2d\u5b9a",
    "Set organization inactive": "\u7d44\u7e54\u3092\u975e\u30a2\u30af\u30c6\u30a3\u30d6\u306b\u8a2d\u5b9a\u3057\u307e\u3057\u305f\u3002",
    "Set password": "\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u8a2d\u5b9a",
    "Set permission": "\u8a31\u53ef\u3092\u8a2d\u5b9a",
    "Set permission of {placeholder}": "{placeholder} \u306e\u6a29\u9650\u3092\u8a2d\u5b9a\u3059\u308b",
    "Set quota": "\u30c7\u30d1\u30fc\u30c8\u30e1\u30f3\u30c8\u306e\u30af\u30a9\u30fc\u30bf\u3092\u8a2d\u5b9a",
    "Set to current": "\u901a\u77e5\u9818\u57df\u306b\u8868\u793a\u3059\u308b",
    "Set user contact email": "\u30e6\u30fc\u30b6\u306e\u9023\u7d61\u5148\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u3092\u8a2d\u5b9a",
    "Set user default quota": "\u30e6\u30fc\u30b6\u306e\u65e2\u5b9a\u30af\u30a9\u30fc\u30bf\u3092\u8a2d\u5b9a",
    "Set user inactive": "\u30e6\u30fc\u30b6\u304c\u975e\u30a2\u30af\u30c6\u30a3\u30d6\u306b\u306a\u308a\u307e\u3057\u305f",
    "Set user name": "\u30e6\u30fc\u30b6\u540d\u3092\u8a2d\u5b9a",
    "Set user quota": "\u30e6\u30fc\u30b6\u30af\u30a9\u30fc\u30bf\u3092\u8a2d\u5b9a",
    "Setting library history is disabled by Admin.": "\u30e9\u30a4\u30d6\u30e9\u30ea\u5c65\u6b74\u306e\u8a2d\u5b9a\u306f\u7ba1\u7406\u8005\u306b\u3088\u3063\u3066\u7121\u52b9\u5316\u3055\u308c\u3066\u3044\u307e\u3059",
    "Setting updated": "\u8a2d\u5b9a\u304c\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f",
    "Settings": "\u8a2d\u5b9a",
    "Share": "\u5171\u6709",
    "Share Admin": "\u5171\u6709\u7ba1\u7406",
    "Share From": "\u5171\u6709\u5143",
    "Share Link": "\u5171\u6709\u30ea\u30f3\u30af",
    "Share Link Traffic": "\u5171\u6709\u30ea\u30f3\u30af\u306e\u30c8\u30e9\u30d5\u30a3\u30c3\u30af",
    "Share Links": "\u30ea\u30f3\u30af\u3092\u5171\u6709",
    "Share To": "\u5171\u6709\u5148",
    "Share To:": "\u5171\u6709\u5148\uff1a",
    "Share existing libraries": "\u65e2\u5b58\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u5171\u6709",
    "Share link download": "\u5171\u6709\u30ea\u30f3\u30af\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9",
    "Share link is copied to the clipboard.": "\u5171\u6709\u30ea\u30f3\u30af\u304c\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3059",
    "Share link upload": "\u5171\u6709\u30ea\u30f3\u30af\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9",
    "Share links cannot be generated because \"Invisible\", \"Online Read-Write\" or \"Online Read-Only\" is set for you on some folder(s) in the library.": "\u5171\u6709\u30ea\u30f3\u30af\u3092\u751f\u6210\u3067\u304d\u307e\u305b\u3093\u3002\"\u4e0d\u53ef\u8996\", \"\u30aa\u30f3\u30e9\u30a4\u30f3 \u8aad\u307f\u53d6\u308a/\u66f8\u304d\u8fbc\u307f\" \u307e\u305f\u306f \"\u30aa\u30f3\u30e9\u30a4\u30f3 \u8aad\u307f\u53d6\u308a\u5c02\u7528\" \u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u30d5\u30a9\u30eb\u30c0\u30fc\u304c\u3042\u308a\u307e\u3059\u3002",
    "Share to group": "\u30b0\u30eb\u30fc\u30d7\u306b\u5171\u6709",
    "Share to other server": "\u4ed6\u306e\u30b5\u30fc\u30d0\u30fc\u3068\u5171\u6709\u3059\u308b",
    "Share to user": "\u30e6\u30fc\u30b6\u306b\u5171\u6709",
    "Share/upload link force password": "\u5171\u6709/\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u3067\u306e\u30d1\u30b9\u30ef\u30fc\u30c9\u5fc5\u9808\u5316",
    "Share/upload link password minimum length": "\u5171\u6709/\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u306e\u30d1\u30b9\u30ef\u30fc\u30c9\u6700\u5c0f\u6587\u5b57\u6570",
    "Share/upload link password strength level": "\u5171\u6709/\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u306e\u30d1\u30b9\u30ef\u30fc\u30c9\u5f37\u5ea6\u30ec\u30d9\u30eb",
    "Shared By": "\u5171\u6709\u8005",
    "Shared Libraries": "\u5171\u6709\u30e9\u30a4\u30d6\u30e9\u30ea",
    "Shared Links": "\u5171\u6709\u30ea\u30f3\u30af",
    "Shared by:": "\u5171\u6709\u5143:",
    "Shared by: ": "\u5171\u6709\u8005\uff1a",
    "Shared from other servers": "\u4ed6\u306e\u30b5\u30fc\u30d0\u30fc\u304b\u3089\u5171\u6709",
    "Shared with all": "\u3059\u3079\u3066\u5171\u6709",
    "Shared with me": "\u79c1\u3068\u5171\u6709",
    "Sharing Time": "\u5171\u6709\u65e5\u6642",
    "Show": "\u8868\u793a",
    "Show Codes": "\u30b3\u30fc\u30c9\u3092\u8868\u793a",
    "Show advanced search": "\u9ad8\u5ea6\u306a\u691c\u7d22\u3092\u8868\u793a",
    "Show all": "\u3059\u3079\u3066\u8868\u793a",
    "Show changes": "\u5909\u66f4\u3092\u8868\u793a",
    "Show daily history": "\u65e5\u6b21\u5c65\u6b74\u3092\u8868\u793a",
    "Show property names": "\u30d7\u30ed\u30d1\u30c6\u30a3\u540d\u3092\u8868\u793a",
    "Side Nav Menu": "\u30b5\u30a4\u30c9\u30ca\u30d3\u30b2\u30fc\u30b7\u30e7\u30f3\u30e1\u30cb\u30e5\u30fc",
    "Single Sign On (SSO)": "\u30b7\u30f3\u30b0\u30eb\u30b5\u30a4\u30f3\u30aa\u30f3 (SSO)",
    "Single select": "\u5358\u4e00\u9078\u629e",
    "Site name": "\u30b5\u30a4\u30c8\u540d",
    "Site name used in email sending": "\u30e1\u30fc\u30eb\u9001\u4fe1\u3067\u4f7f\u7528\u3055\u308c\u308b\u30b5\u30a4\u30c8\u540d",
    "Site title": "\u30b5\u30a4\u30c8\u30bf\u30a4\u30c8\u30eb",
    "Site title shown in a browser tab": "\u30d6\u30e9\u30a6\u30b6\u30bf\u30d6\u306b\u8868\u793a\u3055\u308c\u308b\u30b5\u30a4\u30c8\u30bf\u30a4\u30c8\u30eb",
    "Size": "\u30b5\u30a4\u30ba",
    "Sort": "\u4e26\u3079\u66ff\u3048",
    "Sort ascending": "\u6607\u9806\u3067\u4e26\u3079\u66ff\u3048",
    "Sort descending": "\u964d\u9806\u3067\u4e26\u3079\u66ff\u3048",
    "Space (1 000 000)": "\u30b9\u30da\u30fc\u30b9\u533a\u5207\u308a (1 000 000)",
    "Space Used": "\u5229\u7528\u91cf",
    "Space Used / Quota": "\u4f7f\u7528\u91cf / \u4e0a\u9650",
    "Space used": "\u4f7f\u7528\u6e08\u307f\u30b9\u30da\u30fc\u30b9",
    "Specific people with email address": "\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u3092\u6301\u3064\u7279\u5b9a\u306e\u4eba",
    "Specific users in the team": "\u30c1\u30fc\u30e0\u5185\u306e\u7279\u5b9a\u306e\u30e6\u30fc\u30b6",
    "Star": "\u661f",
    "Start date": "\u958b\u59cb\u65e5",
    "Statistic": "\u7d71\u8a08",
    "Statistics": "\u7d71\u8a08",
    "Status": "\u72b6\u614b",
    "Status: enabled": "\u72b6\u614b: \u6709\u52b9",
    "Storage": "\u30b9\u30c8\u30ec\u30fc\u30b8",
    "Storage Backend": "\u30b9\u30c8\u30ec\u30fc\u30b8\u30d0\u30c3\u30af\u30a8\u30f3\u30c9",
    "Storage Used": "\u4f7f\u7528\u30b9\u30c8\u30ec\u30fc\u30b8",
    "Strong password": "\u5f37\u529b\u306a\u30d1\u30b9\u30ef\u30fc\u30c9",
    "Style": "\u30b9\u30bf\u30a4\u30eb",
    "Submit": "\u767b\u9332",
    "Success": "\u6210\u529f",
    "Successfully added %s.": "\u6210\u529f\u3057\u3066 %s \u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f",
    "Successfully added label(s) for library {placeholder}": "\u30e9\u30a4\u30d6\u30e9\u30ea {placeholder} \u306b\u30e9\u30d9\u30eb\u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f\u3002",
    "Successfully added the file.": "\u30d5\u30a1\u30a4\u30eb\u304c\u6210\u529f\u3057\u3066\u8ffd\u52a0\u3055\u308c\u307e\u3057\u305f\u3002",
    "Successfully added {email_placeholder}": "{email_placeholder}\u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f",
    "Successfully change the group": "\u30b0\u30eb\u30fc\u30d7\u3092\u6210\u529f\u3057\u3066\u5909\u66f4\u3057\u307e\u3057\u305f\u3002",
    "Successfully changed library password.": "\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u30d1\u30b9\u30ef\u30fc\u30c9\u306f\u6b63\u5e38\u306b\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f",
    "Successfully changed the office suite.": "\u30aa\u30d5\u30a3\u30b9\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u304c\u6b63\u5e38\u306b\u5909\u66f4\u3055\u308c\u307e\u3057\u305f\u3002",
    "Successfully cleaned all errors.": "\u3059\u3079\u3066\u306e\u30a8\u30e9\u30fc\u3092\u6210\u529f\u3057\u3066\u30af\u30ea\u30fc\u30f3\u30a2\u30c3\u30d7\u3057\u307e\u3057\u305f\u3002",
    "Successfully cleaned invalid share links.": "\u7121\u52b9\u306a\u5171\u6709\u30ea\u30f3\u30af\u304c\u30af\u30ea\u30fc\u30f3\u3055\u308c\u307e\u3057\u305f\u3002",
    "Successfully cleaned invalid upload links.": "\u7121\u52b9\u306a\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u304c\u30af\u30ea\u30fc\u30f3\u3055\u308c\u307e\u3057\u305f\u3002",
    "Successfully cleared trash.": "\u30b4\u30df\u7bb1\u3092\u6210\u529f\u3057\u3066\u30af\u30ea\u30a2\u3057\u307e\u3057\u305f\u3002",
    "Successfully converted the file.": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u5909\u63db\u3067\u304d\u307e\u3057\u305f\u3002",
    "Successfully copied %(name)s and %(amount)s other items.": "%(name)s \u306e\u307b\u304b%(amount)s\u9805\u76ee\u3092\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f\u3002",
    "Successfully copied %(name)s and 1 other item.": " %(name)s \u307b\u304b\uff11\u9805\u76ee\u3092\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f\u3002",
    "Successfully copied %(name)s.": "\u300c%(name)s\u300d\u3092\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f\u3002",
    "Successfully copied files to another library.": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u30b3\u30d4\u30fc\u3067\u304d\u307e\u3057\u305f\u3002",
    "Successfully copied {name} and {n} other items": "{name}\u3068{n}\u500b\u306e\u4ed6\u306e\u30a2\u30a4\u30c6\u30e0\u3092\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f",
    "Successfully deleted 1 item": "1 \u3064\u306e\u30a2\u30a4\u30c6\u30e0\u3092\u6b63\u5e38\u306b\u524a\u9664\u3057\u307e\u3057\u305f",
    "Successfully deleted 1 item.": "1\u3064\u306e\u30a2\u30a4\u30c6\u30e0\u3092\u6b63\u5e38\u306b\u524a\u9664\u3057\u307e\u3057\u305f",
    "Successfully deleted 1 share link": "1 \u5171\u6709\u30ea\u30f3\u30af\u3092\u524a\u9664\u3057\u307e\u3057\u305f",
    "Successfully deleted 1 upload link": "1 \u3064\u306e\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u3092\u6b63\u5e38\u306b\u524a\u9664\u3057\u307e\u3057\u305f",
    "Successfully deleted 1 user.": "1 \u30e6\u30fc\u30b6\u3092\u524a\u9664\u3057\u307e\u3057\u305f\u3002",
    "Successfully deleted {name}": "{name} \u3092\u6b63\u5e38\u306b\u524a\u9664\u3057\u307e\u3057\u305f",
    "Successfully deleted {name} and {n} other items": "{name} \u3068\u305d\u306e\u4ed6 {n} \u500b\u306e\u30a2\u30a4\u30c6\u30e0\u3092\u6b63\u5e38\u306b\u524a\u9664\u3057\u307e\u3057\u305f",
    "Successfully deleted {name} and {n} other items.": "{name}\u3068{n}\u500b\u306e\u4ed6\u306e\u30a2\u30a4\u30c6\u30e0\u3092\u524a\u9664\u3057\u307e\u3057\u305f\u3002",
    "Successfully deleted {name}.": "\u6210\u529f\u3057\u3066 {name} \u3092\u524a\u9664\u3057\u307e\u3057\u305f\u3002",
    "Successfully deleted {number_placeholder} share links": "{number_placeholder} \u5171\u6709\u30ea\u30f3\u30af\u3092\u524a\u9664\u3057\u307e\u3057\u305f",
    "Successfully deleted {number_placeholder} upload links": "{number_placeholder} \u500b\u306e\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u3092\u6b63\u5e38\u306b\u524a\u9664\u3057\u307e\u3057\u305f",
    "Successfully deleted {user_number_placeholder} users.": "{user_number_placeholder} \u30e6\u30fc\u30b6\u3092\u524a\u9664\u3057\u307e\u3057\u305f\u3002",
    "Successfully edited labels.": "\u30e9\u30d9\u30eb\u3092\u7de8\u96c6\u3057\u307e\u3057\u305f",
    "Successfully imported tags.": "\u30bf\u30b0\u304c\u30a4\u30f3\u30dd\u30fc\u30c8\u3055\u308c\u307e\u3057\u305f\u3002",
    "Successfully imported {user_placeholder}": "{user_placeholder} \u306e\u30a4\u30f3\u30dd\u30fc\u30c8\u306b\u6210\u529f\u3057\u307e\u3057\u305f",
    "Successfully invited %(email) and %(num) other people.": "\u30e6\u30fc\u30b6 %(email) \u3068 %(num) \u4eba\u306e\u4ed6\u306e\u30e6\u30fc\u30b6\u304c\u62db\u5f85\u3055\u308c\u307e\u3057\u305f\u3002",
    "Successfully invited %(email).": "\u30e6\u30fc\u30b6 %(email) \u304c\u62db\u5f85\u3055\u308c\u307e\u3057\u305f\u3002",
    "Successfully modified permission.": "\u6a29\u9650\u306e\u5909\u66f4\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002",
    "Successfully moved %(name)s and %(amount)s other items.": "%(name)s \u306e\u307b\u304b%(amount)s\u9805\u76ee\u3092\u79fb\u52d5\u3057\u307e\u3057\u305f\u3002",
    "Successfully moved %(name)s and 1 other item.": " %(name)s \u307b\u304b\uff11\u9805\u76ee\u3092\u79fb\u52d5\u3057\u307e\u3057\u305f\u3002",
    "Successfully moved %(name)s.": "\u300c%(name)s\u300d\u3092\u79fb\u52d5\u3057\u307e\u3057\u305f\u3002",
    "Successfully moved files to another library.": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u79fb\u52d5\u3067\u304d\u307e\u3057\u305f\u3002",
    "Successfully moved {name} and {n} other items": "{name}\u3068{n}\u500b\u306e\u4ed6\u306e\u30a2\u30a4\u30c6\u30e0\u3092\u79fb\u52d5\u3057\u307e\u3057\u305f",
    "Successfully moved {name}.": "{name}\u3092\u79fb\u52d5\u3057\u307e\u3057\u305f\u3002",
    "Successfully removed {placeholder}.": "{placeholder}\u3092\u524a\u9664\u3057\u307e\u3057\u305f\u3002",
    "Successfully renamed the library.": "\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u540d\u524d\u304c\u5909\u66f4\u3055\u308c\u307e\u3057\u305f",
    "Successfully restored the library {library_name}.": "{library_name} \u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u5fa9\u5143\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002",
    "Successfully restored the library.": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u6210\u529f\u3057\u3066\u5fa9\u5143\u3057\u307e\u3057\u305f\u3002",
    "Successfully restored.": "\u6b63\u5e38\u306b\u5fa9\u5143\u3055\u308c\u307e\u3057\u305f\u3002",
    "Successfully revoke the admin permission of %s": "%s \u306e\u7ba1\u7406\u6a29\u9650\u3092\u5265\u596a\u3057\u307e\u3057\u305f\u3002",
    "Successfully revoked access of user {placeholder}.": "\u30e6\u30fc\u30b6 {placeholder} \u306e\u30a2\u30af\u30bb\u30b9\u6a29\u304c\u53d6\u308a\u6d88\u3055\u308c\u307e\u3057\u305f\u3002",
    "Successfully revoked the admin permission of {placeholder}.": "\u30e6\u30fc\u30b6\u30fc{placeholder}\u306e\u7ba1\u7406\u8005\u6a29\u9650\u3092\u53d6\u308a\u6d88\u3057\u307e\u3057\u305f\u3002",
    "Successfully saved": "\u6210\u529f\u3057\u3066\u4fdd\u5b58\u3057\u307e\u3057\u305f",
    "Successfully sent to {placeholder}": "\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9 {placeholder} \u306b\u6210\u529f\u7684\u306b\u9001\u4fe1\u3057\u307e\u3057\u305f",
    "Successfully set %s as admin.": "%s \u3092\u7ba1\u7406\u8005\u306b\u8a2d\u5b9a\u3057\u307e\u3057\u305f\u3002",
    "Successfully set it.": "\u6b63\u5e38\u306b\u8a2d\u5b9a\u3057\u307e\u3057\u305f",
    "Successfully set library history.": "\u30e9\u30a4\u30d6\u30e9\u30ea\u5c65\u6b74\u3092\u6b63\u5e38\u306b\u8a2d\u5b9a\u3057\u307e\u3057\u305f",
    "Successfully set quota.": "\u30af\u30a9\u30fc\u30bf\u3092\u8a2d\u5b9a\u3057\u307e\u3057\u305f\u3002",
    "Successfully starred {library_name_placeholder}.": "{library_name_placeholder} \u3092\u661f\u4ed8\u3051\u3057\u307e\u3057\u305f\u3002",
    "Successfully starred {name_placeholder}.": "{name_placeholder} \u306e\u661f\u304c\u4ed8\u304d\u307e\u3057\u305f",
    "Successfully transferred the group.": "\u30b0\u30eb\u30fc\u30d7\u3092\u8ee2\u9001\u3057\u307e\u3057\u305f",
    "Successfully transferred the library.": "\u30e9\u30a4\u30d6\u30e9\u30ea\u304c\u8ee2\u9001\u3055\u308c\u307e\u3057\u305f",
    "Successfully unlinked %(name)s.": "\u64cd\u4f5c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002%(name)s \u3092\u30ea\u30f3\u30af\u89e3\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002",
    "Successfully unlinked the device.": "\u30c7\u30d0\u30a4\u30b9\u3092\u6210\u529f\u3057\u3066\u30a2\u30f3\u30ea\u30f3\u30af\u3057\u307e\u3057\u305f\u3002",
    "Successfully unshared library {placeholder}": "\u30e9\u30a4\u30d6\u30e9\u30ea{placeholder}\u306e\u5171\u6709\u3092\u5916\u3057\u307e\u3057\u305f",
    "Successfully unshared {name}": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u6210\u529f\u3057\u3066\u30a2\u30f3\u30b7\u30a7\u30a2\u3057\u307e\u3057\u305f {name}\u3002",
    "Successfully unstarred {library_name_placeholder}.": "{library_name_placeholder} \u3092\u661f\u4ed8\u3051\u89e3\u9664\u3057\u307e\u3057\u305f\u3002",
    "Successfully unstarred {name_placeholder}.": "{name_placeholder} \u306e\u661f\u304c\u5916\u308c\u307e\u3057\u305f",
    "Successfully unwatched the library.": "\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u76e3\u8996\u304c\u505c\u6b62\u3055\u308c\u307e\u3057\u305f",
    "Successfully watched the library.": "\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u76e3\u8996\u304c\u958b\u59cb\u3055\u308c\u307e\u3057\u305f",
    "Suggestion": "\u63d0\u6848",
    "Switch sort mode": "\u30bd\u30fc\u30c8\u30e2\u30fc\u30c9\u3092\u5207\u308a\u66ff\u3048\u308b",
    "Switch to plain text editor": "\u30d7\u30ec\u30fc\u30f3\u30c6\u30ad\u30b9\u30c8\u30a8\u30c7\u30a3\u30bf\u30fc\u306b\u5207\u308a\u66ff\u3048",
    "Switch to rich text editor": "\u30ea\u30c3\u30c1\u30c6\u30ad\u30b9\u30c8\u30a8\u30c7\u30a3\u30bf\u30fc\u306b\u5207\u308a\u66ff\u3048",
    "Switch view mode": "\u30d3\u30e5\u30fc\u30e2\u30fc\u30c9\u3092\u5207\u308a\u66ff\u3048",
    "Symbol position": "\u901a\u8ca8\u8a18\u53f7\u306e\u4f4d\u7f6e",
    "Sync": "\u540c\u671f",
    "Sync Download": "Sync\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9",
    "Sync Traffic": "\u540c\u671f\u30c8\u30e9\u30d5\u30a3\u30c3\u30af",
    "Sync Upload": "\u540c\u671f\u306e\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9",
    "System": "\u30b7\u30b9\u30c6\u30e0",
    "System Admin": "\u30b7\u30b9\u30c6\u30e0\u7ba1\u7406",
    "System Info": "\u30b7\u30b9\u30c6\u30e0\u60c5\u5831",
    "System settings updated": "\u30b7\u30b9\u30c6\u30e0\u8a2d\u5b9a\u304c\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f",
    "Table": "\u8868",
    "Tag": "\u30bf\u30b0",
    "Tag not found": "\u5229\u7528\u53ef\u80fd\u306a\u30aa\u30d7\u30b7\u30e7\u30f3\u304c\u3042\u308a\u307e\u305b\u3093",
    "Tagged Files": "\u30bf\u30b0\u4ed8\u304d\u30d5\u30a1\u30a4\u30eb",
    "Tags": "\u30bf\u30b0",
    "Tags migrated successfully": "\u30bf\u30b0\u306e\u79fb\u884c\u306b\u6210\u529f\u3057\u307e\u3057\u305f",
    "Team deleted": "\u30c1\u30fc\u30e0\u304c\u524a\u9664\u3055\u308c\u307e\u3057\u305f\u3002",
    "Team name": "\u30c1\u30fc\u30e0\u540d",
    "Template": "\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8",
    "Terms": "\u6761\u9805",
    "Terms and Conditions": "\u5229\u7528\u898f\u7d04",
    "Text": "\u672c\u6587",
    "Text file extensions": "\u30c6\u30ad\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u62e1\u5f35\u5b50",
    "Text is required.": "\u30c6\u30ad\u30b9\u30c8\u304c\u5fc5\u8981",
    "Text wraps": "\u30c6\u30ad\u30b9\u30c8\u3092\u6298\u308a\u8fd4\u3059",
    "The content of the document has exceeded the limit of 100000 characters, and only the first 100000 characters are saved": "\u6587\u66f8\u306e\u5185\u5bb9\u304c100,000\u6587\u5b57\u306e\u5236\u9650\u3092\u8d85\u3048\u3066\u304a\u308a\u3001\u6700\u521d\u306e100,000\u6587\u5b57\u306e\u307f\u304c\u4fdd\u5b58\u3055\u308c\u307e\u3059",
    "The content of the document has exceeded the limit of 100000 characters, and the content cannot be saved": "\u6587\u66f8\u306e\u5185\u5bb9\u304c100,000\u6587\u5b57\u306e\u5236\u9650\u3092\u8d85\u3048\u3066\u304a\u308a\u3001\u5185\u5bb9\u3092\u4fdd\u5b58\u3067\u304d\u307e\u305b\u3093",
    "The current quota for {group_name} is {quota}": "\u30b0\u30eb\u30fc\u30d7 {group_name} \u306e\u73fe\u5728\u306e\u30af\u30a9\u30fc\u30bf\u306f {quota} \u3067\u3059",
    "The custom part of the URL must be between 5 and 30 characters long and may only contain letters (a-z), numbers, and hyphens.": "URL\u306e\u30ab\u30b9\u30bf\u30e0\u30d1\u30fc\u30c8\u306f5\u301c30\u6587\u5b57\u306e\u9577\u3055\u3067\u306a\u3051\u308c\u3070\u306a\u3089\u305a\u3001\u6587\u5b57\uff08a\u301cz\uff09\u3001\u6570\u5b57\u3001\u30cf\u30a4\u30d5\u30f3\u306e\u307f\u3092\u542b\u3080\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002",
    "The file is too large. Allowed maximum size is 1MB.": "\u30d5\u30a1\u30a4\u30eb\u304c\u5927\u304d\u3059\u304e\u307e\u3059\u3002\u8a31\u53ef\u3055\u308c\u308b\u6700\u5927\u30b5\u30a4\u30ba\u306f 1MB \u3067\u3059\u3002",
    "The image could not be previewed.": "\u753b\u50cf\u3092\u8868\u793a\u3067\u304d\u307e\u305b\u3093\u3002",
    "The import process may take several minutes depending on the size of your Confluence export.": "\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba\u306b\u3088\u308a\u3001\u53d6\u308a\u8fbc\u307f\u51e6\u7406\u306b\u6570\u5206\u304b\u304b\u308b\u5834\u5408\u304c\u3042\u308a\u307e\u3059\u3002",
    "The imported options already exists": "\u30a4\u30f3\u30dd\u30fc\u30c8\u3057\u305f\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059",
    "The imported options are invalid": "\u30a4\u30f3\u30dd\u30fc\u30c8\u3057\u305f\u30aa\u30d7\u30b7\u30e7\u30f3\u304c\u7121\u52b9\u3067\u3059",
    "The least number of characters a share/upload link password should include.": "\u5171\u6709/\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u306e\u30d1\u30b9\u30ef\u30fc\u30c9\u306b\u542b\u307e\u308c\u308b\u6700\u5c0f\u6587\u5b57\u6570\u3002",
    "The least number of characters an encrypted library password should include.": "\u6697\u53f7\u5316\u3055\u308c\u305f\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u30d1\u30b9\u30ef\u30fc\u30c9\u306b\u542b\u307e\u308c\u308b\u6700\u5c0f\u6587\u5b57\u6570\u3002",
    "The level(1-4) of a share/upload link password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols": "\u5171\u6709/\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u306e\u30d1\u30b9\u30ef\u30fc\u30c9\u306e\u5f37\u3055\u306e\u30ec\u30d9\u30eb(1-4)\u3002\u305f\u3068\u3048\u3070\u3001\u300c3\u300d\u3068\u306f\u3001\u30d1\u30b9\u30ef\u30fc\u30c9\u306b\u306f\u4ee5\u4e0b\u306e\u5c11\u306a\u304f\u3068\u30823\u3064\u304c\u542b\u307e\u308c\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\uff1a\u6570\u5b57\u3001\u4e0a\u6587\u5b57\u3001\u4e0b\u6587\u5b57\u304a\u3088\u3073\u305d\u306e\u4ed6\u306e\u30b7\u30f3\u30dc\u30eb",
    "The link is copied to the clipboard.": "\u30ea\u30f3\u30af\u304c\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3059",
    "The list of added, deleted and modified files will be sent to your mailbox.": "\u8ffd\u52a0\u3001\u524a\u9664\u3001\u5909\u66f4\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u306e\u30ea\u30b9\u30c8\u304c\u30e1\u30fc\u30eb\u30dc\u30c3\u30af\u30b9\u306b\u9001\u4fe1\u3055\u308c\u307e\u3059\u3002",
    "The maximum number of failed login attempts before showing CAPTCHA.": "CAPTCHA\u3092\u8868\u793a\u3059\u308b\u524d\u306e\u6700\u5927\u30ed\u30b0\u30a4\u30f3\u5931\u6557\u56de\u6570\u3002",
    "The name \"{name}\" is already taken. Please choose a different name.": "\u540d\u524d \"{name}\" \u306f\u65e2\u306b\u4f7f\u7528\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u5225\u306e\u540d\u524d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
    "The next month": "\u6b21\u306e1\u30f6\u6708\u9593",
    "The next numbers of days": "\u4eca\u5f8c\u6570\u65e5\u9593",
    "The next week": "\u6b21\u306e1\u9031\u9593",
    "The next year": "\u6b21\u306e1\u5e74\u9593",
    "The owner of this library has run out of space.": "\u3053\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u30aa\u30fc\u30ca\u30fc\u306e\u30b9\u30c8\u30ec\u30fc\u30b8\u5bb9\u91cf\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002",
    "The password is too short.": "\u77ed\u3059\u304e\u308b\u30d1\u30b9\u30ef\u30fc\u30c9\u3067\u3059",
    "The password is too weak. It should include at least {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols.": "\u8106\u5f31\u306a\u30d1\u30b9\u30ef\u30fc\u30c9\u3067\u3059\u3002\u6570\u5b57, \u30a2\u30eb\u30d5\u30a1\u30d9\u30c3\u30c8\u5927\u6587\u5b57\u30fb\u5c0f\u6587\u5b57, \u305d\u306e\u4ed6\u306e\u8a18\u53f7\u306e\u3046\u3061\u3001\u6700\u4f4e{passwordStrengthLevel}\u7a2e\u985e\u3092\u542b\u3081\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002",
    "The password will be kept in the server for only 1 hour.": "\u30d1\u30b9\u30ef\u30fc\u30c9\u306f1\u6642\u9593\u306b\u9650\u308a\u30b5\u30fc\u30d0\u306b\u4fdd\u7ba1\u3055\u308c\u307e\u3059",
    "The past month": "\u904e\u53bb1\u30f6\u6708\u9593",
    "The past numbers of days": "\u904e\u53bb\u6570\u65e5\u9593",
    "The past week": "\u904e\u53bb1\u9031\u9593",
    "The past year": "\u904e\u53bb1\u5e74\u9593",
    "The path has been copied to the clipboard": "\u30d1\u30b9\u304c\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3057\u305f",
    "The row is locked and cannot be modified": "\u884c\u306f\u30ed\u30c3\u30af\u3055\u308c\u3066\u304a\u308a\u3001\u5909\u66f4\u3067\u304d\u307e\u305b\u3093",
    "The uploaded image has not been saved yet. Please close this page later.": "\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u3055\u308c\u305f\u753b\u50cf\u306f\u307e\u3060\u4fdd\u5b58\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u5f8c\u3067\u3053\u306e\u30da\u30fc\u30b8\u3092\u9589\u3058\u3066\u304f\u3060\u3055\u3044\u3002",
    "There is another option with this name": "\u540c\u3058\u540d\u524d\u306e\u5225\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u304c\u5b58\u5728\u3057\u307e\u3059",
    "There is another property with this name": "\u540c\u3058\u540d\u524d\u306e\u30d7\u30ed\u30d1\u30c6\u30a3\u304c\u3042\u308a\u307e\u3059",
    "There is no information to display.": "\u8868\u793a\u3059\u308b\u60c5\u5831\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "This file has (apparently) not been accessed yet": "\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u306b\u306f (\u304a\u305d\u3089\u304f) \u307e\u3060\u30a2\u30af\u30bb\u30b9\u304c\u3042\u308a\u307e\u305b\u3093",
    "This file has been updated.": "\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u306f\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f",
    "This folder has been shared to {user_amount} user(s) and {group_amount} group(s).": "\u3053\u306e\u30d5\u30a9\u30eb\u30c0\u306f\u3001 {user_amount}\u4eba\u306e\u30e6\u30fc\u30b6\u3068 {group_amount}\u3064\u306e\u30b0\u30eb\u30fc\u30d7\u306b\u5171\u6709\u3055\u308c\u3066\u3044\u307e\u3059\u3002",
    "This folder has no content at this time.": "\u3053\u306e\u30d5\u30a9\u30eb\u30c0\u30fc\u306b\u306f\u73fe\u5728\u4f55\u3082\u3042\u308a\u307e\u305b\u3093",
    "This is a special group representing a department.": "\u3053\u308c\u306f\u90e8\u7f72\u3092\u8868\u3059\u7279\u5225\u306a\u30b0\u30eb\u30fc\u30d7\u3067\u3059\u3002",
    "This is required": "\u5fc5\u9808\u3067\u3059",
    "This library contains tags of old version. Do you like to migrate the tags to new version?": "\u3053\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u306b\u306f\u3001\u53e4\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u30bf\u30b0\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002\u65b0\u3057\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u30bf\u30b0\u3092\u79fb\u884c\u3057\u307e\u3059\u304b\uff1f",
    "This library has been set to read-only by admin and cannot be updated.": "\u3053\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u7ba1\u7406\u8005\u306b\u3088\u3063\u3066\u8aad\u307f\u53d6\u308a\u5c02\u7528\u306b\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u3001\u66f4\u65b0\u3067\u304d\u307e\u305b\u3093\u3002",
    "This library has been shared to {user_amount} user(s) and {group_amount} group(s).": "\u3053\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u3001 {user_amount}\u4eba\u306e\u30e6\u30fc\u30b6\u3068 {group_amount}\u3064\u306e\u30b0\u30eb\u30fc\u30d7\u306b\u5171\u6709\u3055\u308c\u3066\u3044\u307e\u3059\u3002",
    "This library is password protected": "\u3053\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u30d1\u30b9\u30ef\u30fc\u30c9\u3067\u4fdd\u8b77\u3055\u308c\u3066\u3044\u307e\u3059",
    "This list is collapsed": "\u3053\u306e\u30ea\u30b9\u30c8\u306f\u6298\u308a\u305f\u305f\u307e\u308c\u3066\u3044\u307e\u3059",
    "This month": "\u4eca\u6708",
    "This operation will not be reverted. Please think twice!": "\u3053\u306e\u64cd\u4f5c\u306f\u30ad\u30e3\u30f3\u30bb\u30eb\u3067\u304d\u307e\u305b\u3093\u3002\u3088\u304f\u8003\u3048\u3066\uff01",
    "This property can not be deleted": "\u3053\u306e\u30d7\u30ed\u30d1\u30c6\u30a3\u306f\u524a\u9664\u3067\u304d\u307e\u305b\u3093",
    "This property does not support sorting": "\u3053\u306e\u30d7\u30ed\u30d1\u30c6\u30a3\u306f\u4e26\u3079\u66ff\u3048\u3092\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093",
    "This property is not editable": "\u3053\u306e\u30d7\u30ed\u30d1\u30c6\u30a3\u306f\u7de8\u96c6\u3067\u304d\u307e\u305b\u3093",
    "This user has not created or joined any groups": "\u3053\u306e\u30e6\u30fc\u30b6\u306f\u30b0\u30eb\u30fc\u30d7\u3092\u4f5c\u6210\u3057\u305f\u308a\u53c2\u52a0\u3057\u305f\u308a\u3057\u3066\u3044\u307e\u305b\u3093",
    "This week": "\u4eca\u9031",
    "This year": "\u4eca\u5e74",
    "Thousands separator": "\u5343\u306e\u533a\u5207\u308a",
    "Thumbnail": "\u30b5\u30e0\u30cd\u30a4\u30eb",
    "Time": "\u65e5\u6642",
    "Tip: -2 means no limit.": "\u30d2\u30f3\u30c8\uff1a-2\u306f\u5236\u9650\u306a\u3057\u3092\u610f\u5473\u3057\u307e\u3059\u3002",
    "Tip: 0 means default limit": "\u30d2\u30f3\u30c8\uff1a 0 \u306f\u65e2\u5b9a\u5024\u3092\u610f\u5473\u3057\u307e\u3059",
    "Tip: 0 means default limit, the unit is MB": "\u30d2\u30f3\u30c8\uff1a0\u306f\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u5236\u9650\u3092\u610f\u5473\u3057\u3001\u5358\u4f4d\u306fMB\u3067\u3059",
    "Tip: a snapshot will be generated after modification, which records the library state after the modification.": "\u30d2\u30f3\u30c8: \u5909\u66f4\u5f8c\u306b\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8\u304c\u751f\u6210\u3055\u308c\u3001\u5909\u66f4\u5f8c\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u72b6\u614b\u304c\u8a18\u9332\u3055\u308c\u307e\u3059\u3002",
    "Tip: libraries deleted {placeholder} days ago will be cleaned automatically.": "\u30d2\u30f3\u30c8: {placeholder} \u65e5\u524d\u306b\u524a\u9664\u3055\u308c\u305f\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u81ea\u52d5\u7684\u306b\u30af\u30ea\u30fc\u30f3\u30a2\u30c3\u30d7\u3055\u308c\u307e\u3059\u3002",
    "Tip: libraries deleted {trashReposExpireDays} days ago will be cleaned automatically.": "\u30d2\u30f3\u30c8: {trashReposExpireDays} \u65e5\u524d\u306b\u524a\u9664\u3055\u308c\u305f\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u81ea\u52d5\u7684\u306b\u30af\u30ea\u30fc\u30f3\u30a2\u30c3\u30d7\u3055\u308c\u307e\u3059\u3002",
    "Tip: you can search by keyword in name or ID.": "\u30d2\u30f3\u30c8: \u540d\u524d\u307e\u305f\u306f ID \u3067\u30ad\u30fc\u30ef\u30fc\u30c9\u3092\u691c\u7d22\u3067\u304d\u307e\u3059\u3002",
    "Tip: you can search by keyword in name.": "\u30d2\u30f3\u30c8\uff1a\u540d\u524d\u306b\u30ad\u30fc\u30ef\u30fc\u30c9\u3092\u5165\u529b\u3057\u3066\u691c\u7d22\u3067\u304d\u307e\u3059",
    "Tips: There are tags of old version. Please migrate tags to new version.": "\u30d2\u30f3\u30c8\uff1a\u53e4\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u30bf\u30b0\u304c\u5b58\u5728\u3057\u307e\u3059\u3002\u65b0\u3057\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u30bf\u30b0\u306b\u30de\u30a4\u30b0\u30ec\u30fc\u30c8\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
    "Tips: These are tags of old version. The feature is deprecated and can no longer be used.": "\u30d2\u30f3\u30c8\uff1a\u53e4\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u30bf\u30b0\u304c\u5b58\u5728\u3057\u307e\u3059\u3002\u3053\u306e\u6a5f\u80fd\u306f\u975e\u63a8\u5968\u3067\u3042\u308a\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002",
    "Title property": "\u30bf\u30a4\u30c8\u30eb\u30d7\u30ed\u30d1\u30c6\u30a3",
    "To confirm, type \"{placeholder}\" in the box below": "\u78ba\u8a8d\u306e\u305f\u3081\u3001\u4e0b\u306e\u30dc\u30c3\u30af\u30b9\u306b \"{placeholder}\" \u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044",
    "Today": "\u4eca\u65e5",
    "Toggle children": "\u5b50\u8981\u7d20\u3092\u5207\u308a\u66ff\u3048",
    "Toggle repo selector": "\u30ea\u30dd\u30b8\u30c8\u30ea\u30bb\u30ec\u30af\u30bf\u3092\u5207\u308a\u66ff\u3048",
    "Toggle selector menu": "\u30bb\u30ec\u30af\u30bf\u30fc\u30e1\u30cb\u30e5\u30fc\u3092\u5207\u308a\u66ff\u3048\u308b",
    "Toggle user selector": "\u30e6\u30fc\u30b6\u30fc\u30bb\u30ec\u30af\u30bf\u3092\u5207\u308a\u66ff\u3048",
    "Token": "\u30c8\u30fc\u30af\u30f3",
    "Token:": "\u30c8\u30fc\u30af\u30f3:",
    "Tomorrow": "\u660e\u65e5",
    "Too many requests": "\u30ea\u30af\u30a8\u30b9\u30c8\u304c\u591a\u3059\u304e\u307e\u3059",
    "Total Devices": "\u7dcf\u30c7\u30d0\u30a4\u30b9\u6570",
    "Total Storage": "\u7dcf\u30b9\u30c8\u30ec\u30fc\u30b8",
    "Total Traffic": "\u7dcf\u30c8\u30e9\u30d5\u30a3\u30c3\u30af",
    "Total Users": "\u7dcf\u30e6\u30fc\u30b6\u6570",
    "Total users": "\u5168\u3066\u306e\u30e6\u30fc\u30b6",
    "Total {comments_count} comment": "\u30b3\u30e1\u30f3\u30c8 {comments_count} \u4ef6",
    "Total {comments_count} comments": "\u30b3\u30e1\u30f3\u30c8 {comments_count} \u4ef6",
    "Traffic": "\u901a\u4fe1\u91cf",
    "Traffic exceeded": "\u7d44\u7e54\u306e\u6d41\u91cf\u5236\u9650\u3092\u8d85\u3048\u307e\u3057\u305f\u3002",
    "Traffic this month": "\u6708\u9593\u6d41\u91cf",
    "Transfer": "\u79fb\u8ee2",
    "Transfer From": "\u8ee2\u9001\u5143",
    "Transfer Group": "\u8ee2\u9001\u30b0\u30eb\u30fc\u30d7",
    "Transfer Group {placeholder} to": "\u30b0\u30eb\u30fc\u30d7 {placeholder} \u3092\u8ee2\u9001\u5148\u306b\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044",
    "Transfer Library": "\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u79fb\u8ee2",
    "Transfer Library {library_name}": "\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u8ee2\u9001\u3059\u308b{library_name}",
    "Transfer To": "\u8ee2\u9001\u5148",
    "Transfer group to": "\u30b0\u30eb\u30fc\u30d7\u3092\u306b\u8ee2\u9001",
    "Transfer to department": "\u90e8\u9580\u306b\u8ee2\u9001",
    "Transfer to user": "\u30e6\u30fc\u30b6\u306b\u8ee2\u9001",
    "Transferred group {group_name} from {user_from} to {user_to}": "\u30b0\u30eb\u30fc\u30d7{group_name}\u3092{user_from}\u304b\u3089{user_to}\u306b\u8ee2\u9001\u3057\u307e\u3057\u305f",
    "Transferred library {library_name} from {user_from} to {user_to}": "\u30e9\u30a4\u30d6\u30e9\u30ea{library_name}\u3092{user_from}\u304b\u3089{user_to}\u306b\u8ee2\u9001\u3057\u307e\u3057\u305f",
    "Trash": "\u30b4\u30df\u7bb1",
    "Turn off": "\u7121\u52b9\u306b\u3059\u308b",
    "Turn off extended properties": "\u62e1\u5f35\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u7121\u52b9\u306b\u3059\u308b",
    "Turn off face recognition": "\u30d5\u30a7\u30fc\u30b9\u8a8d\u8b58\u3092\u7121\u52b9\u306b\u3059\u308b\u3068\u3001\u5199\u771f\u5185\u306e\u4eba\u7269\u3092\u8a8d\u8b58\u3067\u304d\u307e\u305b\u3093\u3002",
    "Turn off tags": "\u30bf\u30b0\u3092\u7121\u52b9\u306b\u3059\u308b",
    "Turn on extensible properties and views to experience a new way of managing files": "\u62e1\u5f35\u30d7\u30ed\u30f3\u30d7\u30c8\u3092\u6709\u52b9\u306b\u3059\u308b\u3068\u3001\u30d5\u30a1\u30a4\u30eb\u306e\u7ba1\u7406\u65b9\u6cd5\u3092\u65b0\u3057\u3044\u65b9\u6cd5\u3067\u4f53\u9a13\u3067\u304d\u307e\u3059",
    "Two-Factor Authentication": "2\u6bb5\u968e\u8a8d\u8a3c",
    "Two-factor authentication is not enabled for your account. Enable two-factor authentication for enhanced account security.": "\u30a2\u30ab\u30a6\u30f3\u30c8\u306b2\u6bb5\u968e\u8a8d\u8a3c\u304c\u6709\u52b9\u306b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u30a2\u30ab\u30a6\u30f3\u30c8\u306e\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u3092\u9ad8\u3081\u308b\u305f\u3081\u306b\u30012\u6bb5\u968e\u8a8d\u8a3c\u3092\u6709\u52b9\u306b\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
    "Type": "\u7a2e\u985e",
    "Type characters to start search": "\u691c\u7d22\u3092\u958b\u59cb\u3059\u308b\u306b\u306f\u6587\u5b57\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044",
    "URL is copied to the clipboard": "URL\u304c\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3057\u305f",
    "URL is required": "URL\u304c\u5fc5\u8981\u3067\u3059",
    "US": "US\u5f62\u5f0f",
    "Uncategorized": "\u5206\u985e\u3055\u308c\u3066\u3044\u306a\u3044",
    "Undo": "\u5143\u306b\u623b\u3059",
    "Unfold": "\u5c55\u958b\u3059\u308b",
    "Unfold the sidebar": "\u30b5\u30a4\u30c9\u30d0\u30fc\u3092\u5c55\u958b",
    "Unfreeze Document": "\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u306e\u51cd\u7d50\u3092\u89e3\u9664",
    "Unhandled": "\u672a\u51e6\u7406",
    "Unknown": "\u4e0d\u660e",
    "Unknown people": "\u672a\u77e5\u306e\u4eba\u7269",
    "Unlink": "\u9023\u643a\u3092\u89e3\u9664",
    "Unlink device": "\u30c7\u30d0\u30a4\u30b9\u306e\u9023\u643a\u3092\u89e3\u9664",
    "Unlock": "\u30ed\u30c3\u30af\u89e3\u9664",
    "Unpublish": "Wiki\u3092\u975e\u516c\u958b",
    "Unpublish Wiki": "Wiki \u3092\u975e\u516c\u958b",
    "Unresolved comments": "\u672a\u89e3\u6c7a\u306e\u30b3\u30e1\u30f3\u30c8",
    "Unselect": "\u9078\u629e\u89e3\u9664",
    "Unselect all": "\u9078\u629e\u3092\u3059\u3079\u3066\u89e3\u9664",
    "Unselect all items": "\u3059\u3079\u3066\u306e\u30a2\u30a4\u30c6\u30e0\u3092\u9078\u629e\u89e3\u9664",
    "Unselect items": "\u30a2\u30a4\u30c6\u30e0\u3092\u9078\u629e\u89e3\u9664",
    "Unselect this item": "\u3053\u306e\u30a2\u30a4\u30c6\u30e0\u3092\u9078\u629e\u89e3\u9664",
    "Unshare": "\u5171\u6709\u3092\u5916\u3059",
    "Unshare Library": "\u30e9\u30a4\u30d6\u30e9\u30ea\u5171\u6709\u3092\u5916\u3059",
    "Unstar": "\u661f\u3092\u5916\u3059",
    "Untitled": "\u7121\u984c",
    "Unwatch File Changes": "\u30d5\u30a1\u30a4\u30eb\u5909\u66f4\u306e\u76e3\u8996\u3092\u505c\u6b62",
    "Up": "\u4e0a",
    "Update": "\u66f4\u65b0",
    "Update Terms and Conditions": "\u5229\u7528\u898f\u7d04\u306e\u66f4\u65b0",
    "Update password": "\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u66f4\u65b0",
    "Update succeeded.": "\u66f4\u65b0\u5b8c\u4e86",
    "Update time": "\u66f4\u65b0\u6642\u9593",
    "Updated draft": "\u30c9\u30e9\u30d5\u30c8\u3092\u66f4\u65b0\u3057\u307e\u3057\u305f",
    "Updated file": "\u30d5\u30a1\u30a4\u30eb\u3092\u66f4\u65b0\u3057\u307e\u3057\u305f",
    "Upgrade to Pro Edition": "\u30d7\u30ed\u30d5\u30a7\u30c3\u30b7\u30e7\u30ca\u30eb\u30a8\u30c7\u30a3\u30b7\u30e7\u30f3\u306b\u30a2\u30c3\u30d7\u30b0\u30ec\u30fc\u30c9",
    "Upload": "\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9",
    "Upload Files": "\u30d5\u30a1\u30a4\u30eb\u306e\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9",
    "Upload Folder": "\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u3059\u308b\u30d5\u30a9\u30eb\u30c0",
    "Upload Link": "\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u7528\u30ea\u30f3\u30af",
    "Upload Links": "\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af",
    "Upload failed": "\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u5931\u6557",
    "Upload file": "\u30d5\u30a1\u30a4\u30eb\u3092\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9",
    "Upload files to": "\u3053\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u306b\u30d5\u30a1\u30a4\u30eb\u3092\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u3059\u308b",
    "Upload license": "\u30e9\u30a4\u30bb\u30f3\u30b9\u3092\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9",
    "Upload link is copied to the clipboard.": "\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u7528\u30ea\u30f3\u30af\u304c\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3057\u305f",
    "Uploaded": "\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u6e08\u307f",
    "Uploading...": "\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u4e2d...",
    "Use custom CSS": "\u30ab\u30b9\u30bf\u30e0CSS\u3092\u4f7f\u7528\u3059\u308b",
    "Use information from your Identity Provider to configure Seafile": "Identity Provider\u304b\u3089\u306e\u60c5\u5831\u3092\u4f7f\u7528\u3057\u3066Seafile\u3092\u8a2d\u5b9a\u3059\u308b",
    "Use the import/export function to transfer options quickly. (The export is in JSON format.) By pasting cells, copied from a text column, an Excel or a TXT file, you can also add options quickly.": "\u30a4\u30f3\u30dd\u30fc\u30c8/\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u6a5f\u80fd\u3092\u4f7f\u7528\u3057\u3066\u3001\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u7d20\u65e9\u304f\u8ee2\u9001\u3067\u304d\u307e\u3059\u3002\uff08\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u306fJSON\u5f62\u5f0f\u3067\u3059\u3002\uff09\u30c6\u30ad\u30b9\u30c8\u5217\u3001Excel\u3001\u307e\u305f\u306fTXT\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u30b3\u30d4\u30fc\u3057\u305f\u30bb\u30eb\u3092\u8cbc\u308a\u4ed8\u3051\u308b\u3053\u3068\u3067\u3001\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u7d20\u65e9\u304f\u8ffd\u52a0\u3059\u308b\u3053\u3068\u3082\u3067\u304d\u307e\u3059\u3002",
    "Use these values to configure your Identity Provider": "Identity Provider\u3092\u8a2d\u5b9a\u3059\u308b\u305f\u3081\u306b\u3001\u4ee5\u4e0b\u306e\u5024\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044",
    "Used:": "\u4f7f\u7528: ",
    "User": "\u30e6\u30fc\u30b6",
    "User Email": "\u30e6\u30fc\u30b6\u306e\u30e1\u30fc\u30eb",
    "User ID": "\u30e6\u30fc\u30b6\u30fcID",
    "User Permission": "\u30e6\u30fc\u30b6\u6a29\u9650",
    "User Shares": "\u30e6\u30fc\u30b6\u5171\u6709",
    "User Storage": "\u30e6\u30fc\u30b6\u306e\u30b9\u30c8\u30ec\u30fc\u30b8",
    "User can not see this folder.": "\u30e6\u30fc\u30b6\u306f\u3053\u306e\u30d5\u30a9\u30eb\u30c0\u3092\u8868\u793a\u3067\u304d\u307e\u305b\u3093\u3002",
    "User can only view files online via browser. Files can't be downloaded.": "\u30e6\u30fc\u30b6\u306f\u30d6\u30e9\u30a6\u30b6\u7d4c\u7531\u3067\u306e\u307f\u30d5\u30a1\u30a4\u30eb\u3092\u30aa\u30f3\u30e9\u30a4\u30f3\u3067\u8868\u793a\u3067\u304d\u307e\u3059\u3002\u30d5\u30a1\u30a4\u30eb\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002",
    "User can read, download and sync files.": "\u30e6\u30fc\u30b6\u306f\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u53d6\u308a\u3001\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3001\u540c\u671f\u3067\u304d\u307e\u3059\u3002",
    "User can read, write, upload, download and sync files.": "\u30e6\u30fc\u30b6\u306f\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u53d6\u308a\u3001\u66f8\u304d\u8fbc\u307f\u3001\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u3001\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3001\u540c\u671f\u3092\u884c\u3046\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002",
    "User can view and edit file online via browser. Files can't be downloaded.": "\u30e6\u30fc\u30b6\u306f\u30d6\u30e9\u30a6\u30b6\u7d4c\u7531\u3067\u30aa\u30f3\u30e9\u30a4\u30f3\u3067\u30d5\u30a1\u30a4\u30eb\u3092\u8868\u793a\u304a\u3088\u3073\u7de8\u96c6\u3067\u304d\u307e\u3059\u3002\u30d5\u30a1\u30a4\u30eb\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002",
    "User default quota": "\u30e6\u30fc\u30b6\u306e\u30c7\u30d5\u30a9\u30eb\u30c8\u30af\u30a9\u30fc\u30bf",
    "User default quota updated": "\u30e6\u30fc\u30b6\u306e\u30c7\u30d5\u30a9\u30eb\u30c8\u30af\u30a9\u30fc\u30bf\u304c\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f",
    "User deleted": "\u30e6\u30fc\u30b6\u3092\u524a\u9664\u3057\u307e\u3057\u305f\u3002",
    "User info updated": "\u30e6\u30fc\u30b6\u60c5\u5831\u304c\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f\u3002",
    "User is already in this group": "\u65e2\u306b\u3053\u306e\u30b0\u30eb\u30fc\u30d7\u306b\u5b58\u5728\u3057\u307e\u3059",
    "User migrate from {user_from} to {user_to}": "\u30e6\u30fc\u30b6\u3092{user_from}\u304b\u3089{user_to}\u306b\u79fb\u884c\u3057\u307e\u3057\u305f",
    "User not found": "\u30e6\u30fc\u30b6\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093",
    "User number limit": "\u30e6\u30fc\u30b6\u6570\u306e\u5236\u9650",
    "User {user_link} has added you to {group_link}": "\u30e6\u30fc\u30b6{user_link}\u304c\u3042\u306a\u305f\u3092{group_link}\u306b\u8ffd\u52a0\u3057\u307e\u3057\u305f",
    "Username:": "\u30e6\u30fc\u30b6\u540d:",
    "Users": "\u30e6\u30fc\u30b6",
    "Value": "\u5024",
    "Verified": "\u691c\u8a3c\u6e08\u307f",
    "Verify": "\u8a8d\u8a3c\u3092\u78ba\u8a8d\u3059\u308b",
    "Verify Domain": "\u30c9\u30e1\u30a4\u30f3\u3092\u8a8d\u8a3c\u3059\u308b",
    "Version": "\u30d0\u30fc\u30b8\u30e7\u30f3",
    "Version Number": "\u30d0\u30fc\u30b8\u30e7\u30f3\u756a\u53f7",
    "Version Number is required.": "\u30d0\u30fc\u30b8\u30e7\u30f3\u756a\u53f7\u304c\u5fc5\u8981",
    "Version Number must be a number.": "\u30d0\u30fc\u30b8\u30e7\u30f3\u756a\u53f7\u306f\u756a\u53f7\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093",
    "Video": "\u30d3\u30c7\u30aa",
    "View": "\u95b2\u89a7",
    "View Link": "\u30ea\u30f3\u30af\u3092\u8868\u793a",
    "View Related Snapshot": "\u95a2\u9023\u3059\u308b\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8\u3092\u8868\u793a",
    "View Snapshot": "\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8\u3092\u898b\u308b",
    "View all notifications": "\u901a\u77e5\u3092\u3059\u3079\u3066\u8868\u793a",
    "View notification": "\u901a\u77e5\u3092\u8868\u793a",
    "View original image": "\u5143\u306e\u89e3\u50cf\u5ea6\u3067\u8868\u793a",
    "View profile and more": "\u30d7\u30ed\u30d5\u30a3\u30fc\u30eb\u305d\u306e\u4ed6",
    "View published page": "\u516c\u958b\u30da\u30fc\u30b8\u3092\u8868\u793a",
    "Views": "\u8868\u793a",
    "Virus": "\u30a6\u30a4\u30eb\u30b9",
    "Virus File": "\u30a6\u30a4\u30eb\u30b9\u30d5\u30a1\u30a4\u30eb",
    "Virus Scan": "\u30d0\u30fc\u30c1\u30e3\u30eb\u306e\u30b9\u30ad\u30e3\u30f3",
    "Visit count": "\u8a2a\u554f\u56de\u6570",
    "Visit old version page": "\u53e4\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u30da\u30fc\u30b8\u3092\u8868\u793a",
    "Visit the wiki": "Wiki \u3092\u8a2a\u554f",
    "Visited": "\u53c2\u7167",
    "Visits": "\u8a2a\u554f\u8005",
    "Waiting...": "\u5f85\u6a5f\u4e2d...",
    "Watch File Changes": "\u30d5\u30a1\u30a4\u30eb\u5909\u66f4\u306e\u76e3\u8996\u3092\u958b\u59cb",
    "Web API Auth Token": "Web API \u8a8d\u8a3c\u30c8\u30fc\u30af\u30f3",
    "Web Download": "Web\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9",
    "Web Traffic": "\u30a6\u30a7\u30d6\u30c8\u30e9\u30d5\u30a3\u30c3\u30af",
    "Web Upload": "Web\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9",
    "WebDAV Access": "WebDAV \u30a2\u30af\u30bb\u30b9",
    "WebDAV password:": "WebDAV \u30d1\u30b9\u30ef\u30fc\u30c9:",
    "WebDAV username:": "WebDAV \u30e6\u30fc\u30b6\u540d:",
    "Welcome to {site_name_placeholder}": "\u3088\u3046\u3053\u305d {site_name_placeholder} \u3078",
    "Whether the notifications of collaboration such as sharing library or joining group should be sent to your mailbox.": "\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u5171\u6709\u3084\u30b0\u30eb\u30fc\u30d7\u3078\u306e\u53c2\u52a0\u306a\u3069\u306e\u30b3\u30e9\u30dc\u30ec\u30fc\u30b7\u30e7\u30f3\u306e\u901a\u77e5\u3092\u30e1\u30fc\u30eb\u30dc\u30c3\u30af\u30b9\u306b\u9001\u4fe1\u3059\u308b\u304b\u3069\u3046\u304b\u3002",
    "Wiki custom URL deleted": "Wiki \u306e\u30ab\u30b9\u30bf\u30e0URL\u304c\u524a\u9664\u3055\u308c\u307e\u3057\u305f",
    "Wiki owner": "Wiki \u6240\u6709\u8005",
    "Wiki published": "Wiki \u3092\u516c\u958b\u3057\u307e\u3057\u305f",
    "Wikis": "Wiki",
    "Workspace": "\u30ef\u30fc\u30af\u30b9\u30da\u30fc\u30b9",
    "Wrong password": "\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u9055\u3044\u307e\u3059",
    "Year": "\u5e74",
    "Yesterday": "\u6628\u65e5",
    "You can also add a user as a guest, who will not be allowed to create libraries and groups.": "\u30e6\u30fc\u30b6\u3092\u30b2\u30b9\u30c8\u3068\u3057\u3066\u8ffd\u52a0\u3059\u308b\u3053\u3068\u3082\u3067\u304d\u307e\u3059\u3002\u30b2\u30b9\u30c8\u306e\u5834\u5408\u306f\u3001\u30e9\u30a4\u30d6\u30e9\u30ea\u3084\u30b0\u30eb\u30fc\u30d7\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002",
    "You can click the \"Add Wiki\" button below to add a new Wiki.": "\u65b0\u3057\u3044 Wiki \u3092\u8ffd\u52a0\u3059\u308b\u306b\u306f\u3001\u4e0b\u306e \"Wiki \u3092\u8ffd\u52a0\" \u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
    "You can create files quickly": "\u30d5\u30a1\u30a4\u30eb\u3092\u3059\u3070\u3084\u304f\u4f5c\u6210\u3067\u304d\u307e\u3059",
    "You can create libraries by clicking the \"New Library\" item in the dropdown menu.": "\u30c9\u30ed\u30c3\u30d7\u30c0\u30a6\u30f3\u30e1\u30cb\u30e5\u30fc\u306e\u300c\u65b0\u898f\u30e9\u30a4\u30d6\u30e9\u30ea\u300d\u9805\u76ee\u3092\u30af\u30ea\u30c3\u30af\u3059\u308b\u3053\u3068\u3067\u3001\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u4f5c\u6210\u3067\u304d\u307e\u3059\u3002",
    "You can enter multiple emails. An invitation link will be sent to each of them.": "\u8907\u6570\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u3092\u5165\u529b\u3067\u304d\u307e\u3059\u3002\u5404\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u62db\u5f85\u30ea\u30f3\u30af\u304c\u9001\u4fe1\u3055\u308c\u307e\u3059\u3002",
    "You can use this field at login.": "\u30ed\u30b0\u30a4\u30f3\u6642\u306b\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u4f7f\u7528\u3067\u304d\u307e\u3059\u3002",
    "You do not have permission": "\u3042\u306a\u305f\u306b\u306f\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093",
    "You don't have any favorite items yet": "\u304a\u6c17\u306b\u5165\u308a\u306e\u30a2\u30a4\u30c6\u30e0\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "You don't have any share links": "\u5171\u6709\u30ea\u30f3\u30af\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "You don't have any upload links": "\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "\u307e\u3060\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\uff08\u30c7\u30b9\u30af\u30c8\u30c3\u30d7\u307e\u305f\u306f\u30e2\u30d0\u30a4\u30eb\uff09\u3067\u30d5\u30a1\u30a4\u30eb\u306b\u30a2\u30af\u30bb\u30b9\u3057\u3066\u3044\u307e\u305b\u3093\u3002\u30c7\u30d0\u30a4\u30b9\u4e0a\u306e\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u3092\u8a2d\u5b9a\u3057\u3066\u3001\u30c7\u30fc\u30bf\u306b\u3088\u308a\u5feb\u9069\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u3059\u3002",
    "You have not added any libraries, folders or files to your favorites yet. A favorite gives you quick access to your most frequently used objects. You can add a library, folder or file to your favorites by clicking the star to the left of its name.": "\u304a\u6c17\u306b\u5165\u308a\u306b\u307e\u3060\u30e9\u30a4\u30d6\u30e9\u30ea\u3084\u30d5\u30a9\u30eb\u30c0\u3084\u30d5\u30a1\u30a4\u30eb\u3092\u8ffd\u52a0\u3057\u3066\u3044\u307e\u305b\u3093\u3002\u304a\u6c17\u306b\u5165\u308a\u306f\u3001\u6700\u3082\u983b\u7e41\u306b\u4f7f\u308f\u308c\u3066\u3044\u308b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306b\u8fc5\u901f\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u3059\u3002\u30e9\u30a4\u30d6\u30e9\u30ea,\u30d5\u30a9\u30eb\u30c0,\u30d5\u30a1\u30a4\u30eb\u3092\u304a\u6c17\u306b\u5165\u308a\u306b\u8ffd\u52a0\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059.",
    "You have not created any libraries yet. A library is a container to organize your files and folders. A library can also be shared with others and synced to your connected devices. You can create a library by clicking the \"New Library\" item in the dropdown menu.": "\u307e\u3060\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u4f5c\u6210\u3057\u3066\u3044\u307e\u305b\u3093\u3002\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u30d5\u30a1\u30a4\u30eb\u3084\u30d5\u30a9\u30eb\u30c0\u30fc\u3092\u6574\u7406\u3059\u308b\u305f\u3081\u306e\u30b3\u30f3\u30c6\u30ca\u30fc\u3067\u3059\u3002\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u4ed6\u306e\u30e6\u30fc\u30b6\u3068\u5171\u6709\u3059\u308b\u3053\u3068\u3082\u3067\u304d\u3001\u63a5\u7d9a\u3055\u308c\u305f\u30c7\u30d0\u30a4\u30b9\u306b\u540c\u671f\u3059\u308b\u3053\u3068\u3082\u3067\u304d\u307e\u3059\u3002\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u4f5c\u6210\u3059\u308b\u306b\u306f\u3001\u30e1\u30cb\u30e5\u30fc\u30d0\u30fc\u306e \"New Library\" \u30dc\u30bf\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u304f\u3060\u3055\u3044\u3002",
    "You have not created any share links yet. A share link can be used to share files and folders with anyone. You can create a share link for a file or folder by clicking the share icon to the right of its name.": "\u307e\u3060\u30b7\u30a7\u30a2\u30ea\u30f3\u30af\u3092\u4f5c\u6210\u3057\u3066\u3044\u307e\u305b\u3093\u3002\u5171\u6709\u30ea\u30f3\u30af\u306f\u3001\u8ab0\u3068\u3067\u3082\u30d5\u30a1\u30a4\u30eb\u3084\u30d5\u30a9\u30eb\u30c0\u3092\u5171\u6709\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002\u30d5\u30a1\u30a4\u30eb\u307e\u305f\u306f\u30d5\u30a9\u30eb\u30c0\u306e\u5171\u6709\u30ea\u30f3\u30af\u3092\u4f5c\u6210\u3059\u308b\u3053\u3068\u306f,\u540d\u524d\u306e\u53f3\u5074\u306e\u5171\u6709\u30a2\u30a4\u30b3\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059.",
    "You have not created any upload links yet. An upload link allows anyone to upload files to a folder or library. You can create an upload link for a folder or library by clicking the share icon to the right of its name.": "\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u306f\u307e\u3060\u4f5c\u6210\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u306b\u3088\u308a\u3001\u8ab0\u3067\u3082\u30d5\u30a9\u30eb\u30c0\u3084\u30e9\u30a4\u30d6\u30e9\u30ea\u306b\u30d5\u30a1\u30a4\u30eb\u3092\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u3067\u304d\u307e\u3059\u3002\u30d5\u30a9\u30eb\u30c0\u3084\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30ea\u30f3\u30af\u306f,\u540d\u524d\u306e\u53f3\u5074\u306b\u3042\u308b\u5171\u6709\u30a2\u30a4\u30b3\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059.",
    "You have not deleted any libraries in the last {placeholder} days. A deleted library will be cleaned automatically after this period.": "\u904e\u53bb {placeholder} \u65e5\u9593\u3067\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u524a\u9664\u3057\u3066\u3044\u307e\u305b\u3093\u3002\u524a\u9664\u3055\u308c\u305f\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u3001\u3053\u306e\u671f\u9593\u5f8c\u306b\u81ea\u52d5\u7684\u306b\u30af\u30ea\u30fc\u30f3\u3055\u308c\u307e\u3059\u3002",
    "You have not invited any guests yet. A guest can access shared libraries through the web interface allowing more efficient ways to collaborate than through links. You can invite a guest by clicking the \"Invite Guest\" item in the dropdown menu.": "\u307e\u3060\u30b2\u30b9\u30c8\u3092\u62db\u5f85\u3057\u3066\u3044\u307e\u305b\u3093\u3002\u30b2\u30b9\u30c8\u306f\u30a6\u30a7\u30d6\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u3092\u901a\u3058\u3066\u5171\u6709\u30e9\u30a4\u30d6\u30e9\u30ea\u306b\u30a2\u30af\u30bb\u30b9\u3059\u308b\u3053\u3068\u304c\u3067\u304d,\u30ea\u30f3\u30af\u3092\u901a\u3058\u3066\u3088\u308a\u3082\u52b9\u7387\u7684\u306a\u65b9\u6cd5\u3067\u5354\u529b\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059.\u30b2\u30b9\u30c8\u3092\u62db\u5f85\u3059\u308b\u3053\u3068\u306f,\u30c9\u30ed\u30c3\u30d7\u30c0\u30a6\u30f3\u30e1\u30cb\u30e5\u30fc\u306e\"\u30b2\u30b9\u30c8\u3092\u62db\u5f85\"\u3092\u30af\u30ea\u30c3\u30af\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059.",
    "You have not shared any folders": "\u5171\u6709\u3057\u3066\u3044\u308b\u30d5\u30a9\u30eb\u30c0\u304c\u3042\u308a\u307e\u305b\u3093\u3002",
    "You have not shared any folders with other users yet. You can share a folder with other users by clicking the share icon to the right of a folder's name.": "\u307e\u3060\u4ed6\u306e\u30e6\u30fc\u30b6\u3068\u30d5\u30a9\u30eb\u30c0\u3092\u5171\u6709\u3057\u3066\u3044\u307e\u305b\u3093\u3002\u30d5\u30a9\u30eb\u30c0\u306e\u540d\u524d\u306e\u53f3\u5074\u306e\u5171\u6709\u30a2\u30a4\u30b3\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3059\u308b\u3053\u3068\u3067,\u4ed6\u306e\u30e6\u30fc\u30b6\u3068\u30d5\u30a9\u30eb\u30c0\u3092\u5171\u6709\u3067\u304d\u307e\u3059.",
    "You have not shared any libraries with other users yet. You can share a library with other users by clicking the share icon to the right of a library's name in \"My Libraries\".": "\u307e\u3060\u4ed6\u306e\u30e6\u30fc\u30b6\u3068\u5171\u6709\u3057\u3066\u3044\u308b\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u3042\u308a\u307e\u305b\u3093\u3002\u300c\u30de\u30a4\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u300d\u3067\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u540d\u524d\u306e\u53f3\u306b\u3042\u308b\u5171\u6709\u30a2\u30a4\u30b3\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3059\u308b\u3068\u3001\u4ed6\u306e\u30e6\u30fc\u30b6\u3068\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u5171\u6709\u3067\u304d\u307e\u3059\u3002",
    "You have only one backup code remaining.": "\u6b8b\u308a\u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u30b3\u30fc\u30c9\u306f1\u3064\u3060\u3051\u3067\u3059\u3002",
    "You have {num} backup codes remaining.": "\u6b8b\u308a\u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u30b3\u30fc\u30c9\u306f {num} \u3064\u3067\u3059\u3002",
    "Your name": "\u3042\u306a\u305f\u306e\u540d\u524d",
    "Your notifications will be sent to this email.": "\u901a\u77e5\u306f\u3053\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306b\u9001\u4fe1\u3055\u308c\u307e\u3059\u3002",
    "Yuan": "\u5143",
    "ZIP": "ZIP",
    "Zoom in": "\u62e1\u5927",
    "Zoom out": "\u7e2e\u5c0f",
    "all": "\u3059\u3079\u3066",
    "all members": "\u5168\u3066\u306e\u30e1\u30f3\u30d0",
    "contains": "\u542b\u3080",
    "copy": "\u30b3\u30d4\u30fc",
    "days": "\u65e5",
    "deleted": "\u524a\u9664",
    "deleted option": "\u524a\u9664\u3055\u308c\u305f\u30aa\u30d7\u30b7\u30e7\u30f3",
    "details": "\u8a73\u7d30",
    "does not contain": "\u542b\u307e\u306a\u3044",
    "email is required": "\u30e1\u30fc\u30eb\u304c\u5fc5\u8981",
    "freezed": "\u51cd\u7d50",
    "has all of...": "\u4ee5\u4e0b\u306e\u3059\u3079\u3066\u3092\u542b\u3080...",
    "has any of...": "\u4ee5\u4e0b\u306e\u3044\u305a\u308c\u304b\u3092\u542b\u3080...",
    "has none of...": "\u4ee5\u4e0b\u306e\u3044\u305a\u308c\u3082\u542b\u307e\u306a\u3044...",
    "icon": "\u30a2\u30a4\u30b3\u30f3",
    "in all libraries": "\u5168\u3066\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u30fc\u3067\u691c\u7d22",
    "in this folder": "\u3053\u306e\u30d5\u30a9\u30eb\u30c0\u30fc\u3067\u691c\u7d22",
    "in this library": "\u3053\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u30fc\u3067\u691c\u7d22",
    "include the current user": "\u73fe\u5728\u306e\u30e6\u30fc\u30b6\u3092\u542b\u3080",
    "is": "\u306f",
    "is after...": "\u4ee5\u4e0b\u306e\u65e5\u4ed8\u3088\u308a\u5f8c\u3067\u3042\u308b...",
    "is any of...": "\u4ee5\u4e0b\u306e\u3044\u305a\u308c\u304b\u3067\u3042\u308b...",
    "is before...": "\u4ee5\u4e0b\u306e\u65e5\u4ed8\u3088\u308a\u524d\u3067\u3042\u308b...",
    "is current user's ID": "\u73fe\u5728\u306e\u30e6\u30fc\u30b6\u306eID\u3067\u3042\u308b",
    "is empty": "\u7a7a\u3067\u3042\u308b",
    "is exactly...": "\u4ee5\u4e0b\u3068\u5b8c\u5168\u4e00\u81f4\u3059\u308b...",
    "is none of...": "\u4ee5\u4e0b\u306e\u3044\u305a\u308c\u3067\u3082\u306a\u3044...",
    "is not": "\u306f...\u3067\u306f\u306a\u3044",
    "is not empty": "\u7a7a\u3067\u306a\u3044",
    "is on or after...": "\u4ee5\u4e0b\u306e\u65e5\u4ed8\u307e\u305f\u306f\u305d\u308c\u4ee5\u964d\u3067\u3042\u308b...",
    "is on or before...": "\u4ee5\u4e0b\u306e\u65e5\u4ed8\u307e\u305f\u306f\u305d\u308c\u4ee5\u524d\u3067\u3042\u308b...",
    "is within...": "\u4ee5\u4e0b\u306e\u7bc4\u56f2\u5185\u3067\u3042\u308b...",
    "items": "\u9805\u76ee",
    "licensed to {placeholder_license_to}, expires on {placeholder_license_expiration}": "\u30e9\u30a4\u30bb\u30f3\u30b9\u306f{placeholder_license_to}\u306b\u30e9\u30a4\u30bb\u30f3\u30b9\u3055\u308c\u3066\u304a\u308a\u3001{placeholder_license_expiration}\u306b\u671f\u9650\u304c\u5207\u308c\u307e\u3059\u3002",
    "licensed to {placeholder_license_to}, upgrade service expired in {placeholder_license_expiration}": "\u30e9\u30a4\u30bb\u30f3\u30b9\u306f{placeholder_license_to}\u306b\u30e9\u30a4\u30bb\u30f3\u30b9\u3055\u308c\u3066\u304a\u308a\u3001{placeholder_license_expiration}\u306b\u671f\u9650\u304c\u5207\u308c\u307e\u3059\u3002",
    "locked": "\u30ed\u30c3\u30af",
    "locked by {name}": "{name} \u306b\u3088\u3063\u3066\u30ed\u30c3\u30af\u3055\u308c\u307e\u3057\u305f",
    "members": "\u30e1\u30f3\u30d0",
    "mm": "mm",
    "name": "\u6c0f\u540d",
    "not set": "\u672a\u8a2d\u5b9a",
    "only show {placeholder}": "\u8868\u793a\u3092 {placeholder} \u306e\u307f\u306b\u9650\u5b9a\u3059\u308b",
    "progress": "\u9032\u6357",
    "s": "s",
    "selected": "\u9078\u629e\u89e3\u9664",
    "show more": "\u3055\u3089\u306b\u8868\u793a",
    "size": "\u30b5\u30a4\u30ba",
    "sorts": "\u4e26\u3079\u66ff\u3048",
    "starred": "\u661f\u4ed8\u3051\u6e08\u307f",
    "state": "\u72b6\u614b",
    "successfully added user %s.": "\u30e6\u30fc\u30b6 %s \u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f\u3002",
    "successfully sent email to %s.": "\u30e6\u30fc\u30b6 %s \u306b\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3057\u307e\u3057\u305f\u3002",
    "tags": "\u30bf\u30b0",
    "unstarred": "\u661f\u4ed8\u3051\u89e3\u9664\u6e08\u307f",
    "xxx cells copied": "xxx \u30bb\u30eb\u3092\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f",
    "xxx cells cut": "xxx \u30bb\u30eb\u3092\u5207\u308a\u53d6\u308a\u307e\u3057\u305f",
    "xxx cells selected": "xxx \u30bb\u30eb\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f",
    "xxx record": "1 \u30ec\u30b3\u30fc\u30c9",
    "xxx records": "xxx \u30ec\u30b3\u30fc\u30c9",
    "xxx records selected": "xxx \u30ec\u30b3\u30fc\u30c9\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f",
    "xxx rows are copied.": "xxx \u884c\u3092\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f",
    "you can also press \u2192": "\u3082\u3063\u3068\u898b\u308b ->",
    "{failed_files_num} file(s) failed to upload": "{failed_files_num} \u30d5\u30a1\u30a4\u30eb\u304c\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f",
    "{file} and {n} other files": "{file} \u3068\u305d\u306e\u4ed6 {n} \u500b\u306e\u30d5\u30a1\u30a4\u30eb",
    "{library_name} Office Suite": "{library_name} \u306e\u30aa\u30d5\u30a3\u30b9\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2",
    "{minDays_placeholder} - {maxDays_placeholder} days": "{minDays_placeholder} - {maxDays_placeholder} \u65e5",
    "{name_placeholder} cells copied": "{name_placeholder} \u500b\u306e\u30bb\u30eb\u304c\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3057\u305f",
    "{name_placeholder} cells cut": "{name_placeholder} \u500b\u306e\u30bb\u30eb\u304c\u5207\u308a\u53d6\u3089\u308c\u307e\u3057\u305f",
    "{name_placeholder} cells selected": "{name_placeholder} \u500b\u306e\u30bb\u30eb\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f",
    "{name_placeholder} hidden properties": "\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u975e\u8868\u793a",
    "{name_placeholder} preset hidden properties": "\u30d7\u30ea\u30bb\u30c3\u30c8\u975e\u8868\u793a\u30d7\u30ed\u30d1\u30c6\u30a3",
    "{name_placeholder} record": "{name_placeholder} \u4ef6\u306e\u30ec\u30b3\u30fc\u30c9",
    "{name_placeholder} records": "{name_placeholder} \u4ef6\u306e\u30ec\u30b3\u30fc\u30c9",
    "{name_placeholder} records selected": "{name_placeholder} \u4ef6\u306e\u30ec\u30b3\u30fc\u30c9\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f",
    "{name_placeholder} rows are copied.": "{name_placeholder} \u884c\u304c\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3057\u305f",
    "{name} rows use this option.": "{name} \u884c\u304c\u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\u3002",
    "{number_placeholder} / Page": "\u30da\u30fc\u30b8 {number_placeholder} / \u30da\u30fc\u30b8",
    "{placeholder} API Token": "{placeholder} API\u30c8\u30fc\u30af\u30f3",
    "{placeholder} Access Log": "{placeholder}\u306e\u30a2\u30af\u30bb\u30b9\u30ed\u30b0",
    "{placeholder} Folder Permission": "{placeholder} \u30d5\u30a9\u30eb\u30c0\u306e\u6a29\u9650",
    "{placeholder} History Setting": "{placeholder} \u306e\u5c65\u6b74\u8a2d\u5b9a",
    "{placeholder} Modification History": "{placeholder} \u5909\u66f4\u5c65\u6b74",
    "{placeholder} Share Admin": "{placeholder} \u5171\u6709\u7ba1\u7406\u8005",
    "{placeholder} Snapshot": "{placeholder} \u306e\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8",
    "{placeholder} Trash": "{placeholder} \u30b4\u30df\u7bb1",
    "{placeholder} Wiki Trash": "{placeholder} Wiki \u30b4\u30df\u7bb1",
    "{share_from} has cancelled the sharing of folder {repo_name}.": "\u30e6\u30fc\u30b6 {share_from} \u304c\u30d5\u30a9\u30eb\u30c0 {repo_name} \u306e\u5171\u6709\u3092\u505c\u6b62",
    "{share_from} has cancelled the sharing of library {repo_name}.": "\u30e6\u30fc\u30b6 {share_from} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {repo_name} \u306e\u5171\u6709\u3092\u505c\u6b62",
    "{share_from} has changed the permission of folder {repo_link} to {permission}.": "\u30e6\u30fc\u30b6 {share_from} \u304c\u30d5\u30a9\u30eb\u30c0 {repo_link} \u306e\u6a29\u9650\u3092 {permission} \u306b\u5909\u66f4",
    "{share_from} has changed the permission of library {repo_link} to {permission}.": "\u30e6\u30fc\u30b6 {share_from} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {repo_link} \u306e\u6a29\u9650\u3092 {permission} \u306b\u5909\u66f4",
    "{share_from} has shared a folder named {repo_link} to group {group_link}.": "\u30e6\u30fc\u30b6 {share_from} \u304c\u30d5\u30a9\u30eb\u30c0 {repo_link} \u3092\u30b0\u30eb\u30fc\u30d7 {group_link} \u306b\u5171\u6709",
    "{share_from} has shared a folder named {repo_link} to you.": "\u30e6\u30fc\u30b6 {share_from} \u304c\u30d5\u30a9\u30eb\u30c0 {repo_link} \u3092\u5171\u6709",
    "{share_from} has shared a library named {repo_link} to group {group_link}.": "\u30e6\u30fc\u30b6 {share_from} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {repo_link} \u3092\u30b0\u30eb\u30fc\u30d7 {group_link} \u306b\u5171\u6709",
    "{share_from} has shared a library named {repo_link} to you.": "\u30e6\u30fc\u30b6 {share_from} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {repo_link} \u3092\u5171\u6709",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. However, since you are a guest user now, you can not create libraries.": "{site_name_placeholder} \u306f\u30d5\u30a1\u30a4\u30eb\u3092\u30e9\u30a4\u30d6\u30e9\u30ea\u5358\u4f4d\u3067\u6574\u7406\u3057\u307e\u3059\u3002\u500b\u3005\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u306b\u7570\u306a\u308b\u540c\u671f\u8a2d\u5b9a\u3084\u5171\u6709\u6a29\u9650\u3092\u8a2d\u5b9a\u3067\u304d\u307e\u3059\u3002\u3057\u304b\u3057\u3001\u4eca\u306f\u3001\u30b2\u30b9\u30c8\u3068\u3057\u3066\u30a2\u30af\u30bb\u30b9\u3057\u3066\u3044\u308b\u305f\u3081\u3001\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u8ffd\u52a0\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. We have created a personal library for you. You can create more libraries later.": "{site_name_placeholder} \u306f\u30d5\u30a1\u30a4\u30eb\u3092\u30e9\u30a4\u30d6\u30e9\u30ea\u5358\u4f4d\u3067\u6574\u7406\u3057\u307e\u3059\u3002\u500b\u3005\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u306b\u7570\u306a\u308b\u540c\u671f\u8a2d\u5b9a\u3084\u5171\u6709\u6a29\u9650\u3092\u8a2d\u5b9a\u3067\u304d\u307e\u3059\u3002\u300cPersonal Library\u300d\u3042\u306a\u305f\u306e\u306f\u3058\u3081\u3066\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u3067\u3059\u3002\u3044\u3064\u3067\u3082\u30e9\u30a4\u30d6\u30e9\u30ea\u306f\u5897\u3084\u3059\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002",
    "{uploaded_files_num}/{all_files_num} Files": "\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u6e08\u307f {uploaded_files_num}/{all_files_num} \u30d5\u30a1\u30a4\u30eb",
    "{userCount} user(s) and {repoCount} libraries of this organization will also be deleted.": "\u7d44\u7e54{placeholder}\u306e\u30e6\u30fc\u30b6\u30fc{userCount}\u4eba\u3068\u30e9\u30a4\u30d6\u30e9\u30ea{repoCount}\u4ef6\u304c\u524a\u9664\u3055\u308c\u307e\u3059\u3002",
    "{user} created file {fileName} and {fileCount} other file(s) in library {libraryName}.": "\u30e6\u30fc\u30b6 {user} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {libraryName} \u306b\u30d5\u30a1\u30a4\u30eb {fileName} \u307b\u304b{fileCount}\u500b\u3092\u5171\u6709",
    "{user} created file {fileName} in library {libraryName}.": "\u30e6\u30fc\u30b6 {user} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {libraryName} \u306b\u30d5\u30a1\u30a4\u30eb {fileName} \u3092\u4f5c\u6210",
    "{user} created folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "\u30e6\u30fc\u30b6 {user} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {libraryName} \u306b\u30d5\u30a9\u30eb\u30c0 {folderName} \u307b\u304b{folderCount}\u500b\u3092\u4f5c\u6210",
    "{user} created folder {folderName} in library {libraryName}.": "\u30e6\u30fc\u30b6 {user} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {libraryName} \u306b\u30d5\u30a9\u30eb\u30c0 {folderName} \u3092\u4f5c\u6210",
    "{user} deleted file {fileName} and {fileCount} other file(s) in library {libraryName}.": "\u30e6\u30fc\u30b6 {user} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {libraryName} \u306e\u30d5\u30a1\u30a4\u30eb {fileName} \u307b\u304b{fileCount}\u500b\u3092\u524a\u9664",
    "{user} deleted file {fileName} in library {libraryName}.": "\u30e6\u30fc\u30b6 {user} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {libraryName} \u306e\u30d5\u30a1\u30a4\u30eb {fileName} \u3092\u524a\u9664",
    "{user} deleted folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "\u30e6\u30fc\u30b6 {user} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {libraryName} \u306b\u30d5\u30a9\u30eb\u30c0 {folderName} \u307b\u304b{folderCount}\u500b\u3092\u524a\u9664",
    "{user} deleted folder {folderName} in library {libraryName}.": "\u30e6\u30fc\u30b6 {user} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {libraryName} \u306e\u30d5\u30a9\u30eb\u30c0 {folderName} \u3092\u524a\u9664",
    "{user} has transferred a library named {repo_link} to you.": "\u30e6\u30fc\u30b6 {user} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {repo_link} \u3092\u5171\u6709",
    "{user} moved file {fileName} and {fileCount} other file(s) in library {libraryName}.": "\u30e6\u30fc\u30b6 {user} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {libraryName} \u306e\u30d5\u30a1\u30a4\u30eb {fileName} \u307b\u304b{fileCount}\u500b\u3092\u79fb\u52d5",
    "{user} moved file {fileName} in library {libraryName}.": "\u30e6\u30fc\u30b6 {user} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {libraryName} \u306e\u30d5\u30a1\u30a4\u30eb {fileName} \u3092\u79fb\u52d5",
    "{user} moved folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "\u30e6\u30fc\u30b6 {user} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {libraryName} \u306e\u30d5\u30a1\u30a4\u30eb {folderName} \u307b\u304b{folderCount}\u500b\u3092\u79fb\u52d5",
    "{user} moved folder {folderName} in library {libraryName}.": "\u30e6\u30fc\u30b6 {user} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {libraryName} \u306e\u30d5\u30a9\u30eb\u30c0 {folderName} \u3092\u79fb\u52d5",
    "{user} renamed file {oldFileName} {fileName} in library {libraryName}.": "\u30e6\u30fc\u30b6 {user} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {libraryName} \u306e\u30d5\u30a1\u30a4\u30eb {oldFileName} \u3092 {fileName} \u306b\u540d\u524d\u5909\u66f4",
    "{user} renamed folder {oldFolderName} {folderName} in library {libraryName}.": "\u30e6\u30fc\u30b6 {user} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {libraryName} \u306e\u30d5\u30a9\u30eb\u30c0 {oldFolderName} \u3092 {folderName} \u306b\u540d\u524d\u5909\u66f4",
    "{user} restored file {fileName} in library {libraryName}.": "\u30e6\u30fc\u30b6 {user} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {libraryName} \u306e\u30d5\u30a1\u30a4\u30eb {fileName} \u3092\u5fa9\u5143",
    "{user} restored folder {folderName} in library {libraryName}.": "\u30e6\u30fc\u30b6 {user} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {libraryName} \u306e\u30d5\u30a9\u30eb\u30c0 {folderName} \u3092\u5fa9\u5143",
    "{user} updated file {fileName} in library {libraryName}.": "\u30e6\u30fc\u30b6 {user} \u304c\u30e9\u30a4\u30d6\u30e9\u30ea {libraryName} \u306e\u30d5\u30a1\u30a4\u30eb {fileName} \u3092\u66f4\u65b0",
    "{xxx} items have been selected": "{xxx} \u500b\u306e\u30a2\u30a4\u30c6\u30e0\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f"
  };
  for (const key in newcatalog) {
    django.catalog[key] = newcatalog[key];
  }
  

  if (!django.jsi18n_initialized) {
    django.gettext = function(msgid) {
      const value = django.catalog[msgid];
      if (typeof value === 'undefined') {
        return msgid;
      } else {
        return (typeof value === 'string') ? value : value[0];
      }
    };

    django.ngettext = function(singular, plural, count) {
      const value = django.catalog[singular];
      if (typeof value === 'undefined') {
        return (count == 1) ? singular : plural;
      } else {
        return value.constructor === Array ? value[django.pluralidx(count)] : value;
      }
    };

    django.gettext_noop = function(msgid) { return msgid; };

    django.pgettext = function(context, msgid) {
      let value = django.gettext(context + '\x04' + msgid);
      if (value.includes('\x04')) {
        value = msgid;
      }
      return value;
    };

    django.npgettext = function(context, singular, plural, count) {
      let value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
      if (value.includes('\x04')) {
        value = django.ngettext(singular, plural, count);
      }
      return value;
    };

    django.interpolate = function(fmt, obj, named) {
      if (named) {
        return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
      } else {
        return fmt.replace(/%s/g, function(match){return String(obj.shift())});
      }
    };


    /* formatting library */

    django.formats = {
    "DATETIME_FORMAT": "Y\u5e74n\u6708j\u65e5G:i",
    "DATETIME_INPUT_FORMATS": [
      "%Y-%m-%d %H:%M:%S",
      "%Y-%m-%d %H:%M:%S.%f",
      "%Y-%m-%d %H:%M",
      "%m/%d/%Y %H:%M:%S",
      "%m/%d/%Y %H:%M:%S.%f",
      "%m/%d/%Y %H:%M",
      "%m/%d/%y %H:%M:%S",
      "%m/%d/%y %H:%M:%S.%f",
      "%m/%d/%y %H:%M"
    ],
    "DATE_FORMAT": "Y\u5e74n\u6708j\u65e5",
    "DATE_INPUT_FORMATS": [
      "%Y-%m-%d",
      "%m/%d/%Y",
      "%m/%d/%y",
      "%b %d %Y",
      "%b %d, %Y",
      "%d %b %Y",
      "%d %b, %Y",
      "%B %d %Y",
      "%B %d, %Y",
      "%d %B %Y",
      "%d %B, %Y"
    ],
    "DECIMAL_SEPARATOR": ".",
    "FIRST_DAY_OF_WEEK": 0,
    "MONTH_DAY_FORMAT": "n\u6708j\u65e5",
    "NUMBER_GROUPING": 3,
    "SHORT_DATETIME_FORMAT": "Y/m/d G:i",
    "SHORT_DATE_FORMAT": "Y/m/d",
    "THOUSAND_SEPARATOR": ",",
    "TIME_FORMAT": "G:i",
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S",
      "%H:%M:%S.%f",
      "%H:%M"
    ],
    "YEAR_MONTH_FORMAT": "Y\u5e74n\u6708"
  };

    django.get_format = function(format_type) {
      const value = django.formats[format_type];
      if (typeof value === 'undefined') {
        return format_type;
      } else {
        return value;
      }
    };

    /* add to global namespace */
    globals.pluralidx = django.pluralidx;
    globals.gettext = django.gettext;
    globals.ngettext = django.ngettext;
    globals.gettext_noop = django.gettext_noop;
    globals.pgettext = django.pgettext;
    globals.npgettext = django.npgettext;
    globals.interpolate = django.interpolate;
    globals.get_format = django.get_format;

    django.jsi18n_initialized = true;
  }
};

