/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.github;

import com.badlogic.gdx.files.FileHandle;
import com.unciv.utils.LogKt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/unciv/logic/github/Zip;", "", "<init>", "()V", "bufferSize", "", "extractFolder", "", "zipFile", "Lcom/badlogic/gdx/files/FileHandle;", "unzipDestination", "core"})
@SourceDebugExtension(value={"SMAP\nZip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Zip.kt\ncom/unciv/logic/github/Zip\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class Zip {
    @NotNull
    public static final Zip INSTANCE = new Zip();
    private static final int bufferSize = 2048;

    private Zip() {
    }

    public final void extractFolder(@NotNull FileHandle zipFile, @NotNull FileHandle unzipDestination) {
        Intrinsics.checkNotNullParameter(zipFile, "zipFile");
        Intrinsics.checkNotNullParameter(unzipDestination, "unzipDestination");
        Object[] objectArray = new Object[]{zipFile, unzipDestination};
        LogKt.debug("Extracting %s to %s", objectArray);
        byte[] data = new byte[2048];
        File file = zipFile.file();
        ZipFile zip2 = new ZipFile(file);
        Enumeration<? extends ZipEntry> zipFileEntries = zip2.entries();
        while (zipFileEntries.hasMoreElements()) {
            ZipEntry entry;
            Intrinsics.checkNotNull(zipFileEntries.nextElement(), "null cannot be cast to non-null type java.util.zip.ZipEntry");
            String currentEntry = entry.getName();
            FileHandle destFile = unzipDestination.child(currentEntry);
            FileHandle destinationParent = destFile.parent();
            destinationParent.mkdirs();
            if (!entry.isDirectory()) {
                InputStream inputStream = zip2.getInputStream(entry);
                Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
                Intrinsics.checkNotNull(destFile);
                Zip.extractFolder$streamCopy(data, inputStream, destFile);
            }
            Intrinsics.checkNotNull(currentEntry);
            if (!StringsKt.endsWith$default(currentEntry, ".zip", false, 2, null)) continue;
            Intrinsics.checkNotNull(destFile);
            Intrinsics.checkNotNull(destinationParent);
            this.extractFolder(destFile, destinationParent);
            destFile.delete();
        }
        zip2.close();
    }

    private static final void extractFolder$streamCopy(byte[] data, InputStream fromStream, FileHandle toHandle) {
        BufferedInputStream inputStream = new BufferedInputStream(fromStream);
        int currentByte = 0;
        FileOutputStream fos = new FileOutputStream(toHandle.file());
        BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
        while (true) {
            int n;
            int it = n = inputStream.read(data, 0, 2048);
            boolean bl = false;
            currentByte = it;
            if (n == -1) break;
            dest.write(data, 0, currentByte);
        }
        dest.flush();
        dest.close();
        inputStream.close();
    }
}

