/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.popups.options;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.metadata.ModCategories;
import com.unciv.models.translations.TranslationFileWriter;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.fonts.FontFamilyData;
import com.unciv.ui.components.fonts.Fonts;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.components.widgets.UncivSlider;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.options.OptionsPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapHolder;
import com.unciv.utils.CollectionExtensionsKt;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import com.unciv.utils.Display;
import com.unciv.utils.StringExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\u0006H\u0002J\b\u0010\f\u001a\u00020\u0006H\u0002J\b\u0010\r\u001a\u00020\u0006H\u0002J\b\u0010\u000e\u001a\u00020\u0006H\u0002J\u0016\u0010\u000f\u001a\u00020\u00062\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0016\u0010\u0010\u001a\u00020\u00062\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\b\u0010\u0011\u001a\u00020\u0006H\u0002J\b\u0010\u0012\u001a\u00020\u0006H\u0002J,\u0010\u0013\u001a\u00020\u0006*\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0006H\u0002J\b\u0010\u001a\u001a\u00020\u0006H\u0002J\b\u0010\u001b\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/unciv/ui/popups/options/AdvancedTab;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "optionsPopup", "Lcom/unciv/ui/popups/options/OptionsPopup;", "onFontChange", "Lkotlin/Function0;", "", "<init>", "(Lcom/unciv/ui/popups/options/OptionsPopup;Lkotlin/jvm/functions/Function0;)V", "settings", "Lcom/unciv/models/metadata/GameSettings;", "addCutoutCheckbox", "addHideSystemUiCheckbox", "addAutosaveField", "addAutosaveTurnsSelectBox", "addFontFamilySelect", "addFontSizeMultiplier", "addMaxZoomSlider", "addTranslationGeneration", "generateScreenshots", "Lkotlinx/coroutines/CoroutineScope;", "configs", "Ljava/util/ArrayList;", "Lcom/unciv/ui/popups/options/AdvancedTab$ScreenshotConfig;", "Lkotlin/collections/ArrayList;", "addSetUserId", "addEasterEggsCheckBox", "addEnlargeNotificationsCheckBox", "ScreenshotConfig", "core"})
@SourceDebugExtension(value={"SMAP\nAdvancedTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvancedTab.kt\ncom/unciv/ui/popups/options/AdvancedTab\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,405:1\n295#2,2:406\n*S KotlinDebug\n*F\n+ 1 AdvancedTab.kt\ncom/unciv/ui/popups/options/AdvancedTab\n*L\n179#1:406,2\n*E\n"})
public final class AdvancedTab
extends Table {
    @NotNull
    private final OptionsPopup optionsPopup;
    @NotNull
    private final GameSettings settings;

    public AdvancedTab(@NotNull OptionsPopup optionsPopup, @NotNull Function0<Unit> onFontChange) {
        Intrinsics.checkNotNullParameter(optionsPopup, "optionsPopup");
        Intrinsics.checkNotNullParameter(onFontChange, "onFontChange");
        super(BaseScreen.Companion.getSkin());
        this.optionsPopup = optionsPopup;
        this.settings = this.optionsPopup.getSettings();
        this.pad(10.0f);
        this.defaults().pad(5.0f);
        this.addAutosaveField();
        this.addAutosaveTurnsSelectBox();
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
        if (Display.INSTANCE.hasCutout()) {
            this.addCutoutCheckbox();
        }
        if (Display.INSTANCE.hasSystemUiVisibility()) {
            this.addHideSystemUiCheckbox();
        }
        this.addFontFamilySelect(onFontChange);
        this.addFontSizeMultiplier(onFontChange);
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
        this.addMaxZoomSlider();
        this.addEasterEggsCheckBox();
        this.addEnlargeNotificationsCheckBox();
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
        this.addSetUserId();
        this.addTranslationGeneration();
    }

    private final void addCutoutCheckbox() {
        OptionsPopup.addCheckbox$core$default(this.optionsPopup, this, "Enable using display cutout areas", this.settings.getAndroidCutout(), false, false, arg_0 -> AdvancedTab.addCutoutCheckbox$lambda$0(this, arg_0), 24, null);
    }

    private final void addHideSystemUiCheckbox() {
        OptionsPopup.addCheckbox$core$default(this.optionsPopup, this, "Hide system status and navigation bars", this.settings.getAndroidHideSystemUi(), false, false, arg_0 -> AdvancedTab.addHideSystemUiCheckbox$lambda$0(this, arg_0), 24, null);
    }

    private final void addAutosaveField() {
        this.add((Actor)Scene2dExtensionsKt.toLabel("Number of autosave files stored")).left().fillX();
        Table autosaveFieldTable = new Table();
        UncivTextField autoSaveTrunsTextField = new UncivTextField("", String.valueOf(this.settings.getMaxAutosavesStored()), null, 4, null);
        autoSaveTrunsTextField.setTextFieldFilter(AdvancedTab::addAutosaveField$lambda$0);
        autosaveFieldTable.add((Actor)autoSaveTrunsTextField);
        TextButton autoSaveTrunsTextFieldButton = Scene2dExtensionsKt.toTextButton$default("Enter", null, false, 3, null);
        ActivationExtensionsKt.onClick(autoSaveTrunsTextFieldButton, () -> AdvancedTab.addAutosaveField$lambda$1(autoSaveTrunsTextField, this));
        autosaveFieldTable.add((Actor)autoSaveTrunsTextFieldButton).row();
        this.add((Actor)autosaveFieldTable).row();
    }

    private final void addAutosaveTurnsSelectBox() {
        this.add((Actor)Scene2dExtensionsKt.toLabel("Turns between autosaves")).left().fillX();
        SelectBox autosaveTurnsSelectBox = new SelectBox(this.getSkin());
        Array<Integer> autosaveTurnsArray = new Array<Integer>();
        Integer[] integerArray = new Integer[]{1, 2, 5, 10, 20, 50, 100, 1000};
        autosaveTurnsArray.addAll(integerArray);
        autosaveTurnsSelectBox.setItems(autosaveTurnsArray);
        autosaveTurnsSelectBox.setSelected(this.settings.getTurnsBetweenAutosaves());
        this.add((Actor)autosaveTurnsSelectBox).pad(10.0f).row();
        ActivationExtensionsKt.onChange(autosaveTurnsSelectBox, arg_0 -> AdvancedTab.addAutosaveTurnsSelectBox$lambda$0(this, autosaveTurnsSelectBox, arg_0));
    }

    private final void addFontFamilySelect(Function0<Unit> onFontChange) {
        this.add((Actor)Scene2dExtensionsKt.toLabel("Font family")).left().fillX();
        Cell selectCell = this.add();
        this.row();
        Concurrency.run$default(Concurrency.INSTANCE, "Add Font Select", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(selectCell, this, onFontChange, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Cell $selectCell;
            final /* synthetic */ AdvancedTab this$0;
            final /* synthetic */ Function0<Unit> $onFontChange;
            {
                this.$selectCell = $selectCell;
                this.this$0 = $receiver;
                this.$onFontChange = $onFontChange;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$run;
                        ResultKt.throwOnFailure($result);
                        Array<FontFamilyData> fonts = new Array<FontFamilyData>();
                        fonts.add(FontFamilyData.Companion.getDefault());
                        FileHandle modsDir = UncivGame.Companion.getCurrent().getFiles().getModsFolder();
                        FileHandle[] fileHandleArray = modsDir.list();
                        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
                        for (FileHandle mod : fileHandleArray) {
                            FileHandle[] fileHandleArray2;
                            FileHandle modFontsDir;
                            if (!mod.isDirectory() || !(modFontsDir = mod.child("fonts")).exists()) continue;
                            Intrinsics.checkNotNullExpressionValue(modFontsDir.list(), "list(...)");
                            for (FileHandle fontFile : fileHandleArray2) {
                                String string = fontFile.extension();
                                Intrinsics.checkNotNullExpressionValue(string, "extension(...)");
                                String string2 = string.toLowerCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                                if (!Intrinsics.areEqual(string2, "ttf")) continue;
                                String string3 = fontFile.nameWithoutExtension() + " (" + mod.name() + ')';
                                String string4 = fontFile.nameWithoutExtension();
                                Intrinsics.checkNotNullExpressionValue(string4, "nameWithoutExtension(...)");
                                fonts.add(new FontFamilyData(string3, string4, fontFile.path()));
                            }
                        }
                        Iterator<FontFamilyData> iterator2 = Fonts.INSTANCE.getSystemFonts().iterator();
                        while (iterator2.hasNext()) {
                            FontFamilyData font = (FontFamilyData)iterator2.next();
                            fonts.add(font);
                        }
                        ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(fonts, this.$selectCell, this.this$0, this.$onFontChange, null){
                            int label;
                            final /* synthetic */ Array<FontFamilyData> $fonts;
                            final /* synthetic */ Cell $selectCell;
                            final /* synthetic */ AdvancedTab this$0;
                            final /* synthetic */ Function0<Unit> $onFontChange;
                            {
                                this.$fonts = $fonts;
                                this.$selectCell = $selectCell;
                                this.this$0 = $receiver;
                                this.$onFontChange = $onFontChange;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure($result);
                                        Cell cell = this.$selectCell;
                                        Intrinsics.checkNotNull(cell);
                                        AdvancedTab.access$addFontFamilySelect$loadFontSelect(this.this$0, this.$onFontChange, this.$fonts, cell);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final void addFontSizeMultiplier(Function0<Unit> onFontChange) {
        this.add((Actor)Scene2dExtensionsKt.toLabel("Font size multiplier")).left().fillX().padTop(5.0f);
        UncivSlider fontSizeSlider = new UncivSlider(0.7f, 1.5f, 0.05f, false, false, this.settings.getFontSizeMultiplier(), null, null, null, arg_0 -> AdvancedTab.addFontSizeMultiplier$lambda$0(this, arg_0), 472, null);
        ActivationExtensionsKt.onChange(fontSizeSlider, arg_0 -> AdvancedTab.addFontSizeMultiplier$lambda$1(fontSizeSlider, onFontChange, arg_0));
        this.add((Actor)fontSizeSlider).pad(5.0f).padTop(10.0f).row();
    }

    private final void addMaxZoomSlider() {
        this.add(TranslationsKt.tr$default("Max zoom out", false, false, 3, null)).left().fillX().padTop(5.0f);
        UncivSlider maxZoomSlider = new UncivSlider(2.0f, 6.0f, 1.0f, false, false, this.settings.getMaxWorldZoomOut(), null, null, null, arg_0 -> AdvancedTab.addMaxZoomSlider$lambda$0(this, arg_0), 472, null);
        this.add((Actor)maxZoomSlider).pad(5.0f).padTop(10.0f).row();
    }

    private final void addTranslationGeneration() {
        if (Gdx.app.getType() != Application.ApplicationType.Desktop) {
            return;
        }
        TextButton generateTranslationsButton = Scene2dExtensionsKt.toTextButton$default("Generate translation files", null, false, 3, null);
        ActivationExtensionsKt.onActivation(generateTranslationsButton, () -> AdvancedTab.addTranslationGeneration$lambda$0(this, generateTranslationsButton));
        ActivationExtensionsKt.getKeyShortcuts(generateTranslationsButton).add(142);
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, generateTranslationsButton, "F12", 18.0f, false, 0, 0, false, null, 124, null);
        this.add((Actor)generateTranslationsButton).colspan(2).row();
        TextButton updateModCategoriesButton = Scene2dExtensionsKt.toTextButton$default("Update Mod categories", null, false, 3, null);
        ActivationExtensionsKt.onActivation(updateModCategoriesButton, () -> AdvancedTab.addTranslationGeneration$lambda$1(updateModCategoriesButton));
        this.add((Actor)updateModCategoriesButton).colspan(2).row();
        if (!UncivGame.Companion.getCurrent().getFiles().getSave("ScreenshotGenerationGame").exists()) {
            return;
        }
        TextButton generateScreenshotsButton = Scene2dExtensionsKt.toTextButton$default("Generate screenshots", null, false, 3, null);
        ActivationExtensionsKt.onActivation(generateScreenshotsButton, () -> AdvancedTab.addTranslationGeneration$lambda$2(generateScreenshotsButton, this));
        this.add((Actor)generateScreenshotsButton).colspan(2).row();
    }

    private final void generateScreenshots(CoroutineScope $this$generateScreenshots, GameSettings settings, ArrayList<ScreenshotConfig> configs) {
        ScreenshotConfig currentConfig = (ScreenshotConfig)CollectionsKt.first((List)configs);
        ConcurrencyKt.launchOnGLThread$default($this$generateScreenshots, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(settings, currentConfig, configs, this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ GameSettings $settings;
            final /* synthetic */ ScreenshotConfig $currentConfig;
            final /* synthetic */ ArrayList<ScreenshotConfig> $configs;
            final /* synthetic */ AdvancedTab this$0;
            {
                this.$settings = $settings;
                this.$currentConfig = $currentConfig;
                this.$configs = $configs;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        screenshotGame = UncivGame.Companion.getCurrent().getFiles().loadGameByName("ScreenshotGenerationGame");
                        this.$settings.setScreenSize(this.$currentConfig.getScreenSize());
                        this.L$0 = SpillingKt.nullOutSpilledVariable(screenshotGame);
                        this.label = 1;
                        v0 = UncivGame.loadGame$default(UncivGame.Companion.getCurrent(), screenshotGame, null, false, this, 6, null);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        screenshotGame = (GameInfo)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        newScreen = (WorldScreen)v0;
                        newScreen.getStage().getViewport().update(this.$currentConfig.getWidth(), this.$currentConfig.getHeight(), true);
                        newScreen.getMapHolder().setSize(newScreen.getStage().getWidth(), newScreen.getStage().getHeight());
                        newScreen.getMapHolder().layout();
                        newScreen.getMinimapWrapper$core().setX(newScreen.getStage().getWidth() - newScreen.getMinimapWrapper$core().getWidth());
                        WorldMapHolder.setCenterPosition$default(newScreen.getMapHolder(), this.$currentConfig.getCenterTile(), true, true, null, 8, null);
                        newScreen.getMapHolder().onTileClicked(newScreen.getMapHolder().getTileMap$core().get(-2, 3));
                        if (this.$currentConfig.getAttackCity()) {
                            newScreen.getMapHolder().onTileClicked(newScreen.getMapHolder().getTileMap$core().get(-2, 2));
                        }
                        newScreen.getMapHolder().zoomIn(true);
                        this.L$0 = SpillingKt.nullOutSpilledVariable(screenshotGame);
                        this.L$1 = SpillingKt.nullOutSpilledVariable(newScreen);
                        this.label = 2;
                        v1 = BuildersKt.withContext(Dispatchers.getIO(), (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$currentConfig, this.$configs, this.this$0, this.$settings, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ ScreenshotConfig $currentConfig;
                            final /* synthetic */ ArrayList<ScreenshotConfig> $configs;
                            final /* synthetic */ AdvancedTab this$0;
                            final /* synthetic */ GameSettings $settings;
                            {
                                this.$currentConfig = $currentConfig;
                                this.$configs = $configs;
                                this.this$0 = $receiver;
                                this.$settings = $settings;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$withContext;
                                        ResultKt.throwOnFailure($result);
                                        Thread.sleep(300L);
                                        ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$withContext, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$currentConfig, this.$configs, this.this$0, this.$settings, null){
                                            int label;
                                            private /* synthetic */ Object L$0;
                                            final /* synthetic */ ScreenshotConfig $currentConfig;
                                            final /* synthetic */ ArrayList<ScreenshotConfig> $configs;
                                            final /* synthetic */ AdvancedTab this$0;
                                            final /* synthetic */ GameSettings $settings;
                                            {
                                                this.$currentConfig = $currentConfig;
                                                this.$configs = $configs;
                                                this.this$0 = $receiver;
                                                this.$settings = $settings;
                                                super(2, $completion);
                                            }

                                            /*
                                             * WARNING - void declaration
                                             */
                                            public final Object invokeSuspend(Object $result) {
                                                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure($result);
                                                        Pixmap pixmap = Pixmap.createFromFrameBuffer(0, 0, this.$currentConfig.getWidth(), this.$currentConfig.getHeight());
                                                        PixmapIO.writePNG(new FileHandle(this.$currentConfig.getFileLocation()), pixmap, -1, true);
                                                        pixmap.dispose();
                                                        ArrayList<ScreenshotConfig> newConfigs = CollectionExtensionsKt.withoutItem(this.$configs, this.$currentConfig);
                                                        if (!((Collection)newConfigs).isEmpty()) {
                                                            void $this$launchOnGLThread;
                                                            AdvancedTab.access$generateScreenshots(this.this$0, (CoroutineScope)$this$launchOnGLThread, this.$settings, newConfigs);
                                                        }
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                function2.L$0 = value;
                                                return (Continuation)((Object)function2);
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }, 1, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                function2.L$0 = value;
                                return (Continuation)((Object)function2);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl40
                    }
                    case 2: {
                        newScreen = (WorldScreen)this.L$1;
                        screenshotGame = (GameInfo)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl40:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    private final void addSetUserId() {
        Label idSetLabel = Scene2dExtensionsKt.toLabel("");
        Actor takeUserIdFromClipboardButton = ActivationExtensionsKt.onClick(Scene2dExtensionsKt.toTextButton$default("Take user ID from clipboard", null, false, 3, null), () -> AdvancedTab.addSetUserId$lambda$0(this, idSetLabel));
        this.add(takeUserIdFromClipboardButton).pad(5.0f).colspan(2).row();
        this.add((Actor)idSetLabel).colspan(2).row();
    }

    private final void addEasterEggsCheckBox() {
        OptionsPopup.addCheckbox$core$default(this.optionsPopup, this, "Enable Easter Eggs", this.settings.getEnableEasterEggs(), false, false, arg_0 -> AdvancedTab.addEasterEggsCheckBox$lambda$0(this, arg_0), 24, null);
    }

    private final void addEnlargeNotificationsCheckBox() {
        OptionsPopup.addCheckbox$core$default(this.optionsPopup, this, "Enlarge selected notifications", this.settings.getEnlargeSelectedNotification(), false, false, arg_0 -> AdvancedTab.addEnlargeNotificationsCheckBox$lambda$0(this, arg_0), 24, null);
    }

    private static final Unit addCutoutCheckbox$lambda$0(AdvancedTab this$0, boolean it) {
        this$0.optionsPopup.getSettings().setAndroidCutout(it);
        Display.INSTANCE.setCutout(it);
        this$0.optionsPopup.reopenAfterDisplayLayoutChange$core();
        return Unit.INSTANCE;
    }

    private static final Unit addHideSystemUiCheckbox$lambda$0(AdvancedTab this$0, boolean it) {
        this$0.optionsPopup.getSettings().setAndroidHideSystemUi(it);
        Display.INSTANCE.setSystemUiVisibility(it);
        this$0.optionsPopup.reopenAfterDisplayLayoutChange$core();
        return Unit.INSTANCE;
    }

    private static final boolean addAutosaveField$lambda$0(TextField textField, char c) {
        return StringsKt.contains$default((CharSequence)"1234567890", c, false, 2, null);
    }

    private static final Unit addAutosaveField$lambda$1(UncivTextField $autoSaveTrunsTextField, AdvancedTab this$0) {
        String string = $autoSaveTrunsTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        if (((CharSequence)string).length() == 0) {
            return Unit.INSTANCE;
        }
        String string2 = $autoSaveTrunsTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
        int numberAutosaveTurns = Integer.parseInt(string2);
        if (numberAutosaveTurns <= 0) {
            Stage stage = this$0.getStage();
            Intrinsics.checkNotNullExpressionValue(stage, "getStage(...)");
            Popup popup2 = new Popup(stage, null, 0.0f, 6, null);
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue(color, "RED");
            Popup.addGoodSizedLabel$default(popup2, "Autosave turns must be larger than 0!", 0, false, color, 6, null);
            Popup.addCloseButton$default(popup2, null, null, null, null, 15, null);
            popup2.open(true);
        } else if (numberAutosaveTurns >= 200) {
            Stage stage = this$0.getStage();
            Intrinsics.checkNotNullExpressionValue(stage, "getStage(...)");
            Popup popup3 = new Popup(stage, null, 0.0f, 6, null);
            Color color = Color.ORANGE;
            Intrinsics.checkNotNullExpressionValue(color, "ORANGE");
            Popup.addGoodSizedLabel$default(popup3, "Autosave turns over 200 may take a lot of space on your device.", 0, false, color, 6, null);
            Popup.addCloseButton$default(popup3, null, null, null, null, 15, null);
            popup3.open(true);
            this$0.settings.setMaxAutosavesStored(numberAutosaveTurns);
        } else {
            this$0.settings.setMaxAutosavesStored(numberAutosaveTurns);
        }
        return Unit.INSTANCE;
    }

    private static final Unit addAutosaveTurnsSelectBox$lambda$0(AdvancedTab this$0, SelectBox $autosaveTurnsSelectBox, ChangeListener.ChangeEvent it) {
        GameSettings gameSettings = this$0.settings;
        Object t = $autosaveTurnsSelectBox.getSelected();
        Intrinsics.checkNotNullExpressionValue(t, "getSelected(...)");
        gameSettings.setTurnsBetweenAutosaves(((Number)t).intValue());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void addFontFamilySelect$loadFontSelect(AdvancedTab this$0, Function0<Unit> $onFontChange, Array<FontFamilyData> fonts, Cell<Actor> selectCell) {
        Object t;
        SelectBox<FontFamilyData> selectBox;
        SelectBox<FontFamilyData> fontSelectBox;
        block2: {
            void $this$firstOrNull$iv;
            if (fonts.isEmpty()) {
                return;
            }
            fontSelectBox = new SelectBox<FontFamilyData>(this$0.getSkin());
            fontSelectBox.setItems(fonts);
            FontFamilyData fontToSelect = this$0.settings.getFontFamilyData();
            Iterable iterable = fonts;
            selectBox = fontSelectBox;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FontFamilyData it = (FontFamilyData)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getInvariantName(), fontToSelect.getInvariantName())) continue;
                t = element$iv;
                break block2;
            }
            t = null;
        }
        selectBox.setSelected((FontFamilyData)t);
        selectCell.setActor((Actor)fontSelectBox).minWidth(this$0.optionsPopup.getSelectBoxMinWidth()).pad(10.0f);
        ActivationExtensionsKt.onChange(fontSelectBox, arg_0 -> AdvancedTab.addFontFamilySelect$loadFontSelect$lambda$1(this$0, fontSelectBox, $onFontChange, arg_0));
    }

    private static final Unit addFontFamilySelect$loadFontSelect$lambda$1(AdvancedTab this$0, SelectBox $fontSelectBox, Function0 $onFontChange, ChangeListener.ChangeEvent it) {
        GameSettings gameSettings = this$0.settings;
        Object t = $fontSelectBox.getSelected();
        Intrinsics.checkNotNullExpressionValue(t, "getSelected(...)");
        gameSettings.setFontFamilyData((FontFamilyData)t);
        $onFontChange.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit addFontSizeMultiplier$lambda$0(AdvancedTab this$0, float it) {
        this$0.settings.setFontSizeMultiplier(it);
        return Unit.INSTANCE;
    }

    private static final Unit addFontSizeMultiplier$lambda$1(UncivSlider $fontSizeSlider, Function0 $onFontChange, ChangeListener.ChangeEvent it) {
        if (!$fontSizeSlider.isDragging()) {
            $onFontChange.invoke();
        }
        return Unit.INSTANCE;
    }

    private static final Unit addMaxZoomSlider$lambda$0(AdvancedTab this$0, float it) {
        this$0.settings.setMaxWorldZoomOut(it);
        if (GUI.INSTANCE.isWorldLoaded()) {
            GUI.INSTANCE.getMap().reloadMaxZoom();
        }
        return Unit.INSTANCE;
    }

    private static final Unit addTranslationGeneration$lambda$0(AdvancedTab this$0, TextButton $generateTranslationsButton) {
        TabbedPager.selectPage$default(this$0.optionsPopup.getTabs(), "Advanced", false, 2, null);
        $generateTranslationsButton.setText(TranslationsKt.tr$default("Working...", false, false, 3, null));
        Concurrency.run$default(Concurrency.INSTANCE, "WriteTranslations", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>($generateTranslationsButton, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TextButton $generateTranslationsButton;
            {
                this.$generateTranslationsButton = $generateTranslationsButton;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$run;
                        ResultKt.throwOnFailure($result);
                        String result2 = TranslationFileWriter.INSTANCE.writeNewTranslationFiles();
                        ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$generateTranslationsButton, result2, null){
                            int label;
                            final /* synthetic */ TextButton $generateTranslationsButton;
                            final /* synthetic */ String $result;
                            {
                                this.$generateTranslationsButton = $generateTranslationsButton;
                                this.$result = $result;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure($result);
                                        this.$generateTranslationsButton.setText(TranslationsKt.tr$default(this.$result, false, false, 3, null));
                                        Scene2dExtensionsKt.disable(this.$generateTranslationsButton);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit addTranslationGeneration$lambda$1(TextButton $updateModCategoriesButton) {
        $updateModCategoriesButton.setText(TranslationsKt.tr$default("Working...", false, false, 3, null));
        Concurrency.run$default(Concurrency.INSTANCE, "GithubTopicQuery", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>($updateModCategoriesButton, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TextButton $updateModCategoriesButton;
            {
                this.$updateModCategoriesButton = $updateModCategoriesButton;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.L$0 = $this$run;
                        this.label = 1;
                        v0 = ModCategories.Companion.mergeOnline(this);
                        if (v0 == var4_3) {
                            return var4_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        result = (String)v0;
                        ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$updateModCategoriesButton, result, null){
                            int label;
                            final /* synthetic */ TextButton $updateModCategoriesButton;
                            final /* synthetic */ String $result;
                            {
                                this.$updateModCategoriesButton = $updateModCategoriesButton;
                                this.$result = $result;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure($result);
                                        this.$updateModCategoriesButton.setText(this.$result);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit addTranslationGeneration$lambda$2(TextButton $generateScreenshotsButton, AdvancedTab this$0) {
        $generateScreenshotsButton.setText(TranslationsKt.tr$default("Working...", false, false, 3, null));
        Concurrency.run$default(Concurrency.INSTANCE, "GenerateScreenshot", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ AdvancedTab this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$run;
                        ResultKt.throwOnFailure($result);
                        String extraImagesLocation = "../../extraImages";
                        ScreenshotConfig[] screenshotConfigArray = new ScreenshotConfig[]{new ScreenshotConfig(630, 500, GameSettings.ScreenSize.Medium, extraImagesLocation + "/itch.io image.png", new Vector2(-2.0f, 2.0f), false), new ScreenshotConfig(1280, 640, GameSettings.ScreenSize.Medium, extraImagesLocation + "/GithubPreviewImage.png", new Vector2(-2.0f, 4.0f), false, 32, null), new ScreenshotConfig(1024, 500, GameSettings.ScreenSize.Medium, extraImagesLocation + "/Feature graphic - Google Play.png", new Vector2(-2.0f, 6.0f), false, 32, null), new ScreenshotConfig(1024, 500, GameSettings.ScreenSize.Medium, "../../fastlane/metadata/android/en-US/images/featureGraphic.png", new Vector2(-2.0f, 8.0f), false, 32, null)};
                        AdvancedTab.access$generateScreenshots(this.this$0, (CoroutineScope)$this$run, AdvancedTab.access$getOptionsPopup$p(this.this$0).getSettings(), CollectionsKt.arrayListOf(screenshotConfigArray));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit addSetUserId$lambda$0(AdvancedTab this$0, Label $idSetLabel) {
        String string = Gdx.app.getClipboard().getContents();
        Intrinsics.checkNotNullExpressionValue(string, "getContents(...)");
        String clipboardContents = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (StringExtensionsKt.isUUID(clipboardContents)) {
            Stage stage = this$0.getStage();
            Intrinsics.checkNotNullExpressionValue(stage, "getStage(...)");
            new ConfirmPopup(stage, "Doing this will reset your current user ID to the clipboard contents - are you sure?", "Take user ID from clipboard", false, null, () -> AdvancedTab.addSetUserId$lambda$0$0(this$0, clipboardContents, $idSetLabel), 24, null).open(true);
            $idSetLabel.setVisible(true);
        } else {
            $idSetLabel.setVisible(true);
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue(color, "RED");
            Scene2dExtensionsKt.setFontColor($idSetLabel, color).setText(TranslationsKt.tr$default("Invalid ID!", false, false, 3, null));
        }
        return Unit.INSTANCE;
    }

    private static final Unit addSetUserId$lambda$0$0(AdvancedTab this$0, String $clipboardContents, Label $idSetLabel) {
        this$0.settings.getMultiplayer().setUserId($clipboardContents);
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        Scene2dExtensionsKt.setFontColor($idSetLabel, color).setText(TranslationsKt.tr$default("ID successfully set!", false, false, 3, null));
        return Unit.INSTANCE;
    }

    private static final Unit addEasterEggsCheckBox$lambda$0(AdvancedTab this$0, boolean it) {
        this$0.settings.setEnableEasterEggs(it);
        return Unit.INSTANCE;
    }

    private static final Unit addEnlargeNotificationsCheckBox$lambda$0(AdvancedTab this$0, boolean it) {
        this$0.settings.setEnlargeSelectedNotification(it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$addFontFamilySelect$loadFontSelect(AdvancedTab this$0, Function0 $onFontChange, Array fonts, Cell selectCell) {
        AdvancedTab.addFontFamilySelect$loadFontSelect(this$0, $onFontChange, fonts, selectCell);
    }

    public static final /* synthetic */ void access$generateScreenshots(AdvancedTab $this, CoroutineScope $receiver, GameSettings settings, ArrayList configs) {
        $this.generateScreenshots($receiver, settings, configs);
    }

    public static final /* synthetic */ OptionsPopup access$getOptionsPopup$p(AdvancedTab $this) {
        return $this.optionsPopup;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001f\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0006H\u00c6\u0003J\t\u0010#\u001a\u00020\bH\u00c6\u0003J\t\u0010$\u001a\u00020\nH\u00c6\u0003J\t\u0010%\u001a\u00020\fH\u00c6\u0003JE\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001J\t\u0010*\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006+"}, d2={"Lcom/unciv/ui/popups/options/AdvancedTab$ScreenshotConfig;", "", "width", "", "height", "screenSize", "Lcom/unciv/models/metadata/GameSettings$ScreenSize;", "fileLocation", "", "centerTile", "Lcom/badlogic/gdx/math/Vector2;", "attackCity", "", "<init>", "(IILcom/unciv/models/metadata/GameSettings$ScreenSize;Ljava/lang/String;Lcom/badlogic/gdx/math/Vector2;Z)V", "getWidth", "()I", "getHeight", "getScreenSize", "()Lcom/unciv/models/metadata/GameSettings$ScreenSize;", "getFileLocation", "()Ljava/lang/String;", "setFileLocation", "(Ljava/lang/String;)V", "getCenterTile", "()Lcom/badlogic/gdx/math/Vector2;", "setCenterTile", "(Lcom/badlogic/gdx/math/Vector2;)V", "getAttackCity", "()Z", "setAttackCity", "(Z)V", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "toString", "core"})
    public static final class ScreenshotConfig {
        private final int width;
        private final int height;
        @NotNull
        private final GameSettings.ScreenSize screenSize;
        @NotNull
        private String fileLocation;
        @NotNull
        private Vector2 centerTile;
        private boolean attackCity;

        public ScreenshotConfig(int width, int height, @NotNull GameSettings.ScreenSize screenSize, @NotNull String fileLocation, @NotNull Vector2 centerTile, boolean attackCity) {
            Intrinsics.checkNotNullParameter((Object)screenSize, "screenSize");
            Intrinsics.checkNotNullParameter(fileLocation, "fileLocation");
            Intrinsics.checkNotNullParameter(centerTile, "centerTile");
            this.width = width;
            this.height = height;
            this.screenSize = screenSize;
            this.fileLocation = fileLocation;
            this.centerTile = centerTile;
            this.attackCity = attackCity;
        }

        public /* synthetic */ ScreenshotConfig(int n, int n2, GameSettings.ScreenSize screenSize, String string, Vector2 vector2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 0x20) != 0) {
                bl = true;
            }
            this(n, n2, screenSize, string, vector2, bl);
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        @NotNull
        public final GameSettings.ScreenSize getScreenSize() {
            return this.screenSize;
        }

        @NotNull
        public final String getFileLocation() {
            return this.fileLocation;
        }

        public final void setFileLocation(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.fileLocation = string;
        }

        @NotNull
        public final Vector2 getCenterTile() {
            return this.centerTile;
        }

        public final void setCenterTile(@NotNull Vector2 vector2) {
            Intrinsics.checkNotNullParameter(vector2, "<set-?>");
            this.centerTile = vector2;
        }

        public final boolean getAttackCity() {
            return this.attackCity;
        }

        public final void setAttackCity(boolean bl) {
            this.attackCity = bl;
        }

        public final int component1() {
            return this.width;
        }

        public final int component2() {
            return this.height;
        }

        @NotNull
        public final GameSettings.ScreenSize component3() {
            return this.screenSize;
        }

        @NotNull
        public final String component4() {
            return this.fileLocation;
        }

        @NotNull
        public final Vector2 component5() {
            return this.centerTile;
        }

        public final boolean component6() {
            return this.attackCity;
        }

        @NotNull
        public final ScreenshotConfig copy(int width, int height, @NotNull GameSettings.ScreenSize screenSize, @NotNull String fileLocation, @NotNull Vector2 centerTile, boolean attackCity) {
            Intrinsics.checkNotNullParameter((Object)screenSize, "screenSize");
            Intrinsics.checkNotNullParameter(fileLocation, "fileLocation");
            Intrinsics.checkNotNullParameter(centerTile, "centerTile");
            return new ScreenshotConfig(width, height, screenSize, fileLocation, centerTile, attackCity);
        }

        public static /* synthetic */ ScreenshotConfig copy$default(ScreenshotConfig screenshotConfig, int n, int n2, GameSettings.ScreenSize screenSize, String string, Vector2 vector2, boolean bl, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = screenshotConfig.width;
            }
            if ((n3 & 2) != 0) {
                n2 = screenshotConfig.height;
            }
            if ((n3 & 4) != 0) {
                screenSize = screenshotConfig.screenSize;
            }
            if ((n3 & 8) != 0) {
                string = screenshotConfig.fileLocation;
            }
            if ((n3 & 0x10) != 0) {
                vector2 = screenshotConfig.centerTile;
            }
            if ((n3 & 0x20) != 0) {
                bl = screenshotConfig.attackCity;
            }
            return screenshotConfig.copy(n, n2, screenSize, string, vector2, bl);
        }

        @NotNull
        public String toString() {
            return "ScreenshotConfig(width=" + this.width + ", height=" + this.height + ", screenSize=" + (Object)((Object)this.screenSize) + ", fileLocation=" + this.fileLocation + ", centerTile=" + this.centerTile + ", attackCity=" + this.attackCity + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.width);
            result2 = result2 * 31 + Integer.hashCode(this.height);
            result2 = result2 * 31 + this.screenSize.hashCode();
            result2 = result2 * 31 + this.fileLocation.hashCode();
            result2 = result2 * 31 + this.centerTile.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.attackCity);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScreenshotConfig)) {
                return false;
            }
            ScreenshotConfig screenshotConfig = (ScreenshotConfig)other;
            if (this.width != screenshotConfig.width) {
                return false;
            }
            if (this.height != screenshotConfig.height) {
                return false;
            }
            if (this.screenSize != screenshotConfig.screenSize) {
                return false;
            }
            if (!Intrinsics.areEqual(this.fileLocation, screenshotConfig.fileLocation)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.centerTile, screenshotConfig.centerTile)) {
                return false;
            }
            return this.attackCity == screenshotConfig.attackCity;
        }
    }
}

