/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.basescreen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.utils.CharArray;
import com.badlogic.gdx.utils.SnapshotArray;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.fonts.Fonts;
import com.unciv.ui.images.ImageGetter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J7\u0010\u0017\u001a)\u0012\u0017\u0012\u00150\u000ej\u0002`\u000f\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0018j\u0004\u0018\u0001`\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001c\u001a\u00020\u0011*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010 \u001a\u00020\u0011*\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/unciv/ui/screens/basescreen/StageMouseOverDebug;", "", "<init>", "()V", "label", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "mouseCoords", "Lcom/badlogic/gdx/math/Vector2;", "shapeRenderer", "Lcom/badlogic/gdx/graphics/glutils/ShapeRenderer;", "axisColor", "Lcom/badlogic/gdx/graphics/Color;", "kotlin.jvm.PlatformType", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "draw", "", "stage", "Lcom/badlogic/gdx/scenes/scene2d/Stage;", "addActorLabel", "actor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "getActorDescriptiveName", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Lcom/unciv/ui/screens/basescreen/AddToStringBuilderFactory;", "appendLimited", "text", "", "layoutLabel", "drawAxes", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nStageMouseOverDebug.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StageMouseOverDebug.kt\ncom/unciv/ui/screens/basescreen/StageMouseOverDebug\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,208:1\n1#2:209\n183#3,2:210\n*S KotlinDebug\n*F\n+ 1 StageMouseOverDebug.kt\ncom/unciv/ui/screens/basescreen/StageMouseOverDebug\n*L\n109#1:210,2\n*E\n"})
public final class StageMouseOverDebug {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Label label;
    @NotNull
    private final Vector2 mouseCoords = new Vector2();
    private ShapeRenderer shapeRenderer;
    private final Color axisColor;
    @NotNull
    private final StringBuilder sb;
    private static final float padding = 3.0f;
    private static final float overlayAlpha = 0.8f;
    private static final int axisInterval = 20;
    private static final float axisTickLength = 6.0f;
    private static final float axisTickWidth = 1.5f;
    private static final int maxChildScan = 10;
    private static final int maxTextLength = 20;

    /*
     * WARNING - void declaration
     */
    public StageMouseOverDebug() {
        void $this$_init__u24lambda_u240;
        Color color = Color.RED.cpy();
        Object object = color;
        Object object2 = this;
        boolean $i$a$-apply-StageMouseOverDebug$axisColor$22 = false;
        $this$axisColor_u24lambda_u240.a = 0.8f;
        ((StageMouseOverDebug)object2).axisColor = color;
        this.sb = new StringBuilder(160);
        Label.LabelStyle style = new Label.LabelStyle(Fonts.INSTANCE.getFont(), Color.WHITE);
        Object $i$a$-apply-StageMouseOverDebug$axisColor$22 = object = ImageGetter.INSTANCE.getWhiteDotDrawable().tint(Color.DARK_GRAY);
        object2 = style;
        boolean bl = false;
        $this$_init__u24lambda_u240.setLeftWidth(3.0f);
        $this$_init__u24lambda_u240.setRightWidth(3.0f);
        $this$_init__u24lambda_u240.setTopHeight(3.0f);
        $this$_init__u24lambda_u240.setBottomHeight(3.0f);
        ((Label.LabelStyle)object2).background = object;
        style.fontColor = Color.GOLDENROD;
        this.label = new Label((CharSequence)"", style);
        this.label.setAlignment(1);
    }

    public final void draw(@NotNull Stage stage) {
        Intrinsics.checkNotNullParameter(stage, "stage");
        this.mouseCoords.set(Gdx.input.getX(), Gdx.input.getY());
        stage.screenToStageCoordinates(this.mouseCoords);
        StringsKt.clear(this.sb);
        this.sb.append(TranslationsKt.tr((int)this.mouseCoords.x));
        this.sb.append(" / ");
        this.sb.append(TranslationsKt.tr((int)this.mouseCoords.y));
        this.sb.append(" (");
        this.sb.append(TranslationsKt.tr(Gdx.graphics.getFramesPerSecond()));
        this.sb.append(")\n");
        this.addActorLabel(stage.hit(this.mouseCoords.x, this.mouseCoords.y, false));
        this.label.setText(this.sb);
        this.layoutLabel(stage);
        Batch batch = stage.getBatch();
        batch.setProjectionMatrix(stage.getCamera().combined);
        batch.begin();
        this.label.draw(batch, 0.8f);
        batch.end();
        this.drawAxes(stage);
    }

    /*
     * WARNING - void declaration
     */
    private final void addActorLabel(Actor actor) {
        if (actor == null) {
            return;
        }
        Function1<StringBuilder, Unit> actorBuilder = this.getActorDescriptiveName(actor);
        Function1<StringBuilder, Unit> parentBuilder = null;
        Function1 childBuilder = null;
        if (actorBuilder == null) {
            if (actor.getParent() != null) {
                Group group = actor.getParent();
                Intrinsics.checkNotNullExpressionValue(group, "getParent(...)");
                parentBuilder = this.getActorDescriptiveName(group);
            }
            if (parentBuilder == null && actor instanceof Group) {
                Object v2;
                block11: {
                    void $this$firstOrNull$iv;
                    SnapshotArray<Actor> snapshotArray = ((Group)actor).getChildren();
                    Intrinsics.checkNotNullExpressionValue(snapshotArray, "getChildren(...)");
                    Sequence<Function1> sequence = SequencesKt.map(SequencesKt.take(CollectionsKt.asSequence((Iterable)snapshotArray), 10), arg_0 -> StageMouseOverDebug.addActorLabel$lambda$0(this, arg_0));
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Function1 it = (Function1)element$iv;
                        boolean bl = false;
                        if (!(it != null)) continue;
                        v2 = element$iv;
                        break block11;
                    }
                    v2 = null;
                }
                childBuilder = v2;
            }
        }
        if (parentBuilder != null) {
            parentBuilder.invoke(this.sb);
            this.sb.append('.');
        } else if (actor.getParent() != null) {
            this.sb.append(actor.getParent().getClass().getSimpleName());
            this.sb.append('.');
        }
        if (actorBuilder != null) {
            actorBuilder.invoke(this.sb);
        } else {
            this.sb.append(actor.getClass().getSimpleName());
        }
        if (childBuilder != null) {
            this.sb.append('(');
            childBuilder.invoke(this.sb);
            this.sb.append(')');
        }
    }

    private final Function1<StringBuilder, Unit> getActorDescriptiveName(Actor actor) {
        if (actor.getName() != null) {
            String className = actor.getClass().getSimpleName();
            String string = actor.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            Intrinsics.checkNotNull(className);
            if (StringsKt.startsWith$default(string, className, false, 2, null)) {
                return arg_0 -> StageMouseOverDebug.getActorDescriptiveName$lambda$0(actor, arg_0);
            }
            return arg_0 -> StageMouseOverDebug.getActorDescriptiveName$lambda$1(className, actor, arg_0);
        }
        if (actor instanceof Label) {
            CharArray charArray = ((Label)actor).getText();
            Intrinsics.checkNotNullExpressionValue(charArray, "getText(...)");
            if (!StringsKt.isBlank(charArray)) {
                return arg_0 -> StageMouseOverDebug.getActorDescriptiveName$lambda$2(this, actor, arg_0);
            }
        }
        if (actor instanceof TextButton) {
            CharSequence charSequence = ((TextButton)actor).getText();
            Intrinsics.checkNotNullExpressionValue(charSequence, "getText(...)");
            if (!StringsKt.isBlank(charSequence)) {
                return arg_0 -> StageMouseOverDebug.getActorDescriptiveName$lambda$3(this, actor, arg_0);
            }
        }
        return null;
    }

    private final void appendLimited(StringBuilder $this$appendLimited, CharSequence text2) {
        int lf = StringsKt.indexOf$default(text2, '\n', 0, false, 6, null) + 1;
        int len = RangesKt.coerceAtMost(lf == 0 ? text2.length() : lf, 20);
        if (len == text2.length()) {
            $this$appendLimited.append(text2);
            return;
        }
        $this$appendLimited.append(text2, 0, len);
        $this$appendLimited.append('\u2025');
    }

    private final void layoutLabel(Stage stage) {
        if (!this.label.needsLayout()) {
            return;
        }
        float width = this.label.getPrefWidth() + 6.0f;
        this.label.setSize(width, this.label.getPrefHeight() + 6.0f);
        this.label.setPosition(stage.getWidth() - width, 0.0f);
        this.label.validate();
    }

    private final void drawAxes(Stage $this$drawAxes) {
        ShapeRenderer shapeRenderer;
        if (this.shapeRenderer == null) {
            this.shapeRenderer = new ShapeRenderer();
            ShapeRenderer shapeRenderer2 = this.shapeRenderer;
            if (shapeRenderer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("shapeRenderer");
                shapeRenderer2 = null;
            }
            shapeRenderer2.setAutoShapeType(true);
        }
        if ((shapeRenderer = this.shapeRenderer) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("shapeRenderer");
            shapeRenderer = null;
        }
        ShapeRenderer sr = shapeRenderer;
        Gdx.gl.glEnable(3042);
        sr.setProjectionMatrix($this$drawAxes.getViewport().getCamera().combined);
        sr.begin();
        sr.set(ShapeRenderer.ShapeType.Filled);
        float y2 = $this$drawAxes.getHeight();
        float y1 = y2 - 6.0f;
        int n = (int)$this$drawAxes.getWidth();
        int x = 0;
        int n2 = ProgressionUtilKt.getProgressionLastElement(0, n, 20);
        if (x <= n2) {
            while (true) {
                float xf = x;
                sr.rectLine(xf, 0.0f, xf, 6.0f, 1.5f, this.axisColor, this.axisColor);
                sr.rectLine(xf, y1, xf, y2, 1.5f, this.axisColor, this.axisColor);
                if (x == n2) break;
                x += 20;
            }
        }
        float x2 = $this$drawAxes.getWidth();
        float x1 = x2 - 6.0f;
        int y = 0;
        n2 = (int)$this$drawAxes.getHeight();
        int n3 = ProgressionUtilKt.getProgressionLastElement(0, n2, 20);
        if (y <= n3) {
            while (true) {
                float yf = y;
                sr.rectLine(0.0f, yf, 6.0f, yf, 1.5f, this.axisColor, this.axisColor);
                sr.rectLine(x1, yf, x2, yf, 1.5f, this.axisColor, this.axisColor);
                if (y == n3) break;
                y += 20;
            }
        }
        sr.end();
        Gdx.gl.glDisable(3042);
    }

    private static final Function1 addActorLabel$lambda$0(StageMouseOverDebug this$0, Actor it) {
        Intrinsics.checkNotNull(it);
        return this$0.getActorDescriptiveName(it);
    }

    private static final Unit getActorDescriptiveName$lambda$0(Actor $actor, StringBuilder sb) {
        Intrinsics.checkNotNullParameter(sb, "sb");
        sb.append($actor.getName());
        return Unit.INSTANCE;
    }

    private static final Unit getActorDescriptiveName$lambda$1(String $className, Actor $actor, StringBuilder sb) {
        Intrinsics.checkNotNullParameter(sb, "sb");
        sb.append($className);
        sb.append(':');
        sb.append($actor.getName());
        return Unit.INSTANCE;
    }

    private static final Unit getActorDescriptiveName$lambda$2(StageMouseOverDebug this$0, Actor $actor, StringBuilder sb) {
        Intrinsics.checkNotNullParameter(sb, "sb");
        sb.append("Label\"");
        CharArray charArray = ((Label)$actor).getText();
        Intrinsics.checkNotNullExpressionValue(charArray, "getText(...)");
        this$0.appendLimited(sb, charArray);
        sb.append('\"');
        return Unit.INSTANCE;
    }

    private static final Unit getActorDescriptiveName$lambda$3(StageMouseOverDebug this$0, Actor $actor, StringBuilder sb) {
        Intrinsics.checkNotNullParameter(sb, "sb");
        sb.append("TextButton\"");
        CharSequence charSequence = ((TextButton)$actor).getText();
        Intrinsics.checkNotNullExpressionValue(charSequence, "getText(...)");
        this$0.appendLimited(sb, charSequence);
        sb.append('\"');
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/unciv/ui/screens/basescreen/StageMouseOverDebug$Companion;", "", "<init>", "()V", "padding", "", "overlayAlpha", "axisInterval", "", "axisTickLength", "axisTickWidth", "maxChildScan", "maxTextLength", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

