/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.pickerscreens;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyFunctions;
import com.unciv.models.UncivSound;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.pickerscreens.PickerPane;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0002J*\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/screens/pickerscreens/DiplomaticVotePickerScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "votingCiv", "Lcom/unciv/logic/civilization/Civilization;", "<init>", "(Lcom/unciv/logic/civilization/Civilization;)V", "chosenCiv", "", "voteAndClose", "", "addButton", "caption", "pickText", "choice", "icon", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "core"})
public final class DiplomaticVotePickerScreen
extends PickerScreen {
    @NotNull
    private final Civilization votingCiv;
    @Nullable
    private String chosenCiv;

    /*
     * WARNING - void declaration
     */
    public DiplomaticVotePickerScreen(@NotNull Civilization votingCiv) {
        void $this$_init__u24lambda_u240;
        Object civ;
        Intrinsics.checkNotNullParameter(votingCiv, "votingCiv");
        super(false, 1, null);
        this.votingCiv = votingCiv;
        this.setDefaultCloseAction();
        this.getRightSideButton().setText(TranslationsKt.tr$default("Choose a civ to vote for", false, false, 3, null));
        this.getDescriptionLabel().setText(TranslationsKt.tr$default("Choose who should become the world leader and win a Diplomatic Victory!", false, false, 3, null));
        Sequence choosableCivs = DiplomacyFunctions.getKnownCivsSorted$default(this.votingCiv.getDiplomacyFunctions(), false, false, 2, null);
        Object object = choosableCivs.iterator();
        while (object.hasNext()) {
            civ = (Civilization)object.next();
            this.addButton(((Civilization)civ).getCivName(), "Vote for [" + ((Civilization)civ).getCivName() + ']', ((Civilization)civ).getCivName(), ImageGetter.INSTANCE.getNationPortrait(((Civilization)civ).getNation(), 30.0f));
        }
        civ = object = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Stop", null, 2, null);
        String string = null;
        String string2 = "Abstain";
        String string3 = "Abstain";
        DiplomaticVotePickerScreen diplomaticVotePickerScreen = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setSize(30.0f, 30.0f);
        Unit unit = Unit.INSTANCE;
        diplomaticVotePickerScreen.addButton(string3, string2, string, (Actor)object);
        ActivationExtensionsKt.onClick(this.getRightSideButton(), UncivSound.Companion.getChimes(), new Function0<Unit>((Object)this){

            @Override
            public final void invoke() {
                ((DiplomaticVotePickerScreen)this.receiver).voteAndClose();
            }
        });
    }

    private final void voteAndClose() {
        this.votingCiv.diplomaticVoteForCiv(this.chosenCiv);
        UncivGame.popScreen$default(UncivGame.Companion.getCurrent(), false, 1, null);
    }

    private final void addButton(String caption, String pickText, String choice, Actor icon) {
        Button button = PickerPane.Companion.getPickerOptionButton(icon, caption);
        ActivationExtensionsKt.onClick(button, () -> DiplomaticVotePickerScreen.addButton$lambda$0(this, choice, pickText));
        ActivationExtensionsKt.onDoubleClick(button, UncivSound.Companion.getChimes(), () -> DiplomaticVotePickerScreen.addButton$lambda$1(this, choice));
        this.getTopTable().add((Actor)button).fillX().pad(10.0f).row();
    }

    private static final Unit addButton$lambda$0(DiplomaticVotePickerScreen this$0, String $choice, String $pickText) {
        this$0.chosenCiv = $choice;
        this$0.pick(TranslationsKt.tr$default($pickText, false, false, 3, null));
        return Unit.INSTANCE;
    }

    private static final Unit addButton$lambda$1(DiplomaticVotePickerScreen this$0, String $choice) {
        this$0.chosenCiv = $choice;
        this$0.voteAndClose();
        return Unit.INSTANCE;
    }
}

