/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.files;

import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.io.CoreKt;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsJvmKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u001a'\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0006\u001a'\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0007\u001a\u0011\u0010\b\u001a\u00020\t*\u00020\u0001H\u0007\u00a2\u0006\u0002\b\n\u001a\u0011\u0010\u000b\u001a\u00020\f*\u00020\u0001H\u0007\u00a2\u0006\u0002\b\r\u001a\u001a\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0003H\u0002\u00a8\u0006\u0017"}, d2={"Path", "Lkotlinx/io/files/Path;", "base", "", "parts", "", "(Ljava/lang/String;[Ljava/lang/String;)Lkotlinx/io/files/Path;", "(Lkotlinx/io/files/Path;[Ljava/lang/String;)Lkotlinx/io/files/Path;", "source", "Lkotlinx/io/Source;", "sourceDeprecated", "sink", "Lkotlinx/io/Sink;", "sinkDeprecated", "removeTrailingSeparators", "path", "isWindows_", "", "isUnc", "removeTrailingSeparatorsUnix", "removeTrailingSeparatorsWindows", "suffixLength", "", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Paths.kt\nkotlinx/io/files/PathsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,177:1\n13402#2,2:178\n*S KotlinDebug\n*F\n+ 1 Paths.kt\nkotlinx/io/files/PathsKt\n*L\n84#1:178,2\n*E\n"})
public final class PathsKt {
    @NotNull
    public static final Path Path(@NotNull String base, String ... parts) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(base, "base");
        Intrinsics.checkNotNullParameter(parts, "parts");
        StringBuilder $this$Path_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$Path_u24lambda_u241.append(base);
        String[] $this$forEach$iv = parts;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            if (((CharSequence)$this$Path_u24lambda_u241).length() > 0 && !StringsKt.endsWith$default((CharSequence)$this$Path_u24lambda_u241, PathsJvmKt.SystemPathSeparator, false, 2, null)) {
                $this$Path_u24lambda_u241.append(PathsJvmKt.SystemPathSeparator);
            }
            $this$Path_u24lambda_u241.append(it);
        }
        return PathsJvmKt.Path(stringBuilder.toString());
    }

    @NotNull
    public static final Path Path(@NotNull Path base, String ... parts) {
        Intrinsics.checkNotNullParameter(base, "base");
        Intrinsics.checkNotNullParameter(parts, "parts");
        return PathsKt.Path(base.toString(), Arrays.copyOf(parts, parts.length));
    }

    @Deprecated(message="Use FileSystem.source instead", replaceWith=@ReplaceWith(expression="SystemFileSystem.source(this).buffered()", imports={"kotlinx.io.files.FileSystem"}), level=DeprecationLevel.WARNING)
    @JvmName(name="sourceDeprecated")
    @NotNull
    public static final Source sourceDeprecated(@NotNull Path $this$source) {
        Intrinsics.checkNotNullParameter($this$source, "<this>");
        return CoreKt.buffered(FileSystemJvmKt.SystemFileSystem.source($this$source));
    }

    @Deprecated(message="Use FileSystem.sink instead", replaceWith=@ReplaceWith(expression="SystemFileSystem.sink(this).buffered()", imports={"kotlinx.io.files.FileSystem"}), level=DeprecationLevel.WARNING)
    @JvmName(name="sinkDeprecated")
    @NotNull
    public static final Sink sinkDeprecated(@NotNull Path $this$sink) {
        Intrinsics.checkNotNullParameter($this$sink, "<this>");
        return CoreKt.buffered(FileSystem.sink$default(FileSystemJvmKt.SystemFileSystem, $this$sink, false, 2, null));
    }

    @NotNull
    public static final String removeTrailingSeparators(@NotNull String path, boolean isWindows_) {
        Intrinsics.checkNotNullParameter(path, "path");
        if (isWindows_) {
            int limit = path.length() > 1 ? (path.charAt(1) == ':' ? 3 : (PathsKt.isUnc(path) ? 2 : 1)) : 1;
            return PathsKt.removeTrailingSeparatorsWindows(limit, path);
        }
        return PathsKt.removeTrailingSeparatorsUnix(path);
    }

    public static /* synthetic */ String removeTrailingSeparators$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = FileSystemJvmKt.isWindows();
        }
        return PathsKt.removeTrailingSeparators(string, bl);
    }

    private static final boolean isUnc(String path) {
        if (path.length() < 2) {
            return false;
        }
        if (StringsKt.startsWith$default(path, "\\\\", false, 2, null)) {
            return true;
        }
        return StringsKt.startsWith$default(path, "//", false, 2, null);
    }

    private static final String removeTrailingSeparatorsUnix(String path) {
        int idx;
        for (idx = path.length(); idx > 1 && path.charAt(idx - 1) == '/'; --idx) {
        }
        String string = path.substring(0, idx);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        return string;
    }

    private static final String removeTrailingSeparatorsWindows(int suffixLength, String path) {
        char c;
        int idx;
        if (!(suffixLength >= 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        for (idx = path.length(); idx > suffixLength && ((c = path.charAt(idx - 1)) == '\\' || c == '/'); --idx) {
        }
        String string = path.substring(0, idx);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        return string;
    }
}

