/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0013\u0010\u001f\u001a\u00020\u001a2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020\u0012H\u0016J\b\u0010#\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u0082\u0001\u0002$%\u00a8\u0006&"}, d2={"Lkotlinx/serialization/internal/MapLikeDescriptor;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialName", "", "keyDescriptor", "valueDescriptor", "<init>", "(Ljava/lang/String;Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "getSerialName", "()Ljava/lang/String;", "getKeyDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "getValueDescriptor", "kind", "Lkotlinx/serialization/descriptors/SerialKind;", "getKind", "()Lkotlinx/serialization/descriptors/SerialKind;", "elementsCount", "", "getElementsCount", "()I", "getElementName", "index", "getElementIndex", "name", "isElementOptional", "", "getElementAnnotations", "", "", "getElementDescriptor", "equals", "other", "", "hashCode", "toString", "Lkotlinx/serialization/internal/HashMapClassDesc;", "Lkotlinx/serialization/internal/LinkedHashMapClassDesc;", "kotlinx-serialization-core"})
@SourceDebugExtension(value={"SMAP\nCollectionDescriptors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionDescriptors.kt\nkotlinx/serialization/internal/MapLikeDescriptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
public abstract class MapLikeDescriptor
implements SerialDescriptor {
    @NotNull
    private final String serialName;
    @NotNull
    private final SerialDescriptor keyDescriptor;
    @NotNull
    private final SerialDescriptor valueDescriptor;
    private final int elementsCount;

    private MapLikeDescriptor(String serialName, SerialDescriptor keyDescriptor, SerialDescriptor valueDescriptor) {
        this.serialName = serialName;
        this.keyDescriptor = keyDescriptor;
        this.valueDescriptor = valueDescriptor;
        this.elementsCount = 2;
    }

    @Override
    @NotNull
    public String getSerialName() {
        return this.serialName;
    }

    @NotNull
    public final SerialDescriptor getKeyDescriptor() {
        return this.keyDescriptor;
    }

    @NotNull
    public final SerialDescriptor getValueDescriptor() {
        return this.valueDescriptor;
    }

    @Override
    @NotNull
    public SerialKind getKind() {
        return StructureKind.MAP.INSTANCE;
    }

    @Override
    public int getElementsCount() {
        return this.elementsCount;
    }

    @Override
    @NotNull
    public String getElementName(int index) {
        return String.valueOf(index);
    }

    @Override
    public int getElementIndex(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Integer n = StringsKt.toIntOrNull(name);
        if (n == null) {
            throw new IllegalArgumentException(name + " is not a valid map index");
        }
        return n;
    }

    @Override
    public boolean isElementOptional(int index) {
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "Illegal index " + index + ", " + this.getSerialName() + " expects only non-negative indices";
            throw new IllegalArgumentException(string.toString());
        }
        return false;
    }

    @Override
    @NotNull
    public List<Annotation> getElementAnnotations(int index) {
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "Illegal index " + index + ", " + this.getSerialName() + " expects only non-negative indices";
            throw new IllegalArgumentException(string.toString());
        }
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public SerialDescriptor getElementDescriptor(int index) {
        SerialDescriptor serialDescriptor;
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "Illegal index " + index + ", " + this.getSerialName() + " expects only non-negative indices";
            throw new IllegalArgumentException(string.toString());
        }
        switch (index % 2) {
            case 0: {
                serialDescriptor = this.keyDescriptor;
                break;
            }
            case 1: {
                serialDescriptor = this.valueDescriptor;
                break;
            }
            default: {
                throw new IllegalStateException("Unreached".toString());
            }
        }
        return serialDescriptor;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MapLikeDescriptor)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getSerialName(), ((MapLikeDescriptor)other).getSerialName())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.keyDescriptor, ((MapLikeDescriptor)other).keyDescriptor)) {
            return false;
        }
        return Intrinsics.areEqual(this.valueDescriptor, ((MapLikeDescriptor)other).valueDescriptor);
    }

    public int hashCode() {
        int result2 = this.getSerialName().hashCode();
        result2 = 31 * result2 + this.keyDescriptor.hashCode();
        result2 = 31 * result2 + this.valueDescriptor.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return this.getSerialName() + '(' + this.keyDescriptor + ", " + this.valueDescriptor + ')';
    }

    public /* synthetic */ MapLikeDescriptor(String serialName, SerialDescriptor keyDescriptor, SerialDescriptor valueDescriptor, DefaultConstructorMarker $constructor_marker) {
        this(serialName, keyDescriptor, valueDescriptor);
    }
}

