vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO vsg-dev/vsgQt
    REF v${VERSION}
    SHA512 0c753d573eeec77bdddab0f3499b7fbabc4c0840246501dd83ef1e3a96effacf9cd9a84d5c1c35b49462520a2840ddd02eeefa92c55b23dc44ce9fc285cbee3b
    HEAD_REF master
)
file(WRITE "${SOURCE_PATH}/examples/CMakeLists.txt" "# skipped by vcpkg\n")

vcpkg_cmake_configure(
    SOURCE_PATH "${SOURCE_PATH}"
    OPTIONS
        -DQT_PACKAGE_NAME=Qt6
)
vcpkg_cmake_install()
vcpkg_copy_pdbs()
vcpkg_cmake_config_fixup(CONFIG_PATH "lib/cmake/vsgQt")
vcpkg_copy_pdbs()

vcpkg_replace_string("${CURRENT_PACKAGES_DIR}/share/vsgqt/vsgQtConfig.cmake"
    "#generated by cmake, do not change" [[
include(CMakeFindDependencyMacro)
find_dependency(vsg)
find_dependency(Qt6 COMPONENTS Widgets)
]])

file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/debug/include")
file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/debug/share")

vcpkg_install_copyright(FILE_LIST "${SOURCE_PATH}/LICENSE.md")
