set(program_name patchelf)
if(CMAKE_HOST_SYSTEM_NAME STREQUAL "Linux")
    set(program_version 0.15.5)
    vcpkg_execute_in_download_mode(COMMAND "uname" "-m" OUTPUT_VARIABLE HOST_ARCH OUTPUT_STRIP_TRAILING_WHITESPACE)
    if(HOST_ARCH STREQUAL "x86_64")
        set(patchelf_platform "x86_64")
        set(download_sha512 "1a638467dc71119d88657e83825bf9c4e65dbb2d3bbbd0267963a507e29429569dc7777490724928c86efc50af82d91b0163b29a09f8f99e62ebf6d9bb1567d2")
    elseif(HOST_ARCH MATCHES "i[3-6]86")
        set(patchelf_platform "i686")
        set(download_sha512 "e27b68e657e440bb262fc8529a615cd71382573d3c8ae4e49ea40accd34338b5fcd05c5b50491329c9b3a134eb8d489a3352399bab8c6d1f0937303d0b6b5a14")
    elseif(HOST_ARCH STREQUAL "aarch64")
        set(patchelf_platform "aarch64")
        set(download_sha512 "f0cc19d7dbf1eeb77f01ad6d9e6e01ebb356adc32b31eeb577de787d93d7292feea98f9027363ab79c08cf645d3c751df31b1e500151fca3597a7fae5b16542b")
    elseif(HOST_ARCH STREQUAL "armv7l")
        set(patchelf_platform "armv7l")
        set(download_sha512 "e9b087d3198837c19ae0d8a30e9b8eb445282107bc6c1a148627a70d7d7dc0843bd570c8865407397e2157b59aa539ab1331862b59325970f94905ad09f1cc57")
    elseif(HOST_ARCH STREQUAL "riscv64")
        set(patchelf_platform "riscv64")
        set(download_sha512 "a88e1a6ddaa6882d1af3582f031e97347098d85fa7baad00a457a9383f79f7f630dd47abc8d34fb6f1ca271ba63c635dbea3931053d0185c77a29750408c24ea")
    elseif(HOST_ARCH STREQUAL "ppc64le")
        set(patchelf_platform "ppc64le")
        set(download_sha512 "fb36a5f032c2fbe377049a860760f8953279c1a0ae080c54f8040cd15abf0a9932668fe10214a16574cec51d328927a36319751c1d4ed6675ed57a2f3615ec69")
    elseif(HOST_ARCH STREQUAL "s390x")
        set(patchelf_platform "s390x")
        set(download_sha512 "e102160c9ee39a52fdc5817548f860884982e7a9bc06eaf13fcc9d9697a46e0929730b398817a00b88e705977d58619bb85e8dc32af8a0017c363ca2ca76a74c")
    else()
        return()
    endif()
    set(download_filename "${program_name}-${program_version}-${patchelf_platform}.tar.gz")
    set(download_urls "https://github.com/NixOS/patchelf/releases/download/${program_version}/${download_filename}")
    set(tool_subdirectory "${program_version}-${patchelf_platform}-linux")
    set(paths_to_search "${DOWNLOADS}/tools/patchelf/${program_version}-${patchelf_platform}-linux/bin")
elseif(CMAKE_HOST_SYSTEM_NAME STREQUAL "Windows")
    set(patchelf_host "win32")
    set(program_version 0.18.0)
    set(download_sha512
"19d24f64bea6d6236292455a09695d289ddca71433a0ccaf372f57da80a4cde5db1c375ac8e29a41ac1f0676b7d3b56ce5b2baf39e58369c4f741b612db51044")
    set(download_filename "${program_name}-${patchelf_host}-${program_version}.exe")
    set(download_urls "https://github.com/NixOS/patchelf/releases/download/${program_version}/${download_filename}")
    set(tool_subdirectory "${program_version}-${patchelf_host}")
    set(paths_to_search "${DOWNLOADS}/tools/patchelf/${program_version}-${patchelf_host}/")
    set(raw_executable ON)
    set(rename_binary_to "patchelf.exe")
endif()
