# Every update requires an update of these hashes and the version within the control file of each of the 32 ports.
# So it is probably better to have a central location for these hashes and let the ports update via a script
set(QT_MAJOR_MINOR_VER 5.15)
set(QT_PATCH_VER 18)
set(QT_UPDATE_VERSION OFF) # Switch to update qt and not build qt. Creates a file cmake/qt_new_hashes.cmake in qt5-base with the new hashes.

set(QT_PORT_LIST base 3d activeqt charts connectivity datavis3d declarative gamepad graphicaleffects imageformats location macextras multimedia networkauth
                 purchasing quickcontrols quickcontrols2 remoteobjects script scxml sensors serialport speech svg tools virtualkeyboard webchannel websockets
                 webview winextras xmlpatterns doc x11extras androidextras translations serialbus webengine webglplugin wayland)

# qt5-mqtt archive is not included in 5.15.18 release, updated separately
# list(APPEND QT_PORT_LIST mqtt)

set(QT_HASH_qt5-3d 53825ff0bad5adc73bafbdf426e7209a770860f8e0ac97f89fdf61b07ac2431d54ce8ad2fbcb69ca3c2a5b953d76a3bcc0d236c32c6b45d219ee6fcb582c5974)
set(QT_HASH_qt5-activeqt f5a29d97d35cf634843d9b202e7f4c2d2bafaac4dd9c5df2348858588d9e64ff57726b91a485ce6433e701b04b4ce0c880b847472a3f064ca4dc3d831901ae79)
set(QT_HASH_qt5-androidextras aeca703d1709f6352c83d634b5a52819400b9f5cde9286b2e93120a37604a059f136ac3ccf466df06ff27394038b90522c8f5dfc18473ee176768c66a44159d9)
set(QT_HASH_qt5-base d39c831e6f3ddcd6a50f103ff60a0700b451f137782249508b7447a80066e3e9259c9b5038e6077ccf8df06b6afefec232c3c4dd331d85765089c92571708206)
set(QT_HASH_qt5-charts 9c4b0d0c7456604048742f0628ecf049217acbb8a4a23c925ef6ce5c47eaf9fbcf6b1aecdcd1113679c9edf8a1635f3ca585acb31fd548f3ab577c5f4e54f3f2)
set(QT_HASH_qt5-connectivity 26f194965090dc44547b46a7ee73d3dc30d3817f213b809f2e2fb9596b2184e5fa276e600d706675ad0f19b0b421c0fc8e52afbc0b6a16eeff00c4c459027dca)
set(QT_HASH_qt5-datavis3d 877b1a15b382d1cfbe32cfbba2d4f7edd8ddc806bc801c23a2f310cc0e892953a63b05fa031f4d1b197013c6da8ea41945ccd2e53f2c1abb33b44414e89eaedf)
set(QT_HASH_qt5-declarative 73c45c47b5074b6bc1127abb1b3cf1cd751deeb80c2f9c86a675c7323fecf20bd83363fad95803bc72cf494ae4679c1f38a02387363f266c093c707e700c9ea2)
set(QT_HASH_qt5-doc fa7a39b69778c96dccff2120544d0bdeccc03bf30c92a0f17bc6aa981ae5ee3589fecb3663a855ccde1a59068dde780fa76790d03e758e267efed5df37ae3cf3)
set(QT_HASH_qt5-gamepad 03d07b4fe07adfad7dc8c3844f16c6f18f023417cefca52b5f833e95d4db47b7b228268d0d2547bc7a77dbc7a7e3174408c026f56126052ef30fbe7c7345014e)
set(QT_HASH_qt5-graphicaleffects 6fff9181d8d0a4f55987e2b219d35adf4db28429206e4ec0572a03664c155aea046a08a1d820fbc5d27f9f3ec4c60768823959c5839766ab2768f64c440273da)
set(QT_HASH_qt5-imageformats 5e8b0895e8b7aa05142ae21eee3f79fb289a8edf6eeed62a59be3ae60d164a2698344740ff283c753e9b61cd6af516d8c7301597762183222ceff0f4c8dddd46)
set(QT_HASH_qt5-location 587e1cc8c8f46ab09ea79c4142dbecc52466dafa94c4bfa61264eba4f202fb5e2979d1ae6ba5fb924376d75764f28b58c7bcc03ab29edef2524aa872adb3c936)
set(QT_HASH_qt5-macextras cc8c10a149c150a7fe422616a1dcf56abfa3c9c0e3f95521bb5c1c1e6873d7f48c547c0c8acacbe3a8e936f048fb687d0913f03b6b7ec27a4087f92f6b389eaf)
set(QT_HASH_qt5-multimedia edebe73911c82ef5671602f895dd1cddcc39b8afb29267be54921848713344d531e49f4cbcfb9a57b095c4e736a9100c245290391102ddccdb08997057a12bd8)
set(QT_HASH_qt5-networkauth f3f9cce52161b77b1e3ebda32444fefed9cff077b9546e0d1b7942b0710e6a8f8681f9c10b521dc56fa3a0020338c59334b6c870420fa1a34a9ae3bbe30dc2d5)
set(QT_HASH_qt5-purchasing e0bdf99a399b52b6195a622202d58191262885808477ab7c977bedc88045fef602cc55ba275adc3a6798951d6c4ff1f0e0af63d0ed95403872c58d9294a57802)
set(QT_HASH_qt5-quick3d 4b1669a5499b23bc76b959340890d6690cd12ba39b3157a7a8499d44065ca5d258e45e9758c94b5959f02956b7b3f04e0095aace3e46552ad697ae11cc5e24e5)
set(QT_HASH_qt5-quickcontrols 9bd2bcd119d162f8ef30b2e1f459776a66b504f5043809cc0846b7c4898ca464eb44f65d1c76d3857a12eef7126ec8a84f8ac3566b5c3200b65572a3ff9296f7)
set(QT_HASH_qt5-quickcontrols2 29d0904c949b4970eae576d20f94b5c92f1fcb71056bb085b6ea8421c894aa265ae9a5cdbd6e21ac849f14385833ed2961a18dcc2c66ea6ed8a28feb51bd7375)
set(QT_HASH_qt5-quicktimeline 730a8c5080510175d3e62919a31bda78e5eeb32bbbd0087be46a1576278684f74a522a5615d8d5fe095d2d364a902470c22afd330adba94c7375814a4b29d99a)
set(QT_HASH_qt5-remoteobjects a4357d720a77d09a1d5e38bbd1152f042d4ac902476de83e74834d5d0b9af210618174d988089818ec7787870caeb496af020dfc80e123b86bfb51b7919a14e5)
set(QT_HASH_qt5-script e4cd79deb2cba1f4216acb6744c50540e41c4a56dd37f4f49631cad7b520642292192ddc8b7cff1f741350e4b8b83aae0626ec3c546366bd4bcaf58c7f849923)
set(QT_HASH_qt5-scxml 9ad88607e25b6bf43ae460904a3ccfb3514c6a6b739dfce4799958d5897601370a83f818e706a0270ccab1a995976384553d1bfca74f53f08bda3f9d1b58cf4c)
set(QT_HASH_qt5-sensors cecc4a7d6eeb64d1bd7c1d9d6c23926bca5168ed50ef5197094b296a61e024b62a5aaed6bfa97c84da2d342faf14d15c473646c5c400973be7172e4617824d94)
set(QT_HASH_qt5-serialbus eb2e7d987b9e7f05f8952c3e424b23347c30a274f22acc0714f2769a9c891a12f212a2cd977a09e34b2f93079c7554e8c65425fe403f996a27c5f31e87c63697)
set(QT_HASH_qt5-serialport 4944c4fc03386c635197c9d0fa4550fd05285c9bd36861409e2c5282aeee153baa5bc285be5314a6309026f54058f8bd605be389471a1dd34b3236f3d05131ec)
set(QT_HASH_qt5-speech f3a9e4782532ee62c455eda6e63a25e49392ea4cbb7e6801e6eb1bb9d58e9bd802769e26811c8afcebc0c6e106fe7d3c56b69ea83c28c1d89603ecc228c1c919)
set(QT_HASH_qt5-svg 2c599bdd0b82eeb969233bac7cb5d53896d3d873ee37b72fead0c3ef38feaef84c8e0a42425ce3ae185ca0f4d8f4590ec95829fc815bda65dd546d1697de8493)
set(QT_HASH_qt5-tools 30a278df553ff3bb64927a4a5be0370b070131ec2970410095b4618e6a0f6e7c45374abf37c458b69dd9e4f7cecb98289b8e777cf5bc85b09f0b5cd278a40a70)
set(QT_HASH_qt5-translations 52a1ca84c01c4a2728d1b7a3168c8d6ffd12f8e8528d729b422d9339a01dcbcb5a768999a252b28b6f4041eb20f874fe74c0389724c54a09ec9dfe42312b4af9)
set(QT_HASH_qt5-virtualkeyboard f7dd1365e45b7ed5f5f942abc6e4a1ea964955d9836bcfabed2c6de9669bcc47693c09370dd917e244bcaefe68cdcb06a985c798dcd612aafb03c1ebfca5b536)
set(QT_HASH_qt5-wayland 9e0d07a4a91eb6dd1bde6b211bae2b64f2035a28176c277adb86ab5d3a281c7740930dc304db94990c1d2277ef54d17b934f99326413719626fb161b612c033f)
set(QT_HASH_qt5-webchannel fb867510da8b74cac277598e346c5eed7bbaaa6b1be85c39b804a07209922ccdc87e314d9ced4eeb966cc06888127772dff517a8f6fef10c8e87080a59112bfa)
set(QT_HASH_qt5-webengine 731e9b01746efa0696bc89299fa4847157077bd21567a9d3358006d6bb7dddbadea5c085f9dfae12279e41619b4751d1d0009bfd0ee4f9ceab3bd1a567831ed2)
set(QT_HASH_qt5-webglplugin 63a05f522e44b2fdefc5394faeb3619f596dd62c59d6e5f0e27ea32560f8ec3e8b6906b78607664f3b392b68dc69c5266a9d398860bdef6153f33fa29acfc49a)
set(QT_HASH_qt5-websockets 29b59fe6681030150b87d18a052f00f05ac17db17203279d794a8161783d739938e9ea659519f7b7c76f3d7e40009ea1797e255ae464a1cd641caa6c039d4777)
set(QT_HASH_qt5-webview 5dc6ae1b648a66572947f36d4e668b3219d7c40f9b455871fb673268de24b0d7e84075b6bcd4aa1cb72ec6a6bd3519344a66e2481b783786df6a613aacfacac0)
set(QT_HASH_qt5-winextras 608f6bcc6c1d259c096da3f2142e24c71d907e4af7f2107190521d7c977692061d1002ca0053511197cb96a00fd99208f8dee3b7510549fd3be5a397e7fc00b8)
set(QT_HASH_qt5-x11extras 7e12f87da4a2c8333adc09f0069cfdbb6b81e778b0e261b13a8631a90bc21deb831fc4d74229e977afa864919ef6dbe98fc37ef29eeffee52cacef21af4216f7)
set(QT_HASH_qt5-xmlpatterns 2c1f1ec6c2a70a2151259a290675b15e44475f19afa46f396b4cd511e3aeb7cd83fffd7d76ddde31817c5f2e944dcd32587550713aed34aac9585f3eeef7e39b)

if(QT_UPDATE_VERSION)
    message(STATUS "Running Qt in automatic version port update mode!")
    set(_VCPKG_INTERNAL_NO_HASH_CHECK 1)
    if("${PORT}" MATCHES "qt5-base")
        function(update_qt_version_in_manifest _port_name)
            set(_current_control "${VCPKG_ROOT_DIR}/ports/${_port_name}/vcpkg.json")
            file(READ ${_current_control} _control_contents)
            #message(STATUS "Before: \n${_control_contents}")
            string(REGEX REPLACE "\"version.*\": \"[0-9]+\.[0-9]+\.[0-9]+\",\n" "\"version\": \"${QT_MAJOR_MINOR_VER}.${QT_PATCH_VER}\",\n" _control_contents "${_control_contents}")
            string(REGEX REPLACE "\n  \"port-version\": [0-9]+," "" _control_contents "${_control_contents}")
            #message(STATUS "After: \n${_control_contents}")
            file(WRITE ${_current_control} "${_control_contents}")
            configure_file("${_current_control}" "${_current_control}" @ONLY NEWLINE_STYLE LF)
        endfunction()

        update_qt_version_in_manifest("qt5")
        foreach(_current_qt_port_basename ${QT_PORT_LIST})
            update_qt_version_in_manifest("qt5-${_current_qt_port_basename}")
        endforeach()
    endif()
endif()
