// WARNING: This file is automatically generated. Any changes will be lost.
#include "twitch-eventsub-ws/chrono.hpp"  // IWYU pragma: keep
#include "twitch-eventsub-ws/detail/errors.hpp"
#include "twitch-eventsub-ws/detail/variant.hpp"  // IWYU pragma: keep
#include "twitch-eventsub-ws/payloads/channel-suspicious-user-message-v1.hpp"

#include <boost/json.hpp>

namespace chatterino::eventsub::lib::payload::channel_suspicious_user_message::
    v1 {

boost::json::result_for<Event, boost::json::value>::type tag_invoke(
    boost::json::try_value_to_tag<Event> /* tag */,
    const boost::json::value &jvRoot)
{
    if (!jvRoot.is_object())
    {
        EVENTSUB_BAIL_HERE(error::Kind::ExpectedObject);
    }
    const auto &root = jvRoot.get_object();

    const auto *jvbroadcasterUserID = root.if_contains("broadcaster_user_id");
    if (jvbroadcasterUserID == nullptr)
    {
        EVENTSUB_BAIL_HERE(error::Kind::FieldMissing);
    }

    auto broadcasterUserID =
        boost::json::try_value_to<String>(*jvbroadcasterUserID);

    if (broadcasterUserID.has_error())
    {
        return broadcasterUserID.error();
    }

    const auto *jvbroadcasterUserLogin =
        root.if_contains("broadcaster_user_login");
    if (jvbroadcasterUserLogin == nullptr)
    {
        EVENTSUB_BAIL_HERE(error::Kind::FieldMissing);
    }

    auto broadcasterUserLogin =
        boost::json::try_value_to<String>(*jvbroadcasterUserLogin);

    if (broadcasterUserLogin.has_error())
    {
        return broadcasterUserLogin.error();
    }

    const auto *jvbroadcasterUserName =
        root.if_contains("broadcaster_user_name");
    if (jvbroadcasterUserName == nullptr)
    {
        EVENTSUB_BAIL_HERE(error::Kind::FieldMissing);
    }

    auto broadcasterUserName =
        boost::json::try_value_to<String>(*jvbroadcasterUserName);

    if (broadcasterUserName.has_error())
    {
        return broadcasterUserName.error();
    }

    const auto *jvuserID = root.if_contains("user_id");
    if (jvuserID == nullptr)
    {
        EVENTSUB_BAIL_HERE(error::Kind::FieldMissing);
    }

    auto userID = boost::json::try_value_to<String>(*jvuserID);

    if (userID.has_error())
    {
        return userID.error();
    }

    const auto *jvuserLogin = root.if_contains("user_login");
    if (jvuserLogin == nullptr)
    {
        EVENTSUB_BAIL_HERE(error::Kind::FieldMissing);
    }

    auto userLogin = boost::json::try_value_to<String>(*jvuserLogin);

    if (userLogin.has_error())
    {
        return userLogin.error();
    }

    const auto *jvuserName = root.if_contains("user_name");
    if (jvuserName == nullptr)
    {
        EVENTSUB_BAIL_HERE(error::Kind::FieldMissing);
    }

    auto userName = boost::json::try_value_to<String>(*jvuserName);

    if (userName.has_error())
    {
        return userName.error();
    }

    static_assert(std::is_trivially_copyable_v<std::remove_reference_t<
                      decltype(std::declval<Event>().lowTrustStatus)>>);
    const auto *jvlowTrustStatus = root.if_contains("low_trust_status");
    if (jvlowTrustStatus == nullptr)
    {
        EVENTSUB_BAIL_HERE(error::Kind::FieldMissing);
    }

    auto lowTrustStatus =
        boost::json::try_value_to<suspicious_users::Status>(*jvlowTrustStatus);

    if (lowTrustStatus.has_error())
    {
        return lowTrustStatus.error();
    }

    std::vector<chatterino::eventsub::lib::String> vsharedBanChannelIds;
    const auto *jvsharedBanChannelIds =
        root.if_contains("shared_ban_channel_ids");
    if (jvsharedBanChannelIds != nullptr && !jvsharedBanChannelIds->is_null())
    {
        auto sharedBanChannelIds = boost::json::try_value_to<
            std::vector<chatterino::eventsub::lib::String>>(
            *jvsharedBanChannelIds);
        if (sharedBanChannelIds.has_error())
        {
            return sharedBanChannelIds.error();
        }
        else
        {
            vsharedBanChannelIds = std::move(sharedBanChannelIds.value());
        }
    }

    std::vector<chatterino::eventsub::lib::suspicious_users::Type> vtypes;
    const auto *jvtypes = root.if_contains("types");
    if (jvtypes != nullptr && !jvtypes->is_null())
    {
        auto types = boost::json::try_value_to<
            std::vector<chatterino::eventsub::lib::suspicious_users::Type>>(
            *jvtypes);
        if (types.has_error())
        {
            return types.error();
        }
        else
        {
            vtypes = std::move(types.value());
        }
    }
    static_assert(std::is_trivially_copyable_v<std::remove_reference_t<
                      decltype(std::declval<Event>().banEvasionEvaluation)>>);
    const auto *jvbanEvasionEvaluation =
        root.if_contains("ban_evasion_evaluation");
    if (jvbanEvasionEvaluation == nullptr)
    {
        EVENTSUB_BAIL_HERE(error::Kind::FieldMissing);
    }

    auto banEvasionEvaluation =
        boost::json::try_value_to<suspicious_users::BanEvasionEvaluation>(
            *jvbanEvasionEvaluation);

    if (banEvasionEvaluation.has_error())
    {
        return banEvasionEvaluation.error();
    }

    const auto *jvmessage = root.if_contains("message");
    if (jvmessage == nullptr)
    {
        EVENTSUB_BAIL_HERE(error::Kind::FieldMissing);
    }

    auto message = boost::json::try_value_to<chat::Message>(*jvmessage);

    if (message.has_error())
    {
        return message.error();
    }

    return Event{
        .broadcasterUserID = std::move(broadcasterUserID.value()),
        .broadcasterUserLogin = std::move(broadcasterUserLogin.value()),
        .broadcasterUserName = std::move(broadcasterUserName.value()),
        .userID = std::move(userID.value()),
        .userLogin = std::move(userLogin.value()),
        .userName = std::move(userName.value()),
        .lowTrustStatus = lowTrustStatus.value(),
        .sharedBanChannelIds = std::move(vsharedBanChannelIds),
        .types = std::move(vtypes),
        .banEvasionEvaluation = banEvasionEvaluation.value(),
        .message = std::move(message.value()),
    };
}

boost::json::result_for<Payload, boost::json::value>::type tag_invoke(
    boost::json::try_value_to_tag<Payload> /* tag */,
    const boost::json::value &jvRoot)
{
    if (!jvRoot.is_object())
    {
        EVENTSUB_BAIL_HERE(error::Kind::ExpectedObject);
    }
    const auto &root = jvRoot.get_object();

    const auto *jvsubscription = root.if_contains("subscription");
    if (jvsubscription == nullptr)
    {
        EVENTSUB_BAIL_HERE(error::Kind::FieldMissing);
    }

    auto subscription =
        boost::json::try_value_to<subscription::Subscription>(*jvsubscription);

    if (subscription.has_error())
    {
        return subscription.error();
    }

    const auto *jvevent = root.if_contains("event");
    if (jvevent == nullptr)
    {
        EVENTSUB_BAIL_HERE(error::Kind::FieldMissing);
    }

    auto event = boost::json::try_value_to<Event>(*jvevent);

    if (event.has_error())
    {
        return event.error();
    }

    return Payload{
        .subscription = std::move(subscription.value()),
        .event = std::move(event.value()),
    };
}

}  // namespace chatterino::eventsub::lib::payload::channel_suspicious_user_message::v1
