/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.pcsc.terminals;

import apdu4j.core.HexUtils;
import apdu4j.pcsc.SCard;
import apdu4j.pcsc.TerminalManager;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

public final class LoggingCardTerminal
extends CardTerminal
implements AutoCloseable {
    protected final CardTerminal terminal;
    protected final PrintStream log;
    protected final PrintStream dump;
    protected long startTime;

    private LoggingCardTerminal(CardTerminal term, PrintStream log, PrintStream dump) {
        if (term == null) {
            throw new IllegalArgumentException("terminal==null");
        }
        this.terminal = term;
        this.log = log;
        this.dump = dump;
    }

    public static LoggingCardTerminal getInstance(CardTerminal term) {
        return new LoggingCardTerminal(term, System.out, null);
    }

    public static LoggingCardTerminal getInstance(CardTerminal term, OutputStream logStream) {
        return new LoggingCardTerminal(term, new PrintStream(logStream, true, StandardCharsets.UTF_8), null);
    }

    public static LoggingCardTerminal getInstance(CardTerminal term, OutputStream logStream, OutputStream dump) {
        return new LoggingCardTerminal(term, new PrintStream(logStream, true, StandardCharsets.UTF_8), new PrintStream(dump, true, StandardCharsets.UTF_8));
    }

    @Override
    public Card connect(String arg0) throws CardException {
        this.startTime = System.currentTimeMillis();
        return new LoggingCard(this.terminal, arg0);
    }

    @Override
    public String getName() {
        return this.terminal.getName();
    }

    @Override
    public boolean isCardPresent() throws CardException {
        return this.terminal.isCardPresent();
    }

    @Override
    public boolean waitForCardAbsent(long arg0) throws CardException {
        return this.terminal.waitForCardAbsent(arg0);
    }

    @Override
    public boolean waitForCardPresent(long arg0) throws CardException {
        return this.terminal.waitForCardPresent(arg0);
    }

    @Override
    public void close() {
        if (this.log != null) {
            this.log.close();
        }
        if (this.dump != null) {
            this.dump.close();
        }
    }

    private static String time(long ms) {
        String time = ms + "ms";
        if (ms > 1000L) {
            time = ms / 1000L + "s" + ms % 1000L + "ms";
        }
        return time;
    }

    private static boolean nil(byte[] v) {
        return v == null || v.length == 0;
    }

    public final class LoggingCard
    extends Card {
        private long inBytes = 0L;
        private long outBytes = 0L;
        private final Card card;

        private LoggingCard(CardTerminal term, String protocol) throws CardException {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("# SCardConnect(\"%s\", %s)", term.getName(), protocol.equals("*") ? "T=*" : protocol));
            try {
                this.card = term.connect(protocol);
                byte[] atr = this.card.getATR().getBytes();
                sb.append(" -> " + this.card.getProtocol() + (String)(atr.length > 0 ? ", " + HexUtils.bin2hex(atr) : ""));
                if (LoggingCardTerminal.this.dump != null) {
                    String ts = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z").format(Calendar.getInstance().getTime());
                    LoggingCardTerminal.this.dump.println("# Generated on " + ts + " by apdu4j/" + TerminalManager.getVersion());
                    LoggingCardTerminal.this.dump.println("# Using " + term.getName());
                    LoggingCardTerminal.this.dump.println("# ATR: " + HexUtils.bin2hex(atr));
                    LoggingCardTerminal.this.dump.println("# PROTOCOL: " + this.card.getProtocol());
                    LoggingCardTerminal.this.dump.println("#");
                }
            }
            catch (CardException e) {
                sb.append(" -> " + SCard.getExceptionMessage(e));
                throw e;
            }
            finally {
                LoggingCardTerminal.this.log.println(sb);
            }
        }

        @Override
        public void beginExclusive() throws CardException {
            LoggingCardTerminal.this.log.println(String.format("# SCardBeginTransaction(\"%s\")", LoggingCardTerminal.this.terminal.getName()));
            this.card.beginExclusive();
        }

        @Override
        public void disconnect(boolean arg0) throws CardException {
            long duration = System.currentTimeMillis() - LoggingCardTerminal.this.startTime;
            LoggingCardTerminal.this.log.println(String.format("# SCardDisconnect(\"%s\", %s) tx:%d/rx:%d in %s", LoggingCardTerminal.this.terminal.getName(), arg0, this.outBytes, this.inBytes, LoggingCardTerminal.time(duration)));
            this.outBytes = 0L;
            this.inBytes = 0L;
            if (LoggingCardTerminal.this.dump != null) {
                LoggingCardTerminal.this.dump.close();
            }
            this.card.disconnect(arg0);
        }

        @Override
        public void endExclusive() throws CardException {
            LoggingCardTerminal.this.log.println(String.format("# SCardEndTransaction(\"%s\")", LoggingCardTerminal.this.terminal.getName()));
            this.card.endExclusive();
        }

        @Override
        public ATR getATR() {
            return this.card.getATR();
        }

        @Override
        public CardChannel getBasicChannel() {
            return new LoggingCardChannel(this.card, this.card.getBasicChannel());
        }

        @Override
        public String getProtocol() {
            return this.card.getProtocol();
        }

        @Override
        public CardChannel openLogicalChannel() throws CardException {
            StringBuilder mc = new StringBuilder();
            mc.append("# MANAGE CHANNEL - OPEN -> ");
            try {
                CardChannel c = this.card.openLogicalChannel();
                mc.append(c.getChannelNumber());
                LoggingCardChannel loggingCardChannel = new LoggingCardChannel(this.card, c);
                return loggingCardChannel;
            }
            catch (CardException e) {
                mc.append(SCard.getPCSCError(e).orElse("Exception (" + e.getMessage() + ")"));
                throw e;
            }
            finally {
                LoggingCardTerminal.this.log.println(mc);
            }
        }

        @Override
        public byte[] transmitControlCommand(int arg0, byte[] arg1) throws CardException {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("# SCardControl(\"%s\", 0x%08X, %s)", LoggingCardTerminal.this.terminal.getName(), arg0, LoggingCardTerminal.nil(arg1) ? "null" : HexUtils.bin2hex(arg1)));
            try {
                byte[] result = this.card.transmitControlCommand(arg0, arg1);
                sb.append(" -> " + (LoggingCardTerminal.nil(result) ? "null" : HexUtils.bin2hex(result)));
                byte[] byArray = result;
                return byArray;
            }
            catch (CardException e) {
                sb.append("-> " + SCard.getPCSCError(e).orElse("Exception"));
                throw e;
            }
            finally {
                LoggingCardTerminal.this.log.println(sb);
            }
        }

        public final class LoggingCardChannel
        extends CardChannel {
            private final CardChannel channel;
            private final Card card;

            public LoggingCardChannel(Card card, CardChannel channel) {
                this.card = card;
                this.channel = channel;
            }

            @Override
            public void close() throws CardException {
                if (this.getChannelNumber() != 0) {
                    LoggingCardTerminal.this.log.println("# MANAGE CHANNEL - CLOSE");
                }
                this.channel.close();
            }

            @Override
            public Card getCard() {
                return this.card;
            }

            @Override
            public int getChannelNumber() {
                return this.channel.getChannelNumber();
            }

            @Override
            public ResponseAPDU transmit(CommandAPDU apdu) throws CardException {
                ResponseAPDU response;
                byte[] cb = apdu.getBytes();
                boolean extended = cb.length > 5 && cb[4] == 0;
                int len_end = extended ? 7 : 5;
                String header = HexUtils.bin2hex(Arrays.copyOfRange(cb, 0, 4));
                StringBuilder log_s = new StringBuilder();
                log_s.append(String.format("A%s>> %s (4+%04d) %s", this.getChannelNumber() != 0 ? String.format("#%d", this.getChannelNumber()) : "", this.card.getProtocol(), apdu.getData().length, header));
                if (cb.length > 4) {
                    int cmdlen = cb[4] & 0xFF;
                    if (cmdlen == 0 && extended) {
                        cmdlen = cb[5] & 0xFF00 | cb[6] & 0xFF;
                    }
                    if (apdu.getData().length < cmdlen) {
                        cmdlen = 0;
                    }
                    log_s.append(" " + HexUtils.bin2hex(Arrays.copyOfRange(cb, 4, len_end)));
                    log_s.append(" " + HexUtils.bin2hex(Arrays.copyOfRange(cb, len_end, len_end + cmdlen)));
                    if (len_end + cmdlen < cb.length) {
                        log_s.append(" " + HexUtils.bin2hex(Arrays.copyOfRange(cb, len_end + cmdlen, cb.length)));
                    }
                }
                LoggingCardTerminal.this.log.println(log_s);
                LoggingCardTerminal.this.log.flush();
                long t = System.currentTimeMillis();
                try {
                    response = this.channel.transmit(apdu);
                    LoggingCard.this.outBytes += (long)cb.length;
                }
                catch (CardException e) {
                    String time = LoggingCardTerminal.time(System.currentTimeMillis() - t);
                    LoggingCardTerminal.this.log.println("<< (" + time + ") " + SCard.getPCSCError(e).orElse("Exception (" + e.getMessage() + ")"));
                    throw e;
                }
                String time = LoggingCardTerminal.time(System.currentTimeMillis() - t);
                StringBuilder log_r = new StringBuilder();
                byte[] rb = response.getBytes();
                LoggingCard.this.inBytes += (long)rb.length;
                log_r.append(String.format("A%s<< (%04d+2) (%s)", this.getChannelNumber() != 0 ? String.format("#%d", this.getChannelNumber()) : "", response.getData().length, time));
                if (rb.length > 2) {
                    log_r.append(" " + HexUtils.bin2hex(Arrays.copyOfRange(rb, 0, rb.length - 2)));
                }
                log_r.append(" " + HexUtils.bin2hex(Arrays.copyOfRange(rb, rb.length - 2, rb.length)));
                LoggingCardTerminal.this.log.println(log_r);
                if (LoggingCardTerminal.this.dump != null) {
                    LoggingCardTerminal.this.dump.println("# Sent\n" + HexUtils.bin2hex(cb));
                    LoggingCardTerminal.this.dump.println("# Received in " + time + "\n" + HexUtils.bin2hex(rb));
                }
                return response;
            }

            @Override
            public int transmit(ByteBuffer command, ByteBuffer response) throws CardException {
                ByteBuffer commandCopy = command.asReadOnlyBuffer();
                byte[] commandBytes = new byte[commandCopy.remaining()];
                commandCopy.get(commandBytes);
                LoggingCardTerminal.this.log.println("B>> " + this.card.getProtocol() + " (" + commandBytes.length + ") " + HexUtils.bin2hex(commandBytes));
                ByteBuffer responseCopy = response.asReadOnlyBuffer();
                responseCopy.mark();
                int resplen = this.channel.transmit(command, response);
                LoggingCard.this.outBytes += (long)commandBytes.length;
                byte[] responseBytes = new byte[resplen];
                responseCopy.reset();
                responseCopy.get(responseBytes);
                LoggingCard.this.inBytes += (long)responseBytes.length;
                LoggingCardTerminal.this.log.println("B<< (" + responseBytes.length + ") " + HexUtils.bin2hex(responseBytes));
                if (LoggingCardTerminal.this.dump != null) {
                    LoggingCardTerminal.this.dump.println("# Sent\n" + HexUtils.bin2hex(commandBytes));
                    LoggingCardTerminal.this.dump.println("# Received\n" + HexUtils.bin2hex(responseBytes));
                }
                return resplen;
            }
        }
    }
}

