/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.core;

import apdu4j.core.HexUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class HexBytes {
    private final byte[] v;

    public HexBytes(String hex) {
        this.v = HexUtils.hex2bin(hex);
    }

    private HexBytes(byte[] v) {
        this.v = (byte[])v.clone();
    }

    public static HexBytes valueOf(String s) {
        if (s.startsWith("|") && s.endsWith("|")) {
            return new HexBytes(s.substring(1, s.length() - 1).getBytes(StandardCharsets.UTF_8));
        }
        return new HexBytes(HexUtils.hex2bin(s));
    }

    public static HexBytes v(String s) {
        return HexBytes.valueOf(s);
    }

    public static HexBytes b(byte[] b) {
        return new HexBytes(b);
    }

    public static HexBytes f(String f, HexBytes a) {
        return HexBytes.v(f.replace(" ", "").replace("%s", a.s()).replace("%l", String.format("%02X", a.len())));
    }

    public int len() {
        return this.v.length;
    }

    public String s() {
        return HexUtils.bin2hex(this.v);
    }

    public byte[] value() {
        return (byte[])this.v.clone();
    }

    public byte[] v() {
        return this.value();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HexBytes bytesKey = (HexBytes)o;
        return Arrays.equals(this.v, bytesKey.v);
    }

    public int hashCode() {
        return Arrays.hashCode(this.v);
    }

    public String toString() {
        return "HexBytes[" + HexUtils.bin2hex(this.v) + "]";
    }

    public static byte[] concatenate(byte[] ... args) {
        int length = 0;
        int pos = 0;
        for (byte[] arg : args) {
            length += arg.length;
        }
        byte[] result = new byte[length];
        for (byte[] arg : args) {
            System.arraycopy(arg, 0, result, pos, arg.length);
            pos += arg.length;
        }
        return result;
    }

    public static boolean isHex(String s) {
        try {
            HexUtils.hex2bin(s);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

