/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.tlv;

import java.nio.ByteBuffer;

public final class Len {
    private Len() {
    }

    public static byte[] ber(int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Negative length");
        }
        if (len < 128) {
            return new byte[]{(byte)len};
        }
        if (len < 256) {
            return new byte[]{-127, (byte)len};
        }
        if (len < 65536) {
            return new byte[]{-126, (byte)(len >> 8), (byte)len};
        }
        if (len < 0x1000000) {
            return new byte[]{-125, (byte)(len >> 16), (byte)(len >> 8), (byte)len};
        }
        throw new IllegalArgumentException("Length too large (max 3 bytes)");
    }

    public static int ber(ByteBuffer buf) {
        int b = buf.get() & 0xFF;
        if ((b & 0x80) == 0) {
            return b;
        }
        int n = b & 0x7F;
        if (n > 3) {
            throw new IllegalArgumentException("Length too large");
        }
        int len = 0;
        for (int i = 0; i < n; ++i) {
            len = len << 8 | buf.get() & 0xFF;
        }
        return len;
    }

    public static byte[] ext(int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Negative length");
        }
        if (len < 255) {
            return new byte[]{(byte)len};
        }
        if (len < 65536) {
            return new byte[]{-1, (byte)(len >> 8), (byte)len};
        }
        throw new IllegalArgumentException("Length too large (max 65535)");
    }

    public static int ext(ByteBuffer buf) {
        int b = buf.get() & 0xFF;
        if (b != 255) {
            return b;
        }
        return (buf.get() & 0xFF) << 8 | buf.get() & 0xFF;
    }
}

