/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.pcsc.terminals;

import apdu4j.core.BIBOException;
import apdu4j.core.HexUtils;
import apdu4j.core.SmartCardAppFutures;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardNotPresentException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SynthesizedCardTerminal
extends CardTerminal {
    private static final Logger logger = LoggerFactory.getLogger(SynthesizedCardTerminal.class);
    private SynthesizedCard card;
    private SynthesizedCard.SynthesizedChannel channel;
    private final SmartCardAppFutures reader;

    public SynthesizedCardTerminal(SmartCardAppFutures app) {
        this.reader = app;
        this.card = new SynthesizedCard();
    }

    @Override
    public String getName() {
        logger.trace("getName()");
        return "CloudSmartCard emulated reader";
    }

    @Override
    public Card connect(String s) throws CardException {
        logger.trace("connect(" + s + ")");
        if (!this.reader.getCardPresentFuture().isDone()) {
            throw new CardNotPresentException("Card not present!");
        }
        try {
            Map<String, Object> props = this.reader.getCardPresentFuture().join();
            this.card._atr = Optional.ofNullable((byte[])props.get("atr")).orElse(HexUtils.hex2bin("3b00"));
            logger.trace("connect(" + s + ") == {}", (Object)this.card);
            return this.card;
        }
        catch (CompletionException e) {
            throw new CardException("Could not: " + e.getMessage(), e.getCause());
        }
    }

    @Override
    public boolean isCardPresent() throws CardNotPresentException {
        boolean r = this.reader.getCardPresentFuture().isDone();
        logger.debug("card future: {}", (Object)this.reader.getCardPresentFuture());
        return r;
    }

    @Override
    public boolean waitForCardPresent(long l) throws CardException {
        logger.debug("waitForCardPresent({})", (Object)l);
        CompletableFuture<Map<String, Object>> cf = this.reader.getCardPresentFuture();
        try {
            if (l == 0L) {
                cf.get(10L, TimeUnit.MINUTES);
                return true;
            }
            cf.get(l, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (InterruptedException e) {
            logger.warn("waitForCardPresent was interrupted");
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException e) {
            logger.debug("card future failed");
            throw new CardException(e.getCause().getMessage(), e);
        }
        catch (TimeoutException e) {
            logger.debug("card future timed out");
            return false;
        }
    }

    @Override
    public boolean waitForCardAbsent(long l) throws CardException {
        logger.trace("CardTerminal#waitForCardAbsent({})", (Object)l);
        return false;
    }

    class SynthesizedCard
    extends Card {
        byte[] _atr;

        SynthesizedCard() {
            SynthesizedCardTerminal.this.channel = new SynthesizedChannel();
        }

        @Override
        public ATR getATR() {
            logger.trace("Card#getATR() == {}", (Object)HexUtils.bin2hex(this._atr));
            return new ATR(this._atr);
        }

        @Override
        public String getProtocol() {
            String protocol = "T=1";
            logger.trace("Card#getProtocol() == {}", (Object)protocol);
            return protocol;
        }

        @Override
        public CardChannel getBasicChannel() {
            logger.trace("Card#getBasicChannel()");
            return SynthesizedCardTerminal.this.channel;
        }

        @Override
        public CardChannel openLogicalChannel() {
            logger.trace("Card#openLogicalChannel()");
            throw new IllegalStateException("Not implemented");
        }

        @Override
        public void beginExclusive() {
            logger.trace("Card#beginExclusive()");
        }

        @Override
        public void endExclusive() {
            logger.trace("Card#endExclusive()");
        }

        @Override
        public byte[] transmitControlCommand(int i, byte[] bytes) throws CardException {
            logger.error("Card#transmitControlCommand() is not implemented");
            throw new CardException("Cloud apps should not use Card#transmitControlCommand()");
        }

        @Override
        public void disconnect(boolean b) {
            logger.trace("Card#disconnect({})", (Object)b);
            SynthesizedCardTerminal.this.reader.close();
        }

        public String toString() {
            return String.format("Card protocol: %s atr: %s", this.getProtocol(), HexUtils.bin2hex(this.getATR().getBytes()));
        }

        class SynthesizedChannel
        extends CardChannel {
            SynthesizedChannel() {
            }

            @Override
            public Card getCard() {
                logger.trace("CardChannel#getCard()");
                return SynthesizedCard.this;
            }

            @Override
            public int getChannelNumber() {
                int result = 0;
                logger.trace("CardChannel#getChannelNumber() == {}", (Object)result);
                return result;
            }

            @Override
            public ResponseAPDU transmit(CommandAPDU commandAPDU) throws CardException {
                if (!SynthesizedCardTerminal.this.isCardPresent()) {
                    throw new IllegalStateException("Card or channel has been closed");
                }
                logger.trace("transmit({})", (Object)HexUtils.bin2hex(commandAPDU.getBytes()));
                try {
                    return new ResponseAPDU(SynthesizedCardTerminal.this.reader.transmit(commandAPDU.getBytes()).get());
                }
                catch (BIBOException e) {
                    throw new CardException(e.getMessage(), e);
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                    throw new CardException(e.getMessage(), e);
                }
            }

            @Override
            public int transmit(ByteBuffer byteBuffer, ByteBuffer byteBuffer1) throws CardException {
                logger.trace("transmit({})", (Object)HexUtils.bin2hex(byteBuffer.array()));
                throw new CardException("Cloud apps should not use Card#transmit()");
            }

            @Override
            public void close() {
                logger.trace("CardChannel#close()");
            }
        }
    }
}

