/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.core.HexUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import pro.javacard.capfile.AID;
import pro.javacard.gp.data.BitField;

public class GPRegistryEntry {
    AID aid;
    byte lifecycle;
    Kind kind;
    AID domain;
    private final EnumSet<Privilege> privileges = EnumSet.noneOf(Privilege.class);
    private AID from;
    private byte[] version;
    private final List<AID> modules = new ArrayList<AID>();
    HashSet<Integer> implicitContact = new HashSet();
    HashSet<Integer> implicitContactless = new HashSet();

    GPRegistryEntry() {
    }

    public Set<Privilege> getPrivileges() {
        return Collections.unmodifiableSet(this.privileges);
    }

    void setPrivileges(Set<Privilege> privs) {
        this.privileges.addAll(privs);
    }

    public Optional<AID> getSource() {
        return Optional.ofNullable(this.from);
    }

    void setLoadFile(AID aid) {
        this.from = aid;
    }

    public boolean hasPrivilege(Privilege p) {
        return this.privileges.contains(p);
    }

    public byte[] getVersion() {
        if (this.version == null) {
            return null;
        }
        return (byte[])this.version.clone();
    }

    public boolean equals(Object other) {
        if (other instanceof GPRegistryEntry) {
            GPRegistryEntry o = (GPRegistryEntry)other;
            return o.kind.equals((Object)this.kind) && o.aid.equals(this.aid);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aid, this.kind});
    }

    void setVersion(byte[] v) {
        this.version = (byte[])v.clone();
    }

    public String getVersionString() {
        if (this.version == null) {
            return "<null>";
        }
        if (this.version.length == 2) {
            return (this.version[0] & 0xFF) + "." + (this.version[1] & 0xFF);
        }
        return "<unknown format " + HexUtils.bin2hex(this.version) + ">";
    }

    public void addModule(AID aid) {
        this.modules.add(aid);
    }

    public List<AID> getModules() {
        return new ArrayList<AID>(this.modules);
    }

    public AID getAID() {
        return this.aid;
    }

    void setAID(AID aid) {
        this.aid = aid;
    }

    public Optional<AID> getDomain() {
        return Optional.ofNullable(this.domain);
    }

    public byte getLifeCycle() {
        return this.lifecycle;
    }

    void setLifeCycle(byte lifecycle) {
        this.lifecycle = lifecycle;
    }

    public Kind getType() {
        return this.kind;
    }

    void setType(Kind type) {
        this.kind = type;
    }

    public boolean isPackage() {
        return this.kind == Kind.PKG;
    }

    public boolean isApplet() {
        return this.kind == Kind.APP;
    }

    public boolean isDomain() {
        return this.kind == Kind.SSD || this.kind == Kind.ISD;
    }

    void setDomain(AID dom) {
        this.domain = dom;
    }

    public String toString() {
        return "%s: %s, %s".formatted(new Object[]{this.kind, HexUtils.bin2hex(this.aid.getBytes()), this.getLifeCycleString()});
    }

    public String getLifeCycleString() {
        if (this.kind == Kind.ISD) {
            return ByteEnum.fromByte(ISDLifeCycle.class, this.lifecycle).name();
        }
        if (this.kind == Kind.SSD) {
            return ByteEnum.fromByte(SSDLifeCycle.class, this.lifecycle).name();
        }
        if (this.kind == Kind.PKG) {
            return ByteEnum.fromByte(PKGLifeCycle.class, this.lifecycle).name();
        }
        return ByteEnum.fromByte(APPLifeCycle.class, this.lifecycle).name();
    }

    public Set<Integer> getImplicitlySelectedContact() {
        return Collections.unmodifiableSet(this.implicitContact);
    }

    public Set<Integer> getImplicitlySelectedContactless() {
        return Collections.unmodifiableSet(this.implicitContactless);
    }

    public static enum Privilege implements BitField<Privilege>
    {
        SecurityDomain(BitField.byte_mask(0, 128)),
        DAPVerification(BitField.byte_mask(0, 192)),
        DelegatedManagement(BitField.byte_mask(0, 160)),
        CardLock(BitField.byte_mask(0, 16)),
        CardTerminate(BitField.byte_mask(0, 8)),
        CardReset(BitField.byte_mask(0, 4)),
        CVMManagement(BitField.byte_mask(0, 2)),
        MandatedDAPVerification(BitField.byte_mask(0, 193)),
        TrustedPath(BitField.byte_mask(1, 128)),
        AuthorizedManagement(BitField.byte_mask(1, 64)),
        TokenVerification(BitField.byte_mask(1, 32)),
        GlobalDelete(BitField.byte_mask(1, 16)),
        GlobalLock(BitField.byte_mask(1, 8)),
        GlobalRegistry(BitField.byte_mask(1, 4)),
        FinalApplication(BitField.byte_mask(1, 2)),
        GlobalService(BitField.byte_mask(1, 1)),
        ReceiptGeneration(BitField.byte_mask(2, 128)),
        CipheredLoadFileDataBlock(BitField.byte_mask(2, 64)),
        ContactlessActivation(BitField.byte_mask(2, 32)),
        ContactlessSelfActivation(BitField.byte_mask(2, 16)),
        PrivacyTrusted(BitField.byte_mask(2, 8)),
        RFU(new BitField.Def.RFU(BitField.byte_mask(2, 7)));

        private final BitField.Def def;

        private Privilege(BitField.Def def) {
            this.def = def;
        }

        public static Optional<Privilege> lookup(String name) {
            return Arrays.stream(Privilege.values()).filter(e -> e.name().equalsIgnoreCase(name)).findFirst();
        }

        @Override
        public BitField.Def def() {
            return this.def;
        }
    }

    public static enum Kind {
        ISD,
        APP,
        SSD,
        PKG;

    }

    public static enum ISDLifeCycle implements ByteEnum
    {
        OP_READY(1),
        INITIALIZED(7),
        SECURED(15),
        CARD_LOCKED(127),
        TERMINATED(255);

        private final byte value;

        private ISDLifeCycle(int value) {
            this.value = (byte)(value & 0xFF);
        }

        @Override
        public Predicate<Byte> matcher() {
            return v -> v == this.value;
        }

        public byte getValue() {
            return this.value;
        }
    }

    public static interface ByteEnum {
        default public Predicate<Byte> matcher() {
            return p -> true;
        }

        public static <T extends Enum<T>> T fromByte(Class<T> klass, byte value) {
            for (Enum state : (Enum[])klass.getEnumConstants()) {
                if (!((ByteEnum)((Object)state)).matcher().test(value)) continue;
                return (T)state;
            }
            throw new IllegalArgumentException("Unknown %s value: 0x%02X".formatted(klass.getSimpleName(), value & 0xFF));
        }
    }

    public static enum SSDLifeCycle implements ByteEnum
    {
        INSTALLED(v -> v == 3),
        SELECTABLE(v -> v == 7),
        PERSONALIZED(v -> v == 15),
        LOCKED(v -> (v & 0x83) == 131);

        private final Predicate<Byte> matcher;

        private SSDLifeCycle(Predicate<Byte> matcher) {
            this.matcher = matcher;
        }

        @Override
        public Predicate<Byte> matcher() {
            return this.matcher;
        }
    }

    public static enum PKGLifeCycle implements ByteEnum
    {
        LOADED(v -> v == 1),
        LOGICALLY_DELETED(v -> v == 0);

        private final Predicate<Byte> matcher;

        private PKGLifeCycle(Predicate<Byte> matcher) {
            this.matcher = matcher;
        }

        @Override
        public Predicate<Byte> matcher() {
            return this.matcher;
        }
    }

    public static enum APPLifeCycle implements ByteEnum
    {
        INSTALLED(v -> v == 3),
        SELECTABLE(v -> (v & 0xFF) <= 127),
        LOCKED(v -> (v & 0x83) == 131);

        private final Predicate<Byte> matcher;

        private APPLifeCycle(Predicate<Byte> matcher) {
            this.matcher = matcher;
        }

        @Override
        public Predicate<Byte> matcher() {
            return this.matcher;
        }
    }
}

