/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.adapters.ReflectionHelper;
import com.jfoenix.adapters.skins.DatePickerSkin;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.skins.JFXDatePickerContent;
import com.jfoenix.svg.SVGGlyph;
import java.time.LocalDate;
import java.time.YearMonth;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.StringConverter;

public class JFXDatePickerSkin
extends DatePickerSkin {
    private JFXDatePicker jfxDatePicker;
    private TextField displayNode;
    private JFXDatePickerContent content;
    private JFXDialog dialog;

    public JFXDatePickerSkin(JFXDatePicker datePicker) {
        super(datePicker);
        this.jfxDatePicker = datePicker;
        super.getPopupContent();
        try {
            Object expressionHelper = ReflectionHelper.getFieldContent(datePicker.focusedProperty().getClass().getSuperclass(), datePicker.focusedProperty(), "helper");
            ChangeListener[] changeListeners = (ChangeListener[])ReflectionHelper.getFieldContent(expressionHelper, "changeListeners");
            int i = changeListeners.length - 1;
            while (changeListeners[i] == null) {
                --i;
            }
            datePicker.focusedProperty().removeListener(changeListeners[i]);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        datePicker.focusedProperty().addListener((obj, oldVal, newVal) -> {
            if (this.getEditor() != null && !newVal.booleanValue()) {
                this.setTextFromTextFieldIntoComboBoxValue2();
            }
        });
        SVGGlyph glyph = new SVGGlyph(0, "calendar", "M320 384h128v128h-128zM512 384h128v128h-128zM704 384h128v128h-128zM128 768h128v128h-128zM320 768h128v128h-128zM512 768h128v128h-128zM320 576h128v128h-128zM512 576h128v128h-128zM704 576h128v128h-128zM128 576h128v128h-128zM832 0v64h-128v-64h-448v64h-128v-64h-128v1024h960v-1024h-128zM896 960h-832v-704h832v704z", (Paint)Color.BLACK);
        this.setArrow((Region)glyph);
        glyph.fillProperty().bind(this.jfxDatePicker.defaultColorProperty());
        glyph.setSize(20.0, 20.0);
        this.getArrowButton().getChildren().setAll((Object[])new Node[]{glyph});
        this.getArrowButton().setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getArrowButton().setPadding(new Insets(1.0, 8.0, 1.0, 8.0));
        this.registerChangeListener2((ObservableValue<?>)datePicker.converterProperty(), "CONVERTER", () -> this.updateDisplayNode2());
        this.registerChangeListener2((ObservableValue<?>)datePicker.dayCellFactoryProperty(), "DAY_CELL_FACTORY", () -> {
            this.updateDisplayNode2();
            this.content = null;
            this.setPopup2(null);
        });
        this.registerChangeListener2((ObservableValue<?>)datePicker.editorProperty(), "EDITOR", () -> this.getEditableInputNode2());
        this.registerChangeListener2((ObservableValue<?>)datePicker.showingProperty(), "SHOWING", () -> {
            if (this.jfxDatePicker.isShowing()) {
                if (this.content != null) {
                    LocalDate date = (LocalDate)this.jfxDatePicker.getValue();
                    this.content.displayedYearMonthProperty().set((Object)(date != null ? YearMonth.from(date) : YearMonth.now()));
                    this.content.updateValues();
                }
                this.show();
            } else {
                this.hide();
            }
        });
        this.registerChangeListener2((ObservableValue<?>)datePicker.showWeekNumbersProperty(), "SHOW_WEEK_NUMBERS", () -> {
            if (this.content != null) {
                this.content.updateContentGrid();
                this.content.updateWeekNumberDateCells();
            }
        });
        this.registerChangeListener2((ObservableValue<?>)datePicker.valueProperty(), "VALUE", () -> {
            this.updateDisplayNode2();
            if (this.content != null) {
                LocalDate date = (LocalDate)this.jfxDatePicker.getValue();
                this.content.displayedYearMonthProperty().set((Object)(date != null ? YearMonth.from(date) : YearMonth.now()));
                this.content.updateValues();
            }
            this.jfxDatePicker.fireEvent((Event)new ActionEvent());
        });
    }

    public Node getPopupContent() {
        if (this.content == null) {
            this.content = new JFXDatePickerContent(this.jfxDatePicker);
        }
        return this.content;
    }

    public void show() {
        if (!((JFXDatePicker)this.getSkinnable()).isOverLay()) {
            super.show();
        }
        if (this.content != null) {
            this.content.init();
            this.content.clearFocus();
        }
        if (((JFXDatePicker)this.getSkinnable()).isOverLay() && this.dialog == null) {
            StackPane dialogParent = this.jfxDatePicker.getDialogParent();
            if (dialogParent == null) {
                dialogParent = (StackPane)((ComboBoxBase)this.getSkinnable()).getScene().getRoot();
            }
            this.dialog = new JFXDialog(dialogParent, (Region)this.getPopupContent(), JFXDialog.DialogTransition.CENTER, true);
            this.getArrowButton().setOnMouseClicked(click -> {
                if (((JFXDatePicker)this.getSkinnable()).isOverLay()) {
                    StackPane parent = this.jfxDatePicker.getDialogParent();
                    if (parent == null) {
                        parent = (StackPane)((ComboBoxBase)this.getSkinnable()).getScene().getRoot();
                    }
                    this.dialog.show(parent);
                }
            });
        }
    }

    protected TextField getEditor() {
        return ((DatePicker)this.getSkinnable()).getEditor();
    }

    protected StringConverter<LocalDate> getConverter() {
        return ((DatePicker)this.getSkinnable()).getConverter();
    }

    public Node getDisplayNode() {
        if (this.displayNode == null) {
            this.displayNode = this.getEditableInputNode2();
            this.displayNode.getStyleClass().add((Object)"date-picker-display-node");
            this.updateDisplayNode2();
        }
        this.displayNode.setEditable(this.jfxDatePicker.isEditable());
        return this.displayNode;
    }

    public void syncWithAutoUpdate() {
        if (!this.getPopup2().isShowing() && this.jfxDatePicker.isShowing()) {
            this.jfxDatePicker.hide();
        }
    }
}

