/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.multimc;

import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.util.List;
import kala.compress.archivers.zip.ZipArchiveEntry;
import kala.compress.archivers.zip.ZipArchiveReader;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.gson.JsonUtils;

@Immutable
public final class MultiMCManifest {
    @SerializedName(value="formatVersion")
    private final int formatVersion;
    @SerializedName(value="components")
    private final List<MultiMCManifestComponent> components;

    public MultiMCManifest(int formatVersion, List<MultiMCManifestComponent> components) {
        this.formatVersion = formatVersion;
        this.components = components;
    }

    public int getFormatVersion() {
        return this.formatVersion;
    }

    public List<MultiMCManifestComponent> getComponents() {
        return this.components;
    }

    public static MultiMCManifest readMultiMCModpackManifest(ZipArchiveReader zipFile, String rootEntryName) throws IOException {
        ZipArchiveEntry mmcPack = zipFile.getEntry(rootEntryName + "mmc-pack.json");
        if (mmcPack == null) {
            return null;
        }
        MultiMCManifest manifest = JsonUtils.fromNonNullJsonFully(zipFile.getInputStream(mmcPack), MultiMCManifest.class);
        if (manifest.getComponents() == null) {
            throw new IOException("mmc-pack.json malformed.");
        }
        return manifest;
    }

    public static final class MultiMCManifestComponent {
        @SerializedName(value="cachedName")
        private final String cachedName;
        @SerializedName(value="cachedRequires")
        private final List<MultiMCManifestCachedRequires> cachedRequires;
        @SerializedName(value="cachedVersion")
        private final String cachedVersion;
        @SerializedName(value="important")
        private final boolean important;
        @SerializedName(value="dependencyOnly")
        private final boolean dependencyOnly;
        @SerializedName(value="uid")
        private final String uid;
        @SerializedName(value="version")
        private final String version;

        public MultiMCManifestComponent(boolean important, boolean dependencyOnly, String uid, String version) {
            this(null, null, null, important, dependencyOnly, uid, version);
        }

        public MultiMCManifestComponent(String cachedName, List<MultiMCManifestCachedRequires> cachedRequires, String cachedVersion, boolean important, boolean dependencyOnly, String uid, String version) {
            this.cachedName = cachedName;
            this.cachedRequires = cachedRequires;
            this.cachedVersion = cachedVersion;
            this.important = important;
            this.dependencyOnly = dependencyOnly;
            this.uid = uid;
            this.version = version;
        }

        public String getCachedName() {
            return this.cachedName;
        }

        public List<MultiMCManifestCachedRequires> getCachedRequires() {
            return this.cachedRequires;
        }

        public String getCachedVersion() {
            return this.cachedVersion;
        }

        public boolean isImportant() {
            return this.important;
        }

        public boolean isDependencyOnly() {
            return this.dependencyOnly;
        }

        public String getUid() {
            return this.uid;
        }

        public String getVersion() {
            return this.version;
        }
    }

    public static final class MultiMCManifestCachedRequires {
        @SerializedName(value="equals")
        private final String equalsVersion;
        @SerializedName(value="uid")
        private final String uid;
        @SerializedName(value="suggests")
        private final String suggests;

        public MultiMCManifestCachedRequires(String equalsVersion, String uid, String suggests) {
            this.equalsVersion = equalsVersion;
            this.uid = uid;
            this.suggests = suggests;
        }

        public String getEqualsVersion() {
            return this.equalsVersion;
        }

        public String getID() {
            return this.uid;
        }

        public String getSuggests() {
            return this.suggests;
        }
    }
}

