/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXButton;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;

public class FileItem
extends BorderPane {
    private final Label lblPath = new Label();
    private final SimpleStringProperty name = new SimpleStringProperty((Object)this, "name");
    private final SimpleStringProperty title = new SimpleStringProperty((Object)this, "title");
    private final SimpleStringProperty path = new SimpleStringProperty((Object)this, "path");
    private final SimpleBooleanProperty convertToRelativePath = new SimpleBooleanProperty((Object)this, "convertToRelativePath");

    public FileItem() {
        VBox left = new VBox();
        Label name = new Label();
        name.textProperty().bind((ObservableValue)this.nameProperty());
        this.lblPath.getStyleClass().addAll((Object[])new String[]{"subtitle-label"});
        this.lblPath.textProperty().bind((ObservableValue)this.path);
        left.getChildren().addAll((Object[])new Node[]{name, this.lblPath});
        this.setLeft((Node)left);
        JFXButton right = new JFXButton();
        right.setGraphic(SVG.EDIT.createIcon(16.0));
        right.getStyleClass().add((Object)"toggle-icon4");
        right.setOnAction(e -> this.onExplore());
        FXUtils.installFastTooltip((Node)right, I18n.i18n("button.edit"));
        this.setRight((Node)right);
        this.convertToRelativePath.addListener(FXUtils.onInvalidating(() -> this.path.set(this.processPath(this.path.get()))));
    }

    private String processPath(String path) {
        Path given;
        try {
            given = Path.of(path, new String[0]).toAbsolutePath().normalize();
        }
        catch (IllegalArgumentException e) {
            return path;
        }
        if (this.isConvertToRelativePath()) {
            try {
                return Metadata.CURRENT_DIRECTORY.relativize(given).normalize().toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return given.normalize().toString();
    }

    public void onExplore() {
        DirectoryChooser chooser = new DirectoryChooser();
        if (this.path.get() != null) {
            try {
                Path file = Path.of(this.path.get(), new String[0]);
                if (Files.exists(file, new LinkOption[0])) {
                    if (Files.isRegularFile(file, new LinkOption[0])) {
                        file = file.toAbsolutePath().normalize().getParent();
                    } else if (Files.isDirectory(file, new LinkOption[0])) {
                        file = file.toAbsolutePath().normalize();
                    }
                    chooser.setInitialDirectory(file.toFile());
                }
            }
            catch (InvalidPathException e) {
                Logger.LOG.warning("Failed to resolve path: " + this.path.get());
            }
        }
        chooser.titleProperty().bind((ObservableValue)this.titleProperty());
        File selectedDir = chooser.showDialog((Window)Controllers.getStage());
        if (selectedDir != null) {
            this.path.set(this.processPath(selectedDir.toString()));
        }
        chooser.titleProperty().unbind();
    }

    public String getName() {
        return this.name.get();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public void setName(String name) {
        this.name.set(name);
    }

    public String getTitle() {
        return this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.set(title);
    }

    public String getPath() {
        return this.path.get();
    }

    public StringProperty pathProperty() {
        return this.path;
    }

    public void setPath(String path) {
        this.path.set(path);
    }

    public boolean isConvertToRelativePath() {
        return this.convertToRelativePath.get();
    }

    public BooleanProperty convertToRelativePathProperty() {
        return this.convertToRelativePath;
    }

    public void setConvertToRelativePath(boolean convertToRelativePath) {
        this.convertToRelativePath.set(convertToRelativePath);
    }
}

