/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javafx.scene.layout.Region;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.game.WorldLockedException;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.construct.InputDialogPane;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.versions.WorldExportPage;
import org.jackhuang.hmcl.ui.wizard.SinglePageWizardProvider;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class WorldManageUIUtils {
    private WorldManageUIUtils() {
    }

    public static void delete(World world, Runnable runnable) {
        WorldManageUIUtils.delete(world, runnable, null);
    }

    public static void delete(World world, Runnable runnable, FileChannel sessionLockChannel) {
        Controllers.confirm(I18n.i18n("button.remove.confirm"), I18n.i18n("world.delete"), () -> Task.runAsync(() -> WorldManageUIUtils.closeSessionLockChannel(world, sessionLockChannel)).thenRunAsync(world::delete).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception == null) {
                runnable.run();
            } else if (exception instanceof WorldLockedException) {
                Controllers.dialog(I18n.i18n("world.locked.failed"), null, MessageDialogPane.MessageType.WARNING);
            } else {
                Controllers.dialog(I18n.i18n("world.delete.failed", StringUtils.getStackTrace(exception)), null, MessageDialogPane.MessageType.WARNING);
            }
        }).start(), null);
    }

    public static void export(World world) {
        WorldManageUIUtils.export(world, null);
    }

    public static void export(World world, FileChannel sessionLockChannel) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(I18n.i18n("world.export.title"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("world"), new String[]{"*.zip"}));
        fileChooser.setInitialFileName(world.getWorldName());
        Path file = FileUtils.toPath(fileChooser.showSaveDialog((Window)Controllers.getStage()));
        if (file == null) {
            return;
        }
        try {
            WorldManageUIUtils.closeSessionLockChannel(world, sessionLockChannel);
        }
        catch (IOException e) {
            return;
        }
        Controllers.getDecorator().startWizard(new SinglePageWizardProvider(controller -> new WorldExportPage(world, file, controller::onFinish)));
    }

    public static void copyWorld(World world, Runnable runnable) {
        Path worldPath = world.getFile();
        Controllers.dialog((Region)new InputDialogPane(I18n.i18n("world.duplicate.prompt"), "", (result, resolve, reject) -> {
            if (StringUtils.isBlank(result)) {
                reject.accept(I18n.i18n("world.duplicate.failed.empty_name"));
                return;
            }
            if (result.contains("/") || result.contains("\\") || !FileUtils.isNameValid(result)) {
                reject.accept(I18n.i18n("world.duplicate.failed.invalid_name"));
                return;
            }
            Path targetDir = worldPath.resolveSibling((String)result);
            if (Files.exists(targetDir, new LinkOption[0])) {
                reject.accept(I18n.i18n("world.duplicate.failed.already_exists"));
                return;
            }
            Task.runAsync(Schedulers.io(), () -> world.copy((String)result)).thenAcceptAsync(Schedulers.javafx(), Void2 -> Controllers.showToast(I18n.i18n("world.duplicate.success.toast"))).thenAcceptAsync(Schedulers.javafx(), Void2 -> {
                if (runnable != null) {
                    runnable.run();
                }
            }).whenComplete(Schedulers.javafx(), throwable -> {
                if (throwable == null) {
                    resolve.run();
                } else {
                    reject.accept(I18n.i18n("world.duplicate.failed"));
                    Logger.LOG.warning("Failed to duplicate world " + String.valueOf(world.getFile()), throwable);
                }
            }).start();
        }));
    }

    public static void closeSessionLockChannel(World world, FileChannel sessionLockChannel) throws IOException {
        if (sessionLockChannel != null) {
            try {
                sessionLockChannel.close();
                Logger.LOG.info("Closed session lock channel of the world " + world.getFileName());
            }
            catch (IOException e) {
                throw new IOException("Failed to close session lock channel of the world " + String.valueOf(world.getFile()), e);
            }
        }
    }

    public static FileChannel getSessionLockChannel(World world) {
        try {
            FileChannel lock = world.lock();
            Logger.LOG.info("Acquired lock on world " + world.getFileName());
            return lock;
        }
        catch (IOException ignored) {
            return null;
        }
    }
}

