/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.adapters.skins.ToggleButtonSkin;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.controls.JFXToggleButton;
import com.jfoenix.effects.JFXDepthManager;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.StrokeLineCap;
import javafx.util.Duration;

public class JFXToggleButtonSkin
extends ToggleButtonSkin {
    private Line line;
    private Circle circle;
    private final double circleRadius;
    private StackPane circleContainer = new StackPane();
    private JFXRippler rippler;
    private Timeline transition;
    private Runnable releaseManualRippler = null;

    public JFXToggleButtonSkin(JFXToggleButton toggleButton) {
        super(toggleButton);
        toggleButton.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)}));
        double size = toggleButton.getSize();
        double startY = 0.0;
        double endX = size * 2.0 + 2.0;
        double startX = 0.0;
        this.circleRadius = toggleButton.getSize();
        this.line = new Line(0.0, 0.0, endX, 0.0);
        this.line.setStroke(toggleButton.getUnToggleLineColor());
        this.line.setStrokeWidth(size * 1.5);
        this.line.setStrokeLineCap(StrokeLineCap.ROUND);
        this.circle = new Circle(0.0 - this.circleRadius, 0.0, this.circleRadius);
        this.circle.setFill(toggleButton.getUnToggleColor());
        this.circle.setSmooth(true);
        JFXDepthManager.setDepth((Node)this.circle, 1);
        StackPane circlePane = new StackPane();
        circlePane.getChildren().add((Object)this.circle);
        circlePane.setPadding(new Insets(size * 1.5));
        this.rippler = new JFXRippler((Node)circlePane, JFXRippler.RipplerMask.CIRCLE, JFXRippler.RipplerPos.BACK){

            @Override
            protected void initListeners() {
                this.ripplerPane.setOnMousePressed(event -> {
                    if (JFXToggleButtonSkin.this.releaseManualRippler != null) {
                        JFXToggleButtonSkin.this.releaseManualRippler.run();
                    }
                    JFXToggleButtonSkin.this.releaseManualRippler = null;
                    this.createRipple(event.getX(), event.getY());
                });
            }
        };
        this.rippler.setRipplerFill(toggleButton.getUnToggleLineColor());
        this.circleContainer.getChildren().add((Object)this.rippler);
        this.circleContainer.setTranslateX(-(this.line.getLayoutBounds().getWidth() / 2.0) + this.circleRadius);
        StackPane main = new StackPane();
        main.getChildren().add((Object)this.line);
        main.getChildren().add((Object)this.circleContainer);
        main.setCursor(Cursor.HAND);
        ((ToggleButton)this.getSkinnable()).armedProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.releaseManualRippler = this.rippler.createManualRipple();
            } else if (this.releaseManualRippler != null) {
                this.releaseManualRippler.run();
            }
        });
        toggleButton.focusedProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                if (!((ToggleButton)this.getSkinnable()).isPressed()) {
                    this.rippler.showOverlay();
                }
            } else {
                this.rippler.hideOverlay();
            }
        });
        toggleButton.pressedProperty().addListener((o, oldVal, newVal) -> this.rippler.hideOverlay());
        ((ToggleButton)this.getSkinnable()).selectedProperty().addListener((o, oldVal, newVal) -> {
            this.rippler.setRipplerFill(newVal != false ? toggleButton.getToggleColor() : toggleButton.getUnToggleLineColor());
            this.transition.setRate(newVal != false ? 1.0 : -1.0);
            this.transition.play();
        });
        ((ToggleButton)this.getSkinnable()).setGraphic((Node)main);
        this.updateToggleTransition();
        toggleButton.toggleColorProperty().addListener((o, oldVal, newVal) -> {
            this.updateToggleTransition();
            this.udpateCricle();
        });
        toggleButton.unToggleColorProperty().addListener((o, oldVal, newVal) -> {
            this.updateToggleTransition();
            this.udpateCricle();
        });
        toggleButton.toggleLineColorProperty().addListener((o, oldVal, newVal) -> {
            this.updateToggleTransition();
            this.updateLine();
        });
        toggleButton.unToggleLineColorProperty().addListener((o, oldVal, newVal) -> {
            this.updateToggleTransition();
            this.updateLine();
        });
        this.rippler.setRipplerFill(((ToggleButton)this.getSkinnable()).isSelected() ? toggleButton.getToggleColor() : toggleButton.getUnToggleLineColor());
        if (((ToggleButton)this.getSkinnable()).isSelected()) {
            this.circleContainer.setTranslateX(this.line.getLayoutBounds().getWidth() / 2.0 - this.circleRadius);
            this.line.setStroke(((JFXToggleButton)this.getSkinnable()).getToggleLineColor());
            this.circle.setFill(((JFXToggleButton)this.getSkinnable()).getToggleColor());
        }
    }

    private void udpateCricle() {
        this.circle.setFill(((ToggleButton)this.getSkinnable()).isSelected() ? ((JFXToggleButton)this.getSkinnable()).getToggleColor() : ((JFXToggleButton)this.getSkinnable()).getUnToggleColor());
    }

    private void updateLine() {
        this.line.setStroke(((ToggleButton)this.getSkinnable()).isSelected() ? ((JFXToggleButton)this.getSkinnable()).getToggleLineColor() : ((JFXToggleButton)this.getSkinnable()).getUnToggleLineColor());
    }

    private void updateToggleTransition() {
        this.transition = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.circleContainer.translateXProperty(), (Object)(-(this.line.getLayoutBounds().getWidth() / 2.0) + this.circleRadius), Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.line.strokeProperty(), (Object)((JFXToggleButton)this.getSkinnable()).getUnToggleLineColor(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.circle.fillProperty(), (Object)((JFXToggleButton)this.getSkinnable()).getUnToggleColor(), Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)this.circleContainer.translateXProperty(), (Object)(this.line.getLayoutBounds().getWidth() / 2.0 - this.circleRadius), Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.line.strokeProperty(), (Object)((JFXToggleButton)this.getSkinnable()).getToggleLineColor(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.circle.fillProperty(), (Object)((JFXToggleButton)this.getSkinnable()).getToggleColor(), Interpolator.EASE_BOTH)})});
    }
}

