/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.game;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.jackhuang.hmcl.download.AbstractDependencyManager;
import org.jackhuang.hmcl.download.DefaultCacheRepository;
import org.jackhuang.hmcl.download.game.LibraryDownloadException;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.task.DownloadException;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public class LibraryDownloadTask
extends Task<Void> {
    private FileDownloadTask task;
    protected final File jar;
    protected final DefaultCacheRepository cacheRepository;
    protected final AbstractDependencyManager dependencyManager;
    protected final Library library;
    protected final String url;
    private final Library originalLibrary;
    private boolean cached = false;

    public LibraryDownloadTask(AbstractDependencyManager dependencyManager, File file, Library library) {
        this.dependencyManager = dependencyManager;
        this.originalLibrary = library;
        this.setSignificance(Task.TaskSignificance.MODERATE);
        if (library.is("net.minecraftforge", "forge")) {
            library = library.setClassifier("universal");
        }
        this.library = library;
        this.cacheRepository = dependencyManager.getCacheRepository();
        this.url = library.getDownload().getUrl();
        this.jar = file;
    }

    @Override
    public Collection<Task<?>> getDependents() {
        if (this.cached) {
            return Collections.emptyList();
        }
        return Collections.singleton(this.task);
    }

    @Override
    public boolean isRelyingOnDependents() {
        return false;
    }

    @Override
    public void execute() throws Exception {
        if (this.cached) {
            return;
        }
        if (!this.isDependentsSucceeded()) {
            Exception t = this.task.getException();
            if (t instanceof DownloadException) {
                throw new LibraryDownloadException(this.library, t.getCause());
            }
            if (t instanceof CancellationException) {
                throw new CancellationException();
            }
            throw new LibraryDownloadException(this.library, (Throwable)t);
        }
    }

    @Override
    public boolean doPreExecute() {
        return true;
    }

    @Override
    public void preExecute() {
        Optional<Path> libPath = this.cacheRepository.getLibrary(this.originalLibrary);
        if (libPath.isPresent()) {
            try {
                FileUtils.copyFile(libPath.get().toFile(), this.jar);
                this.cached = true;
                return;
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to copy file from cache", e);
            }
        }
        List<URL> urls = this.dependencyManager.getDownloadProvider().injectURLWithCandidates(this.url);
        this.task = new FileDownloadTask(urls, this.jar, this.library.getDownload().getSha1() != null ? new FileDownloadTask.IntegrityCheck("SHA-1", this.library.getDownload().getSha1()) : null);
        this.task.setCacheRepository(this.cacheRepository);
        this.task.setCaching(true);
        this.task.addIntegrityCheckHandler(FileDownloadTask.ZIP_INTEGRITY_CHECK_HANDLER);
    }

    @Override
    public boolean doPostExecute() {
        return true;
    }

    @Override
    public void postExecute() throws Exception {
        if (!this.cached) {
            try {
                this.cacheRepository.cacheLibrary(this.library, this.jar.toPath(), false);
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to cache downloaded library " + this.library, e);
            }
        }
    }

    public static boolean checksumValid(File libPath, List<String> checksums) {
        try {
            if (checksums == null || checksums.isEmpty()) {
                return true;
            }
            byte[] fileData = Files.readAllBytes(libPath.toPath());
            boolean valid = checksums.contains(DigestUtils.digestToString("SHA-1", fileData));
            if (!valid && libPath.getName().endsWith(".jar")) {
                valid = LibraryDownloadTask.validateJar(fileData, checksums);
            }
            return valid;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean validateJar(byte[] data, List<String> checksums) throws IOException {
        HashMap<String, String> files = new HashMap<String, String>();
        String[] hashes = null;
        JarInputStream jar = new JarInputStream(new ByteArrayInputStream(data));
        JarEntry entry = jar.getNextJarEntry();
        while (entry != null) {
            byte[] eData = IOUtils.readFullyWithoutClosing(jar);
            if (entry.getName().equals("checksums.sha1")) {
                hashes = new String(eData, StandardCharsets.UTF_8).split("\n");
            }
            if (!entry.isDirectory()) {
                files.put(entry.getName(), DigestUtils.digestToString("SHA-1", eData));
            }
            entry = jar.getNextJarEntry();
        }
        jar.close();
        if (hashes != null) {
            boolean failed;
            boolean bl = failed = !checksums.contains(files.get("checksums.sha1"));
            if (!failed) {
                for (String hash : hashes) {
                    if (hash.trim().equals("") || !hash.contains(" ")) continue;
                    String[] e = hash.split(" ");
                    String validChecksum = e[0];
                    String target = hash.substring(validChecksum.length() + 1);
                    String checksum = (String)files.get(target);
                    if (!files.containsKey(target) || checksum == null) {
                        Logger.LOG.warning("    " + target + " : missing");
                        failed = true;
                        break;
                    }
                    if (checksum.equals(validChecksum)) continue;
                    Logger.LOG.warning("    " + target + " : failed (" + checksum + ", " + validChecksum + ")");
                    failed = true;
                    break;
                }
            }
            return !failed;
        }
        return false;
    }
}

