/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXSpinner;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;

@DefaultProperty(value="content")
public class SpinnerPane
extends Control {
    private final ObjectProperty<Node> content = new SimpleObjectProperty((Object)this, "content");
    private final BooleanProperty loading = new SimpleBooleanProperty((Object)this, "loading");
    private final StringProperty failedReason = new SimpleStringProperty((Object)this, "failedReason");
    private final ObjectProperty<EventHandler<Event>> onFailedAction = new SimpleObjectProperty<EventHandler<Event>>((Object)this, "onFailedAction"){

        protected void invalidated() {
            SpinnerPane.this.setEventHandler(FAILED_ACTION, (EventHandler)this.get());
        }
    };
    public static final EventType<Event> FAILED_ACTION = new EventType(Event.ANY, "FAILED_ACTION");

    public SpinnerPane() {
        this.getStyleClass().add((Object)"spinner-pane");
    }

    public void showSpinner() {
        this.setLoading(true);
    }

    public void hideSpinner() {
        this.setFailedReason(null);
        this.setLoading(false);
    }

    public Node getContent() {
        return (Node)this.content.get();
    }

    public ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public void setContent(Node content) {
        this.content.set((Object)content);
    }

    public boolean isLoading() {
        return this.loading.get();
    }

    public BooleanProperty loadingProperty() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading.set(loading);
    }

    public String getFailedReason() {
        return (String)this.failedReason.get();
    }

    public StringProperty failedReasonProperty() {
        return this.failedReason;
    }

    public void setFailedReason(String failedReason) {
        this.failedReason.set((Object)failedReason);
    }

    public final ObjectProperty<EventHandler<Event>> onFailedActionProperty() {
        return this.onFailedAction;
    }

    public final void setOnFailedAction(EventHandler<Event> value) {
        this.onFailedActionProperty().set(value);
    }

    public final EventHandler<Event> getOnFailedAction() {
        return (EventHandler)this.onFailedActionProperty().get();
    }

    protected SkinBase<SpinnerPane> createDefaultSkin() {
        return new Skin(this);
    }

    private static final class Skin
    extends SkinBase<SpinnerPane> {
        private final JFXSpinner spinner = new JFXSpinner();
        private final StackPane contentPane = new StackPane();
        private final StackPane topPane = new StackPane();
        private final TransitionPane root = new TransitionPane();
        private final StackPane failedPane = new StackPane();
        private final Label failedReasonLabel = new Label();
        private final InvalidationListener observer;

        Skin(SpinnerPane control) {
            super((Control)control);
            this.topPane.getChildren().setAll((Object[])new Node[]{this.spinner});
            this.topPane.getStyleClass().add((Object)"notice-pane");
            this.failedPane.getStyleClass().add((Object)"notice-pane");
            this.failedPane.getChildren().setAll((Object[])new Node[]{this.failedReasonLabel});
            FXUtils.onClicked((Node)this.failedPane, () -> {
                EventHandler<Event> action = control.getOnFailedAction();
                if (action != null) {
                    action.handle(new Event(FAILED_ACTION));
                }
            });
            FXUtils.onChangeAndOperate(((SpinnerPane)this.getSkinnable()).content, newValue -> {
                if (newValue == null) {
                    this.contentPane.getChildren().clear();
                } else {
                    this.contentPane.getChildren().setAll((Object[])new Node[]{newValue});
                }
            });
            this.getChildren().setAll((Object[])new Node[]{this.root});
            this.observer = FXUtils.observeWeak(() -> {
                if (((SpinnerPane)this.getSkinnable()).getFailedReason() != null) {
                    this.root.setContent((Node)this.failedPane, ContainerAnimations.FADE);
                    this.failedReasonLabel.setText(((SpinnerPane)this.getSkinnable()).getFailedReason());
                } else if (((SpinnerPane)this.getSkinnable()).isLoading()) {
                    this.root.setContent((Node)this.topPane, ContainerAnimations.FADE);
                } else {
                    this.root.setContent((Node)this.contentPane, ContainerAnimations.FADE);
                }
            }, new Observable[]{((SpinnerPane)this.getSkinnable()).loadingProperty(), ((SpinnerPane)this.getSkinnable()).failedReasonProperty()});
        }
    }
}

