/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.javafx;

import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public final class MappedProperty<T, U>
extends SimpleObjectProperty<U> {
    private final Property<T> predecessor;
    private final Function<U, T> reservedMapper;
    private final ObjectBinding<U> binding;

    public MappedProperty(Property<T> predecessor, Function<T, U> mapper, Function<U, T> reservedMapper) {
        this(null, "", predecessor, mapper, reservedMapper);
    }

    public MappedProperty(Object bean, String name, final Property<T> predecessor, final Function<T, U> mapper, Function<U, T> reservedMapper) {
        super(bean, name);
        this.predecessor = predecessor;
        this.reservedMapper = reservedMapper;
        this.binding = new ObjectBinding<U>(){
            {
                this.bind(new Observable[]{predecessor});
            }

            protected U computeValue() {
                return mapper.apply(predecessor.getValue());
            }

            protected void onInvalidating() {
                MappedProperty.this.fireValueChangedEvent();
            }
        };
    }

    public U get() {
        return (U)this.binding.get();
    }

    public void set(U value) {
        this.predecessor.setValue(this.reservedMapper.apply(value));
    }

    public void bind(ObservableValue<? extends U> observable) {
        this.predecessor.bind((ObservableValue)Bindings.createObjectBinding(() -> this.reservedMapper.apply(observable.getValue()), (Observable[])new Observable[]{observable}));
    }

    public void unbind() {
        this.predecessor.unbind();
    }

    public boolean isBound() {
        return this.predecessor.isBound();
    }
}

