/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.tree;

import java.io.IOException;
import java.io.InputStream;
import kala.compress.archivers.zip.ZipArchiveEntry;
import kala.compress.archivers.zip.ZipArchiveReader;
import org.jackhuang.hmcl.util.tree.ArchiveFileTree;

public final class ZipFileTree
extends ArchiveFileTree<ZipArchiveReader, ZipArchiveEntry> {
    public ZipFileTree(ZipArchiveReader file) throws IOException {
        super(file);
        try {
            for (ZipArchiveEntry zipArchiveEntry : file.getEntries()) {
                this.addEntry(zipArchiveEntry);
            }
        }
        catch (Throwable e) {
            try {
                file.close();
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        ((ZipArchiveReader)this.file).close();
    }

    @Override
    public InputStream getInputStream(ZipArchiveEntry entry) throws IOException {
        return ((ZipArchiveReader)this.getFile()).getInputStream(entry);
    }

    @Override
    public boolean isLink(ZipArchiveEntry entry) {
        return entry.isUnixSymlink();
    }

    @Override
    public String getLink(ZipArchiveEntry entry) throws IOException {
        return ((ZipArchiveReader)this.getFile()).getUnixSymlink(entry);
    }

    @Override
    public boolean isExecutable(ZipArchiveEntry entry) {
        return !entry.isDirectory() && !entry.isUnixSymlink() && (entry.getUnixMode() & 0x40) != 0;
    }
}

