/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.java;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import kala.compress.archivers.ArchiveEntry;
import org.jackhuang.hmcl.util.KeyValuePairUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;
import org.jackhuang.hmcl.util.tree.ArchiveFileTree;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.jetbrains.annotations.Nullable;

public final class JavaInfo {
    public static final JavaInfo CURRENT_ENVIRONMENT = new JavaInfo(Platform.CURRENT_PLATFORM, System.getProperty("java.version"), System.getProperty("java.vendor"));
    private final Platform platform;
    private final String version;
    @Nullable
    private final String vendor;
    private final transient int parsedVersion;
    private final transient VersionNumber versionNumber;

    public static int parseVersion(String version) {
        int startIndex;
        char ch;
        int endIndex;
        for (endIndex = startIndex = version.startsWith("1.") ? 2 : 0; endIndex < version.length() && (ch = version.charAt(endIndex)) >= '0' && ch <= '9'; ++endIndex) {
        }
        try {
            return endIndex > startIndex ? Integer.parseInt(version.substring(startIndex, endIndex)) : -1;
        }
        catch (Throwable e) {
            return -1;
        }
    }

    public static JavaInfo fromReleaseFile(BufferedReader reader) throws IOException {
        Map<String, String> properties = KeyValuePairUtils.loadProperties(reader);
        String osName = properties.get("OS_NAME");
        String osArch = properties.get("OS_ARCH");
        String vendor = properties.get("IMPLEMENTOR");
        OperatingSystem os = "".equals(osName) && "OpenJDK BSD Porting Team".equals(vendor) ? OperatingSystem.FREEBSD : OperatingSystem.parseOSName(osName);
        Architecture arch = Architecture.parseArchName(osArch);
        String javaVersion = properties.get("JAVA_VERSION");
        if (os == OperatingSystem.UNKNOWN) {
            throw new IOException("Unknown operating system: " + osName);
        }
        if (arch == Architecture.UNKNOWN) {
            throw new IOException("Unknown architecture: " + osArch);
        }
        if (javaVersion == null) {
            throw new IOException("Missing Java version");
        }
        return new JavaInfo(Platform.getPlatform(os, arch), javaVersion, vendor);
    }

    public static JavaInfo fromReleaseFile(Path releaseFile) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(releaseFile);){
            JavaInfo javaInfo = JavaInfo.fromReleaseFile(reader);
            return javaInfo;
        }
    }

    public static <F, E extends ArchiveEntry> JavaInfo fromArchive(ArchiveFileTree<F, E> tree) throws IOException {
        JavaInfo info;
        if (tree.getRoot().getSubDirs().size() != 1 || !tree.getRoot().getFiles().isEmpty()) {
            throw new IOException();
        }
        ArchiveFileTree.Dir<E> jdkRoot = tree.getRoot().getSubDirs().values().iterator().next();
        ArchiveEntry releaseEntry = (ArchiveEntry)jdkRoot.getFiles().get("release");
        if (releaseEntry == null) {
            throw new IOException("Missing release file");
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(tree.getInputStream(releaseEntry), StandardCharsets.UTF_8));){
            info = JavaInfo.fromReleaseFile(reader);
        }
        ArchiveFileTree.Dir<E> binDir = jdkRoot.getSubDirs().get("bin");
        if (binDir == null || binDir.getFiles().get(info.getPlatform().getOperatingSystem().getJavaExecutable()) == null) {
            throw new IOException("Missing java executable file");
        }
        return info;
    }

    public static String normalizeVendor(String vendor) {
        if (vendor == null) {
            return null;
        }
        switch (vendor) {
            case "N/A": {
                return null;
            }
            case "Oracle Corporation": {
                return "Oracle";
            }
            case "Azul Systems, Inc.": {
                return "Azul";
            }
            case "IBM Corporation": 
            case "International Business Machines Corporation": 
            case "Eclipse OpenJ9": {
                return "IBM";
            }
            case "Eclipse Adoptium": {
                return "Adoptium";
            }
            case "Amazon.com Inc.": {
                return "Amazon";
            }
        }
        return vendor;
    }

    public JavaInfo(Platform platform, String version, @Nullable String vendor) {
        this.platform = platform;
        this.version = version;
        this.parsedVersion = JavaInfo.parseVersion(version);
        this.versionNumber = VersionNumber.asVersion(version);
        this.vendor = vendor;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public String getVersion() {
        return this.version;
    }

    public VersionNumber getVersionNumber() {
        return this.versionNumber;
    }

    public int getParsedVersion() {
        return this.parsedVersion;
    }

    @Nullable
    public String getVendor() {
        return this.vendor;
    }

    public String toString() {
        return JsonUtils.GSON.toJson(this);
    }
}

