/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.upgrade;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.io.IOUtils;

final class ExecutableHeaderHelper {
    private static Map<String, String> suffix2header = Lang.mapOf(Pair.pair("exe", "assets/HMCLauncher.exe"), Pair.pair("sh", "assets/HMCLauncher.sh"));

    private ExecutableHeaderHelper() {
    }

    private static Optional<String> getSuffix(Path file) {
        String filename = file.getFileName().toString();
        int idxDot = filename.lastIndexOf(46);
        if (idxDot < 0) {
            return Optional.empty();
        }
        return Optional.of(filename.substring(idxDot + 1));
    }

    private static Optional<byte[]> readHeader(ZipFile zip, String suffix) throws IOException {
        ZipEntry entry;
        String location = suffix2header.get(suffix);
        if (location != null && (entry = zip.getEntry(location)) != null && !entry.isDirectory()) {
            try (InputStream in = zip.getInputStream(entry);){
                Optional<byte[]> optional = Optional.of(IOUtils.readFully(in));
                return optional;
            }
        }
        return Optional.empty();
    }

    private static int detectHeaderLength(ZipFile zip, FileChannel channel) throws IOException {
        MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        block0: for (String suffix : suffix2header.keySet()) {
            Optional<byte[]> header = ExecutableHeaderHelper.readHeader(zip, suffix);
            if (!header.isPresent()) continue;
            ((Buffer)buf).rewind();
            for (byte b : header.get()) {
                if (!buf.hasRemaining() || b != buf.get()) continue block0;
            }
            return header.get().length;
        }
        return 0;
    }

    public static void copyWithoutHeader(Path from, Path to) throws IOException {
        try (FileChannel in = FileChannel.open(from, StandardOpenOption.READ);
             FileChannel out = FileChannel.open(to, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
             ZipFile zip = new ZipFile(from.toFile());){
            in.transferTo(ExecutableHeaderHelper.detectHeaderLength(zip, in), Long.MAX_VALUE, out);
        }
    }

    public static void copyWithHeader(Path from, Path to) throws IOException {
        try (FileChannel in = FileChannel.open(from, StandardOpenOption.READ);
             FileChannel out = FileChannel.open(to, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
             ZipFile zip = new ZipFile(from.toFile());){
            Optional<byte[]> header;
            Optional<String> suffix = ExecutableHeaderHelper.getSuffix(to);
            if (suffix.isPresent() && (header = ExecutableHeaderHelper.readHeader(zip, suffix.get())).isPresent()) {
                out.write(ByteBuffer.wrap(header.get()));
            }
            in.transferTo(ExecutableHeaderHelper.detectHeaderLength(zip, in), Long.MAX_VALUE, out);
        }
    }
}

