/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import org.jackhuang.hmcl.util.gson.JsonSubtype;
import org.jackhuang.hmcl.util.gson.JsonType;

public final class JsonTypeAdapterFactory
implements TypeAdapterFactory {
    public static final JsonTypeAdapterFactory INSTANCE = new JsonTypeAdapterFactory();

    private <T> TypeAdapter<T> createForJsonType(Gson gson, final TypeToken<T> type) {
        Class<T> rawType = type.getRawType();
        final JsonType jsonType = rawType.getDeclaredAnnotation(JsonType.class);
        if (jsonType == null) {
            return null;
        }
        JsonSubtype[] subtypes = jsonType.subtypes();
        final HashMap labelTypeAdapterMap = new HashMap();
        final HashMap classTypeAdapterMap = new HashMap();
        final HashMap classJsonSubtypeMap = new HashMap();
        for (JsonSubtype subtype : subtypes) {
            TypeAdapter<?> typeAdapter = gson.getDelegateAdapter(this, TypeToken.get(subtype.clazz()));
            labelTypeAdapterMap.put(subtype.name(), typeAdapter);
            classTypeAdapterMap.put(subtype.clazz(), typeAdapter);
            classJsonSubtypeMap.put(subtype.clazz(), subtype);
        }
        return new TypeAdapter<T>(){

            @Override
            public void write(JsonWriter out, T value) throws IOException {
                Class<?> type2 = value.getClass();
                TypeAdapter delegate = (TypeAdapter)classTypeAdapterMap.get(type2);
                if (delegate == null) {
                    throw new JsonParseException("Cannot serialize " + type2.getName() + ". Please check your @JsonType configuration");
                }
                JsonSubtype subtype = (JsonSubtype)classJsonSubtypeMap.get(type2);
                JsonObject jsonObject = delegate.toJsonTree(value).getAsJsonObject();
                if (jsonObject.has(jsonType.property())) {
                    throw new JsonParseException("Cannot serialize " + type2.getName() + ". Because it has already defined a field named '" + jsonType.property() + "'");
                }
                jsonObject.add(jsonType.property(), new JsonPrimitive(subtype.name()));
                Streams.write(jsonObject, out);
            }

            @Override
            public T read(JsonReader in) {
                JsonElement jsonElement = Streams.parse(in);
                JsonElement typeLabelElement = jsonElement.getAsJsonObject().get(jsonType.property());
                if (typeLabelElement == null) {
                    throw new JsonParseException("Cannot deserialize " + String.valueOf(type) + ". Because it does not define a field named '" + jsonType.property() + "'");
                }
                String typeLabel = typeLabelElement.getAsString();
                TypeAdapter delegate = (TypeAdapter)labelTypeAdapterMap.get(typeLabel);
                if (delegate == null) {
                    throw new JsonParseException("Cannot deserialize " + String.valueOf(type) + " with subtype '" + typeLabel + "'");
                }
                return delegate.fromJsonTree(jsonElement);
            }
        };
    }

    private <T> TypeAdapter<T> createForJsonSubtype(Gson gson, TypeToken<T> type) {
        Class<T> rawType = type.getRawType();
        if (rawType.getSuperclass() == null) {
            return null;
        }
        final JsonType jsonType = rawType.getSuperclass().getDeclaredAnnotation(JsonType.class);
        if (jsonType == null) {
            return null;
        }
        JsonSubtype jsonSubtype = null;
        for (JsonSubtype subtype : jsonType.subtypes()) {
            if (subtype.clazz() != rawType) continue;
            jsonSubtype = subtype;
        }
        if (jsonSubtype == null) {
            return null;
        }
        final JsonSubtype subtype = jsonSubtype;
        final TypeAdapter<T> delegate = gson.getDelegateAdapter(this, type);
        return new TypeAdapter<T>(){

            @Override
            public void write(JsonWriter out, T value) throws IOException {
                Class<?> type = value.getClass();
                JsonObject jsonObject = delegate.toJsonTree(value).getAsJsonObject();
                if (jsonObject.has(jsonType.property())) {
                    throw new JsonParseException("Cannot serialize " + type.getName() + ". Because it has already defined a field named '" + jsonType.property() + "'");
                }
                jsonObject.add(jsonType.property(), new JsonPrimitive(subtype.name()));
                Streams.write(jsonObject, out);
            }

            @Override
            public T read(JsonReader in) throws IOException {
                return delegate.read(in);
            }
        };
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        TypeAdapter<T> typeAdapter = this.createForJsonType(gson, type);
        if (typeAdapter == null) {
            typeAdapter = this.createForJsonSubtype(gson, type);
        }
        return typeAdapter;
    }
}

