/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.i18n.translator;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.util.i18n.SupportedLocale;

public class Translator {
    protected final SupportedLocale supportedLocale;
    protected final Locale locale;
    protected DateTimeFormatter dateTimeFormatter;

    public Translator(SupportedLocale supportedLocale) {
        this.supportedLocale = supportedLocale;
        this.locale = supportedLocale.getLocale();
    }

    public final SupportedLocale getSupportedLocale() {
        return this.supportedLocale;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public String getDisplayVersion(RemoteVersion remoteVersion) {
        return remoteVersion.getSelfVersion();
    }

    public String formatDateTime(TemporalAccessor time) {
        DateTimeFormatter formatter = this.dateTimeFormatter;
        if (formatter == null) {
            formatter = this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.supportedLocale.getResourceBundle().getString("datetime.format")).withZone(ZoneId.systemDefault());
        }
        return formatter.format(time);
    }
}

