/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.adapters;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import sun.misc.Unsafe;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ReflectionHelper {
    private static Unsafe unsafe = null;
    private static long objectFieldOffset;

    private static void setAccessible(AccessibleObject obj) {
        unsafe.putBoolean(obj, objectFieldOffset, true);
    }

    public static <T> T invoke(Class cls, Object obj, String methodName) {
        try {
            Method method = cls.getDeclaredMethod(methodName, new Class[0]);
            ReflectionHelper.setAccessible(method);
            return (T)method.invoke(obj, new Object[0]);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static <T> T invoke(Object obj, String methodName) {
        return ReflectionHelper.invoke(obj.getClass(), obj, methodName);
    }

    public static Field getField(Class cls, String fieldName) {
        try {
            Field field = cls.getDeclaredField(fieldName);
            ReflectionHelper.setAccessible(field);
            return field;
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static <T> T getFieldContent(Object obj, String fieldName) {
        return ReflectionHelper.getFieldContent(obj.getClass(), obj, fieldName);
    }

    public static <T> T getFieldContent(Class cls, Object obj, String fieldName) {
        try {
            Field field = cls.getDeclaredField(fieldName);
            ReflectionHelper.setAccessible(field);
            return (T)field.get(obj);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static void setFieldContent(Class cls, Object obj, String fieldName, Object content) {
        try {
            Field field = cls.getDeclaredField(fieldName);
            ReflectionHelper.setAccessible(field);
            field.set(obj, content);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        try {
            unsafe = AccessController.doPrivileged(() -> {
                Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                return (Unsafe)theUnsafe.get(null);
            });
            Field overrideField = AccessibleObject.class.getDeclaredField("override");
            objectFieldOffset = unsafe.objectFieldOffset(overrideField);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

