/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.yggdrasil;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class PropertyMapSerializer
implements JsonSerializer<Map<String, String>>,
JsonDeserializer<Map<String, String>> {
    @Override
    public Map<String, String> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (JsonElement element : json.getAsJsonArray()) {
            if (!(element instanceof JsonObject)) continue;
            JsonObject object = (JsonObject)element;
            result.put(object.get("name").getAsString(), object.get("value").getAsString());
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public JsonElement serialize(Map<String, String> src, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray result = new JsonArray();
        src.forEach((k, v) -> {
            JsonObject object = new JsonObject();
            object.addProperty("name", (String)k);
            object.addProperty("value", (String)v);
            result.add(object);
        });
        return result;
    }
}

