/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.java;

import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.glavo.info.Main;
import org.jackhuang.hmcl.java.JavaInfo;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;
import org.jackhuang.hmcl.util.platform.SystemUtils;
import org.jetbrains.annotations.NotNull;

public final class JavaInfoUtils {
    private JavaInfoUtils() {
    }

    private static Path tryFindReleaseFile(Path executable) {
        Path javaHome;
        Path parent = executable.getParent();
        if (parent != null && parent.getFileName() != null && parent.getFileName().toString().equals("bin") && (javaHome = parent.getParent()) != null && javaHome.getFileName() != null) {
            Path releaseFile = javaHome.resolve("release");
            String javaHomeName = javaHome.getFileName().toString();
            if ((javaHomeName.contains("jre") || javaHomeName.contains("jdk") || javaHomeName.contains("openj9")) && Files.isRegularFile(releaseFile, new LinkOption[0])) {
                return releaseFile;
            }
        }
        return null;
    }

    @NotNull
    public static JavaInfo fromExecutable(Path executable, boolean tryFindReleaseFile) throws IOException {
        Path thisPath;
        Path releaseFile;
        assert (executable.isAbsolute());
        if (tryFindReleaseFile && (releaseFile = JavaInfoUtils.tryFindReleaseFile(executable)) != null) {
            try {
                return JavaInfo.fromReleaseFile(releaseFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((thisPath = JarUtils.thisJarPath()) == null) {
            throw new IOException("Failed to find current HMCL location");
        }
        try {
            Result result = JsonUtils.GSON.fromJson(SystemUtils.run(executable.toString(), "-classpath", thisPath.toString(), Main.class.getName()), Result.class);
            if (result == null) {
                throw new IOException("Failed to get Java info from " + String.valueOf(executable));
            }
            if (result.javaVersion == null) {
                throw new IOException("Failed to get Java version from " + String.valueOf(executable));
            }
            Architecture architecture = Architecture.parseArchName(result.osArch);
            Platform platform = Platform.getPlatform(OperatingSystem.CURRENT_OS, architecture != Architecture.UNKNOWN ? architecture : Architecture.SYSTEM_ARCH);
            return new JavaInfo(platform, result.javaVersion, result.javaVendor);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    private static final class Result {
        @SerializedName(value="os.name")
        public String osName;
        @SerializedName(value="os.arch")
        public String osArch;
        @SerializedName(value="java.version")
        public String javaVersion;
        @SerializedName(value="java.vendor")
        public String javaVendor;

        private Result() {
        }
    }
}

