/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.scene.paint.Color;
import org.jackhuang.hmcl.setting.ConfigHolder;

@JsonAdapter(value=TypeAdapter.class)
public final class Theme {
    public static final Theme BLUE = new Theme("blue", "#5C6BC0");
    public static final Color BLACK = Color.web((String)"#292929");
    public static final Color[] SUGGESTED_COLORS = new Color[]{Color.web((String)"#3D6DA3"), Color.web((String)"#283593"), Color.web((String)"#43A047"), Color.web((String)"#E67E22"), Color.web((String)"#9C27B0"), Color.web((String)"#B71C1C")};
    private final Color paint;
    private final String color;
    private final String name;
    private static ObjectBinding<Color> FOREGROUND_FILL;

    public static Theme getTheme() {
        Theme theme = ConfigHolder.config().getTheme();
        return theme == null ? BLUE : theme;
    }

    Theme(String name, String color) {
        this.name = name;
        this.color = Objects.requireNonNull(color);
        this.paint = Color.web((String)color);
    }

    public String getName() {
        return this.name;
    }

    public String getColor() {
        return this.color;
    }

    public Color getPaint() {
        return this.paint;
    }

    public boolean isCustom() {
        return this.name.startsWith("#");
    }

    public boolean isLight() {
        return this.paint.grayscale().getRed() >= 0.5;
    }

    public Color getForegroundColor() {
        return this.isLight() ? Color.BLACK : Color.WHITE;
    }

    public static Theme custom(String color) {
        if (!color.startsWith("#")) {
            throw new IllegalArgumentException();
        }
        return new Theme(color, color);
    }

    public static Optional<Theme> getTheme(String name) {
        if (name == null) {
            return Optional.empty();
        }
        if (name.startsWith("#")) {
            try {
                Color.web((String)name);
                return Optional.of(Theme.custom(name));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            String color = null;
            switch (name.toLowerCase(Locale.ROOT)) {
                case "blue": {
                    return Optional.of(BLUE);
                }
                case "darker_blue": {
                    color = "#283593";
                    break;
                }
                case "green": {
                    color = "#43A047";
                    break;
                }
                case "orange": {
                    color = "#E67E22";
                    break;
                }
                case "purple": {
                    color = "#9C27B0";
                    break;
                }
                case "red": {
                    color = "#F44336";
                }
            }
            if (color != null) {
                return Optional.of(new Theme(name, color));
            }
        }
        return Optional.empty();
    }

    public static String getColorDisplayName(Color c) {
        return c != null ? String.format("#%02X%02X%02X", Math.round(c.getRed() * 255.0), Math.round(c.getGreen() * 255.0), Math.round(c.getBlue() * 255.0)) : null;
    }

    public static ObjectBinding<Color> foregroundFillBinding() {
        if (FOREGROUND_FILL == null) {
            FOREGROUND_FILL = Bindings.createObjectBinding(() -> Theme.getTheme().getForegroundColor(), (Observable[])new Observable[]{ConfigHolder.config().themeProperty()});
        }
        return FOREGROUND_FILL;
    }

    public static Color blackFill() {
        return BLACK;
    }

    public static Color whiteFill() {
        return Color.WHITE;
    }

    public static class TypeAdapter
    extends com.google.gson.TypeAdapter<Theme> {
        @Override
        public void write(JsonWriter out, Theme value) throws IOException {
            out.value(value.getName().toLowerCase(Locale.ROOT));
        }

        @Override
        public Theme read(JsonReader in) throws IOException {
            return Theme.getTheme(in.nextString()).orElse(BLUE);
        }
    }
}

