/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXSlider;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.effects.JFXDepthManager;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.binding.When;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.util.Callback;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.EnumBackgroundImage;
import org.jackhuang.hmcl.setting.FontManager;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.ComponentSublist;
import org.jackhuang.hmcl.ui.construct.FontComboBox;
import org.jackhuang.hmcl.ui.construct.MultiFileItem;
import org.jackhuang.hmcl.ui.construct.OptionToggleButton;
import org.jackhuang.hmcl.ui.construct.URLValidator;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.javafx.SafeStringConverter;

public class PersonalizationPage
extends StackPane {
    private static int snapOpacity(double val) {
        if (val <= 0.0) {
            return 0;
        }
        if (Double.isNaN(val) || val >= 100.0) {
            return 100;
        }
        int prevTick = (int)(val / 5.0);
        int prevTickValue = prevTick * 5;
        int nextTickValue = (prevTick + 1) * 5;
        return val - (double)prevTickValue > (double)nextTickValue - val ? nextTickValue : prevTickValue;
    }

    public PersonalizationPage() {
        VBox content = new VBox(10.0);
        content.setPadding(new Insets(10.0));
        content.setFillWidth(true);
        ScrollPane scrollPane = new ScrollPane((Node)content);
        FXUtils.smoothScrolling(scrollPane);
        scrollPane.setFitToWidth(true);
        this.getChildren().setAll((Object[])new Node[]{scrollPane});
        ComponentList themeList = new ComponentList();
        BorderPane themePane = new BorderPane();
        themeList.getContent().add((Object)themePane);
        Label left = new Label(I18n.i18n("settings.launcher.theme"));
        BorderPane.setAlignment((Node)left, (Pos)Pos.CENTER_LEFT);
        themePane.setLeft((Node)left);
        StackPane themeColorPickerContainer = new StackPane();
        themeColorPickerContainer.setMinHeight(30.0);
        themePane.setRight((Node)themeColorPickerContainer);
        ColorPicker picker = new ColorPicker(Color.web((String)Theme.getTheme().getColor()));
        picker.getCustomColors().setAll((Object[])Theme.SUGGESTED_COLORS);
        picker.setOnAction(e -> ConfigHolder.config().setTheme(Theme.custom(Theme.getColorDisplayName((Color)picker.getValue()))));
        themeColorPickerContainer.getChildren().setAll((Object[])new Node[]{picker});
        Platform.runLater(() -> JFXDepthManager.setDepth((Node)picker, 0));
        OptionToggleButton titleTransparentButton = new OptionToggleButton();
        themeList.getContent().add((Object)titleTransparentButton);
        titleTransparentButton.selectedProperty().bindBidirectional((Property)ConfigHolder.config().titleTransparentProperty());
        titleTransparentButton.setTitle(I18n.i18n("settings.launcher.title_transparent"));
        OptionToggleButton animationButton = new OptionToggleButton();
        themeList.getContent().add((Object)animationButton);
        animationButton.selectedProperty().bindBidirectional((Property)ConfigHolder.config().animationDisabledProperty());
        animationButton.setTitle(I18n.i18n("settings.launcher.turn_off_animations"));
        content.getChildren().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("settings.launcher.appearance")), themeList});
        ComponentList componentList = new ComponentList();
        MultiFileItem backgroundItem = new MultiFileItem();
        ComponentSublist backgroundSublist = new ComponentSublist();
        backgroundSublist.getContent().add(backgroundItem);
        backgroundSublist.setTitle(I18n.i18n("launcher.background"));
        backgroundSublist.setHasSubtitle(true);
        backgroundItem.loadChildren(Arrays.asList(new MultiFileItem.Option<EnumBackgroundImage>(I18n.i18n("launcher.background.default"), EnumBackgroundImage.DEFAULT).setTooltip(I18n.i18n("launcher.background.default.tooltip")), new MultiFileItem.Option<EnumBackgroundImage>(I18n.i18n("launcher.background.classic"), EnumBackgroundImage.CLASSIC), new MultiFileItem.FileOption<EnumBackgroundImage>(I18n.i18n("settings.custom"), EnumBackgroundImage.CUSTOM).setChooserTitle(I18n.i18n("launcher.background.choose")).addExtensionFilter(FXUtils.getImageExtensionFilter()).bindBidirectional((Property<String>)ConfigHolder.config().backgroundImageProperty()), new MultiFileItem.StringOption<EnumBackgroundImage>(I18n.i18n("launcher.background.network"), EnumBackgroundImage.NETWORK).setValidators(new URLValidator(true)).bindBidirectional((Property<String>)ConfigHolder.config().backgroundImageUrlProperty()), new MultiFileItem.PaintOption<EnumBackgroundImage>(I18n.i18n("launcher.background.paint"), EnumBackgroundImage.PAINT).bindBidirectional((Property<Paint>)ConfigHolder.config().backgroundPaintProperty())));
        backgroundItem.selectedDataProperty().bindBidirectional(ConfigHolder.config().backgroundImageTypeProperty());
        backgroundSublist.subtitleProperty().bind((ObservableValue)new When((ObservableBooleanValue)backgroundItem.selectedDataProperty().isEqualTo((Object)EnumBackgroundImage.DEFAULT)).then(I18n.i18n("launcher.background.default")).otherwise((ObservableStringValue)ConfigHolder.config().backgroundImageProperty()));
        HBox opacityItem = new HBox(8.0);
        opacityItem.setAlignment(Pos.CENTER);
        Label label = new Label(I18n.i18n("settings.launcher.background.settings.opacity"));
        final JFXSlider slider = new JFXSlider(0.0, 100.0, ConfigHolder.config().getBackgroundImageType() != EnumBackgroundImage.TRANSLUCENT ? (double)ConfigHolder.config().getBackgroundImageOpacity() : 50.0);
        slider.setShowTickMarks(true);
        slider.setMajorTickUnit(10.0);
        slider.setMinorTickCount(1);
        slider.setBlockIncrement(5.0);
        slider.setSnapToTicks(true);
        HBox.setHgrow((Node)slider, (Priority)Priority.ALWAYS);
        if (ConfigHolder.config().getBackgroundImageType() == EnumBackgroundImage.TRANSLUCENT) {
            slider.setDisable(true);
            ConfigHolder.config().backgroundImageTypeProperty().addListener((ChangeListener)new ChangeListener<EnumBackgroundImage>(){

                public void changed(ObservableValue<? extends EnumBackgroundImage> observable, EnumBackgroundImage oldValue, EnumBackgroundImage newValue) {
                    if (newValue != EnumBackgroundImage.TRANSLUCENT) {
                        ConfigHolder.config().backgroundImageTypeProperty().removeListener((ChangeListener)this);
                        slider.setDisable(false);
                        slider.setValue(100.0);
                    }
                }
            });
        }
        Label textOpacity = new Label();
        FXUtils.setLimitWidth((Region)textOpacity, 35.0);
        StringBinding valueBinding = Bindings.createStringBinding(() -> (int)slider.getValue() + "%", (Observable[])new Observable[]{slider.valueProperty()});
        textOpacity.textProperty().bind((ObservableValue)valueBinding);
        slider.setValueFactory((Callback<JFXSlider, StringBinding>)((Callback)s -> valueBinding));
        slider.valueProperty().addListener((observable, oldValue, newValue) -> ConfigHolder.config().setBackgroundImageOpacity(PersonalizationPage.snapOpacity(newValue.doubleValue())));
        opacityItem.getChildren().setAll((Object[])new Node[]{label, slider, textOpacity});
        componentList.getContent().setAll((Object[])new Node[]{backgroundItem, opacityItem});
        content.getChildren().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("launcher.background")), componentList});
        ComponentSublist logPane = new ComponentSublist();
        logPane.setTitle(I18n.i18n("settings.launcher.log"));
        VBox fontPane = new VBox();
        fontPane.setSpacing(5.0);
        BorderPane borderPane = new BorderPane();
        fontPane.getChildren().add((Object)borderPane);
        Label left2 = new Label(I18n.i18n("settings.launcher.log.font"));
        BorderPane.setAlignment((Node)left2, (Pos)Pos.CENTER_LEFT);
        borderPane.setLeft((Node)left2);
        HBox hBox = new HBox();
        hBox.setSpacing(3.0);
        FontComboBox cboLogFont = new FontComboBox();
        cboLogFont.valueProperty().bindBidirectional((Property)ConfigHolder.config().fontFamilyProperty());
        JFXTextField txtLogFontSize = new JFXTextField();
        FXUtils.setLimitWidth((Region)txtLogFontSize, 50.0);
        FXUtils.bind(txtLogFontSize, ConfigHolder.config().fontSizeProperty(), SafeStringConverter.fromFiniteDouble().restrict(it -> it > 0.0).fallbackTo(12.0).asPredicate(Validator.addTo(txtLogFontSize)));
        hBox.getChildren().setAll((Object[])new Node[]{cboLogFont, txtLogFontSize});
        borderPane.setRight((Node)hBox);
        Label lblLogFontDisplay = new Label("[23:33:33] [Client Thread/INFO] [WaterPower]: Loaded mod WaterPower.");
        lblLogFontDisplay.fontProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> Font.font((String)Lang.requireNonNullElse(ConfigHolder.config().getFontFamily(), FXUtils.DEFAULT_MONOSPACE_FONT), (double)ConfigHolder.config().getFontSize()), (Observable[])new Observable[]{ConfigHolder.config().fontFamilyProperty(), ConfigHolder.config().fontSizeProperty()}));
        fontPane.getChildren().add((Object)lblLogFontDisplay);
        logPane.getContent().add((Object)fontPane);
        content.getChildren().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("settings.launcher.log")), logPane});
        ComponentSublist fontPane2 = new ComponentSublist();
        fontPane2.setTitle(I18n.i18n("settings.launcher.font"));
        VBox vbox = new VBox();
        vbox.setSpacing(5.0);
        borderPane = new BorderPane();
        vbox.getChildren().add((Object)borderPane);
        left2 = new Label(I18n.i18n("settings.launcher.font"));
        BorderPane.setAlignment((Node)left2, (Pos)Pos.CENTER_LEFT);
        borderPane.setLeft((Node)left2);
        hBox = new HBox();
        hBox.setSpacing(8.0);
        FontComboBox cboFont = new FontComboBox();
        cboFont.setValue(ConfigHolder.config().getLauncherFontFamily());
        FXUtils.onChange(cboFont.valueProperty(), FontManager::setFontFamily);
        JFXButton clearButton = new JFXButton();
        clearButton.getStyleClass().add((Object)"toggle-icon4");
        clearButton.setGraphic(SVG.RESTORE.createIcon((Paint)Theme.blackFill(), -1.0));
        clearButton.setOnAction(e -> cboFont.setValue(null));
        hBox.getChildren().setAll((Object[])new Node[]{cboFont, clearButton});
        borderPane.setRight((Node)hBox);
        vbox.getChildren().add((Object)new Label("Hello Minecraft! Launcher"));
        fontPane2.getContent().add((Object)vbox);
        BorderPane fontAntiAliasingPane = new BorderPane();
        Label left3 = new Label(I18n.i18n("settings.launcher.font.anti_aliasing"));
        BorderPane.setAlignment((Node)left3, (Pos)Pos.CENTER_LEFT);
        fontAntiAliasingPane.setLeft((Node)left3);
        JFXComboBox cboAntiAliasing = new JFXComboBox(FXCollections.observableArrayList((Object[])new Optional[]{Optional.empty(), Optional.of(FontSmoothingType.LCD), Optional.of(FontSmoothingType.GRAY)}));
        String fontAntiAliasing = ConfigHolder.globalConfig().getFontAntiAliasing();
        if ("lcd".equalsIgnoreCase(fontAntiAliasing)) {
            cboAntiAliasing.setValue(Optional.of(FontSmoothingType.LCD));
        } else if ("gray".equalsIgnoreCase(fontAntiAliasing)) {
            cboAntiAliasing.setValue(Optional.of(FontSmoothingType.GRAY));
        } else {
            cboAntiAliasing.setValue(Optional.empty());
        }
        cboAntiAliasing.setConverter(FXUtils.stringConverter(value -> {
            if (value.isPresent()) {
                return I18n.i18n("settings.launcher.font.anti_aliasing." + ((FontSmoothingType)value.get()).name().toLowerCase(Locale.ROOT));
            }
            return I18n.i18n("settings.launcher.font.anti_aliasing.auto");
        }));
        FXUtils.onChange(cboAntiAliasing.valueProperty(), value -> ConfigHolder.globalConfig().setFontAntiAliasing(value.map(it -> it.name().toLowerCase(Locale.ROOT)).orElse(null)));
        fontAntiAliasingPane.setRight(cboAntiAliasing);
        fontPane2.getContent().add((Object)fontAntiAliasingPane);
        content.getChildren().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("settings.launcher.font")), fontPane2});
    }
}

