/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.i18n;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.jackhuang.hmcl.util.i18n.LocaleUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Adapter.class)
public final class LocalizedText {
    @Nullable
    private final String value;
    @Nullable
    private final Map<String, String> localizedValues;

    public LocalizedText(String value) {
        this.value = value;
        this.localizedValues = null;
    }

    public LocalizedText(@NotNull Map<String, String> localizedValues) {
        this.value = null;
        this.localizedValues = Objects.requireNonNull(localizedValues);
    }

    public String getText(@NotNull List<Locale> candidates) {
        if (this.localizedValues != null) {
            for (Locale locale : candidates) {
                String value = this.localizedValues.get(LocaleUtils.toLanguageKey(locale));
                if (value == null) continue;
                return value;
            }
            return null;
        }
        return this.value;
    }

    static final class Adapter
    extends TypeAdapter<LocalizedText> {
        Adapter() {
        }

        @Override
        public LocalizedText read(JsonReader jsonReader) throws IOException {
            JsonToken nextToken = jsonReader.peek();
            if (nextToken == JsonToken.NULL) {
                return null;
            }
            if (nextToken == JsonToken.STRING) {
                return new LocalizedText(jsonReader.nextString());
            }
            if (nextToken == JsonToken.BEGIN_OBJECT) {
                LinkedHashMap<String, String> localizedValues = new LinkedHashMap<String, String>();
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    String name = jsonReader.nextName();
                    String value = jsonReader.nextString();
                    localizedValues.put(name, value);
                }
                jsonReader.endObject();
                return new LocalizedText(localizedValues);
            }
            throw new JsonSyntaxException("Unexpected token " + String.valueOf((Object)nextToken));
        }

        @Override
        public void write(JsonWriter jsonWriter, LocalizedText localizedText) throws IOException {
            if (localizedText == null) {
                jsonWriter.nullValue();
            } else if (localizedText.localizedValues != null) {
                jsonWriter.beginObject();
                for (Map.Entry<String, String> entry : localizedText.localizedValues.entrySet()) {
                    jsonWriter.name(entry.getKey());
                    jsonWriter.value(entry.getValue());
                }
                jsonWriter.endObject();
            } else {
                jsonWriter.value(localizedText.value);
            }
        }
    }
}

