/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.validation;

import com.jfoenix.concurrency.JFXUtilities;
import com.jfoenix.validation.base.ValidatorBase;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

public class ValidationFacade
extends VBox {
    private static final String DEFAULT_STYLE_CLASS = "validation-facade";
    private Label errorLabel;
    private StackPane errorIcon;
    private HBox errorContainer;
    private double oldErrorLabelHeight = -1.0;
    private double initYlayout = -1.0;
    private double initHeight = -1.0;
    private boolean errorShown = false;
    private double currentFieldHeight = -1.0;
    private double errorLabelInitHeight = 0.0;
    private boolean heightChanged = false;
    private boolean disableAnimation = false;
    private Timeline hideErrorAnimation;
    private ReadOnlyObjectWrapper<ValidatorBase> activeValidator = new ReadOnlyObjectWrapper();
    private ObservableList<ValidatorBase> validators = FXCollections.observableArrayList();
    private ObjectProperty<Control> controlProperty = new SimpleObjectProperty();
    private static final PseudoClass PSEUDO_CLASS_ERROR = PseudoClass.getPseudoClass((String)"error");

    public ValidationFacade() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.setSpacing(0.0);
        this.errorLabel = new Label();
        this.errorLabel.getStyleClass().add((Object)"error-label");
        this.errorLabel.setWrapText(true);
        StackPane errorLabelContainer = new StackPane();
        errorLabelContainer.getChildren().add((Object)this.errorLabel);
        StackPane.setAlignment((Node)this.errorLabel, (Pos)Pos.CENTER_LEFT);
        this.errorIcon = new StackPane();
        this.errorContainer = new HBox();
        this.errorContainer.setAlignment(Pos.TOP_LEFT);
        this.errorContainer.getChildren().add((Object)errorLabelContainer);
        this.errorContainer.getChildren().add((Object)this.errorIcon);
        HBox.setHgrow((Node)errorLabelContainer, (Priority)Priority.ALWAYS);
        errorLabelContainer.setMaxWidth(Double.MAX_VALUE);
        this.errorIcon.setTranslateY(5.0);
        this.errorContainer.setSpacing(10.0);
        this.errorContainer.setVisible(false);
        this.errorContainer.setOpacity(0.0);
        this.errorLabel.heightProperty().addListener((o, oldVal, newVal) -> {
            if (this.errorShown) {
                if (this.oldErrorLabelHeight == -1.0) {
                    this.oldErrorLabelHeight = this.errorLabelInitHeight = oldVal.doubleValue();
                }
                this.heightChanged = true;
                double newHeight = this.getHeight() - this.oldErrorLabelHeight + newVal.doubleValue();
                Timeline errorAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.minHeightProperty(), (Object)this.currentFieldHeight, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)160.0), new KeyValue[]{new KeyValue((WritableValue)this.translateYProperty(), (Object)(this.initYlayout + this.getMaxHeight() / 2.0 - newHeight / 2.0), Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.minHeightProperty(), (Object)newHeight, Interpolator.EASE_BOTH)})});
                errorAnimation.play();
                errorAnimation.setOnFinished(finish -> new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)160.0), new KeyValue[]{new KeyValue((WritableValue)this.errorContainer.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})}).play());
                this.currentFieldHeight = newHeight;
                this.oldErrorLabelHeight = newVal.doubleValue();
            }
        });
        this.errorContainer.visibleProperty().addListener((o, oldVal, newVal) -> new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)160.0), new KeyValue[]{new KeyValue((WritableValue)this.errorContainer.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})}).play());
        this.activeValidatorProperty().addListener((o, oldVal, newVal) -> {
            if (!this.isDisableAnimation()) {
                if (this.hideErrorAnimation != null && this.hideErrorAnimation.getStatus() == Animation.Status.RUNNING) {
                    this.hideErrorAnimation.stop();
                }
                if (newVal != null) {
                    this.hideErrorAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)160.0), new KeyValue[]{new KeyValue((WritableValue)this.errorContainer.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)})});
                    this.hideErrorAnimation.setOnFinished(finish -> JFXUtilities.runInFX(() -> this.showError((ValidatorBase)((Object)newVal))));
                    this.hideErrorAnimation.play();
                } else {
                    JFXUtilities.runInFX(this::hideError);
                }
            } else if (newVal != null) {
                JFXUtilities.runInFXAndWait(() -> this.showError((ValidatorBase)((Object)newVal)));
            } else {
                JFXUtilities.runInFXAndWait(this::hideError);
            }
        });
    }

    public ValidatorBase getActiveValidator() {
        return this.activeValidator == null ? null : (ValidatorBase)((Object)this.activeValidator.get());
    }

    public ReadOnlyObjectProperty<ValidatorBase> activeValidatorProperty() {
        return this.activeValidator.getReadOnlyProperty();
    }

    public ObservableList<ValidatorBase> getValidators() {
        return this.validators;
    }

    public void setValidators(ValidatorBase ... validators) {
        this.validators.addAll((Object[])validators);
    }

    public static boolean validate(Control control) {
        ValidationFacade facade = (ValidationFacade)control.getParent();
        for (ValidatorBase validator : facade.validators) {
            if (validator.getSrcControl() == null) {
                validator.setSrcControl((Node)facade.controlProperty.get());
            }
            validator.validate();
            if (!validator.getHasErrors()) continue;
            facade.activeValidator.set((Object)validator);
            control.pseudoClassStateChanged(PSEUDO_CLASS_ERROR, true);
            return false;
        }
        control.pseudoClassStateChanged(PSEUDO_CLASS_ERROR, false);
        facade.activeValidator.set(null);
        return true;
    }

    public static void reset(Control control) {
        ValidationFacade facade = (ValidationFacade)control.getParent();
        control.pseudoClassStateChanged(PSEUDO_CLASS_ERROR, false);
        facade.activeValidator.set(null);
    }

    public Control getControl() {
        return (Control)this.controlProperty.get();
    }

    public void setControl(Control control) {
        this.maxWidthProperty().bind((ObservableValue)control.maxWidthProperty());
        this.prefWidthProperty().bind((ObservableValue)control.prefWidthProperty());
        this.prefHeightProperty().bind((ObservableValue)control.prefHeightProperty());
        this.errorContainer.setMaxWidth(control.getMaxWidth() > -1.0 ? control.getMaxWidth() : control.getPrefWidth());
        this.errorContainer.prefWidthProperty().bind((ObservableValue)control.widthProperty());
        this.errorContainer.prefHeightProperty().bind((ObservableValue)control.heightProperty());
        this.getChildren().clear();
        this.getChildren().add((Object)control);
        this.getChildren().add((Object)this.errorContainer);
        this.controlProperty.set((Object)control);
    }

    private void showError(ValidatorBase validator) {
        this.errorLabel.setText(validator.getMessage());
        Node awsomeIcon = validator.getIcon();
        this.errorIcon.getChildren().clear();
        if (awsomeIcon != null) {
            this.errorIcon.getChildren().add((Object)awsomeIcon);
            StackPane.setAlignment((Node)awsomeIcon, (Pos)Pos.TOP_RIGHT);
        }
        if (this.initYlayout == -1.0) {
            this.initYlayout = this.getBoundsInParent().getMinY();
            this.currentFieldHeight = this.initHeight = this.getHeight();
        }
        this.errorContainer.setVisible(true);
        this.errorShown = true;
    }

    private void hideError() {
        if (this.heightChanged) {
            new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)160.0), new KeyValue[]{new KeyValue((WritableValue)this.translateYProperty(), (Object)0, Interpolator.EASE_BOTH)})}).play();
            new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)160.0), new KeyValue[]{new KeyValue((WritableValue)this.minHeightProperty(), (Object)this.initHeight, Interpolator.EASE_BOTH)})}).play();
            this.heightChanged = false;
        }
        this.errorLabel.setText(null);
        this.oldErrorLabelHeight = this.errorLabelInitHeight;
        this.errorIcon.getChildren().clear();
        this.currentFieldHeight = this.initHeight;
        this.errorContainer.setVisible(false);
        this.errorShown = false;
    }

    public boolean isDisableAnimation() {
        return this.disableAnimation;
    }

    public void setDisableAnimation(boolean disableAnimation) {
        this.disableAnimation = disableAnimation;
    }
}

