/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp.lossless;

import com.twelvemonkeys.imageio.plugins.webp.LSBBitReader;
import com.twelvemonkeys.imageio.plugins.webp.lossless.ColorCache;
import com.twelvemonkeys.imageio.plugins.webp.lossless.ColorIndexingTransform;
import com.twelvemonkeys.imageio.plugins.webp.lossless.ColorTransform;
import com.twelvemonkeys.imageio.plugins.webp.lossless.HuffmanCodeGroup;
import com.twelvemonkeys.imageio.plugins.webp.lossless.HuffmanInfo;
import com.twelvemonkeys.imageio.plugins.webp.lossless.PredictorTransform;
import com.twelvemonkeys.imageio.plugins.webp.lossless.SubtractGreenTransform;
import com.twelvemonkeys.imageio.plugins.webp.lossless.Transform;
import com.twelvemonkeys.imageio.util.RasterUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.stream.ImageInputStream;

public final class VP8LDecoder {
    private static final byte[] DISTANCES = new byte[]{24, 7, 23, 25, 40, 6, 39, 41, 22, 26, 38, 42, 56, 5, 55, 57, 21, 27, 54, 58, 37, 43, 72, 4, 71, 73, 20, 28, 53, 59, 70, 74, 36, 44, 88, 69, 75, 52, 60, 3, 87, 89, 19, 29, 86, 90, 35, 45, 68, 76, 85, 91, 51, 61, 104, 2, 103, 105, 18, 30, 102, 106, 34, 46, 84, 92, 67, 77, 101, 107, 50, 62, 120, 1, 119, 121, 83, 93, 17, 31, 100, 108, 66, 78, 118, 122, 33, 47, 117, 123, 49, 63, 99, 109, 82, 94, 0, 116, 124, 65, 79, 16, 32, 98, 110, 48, 115, 125, 81, 95, 64, 114, 126, 97, 111, 80, 113, 127, 96, 112};
    private final ImageInputStream imageInput;
    private final LSBBitReader lsbBitReader;

    public VP8LDecoder(ImageInputStream imageInputStream, boolean bl) {
        this.imageInput = imageInputStream;
        this.lsbBitReader = new LSBBitReader(imageInputStream);
    }

    public void readVP8Lossless(WritableRaster writableRaster, boolean bl, ImageReadParam imageReadParam, int n, int n2) throws IOException {
        WritableRaster writableRaster2;
        WritableRaster writableRaster3;
        if (bl) {
            this.imageInput.seek(this.imageInput.getStreamPosition() + 5L);
        }
        int n3 = n;
        ArrayList<Transform> arrayList = new ArrayList<Transform>();
        while (bl && this.lsbBitReader.readBit() == 1) {
            n3 = this.readTransform(n3, n2, arrayList);
        }
        int n4 = 0;
        if (this.lsbBitReader.readBit() == 1 && ((n4 = (int)this.lsbBitReader.readBits(4)) < 1 || n4 > 11)) {
            throw new IIOException("Corrupt WebP stream, colorCacheBits < 1 || > 11: " + n4);
        }
        HuffmanInfo huffmanInfo = this.readHuffmanCodes(n3, n2, n4, bl);
        ColorCache colorCache = null;
        if (n4 > 0) {
            colorCache = new ColorCache(n4);
        }
        if (bl) {
            Rectangle rectangle = new Rectangle(n, n2);
            writableRaster3 = this.createDecodeRaster(writableRaster, imageReadParam, rectangle);
            writableRaster2 = writableRaster3.createWritableChild(0, 0, n3, n2, 0, 0, null);
        } else {
            writableRaster2 = writableRaster3 = writableRaster;
        }
        this.decodeImage(writableRaster2, huffmanInfo, colorCache);
        for (Transform transform : arrayList) {
            transform.applyInverse(writableRaster3);
        }
        if (writableRaster3 != writableRaster) {
            VP8LDecoder.copyIntoRasterWithParams(writableRaster3, writableRaster, imageReadParam);
        }
    }

    private WritableRaster createDecodeRaster(WritableRaster writableRaster, ImageReadParam imageReadParam, Rectangle rectangle) {
        boolean bl = false;
        if (imageReadParam != null) {
            if (imageReadParam.getSourceRegion() != null && !imageReadParam.getSourceRegion().contains(rectangle) || imageReadParam.getSourceXSubsampling() != 1 || imageReadParam.getSourceYSubsampling() != 1) {
                return VP8LDecoder.createCompatibleRaster(writableRaster, rectangle.width, rectangle.height);
            }
            rectangle.setLocation(imageReadParam.getDestinationOffset());
            bl = true;
        }
        if (!writableRaster.getBounds().contains(rectangle)) {
            return VP8LDecoder.createCompatibleRaster(writableRaster, rectangle.width, rectangle.height);
        }
        return bl ? writableRaster.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, 0, null) : writableRaster;
    }

    private static WritableRaster createCompatibleRaster(WritableRaster writableRaster, int n, int n2) {
        SampleModel sampleModel = writableRaster.getSampleModel().createCompatibleSampleModel(n, n2);
        return Raster.createWritableRaster(sampleModel, sampleModel.createDataBuffer(), null);
    }

    public static void copyIntoRasterWithParams(Raster raster, WritableRaster writableRaster, ImageReadParam imageReadParam) {
        Point point;
        Rectangle rectangle = imageReadParam != null && imageReadParam.getSourceRegion() != null ? imageReadParam.getSourceRegion() : raster.getBounds();
        int n = imageReadParam != null ? imageReadParam.getSourceXSubsampling() : 1;
        int n2 = imageReadParam != null ? imageReadParam.getSourceYSubsampling() : 1;
        int n3 = imageReadParam != null ? imageReadParam.getSubsamplingXOffset() : 0;
        int n4 = imageReadParam != null ? imageReadParam.getSubsamplingYOffset() : 0;
        Point point2 = point = imageReadParam != null ? imageReadParam.getDestinationOffset() : new Point(0, 0);
        if (n == 1 && n2 == 1) {
            writableRaster.setRect(point.x, point.y, raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, 0, null));
        } else {
            byte[] byArray = new byte[4];
            int n5 = writableRaster.getWidth() + writableRaster.getMinX();
            int n6 = writableRaster.getHeight() + writableRaster.getMinY();
            int n7 = point.y;
            int n8 = rectangle.y + n4;
            while (n7 < n6) {
                int n9 = point.x;
                int n10 = rectangle.x + n3;
                while (n9 < n5) {
                    raster.getDataElements(n10, n8, byArray);
                    writableRaster.setDataElements(n9, n7, byArray);
                    ++n9;
                    n10 += n;
                }
                ++n7;
                n8 += n2;
            }
        }
    }

    private void decodeImage(WritableRaster writableRaster, HuffmanInfo huffmanInfo, ColorCache colorCache) throws IOException {
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = huffmanInfo.metaCodeBits == 0 ? -1 : (1 << huffmanInfo.metaCodeBits) - 1;
        HuffmanCodeGroup huffmanCodeGroup = huffmanInfo.huffmanGroups[0];
        byte[] byArray = new byte[4];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                short s;
                if ((j & n3) == 0 && huffmanInfo.huffmanMetaCodes != null) {
                    s = huffmanInfo.huffmanMetaCodes.getSample(j >> huffmanInfo.metaCodeBits, i >> huffmanInfo.metaCodeBits, 0);
                    huffmanCodeGroup = huffmanInfo.huffmanGroups[s];
                }
                if ((s = huffmanCodeGroup.mainCode.readSymbol(this.lsbBitReader)) < 256) {
                    this.decodeLiteral(writableRaster, colorCache, huffmanCodeGroup, byArray, i, j, s);
                    continue;
                }
                if (s < 280) {
                    int n4 = this.decodeBwRef(writableRaster, colorCache, n, huffmanCodeGroup, byArray, s, j, i);
                    i += (--j + n4) / n;
                    j = (j + n4) % n;
                    if (i >= n2 || j >= n || huffmanInfo.huffmanMetaCodes == null) continue;
                    int n5 = huffmanInfo.huffmanMetaCodes.getSample(j >> huffmanInfo.metaCodeBits, i >> huffmanInfo.metaCodeBits, 0);
                    huffmanCodeGroup = huffmanInfo.huffmanGroups[n5];
                    continue;
                }
                this.decodeCached(writableRaster, colorCache, byArray, i, j, s);
            }
        }
    }

    private void decodeCached(WritableRaster writableRaster, ColorCache colorCache, byte[] byArray, int n, int n2, short s) {
        int n3 = colorCache.lookup(s - 256 - 24);
        byArray[0] = (byte)(n3 >> 16 & 0xFF);
        byArray[1] = (byte)(n3 >> 8 & 0xFF);
        byArray[2] = (byte)(n3 & 0xFF);
        byArray[3] = (byte)(n3 >>> 24);
        writableRaster.setDataElements(n2, n, byArray);
    }

    private void decodeLiteral(WritableRaster writableRaster, ColorCache colorCache, HuffmanCodeGroup huffmanCodeGroup, byte[] byArray, int n, int n2, short s) throws IOException {
        byte by = (byte)huffmanCodeGroup.redCode.readSymbol(this.lsbBitReader);
        byte by2 = (byte)huffmanCodeGroup.blueCode.readSymbol(this.lsbBitReader);
        byte by3 = (byte)huffmanCodeGroup.alphaCode.readSymbol(this.lsbBitReader);
        byArray[0] = by;
        byArray[1] = (byte)s;
        byArray[2] = by2;
        byArray[3] = by3;
        writableRaster.setDataElements(n2, n, byArray);
        if (colorCache != null) {
            colorCache.insert((by3 & 0xFF) << 24 | (by & 0xFF) << 16 | (s & 0xFF) << 8 | by2 & 0xFF);
        }
    }

    private int decodeBwRef(WritableRaster writableRaster, ColorCache colorCache, int n, HuffmanCodeGroup huffmanCodeGroup, byte[] byArray, short s, int n2, int n3) throws IOException {
        int n4;
        int n5;
        int n6;
        int n7 = this.lz77decode(s - 256);
        short s2 = huffmanCodeGroup.distanceCode.readSymbol(this.lsbBitReader);
        int n8 = this.lz77decode(s2);
        if (n8 > 120) {
            n6 = n8 - 120;
            n5 = n3 - n6 / n;
            n4 = n2 - n6 % n;
        } else {
            n4 = n2 - (8 - (DISTANCES[n8 - 1] & 0xF));
            n5 = n3 - (DISTANCES[n8 - 1] >> 4);
        }
        if (n4 < 0) {
            --n5;
            n4 += n;
        } else if (n4 >= n) {
            n4 -= n;
            ++n5;
        }
        for (n6 = n7; n6 > 0; --n6) {
            if (n2 == n) {
                n2 = 0;
                ++n3;
            }
            writableRaster.getDataElements(n4++, n5, byArray);
            writableRaster.setDataElements(n2, n3, byArray);
            if (n4 == n) {
                n4 = 0;
                ++n5;
            }
            if (colorCache != null) {
                colorCache.insert((byArray[3] & 0xFF) << 24 | (byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF);
            }
            ++n2;
        }
        return n7;
    }

    private int lz77decode(int n) throws IOException {
        if (n < 4) {
            return n + 1;
        }
        int n2 = n - 2 >> 1;
        int n3 = 2 + (n & 1) << n2;
        return n3 + (int)this.lsbBitReader.readBits(n2) + 1;
    }

    private int readTransform(int n, int n2, List<Transform> list) throws IOException {
        int n3 = (int)this.lsbBitReader.readBits(2);
        switch (n3) {
            case 0: 
            case 1: {
                byte by = (byte)(this.lsbBitReader.readBits(3) + 2L);
                int n4 = VP8LDecoder.subSampleSize(n, by);
                int n5 = VP8LDecoder.subSampleSize(n2, by);
                WritableRaster writableRaster = Raster.createInterleavedRaster(0, n4, n5, 4 * n4, 4, new int[]{0, 1, 2, 3}, null);
                this.readVP8Lossless(writableRaster, false, null, n4, n5);
                if (n3 == 0) {
                    list.add(0, new PredictorTransform(writableRaster, by));
                    break;
                }
                list.add(0, new ColorTransform(writableRaster, by));
                break;
            }
            case 2: {
                list.add(0, new SubtractGreenTransform());
                break;
            }
            case 3: {
                byte by;
                int n6 = (int)this.lsbBitReader.readBits(8) + 1;
                int n7 = n6 > 16 ? 256 : (n6 > 4 ? 16 : (n6 > 2 ? 4 : 2));
                byte[] byArray = new byte[n7 * 4];
                this.readVP8Lossless(Raster.createInterleavedRaster(new DataBufferByte(byArray, n6 * 4), n6, 1, n6 * 4, 4, new int[]{0, 1, 2, 3}, null), false, null, n6, 1);
                for (by = 4; by < byArray.length; ++by) {
                    byte by2 = by;
                    byArray[by2] = (byte)(byArray[by2] + byArray[by - 4]);
                }
                by = (byte)(n6 > 16 ? 0 : (n6 > 4 ? 1 : (n6 > 2 ? 2 : 3)));
                n = VP8LDecoder.subSampleSize(n, by);
                list.add(0, new ColorIndexingTransform(byArray, by));
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid transformType: " + n3));
            }
        }
        return n;
    }

    private HuffmanInfo readHuffmanCodes(int n, int n2, int n3, boolean bl) throws IOException {
        Object object;
        int n4 = 1;
        int n5 = 0;
        WritableRaster writableRaster = null;
        if (bl && this.lsbBitReader.readBit() == 1) {
            n5 = (int)this.lsbBitReader.readBits(3) + 2;
            int n6 = VP8LDecoder.subSampleSize(n, n5);
            int n7 = VP8LDecoder.subSampleSize(n2, n5);
            object = Raster.createPackedRaster(3, n6, n7, new int[]{65280, 255, -16777216, 0xFF0000}, null);
            this.readVP8Lossless(RasterUtils.asByteRaster((WritableRaster)object), false, null, n6, n7);
            int[] nArray = ((DataBufferInt)((Raster)object).getDataBuffer()).getData();
            int n8 = Integer.MIN_VALUE;
            for (int n9 : nArray) {
                n8 = Math.max(n8, n9 & 0xFFFF);
            }
            n4 = n8 + 1;
            writableRaster = Raster.createPackedRaster(((Raster)object).getDataBuffer(), n6, n7, n6, new int[]{65535}, null);
        }
        object = new HuffmanCodeGroup[n4];
        for (int i = 0; i < ((HuffmanCodeGroup[])object).length; ++i) {
            object[i] = new HuffmanCodeGroup(this.lsbBitReader, n3);
        }
        return new HuffmanInfo(writableRaster, n5, (HuffmanCodeGroup[])object);
    }

    private static int subSampleSize(int n, int n2) {
        return n + (1 << n2) - 1 >> n2;
    }
}

