/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.event;

import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.event.EventPriority;
import org.jetbrains.annotations.Contract;

public final class EventManager<T extends Event> {
    private static final int PRIORITY_COUNT = EventPriority.values().length;
    private final ReentrantLock lock = new ReentrantLock();
    private final CopyOnWriteArrayList<Consumer<T>>[] allHandlers = new CopyOnWriteArrayList[PRIORITY_COUNT];

    @Contract(value="_ -> param1")
    public Consumer<T> registerWeak(Consumer<T> consumer) {
        this.register(new WeakListener<T>(new WeakReference<Consumer<T>>(consumer)));
        return consumer;
    }

    @Contract(value="_, _ -> param1")
    public Consumer<T> registerWeak(Consumer<T> consumer, EventPriority priority) {
        this.register(new WeakListener<T>(new WeakReference<Consumer<T>>(consumer)), priority);
        return consumer;
    }

    public void register(Consumer<T> consumer) {
        this.register(consumer, EventPriority.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Consumer<T> consumer, EventPriority priority) {
        this.lock.lock();
        try {
            CopyOnWriteArrayList<Consumer<Object>> handlers = this.allHandlers[priority.ordinal()];
            if (handlers == null) {
                handlers = new CopyOnWriteArrayList();
                this.allHandlers[priority.ordinal()] = handlers;
            }
            handlers.add(consumer);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void register(Runnable runnable) {
        this.register((T t) -> runnable.run());
    }

    public void register(Runnable runnable, EventPriority priority) {
        this.register((T t) -> runnable.run(), priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event.Result fireEvent(T event) {
        this.lock.lock();
        try {
            for (CopyOnWriteArrayList<Consumer<T>> handlers : this.allHandlers) {
                if (handlers == null) continue;
                for (Consumer<T> handler : handlers) {
                    if (handler instanceof WeakListener) {
                        WeakListener weakListener = (WeakListener)handler;
                        Consumer consumer = (Consumer)weakListener.ref.get();
                        if (consumer != null) {
                            consumer.accept(event);
                            continue;
                        }
                        handlers.remove(weakListener);
                        continue;
                    }
                    handler.accept(event);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return ((Event)event).hasResult() ? ((Event)event).getResult() : Event.Result.DEFAULT;
    }

    private record WeakListener<T>(WeakReference<Consumer<T>> ref) implements Consumer<T>
    {
        @Override
        public void accept(T t) {
            Consumer listener = (Consumer)this.ref.get();
            if (listener != null) {
                listener.accept(t);
            }
        }
    }
}

