/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialogLayout;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import java.util.concurrent.CompletableFuture;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.DialogAware;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.util.FutureCallback;
import org.jackhuang.hmcl.util.i18n.I18n;

public class InputDialogPane
extends JFXDialogLayout
implements DialogAware {
    private final CompletableFuture<String> future = new CompletableFuture();
    private final JFXTextField textField;
    private final Label lblCreationWarning;
    private final SpinnerPane acceptPane;
    private final JFXButton acceptButton;

    public InputDialogPane(String text, String initialValue, FutureCallback<String> onResult, ValidatorBase ... validators) {
        this(text, initialValue, onResult);
        if (validators != null && validators.length > 0) {
            this.textField.getValidators().addAll((Object[])validators);
            FXUtils.setValidateWhileTextChanged((Node)this.textField, true);
            this.acceptButton.disableProperty().bind((ObservableValue)this.textField.activeValidatorProperty().isNotNull());
        }
    }

    public InputDialogPane(String text, String initialValue, FutureCallback<String> onResult) {
        this.textField = new JFXTextField(initialValue);
        this.setHeading(new Node[]{new HBox(new Node[]{new Label(text)})});
        this.setBody(new Node[]{new VBox(new Node[]{this.textField})});
        this.lblCreationWarning = new Label();
        this.acceptPane = new SpinnerPane();
        this.acceptPane.getStyleClass().add((Object)"small-spinner-pane");
        this.acceptButton = new JFXButton(I18n.i18n("button.ok"));
        this.acceptButton.getStyleClass().add((Object)"dialog-accept");
        this.acceptPane.setContent((Node)this.acceptButton);
        JFXButton cancelButton = new JFXButton(I18n.i18n("button.cancel"));
        cancelButton.getStyleClass().add((Object)"dialog-cancel");
        this.setActions(new Node[]{this.lblCreationWarning, this.acceptPane, cancelButton});
        cancelButton.setOnAction(e -> this.fireEvent(new DialogCloseEvent()));
        this.acceptButton.setOnAction(e -> {
            this.acceptPane.showSpinner();
            onResult.call(this.textField.getText(), new FutureCallback.ResultHandler(){

                @Override
                public void resolve() {
                    InputDialogPane.this.acceptPane.hideSpinner();
                    InputDialogPane.this.future.complete(InputDialogPane.this.textField.getText());
                    InputDialogPane.this.fireEvent(new DialogCloseEvent());
                }

                @Override
                public void reject(String reason) {
                    InputDialogPane.this.acceptPane.hideSpinner();
                    InputDialogPane.this.lblCreationWarning.setText(reason);
                }
            });
        });
        this.textField.setOnAction(event -> this.acceptButton.fire());
        FXUtils.onEscPressed((Node)this, () -> ((JFXButton)cancelButton).fire());
    }

    @Override
    public void onDialogShown() {
        this.textField.requestFocus();
    }

    public CompletableFuture<String> getCompletableFuture() {
        return this.future;
    }
}

