/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.LineButtonBase;

public class LineButton
extends LineButtonBase {
    private static final String DEFAULT_STYLE_CLASS = "line-button";
    private static final int IDX_TRAILING_TEXT = 2;
    private static final int IDX_TRAILING_ICON = 3;
    private ObjectProperty<EventHandler<ActionEvent>> onAction;
    private StringProperty trailingText;
    private ObjectProperty<Node> trailingIcon;

    public static LineButton createNavigationButton() {
        LineButton button = new LineButton();
        button.setTrailingIcon(SVG.ARROW_FORWARD);
        return button;
    }

    public static LineButton createExternalLinkButton(String url) {
        LineButton button = new LineButton();
        button.setTrailingIcon(SVG.OPEN_IN_NEW);
        if (url != null) {
            button.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> FXUtils.openLink(url)));
        }
        return button;
    }

    public LineButton() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.container.setMouseTransparent(true);
    }

    public ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        if (this.onAction == null) {
            this.onAction = new ObjectPropertyBase<EventHandler<ActionEvent>>(){

                public Object getBean() {
                    return LineButton.this;
                }

                public String getName() {
                    return "onAction";
                }

                protected void invalidated() {
                    LineButton.this.setEventHandler(ActionEvent.ACTION, (EventHandler)this.get());
                }
            };
        }
        return this.onAction;
    }

    public EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty().get();
    }

    public void setOnAction(EventHandler<ActionEvent> value) {
        this.onActionProperty().set(value);
    }

    public StringProperty trailingTextProperty() {
        if (this.trailingText == null) {
            this.trailingText = new StringPropertyBase(){
                private Label trailingTextLabel;

                public Object getBean() {
                    return LineButton.this;
                }

                public String getName() {
                    return "trailingText";
                }

                protected void invalidated() {
                    String message = this.get();
                    if (message != null && !message.isEmpty()) {
                        if (this.trailingTextLabel == null) {
                            this.trailingTextLabel = new Label();
                            this.trailingTextLabel.getStyleClass().add((Object)"trailing-label");
                            this.trailingTextLabel.setTextOverrun(OverrunStyle.CENTER_ELLIPSIS);
                        }
                        this.trailingTextLabel.setText(message);
                        LineButton.this.setNode(2, (Node)this.trailingTextLabel);
                    } else if (this.trailingTextLabel != null) {
                        this.trailingTextLabel.setText("");
                        LineButton.this.setNode(2, null);
                    }
                }
            };
        }
        return this.trailingText;
    }

    public String getTrailingText() {
        return this.trailingText != null ? (String)this.trailingText.get() : null;
    }

    public void setTrailingText(String trailingText) {
        this.trailingTextProperty().set((Object)trailingText);
    }

    public ObjectProperty<Node> trailingIconProperty() {
        if (this.trailingIcon == null) {
            this.trailingIcon = new ObjectPropertyBase<Node>(){

                public Object getBean() {
                    return LineButton.this;
                }

                public String getName() {
                    return "trailingIcon";
                }

                protected void invalidated() {
                    LineButton.this.setNode(3, (Node)this.get());
                }
            };
        }
        return this.trailingIcon;
    }

    public Node getTrailingIcon() {
        return this.trailingIcon != null ? (Node)this.trailingIcon.get() : null;
    }

    public void setTrailingIcon(Node trailingIcon) {
        this.trailingIconProperty().set((Object)trailingIcon);
    }

    public void setTrailingIcon(SVG rightIcon) {
        this.setTrailingIcon(rightIcon, 20.0);
    }

    public void setTrailingIcon(SVG rightIcon, double size) {
        Node rightIconNode = rightIcon.createIcon(size);
        rightIconNode.getStyleClass().add((Object)"trailing-icon");
        this.setTrailingIcon(rightIconNode);
    }
}

