/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import java.util.Arrays;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.NoPaddingComponent;

public abstract class LineComponent
extends StackPane
implements NoPaddingComponent {
    private static final String DEFAULT_STYLE_CLASS = "line-component";
    private static final double MIN_HEIGHT = 48.0;
    private static final PseudoClass PSEUDO_LARGER_TITLE = PseudoClass.getPseudoClass((String)"large-title");
    protected static final int IDX_LEADING = 0;
    protected static final int IDX_TITLE = 1;
    protected static final int IDX_TRAILING = 2;
    public static final double SPACING = 12.0;
    public static final double DEFAULT_ICON_SIZE = 20.0;
    protected final HBox container;
    private final Label titleLabel;
    private final VBox titleContainer;
    private Node[] nodes = new Node[2];
    private final StringProperty title = new StringPropertyBase(){

        public Object getBean() {
            return LineComponent.this;
        }

        public String getName() {
            return "title";
        }

        protected void invalidated() {
            LineComponent.this.titleLabel.setText(this.get());
        }
    };
    private StringProperty subtitle;
    private ObjectProperty<Node> leading;

    public static void setMargin(Node child, Insets value) {
        HBox.setMargin((Node)child, (Insets)value);
    }

    public LineComponent() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setMinHeight(48.0);
        this.container = new HBox(12.0);
        this.container.getStyleClass().add((Object)"line-component-container");
        this.container.setAlignment(Pos.CENTER_LEFT);
        this.titleLabel = new Label();
        this.titleLabel.getStyleClass().add((Object)"title-label");
        this.titleLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        this.titleContainer = new VBox(new Node[]{this.titleLabel});
        this.titleContainer.getStyleClass().add((Object)"title-container");
        this.titleContainer.setMouseTransparent(true);
        this.titleContainer.setAlignment(Pos.CENTER_LEFT);
        this.titleContainer.minWidthProperty().bind((ObservableValue)this.titleLabel.prefWidthProperty());
        HBox.setHgrow((Node)this.titleContainer, (Priority)Priority.ALWAYS);
        this.setNode(1, (Node)this.titleContainer);
        this.getChildren().setAll((Object[])new Node[]{this.container});
    }

    protected void setNode(int idx, Node node) {
        if (this.nodes.length <= idx) {
            this.nodes = Arrays.copyOf(this.nodes, idx + 1);
        }
        if (this.nodes[idx] != node) {
            this.nodes[idx] = node;
            this.container.getChildren().setAll((Object[])((Node[])Arrays.stream(this.nodes).filter(Objects::nonNull).toArray(Node[]::new)));
        }
    }

    public void setLargeTitle(boolean largeTitle) {
        this.pseudoClassStateChanged(PSEUDO_LARGER_TITLE, largeTitle);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public String getTitle() {
        return (String)this.titleProperty().get();
    }

    public void setTitle(String title) {
        this.titleProperty().set((Object)title);
    }

    public final StringProperty subtitleProperty() {
        if (this.subtitle == null) {
            this.subtitle = new StringPropertyBase(){
                private Label subtitleLabel;

                public String getName() {
                    return "subtitle";
                }

                public Object getBean() {
                    return LineComponent.this;
                }

                protected void invalidated() {
                    String subtitle = this.get();
                    if (subtitle != null && !subtitle.isEmpty()) {
                        if (this.subtitleLabel == null) {
                            this.subtitleLabel = new Label();
                            this.subtitleLabel.setWrapText(true);
                            this.subtitleLabel.setMinHeight(Double.NEGATIVE_INFINITY);
                            this.subtitleLabel.getStyleClass().add((Object)"subtitle-label");
                        }
                        this.subtitleLabel.setText(subtitle);
                        if (LineComponent.this.titleContainer.getChildren().size() == 1) {
                            LineComponent.this.titleContainer.getChildren().add((Object)this.subtitleLabel);
                        }
                    } else if (this.subtitleLabel != null) {
                        this.subtitleLabel.setText(null);
                        if (LineComponent.this.titleContainer.getChildren().size() == 2) {
                            LineComponent.this.titleContainer.getChildren().remove(1);
                        }
                    }
                }
            };
        }
        return this.subtitle;
    }

    public final String getSubtitle() {
        return this.subtitle != null ? (String)this.subtitle.get() : null;
    }

    public final void setSubtitle(String subtitle) {
        this.subtitleProperty().set((Object)subtitle);
    }

    public final ObjectProperty<Node> leadingProperty() {
        if (this.leading == null) {
            this.leading = new ObjectPropertyBase<Node>(){

                public Object getBean() {
                    return LineComponent.this;
                }

                public String getName() {
                    return "leading";
                }

                protected void invalidated() {
                    LineComponent.this.setNode(0, (Node)this.get());
                }
            };
        }
        return this.leading;
    }

    public final Node getLeading() {
        return (Node)this.leadingProperty().get();
    }

    public final void setLeading(Node node) {
        this.leadingProperty().set((Object)node);
    }

    public void setLeading(Image icon) {
        this.setLeading(icon, -1.0);
    }

    public void setLeading(Image icon, double size) {
        ImageView imageView = new ImageView(icon);
        if (size > 0.0) {
            imageView.setFitWidth(size);
            imageView.setFitHeight(size);
            imageView.setPreserveRatio(true);
            imageView.setSmooth(true);
        }
        imageView.setMouseTransparent(true);
        this.setNode(0, (Node)imageView);
    }

    public void setLeading(SVG svg) {
        this.setLeading(svg, 20.0);
    }

    public void setLeading(SVG svg, double size) {
        Node node = svg.createIcon(size);
        node.setMouseTransparent(true);
        this.setNode(0, node);
    }
}

