/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXListView;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;

public abstract class MDListCell<T>
extends ListCell<T> {
    private static final PseudoClass SELECTED = PseudoClass.getPseudoClass((String)"selected");
    private final StackPane container = new StackPane();
    private final StackPane root = new StackPane();

    public MDListCell(JFXListView<T> listView) {
        this.setText(null);
        this.setGraphic(null);
        this.root.getStyleClass().add((Object)"md-list-cell");
        RipplerContainer ripplerContainer = new RipplerContainer((Node)this.container);
        this.root.getChildren().setAll((Object[])new Node[]{ripplerContainer});
        Region clippedContainer = (Region)listView.lookup(".clipped-container");
        this.setPrefWidth(0.0);
        if (clippedContainer != null) {
            DoubleBinding converted = clippedContainer.widthProperty().subtract(1);
            this.maxWidthProperty().bind((ObservableValue)converted);
            this.prefWidthProperty().bind((ObservableValue)converted);
            this.minWidthProperty().bind((ObservableValue)converted);
        }
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        this.updateControl(item, empty);
        if (empty) {
            this.setGraphic(null);
        } else {
            this.setGraphic((Node)this.root);
        }
    }

    protected StackPane getContainer() {
        return this.container;
    }

    protected void setSelectable() {
        FXUtils.onChangeAndOperate(this.selectedProperty(), selected -> this.root.pseudoClassStateChanged(SELECTED, selected.booleanValue()));
    }

    protected abstract void updateControl(T var1, boolean var2);
}

